/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

class XMLOutput {
    XMLOutput() {
    }

    static void writeFileHeader(PrintWriter fd) {
        fd.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n", new Object[0]);
        fd.format("<gpx\n", new Object[0]);
        fd.format("\tversion=\"1.1\"\n", new Object[0]);
        fd.format("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n", new Object[0]);
        fd.format("   xmlns=\"http://www.topografix.com/GPX/1/1\"\n", new Object[0]);
        fd.format("   xmlns:topografix=\"http://www.topografix.com/GPX/Private/TopoGrafix/0/1\"\n", new Object[0]);
        fd.format("   xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1\n", new Object[0]);
        fd.format("   http://www.topografix.com/GPX/1/1/gpx.xsd\n", new Object[0]);
        fd.format("   http://www.topografix.com/GPX/Private/TopoGrafix/0/1\n", new Object[0]);
        fd.format("   http://www.topografix.com/GPX/Private/TopoGrafix/0/1/topografix.xsd\">\n", new Object[0]);
    }

    static void writeTrackHeader(PrintWriter fd, Track t) {
        fd.format(" <trk>\n", new Object[0]);
        fd.format("  <name>Track %d</name>\n", t.num);
        fd.format("  <desc>%02d-%02d-%04d</desc>\n", t.month, t.day, t.year);
        fd.format("  <trkseg>\n", new Object[0]);
    }

    static void writePoint(PrintWriter fd, Track t, TrackPoint pt) {
        fd.format("   <trkpt lat=\"%1.6f\" lon=\"%1.6f\">\n", pt.lat, pt.lon);
        fd.format("    <ele>%d</ele>\n", pt.alt);
        fd.format("    <name>%1.1f km/h</name>\n", pt.speed);
        fd.format("    <time>%04d-%02d-%02dT%02d:%02d:%02dZ</time>\n", t.year, t.month, t.day, pt.hour, pt.min, pt.sec);
        fd.format("   </trkpt>\n", new Object[0]);
    }

    static void writeTrackFooter(PrintWriter fd) {
        fd.format("  </trkseg>\n", new Object[0]);
        fd.format(" </trk>\n", new Object[0]);
    }

    static void writeFileFooter(PrintWriter fd) {
        fd.format("</gpx>\n", new Object[0]);
    }

    static void writeFile(String filename, Vector<Track> tracks) throws IOException {
        PrintWriter fd = new PrintWriter(new FileWriter(filename));
        XMLOutput.writeFileHeader(fd);
        for (Track t : tracks) {
            XMLOutput.writeTrackHeader(fd, t);
            for (TrackPoint pt : t.points) {
                XMLOutput.writePoint(fd, t, pt);
            }
            XMLOutput.writeTrackFooter(fd);
        }
        XMLOutput.writeFileFooter(fd);
        fd.close();
    }
}

