/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class FlightConverter {
    static double decodeCoordinate(byte[] coord, int offset) {
        int b0 = coord[offset + 0] & 0xFF;
        int b1 = coord[offset + 1] & 0xFF;
        int b2 = coord[offset + 2] & 0xFF;
        int b3 = coord[offset + 3] & 0xFF;
        double deg = b0;
        double min = (float)(b1 & 0x7F) + (float)b2 * 0.01f + (float)b3 * 1.0E-4f;
        if ((b1 & 0x80) != 0) {
            return -(deg + min / 60.0);
        }
        return deg + min / 60.0;
    }

    static int decodeHalfword(byte[] b, int offset) {
        return (b[offset] & 0xFF) * 256 + (b[offset + 1] & 0xFF);
    }

    public static Vector<Track> parseFile(String filename) throws Exception {
        int len;
        Vector<Track> tracks = new Vector<Track>(0);
        File inputFile = new File(filename);
        FileInputStream input = new FileInputStream(inputFile);
        byte[] header = new byte[9];
        byte[] log_entry = new byte[20];
        if (input.read(header) != 9) {
            throw new Exception("Error reading header;");
        }
        int n_track = 0;
        Track curTrack = null;
        while ((len = input.read(log_entry)) == 20) {
            if ((log_entry[0] & 0x80) != 0) {
                System.out.println("Reading track " + ++n_track);
                int year = 2000 + (log_entry[0] & 0x7F);
                byte month = log_entry[1];
                byte day = log_entry[2];
                curTrack = new Track(month, day, year, n_track);
                tracks.addElement(curTrack);
            } else {
                byte hour = log_entry[0];
                byte min = log_entry[1];
                byte sec = log_entry[2];
                double lat = FlightConverter.decodeCoordinate(log_entry, 3);
                double lon = FlightConverter.decodeCoordinate(log_entry, 7);
                double speed = (float)FlightConverter.decodeHalfword(log_entry, 11) * 0.1f;
                int alt = FlightConverter.decodeHalfword(log_entry, 13);
                TrackPoint pt = new TrackPoint(lat, lon, alt, speed, hour, min, sec);
                if (curTrack == null) {
                    throw new Exception("No current track - malformed file?");
                }
                curTrack.points.addElement(pt);
            }
            if (len == 20) continue;
        }
        if (tracks.size() != 0) {
            return tracks;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\nskywombat's RIB to GPX converter, version 0.1");
        System.out.println("This program is extremely beta - please be gentle");
        if (args.length == 0) {
            System.out.println("Usage: FlightConverter.jar <rib file> [more rib files...]");
            System.exit(-1);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String inFile = stringArray[n2];
            System.out.println();
            System.out.println("Reading " + inFile);
            Vector<Track> tracks = null;
            try {
                tracks = FlightConverter.parseFile(inFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (tracks != null) {
                String outFile = String.valueOf(inFile) + ".gpx";
                System.out.println("Writing " + outFile);
                XMLOutput.writeFile(outFile, tracks);
            } else {
                System.out.println("No tracks found in " + inFile);
            }
            ++n2;
        }
        System.out.println("Done");
    }
}

