/*
 * Decompiled with CFR 0.152.
 */
package android.net.wimax;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.wimax.ConnectionStatistics;
import android.net.wimax.DeviceInfo;
import android.net.wimax.DeviceStatusInfo;
import android.net.wimax.WimaxInfo;
import android.net.wimax.WimaxManager;
import android.net.wimax.WimaxMonitor;
import android.net.wimax.WimaxNative;
import android.net.wimax.WimaxState;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.StringTokenizer;

public class WimaxStateTracker
extends NetworkStateTracker {
    private boolean m_bLog = false;
    private Context mContext;
    private static final String TAG = "WimaxStateTracker";
    private static final int EVENT_WIMAX_STATE_CHANGED = 1;
    private static final int EVENT_INTERFACE_CONFIGURATION_SUCCEEDED = 2;
    private static final int EVENT_INTERFACE_CONFIGURATION_FAILED = 3;
    private static final int EVENT_POLL_INTERVAL = 4;
    private static final int EVENT_DHCP_START = 5;
    private static final int EVENT_AFTER_VI_REQ_NEED_DELAY = 6;
    private static final int EVENT_SCAN_DELAY = 7;
    private static final int EVENT_VI_REQ = 8;
    private static final int EVENT_DRIVER_STATE_CHANGED = 9;
    private static final int EVENT_IP_RENEW = 10;
    private static final int EVENT_AUTH_FAIL = 11;
    private static final int EVENT_OMADM_RESP_DATA = 12;
    private static final int EVENT_RADIO_INFO_RESP_DATA = 13;
    private static final int EVENT_LINK_WEAK_INFO = 14;
    private static final int EVENT_MOCALL_INFO = 15;
    private static final int EVENT_MOCALL_FAIL = 16;
    private static final int EVENT_START_INITIALIZING = 17;
    private static final int m_nwaitLU = 5;
    private static final int POLL_STATUS_INTERVAL_MSECS = 1000;
    private static final int DEFAULT_MAX_DHCP_RETRIES = 2;
    private static final int WIMAX_DHCP_RENEW_INTERVAL = 0;
    private static int nOdbReqCount = 0;
    private int m_nAutoConnectEnabled = 1;
    private int mDiffDhcpTime = 0;
    private int mnOldIP = 0;
    private int nOldSignalLevel = -1;
    private int WIMAX_SCAN_ATTEMPT_TIMEOUT = 2;
    private int WIMAX_SCAN_RETRY_SECONDS = 120;
    private int WIMAX_ENTRY_DELAY = 300;
    public int nRetryFlag = 0;
    public int nScanAttempt = 0;
    private WimaxState mWimaxState = WimaxState.UNKNOWN;
    private WimaxState mWimaxStateOld = WimaxState.UNKNOWN;
    private DeviceStatusInfo.ConnectionProgressInfo mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
    private DeviceStatusInfo.ConnectionProgressInfo mWimaxStateDetailOld = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
    private WimaxInfo mWimaxInfo;
    private WimaxManager mWM;
    private WimaxMonitor mWimaxMonitor;
    private DhcpHandler mDhcpTarget;
    private DhcpInfo mDhcpInfo;
    private boolean mHaveIpAddress;
    private boolean mObtainingIpAddress;
    private boolean mUseStaticIp = false;
    private boolean mTornDownByConnMgr;
    private boolean m_bUserDisconnect = false;
    private boolean isHaveLinkInfo = false;
    private boolean isIdleState = false;
    private boolean m_bScreenOff = false;
    private boolean m_isBootCompleted = false;
    private boolean m_bNoBackOff = false;
    private boolean m_bRct = false;
    private boolean m_bReject = false;
    public boolean mEnableUSB = false;
    public boolean mIsTetheredmode = false;
    public boolean mTetheredModeUsbPlugged = false;
    public boolean m_bMruWorking = false;
    public boolean mModemReset = false;
    private long mDhcpStart = 0L;
    private long mDhcpEnd = 0L;
    private ConnectionStatistics mConnectionStatistics;
    private long mTotalRxBytes = 0L;
    private long mTotalTxBytes = 0L;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_STOPPING = 3;
    private static final int RUN_STATE_STOPPED = 4;
    private static final String[] mRunStateNames = new String[]{"Starting", "Running", "Stopping", "Stopped"};
    private int mRunState;
    private final IBatteryStats mBatteryStats;
    private String mInterfaceName;
    private static String LS = System.getProperty("line.separator");
    private Runnable mReleaseWakeLockCallback;
    private static PowerManager.WakeLock sWakeLock = null;
    private AlarmManager mAlarmManager;
    private PendingIntent mDhcpRenewIntent;
    public static final String ACTION_WIMAX_DHCP_RENEW = "com.android.server.WimaxManager.action.WIMAX_DHCP_RENEW";
    private static final String USB_PATH = "/sys/class/sec/switch/usb_sel";
    private static String[] sDnsPropNames;
    private String m_strErrorMsg = null;
    private static final byte[] PDA;
    private static final byte[] WiMAX;
    private boolean mIpRenew = false;
    private Notification mNotification;
    private NotificationManager mWimaxNotifyManager;
    private PendingIntent mWimaxSettingIntent;
    private static int ICON_WIMAX_CONNECTED;
    private static int ICON_WIMAX_DISCONNECTED;

    public WimaxStateTracker(Context context, Handler target) {
        super(context, target, 6, 0, "WiMax", "");
        this.mContext = context;
        this.mWimaxInfo = new WimaxInfo();
        this.mWimaxMonitor = new WimaxMonitor(this);
        this.mConnectionStatistics = new ConnectionStatistics();
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.setTornDownByConnMgr(false);
        this.mDhcpInfo = new DhcpInfo();
        this.mRunState = 1;
        this.mInterfaceName = SystemProperties.get((String)"wimax.interface", (String)"uwbr0");
        sDnsPropNames = new String[]{"dhcp." + this.mInterfaceName + ".dns1", "dhcp." + this.mInterfaceName + ".dns2"};
        this.mBatteryStats = IBatteryStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"batteryinfo"));
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent DhcpRenewIntent = new Intent(ACTION_WIMAX_DHCP_RENEW, null);
        this.mDhcpRenewIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)DhcpRenewIntent, (int)0);
        this.mWimaxNotifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotification = new Notification(ICON_WIMAX_DISCONNECTED, null, 0L);
        this.mWimaxSettingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent("android.settings.WIMAX_SETTINGS"), (int)0);
        ICON_WIMAX_CONNECTED = this.mContext.getResources().getIdentifier("stat_sys_data_wimax_signal_3_fully", "drawable", this.mContext.getPackageName());
        ICON_WIMAX_DISCONNECTED = this.mContext.getResources().getIdentifier("stat_sys_data_wimax_signal_disconnected", "drawable", this.mContext.getPackageName());
    }

    private void setTornDownByConnMgr(boolean flag) {
        this.mTornDownByConnMgr = flag;
        this.updateNetworkInfo();
    }

    public String[] getNameServers() {
        return WimaxStateTracker.getNameServerList((String[])sDnsPropNames);
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wimax";
    }

    public void startMonitoring() {
        this.mWM = WimaxManager.getInstance();
    }

    public void startEventLoop() {
        this.mWimaxMonitor.startMonitoring();
    }

    public synchronized boolean isAvailable() {
        boolean bRet;
        boolean bl = bRet = this.getCurrentWimaxState() != WimaxState.UNKNOWN && this.getCurrentWimaxState() != WimaxState.INITIALIZING && (this.mTornDownByConnMgr || !this.isDriverStopped());
        if (this.m_bLog) {
            Log.i((String)TAG, (String)("isAvailable() !!!!!!!!!!!!!!!!!!!!!!!! return " + bRet));
        }
        return bRet;
    }

    public int getNetworkSubtype() {
        return 0;
    }

    private void updateNetworkInfo() {
        this.mNetworkInfo.setIsAvailable(this.isAvailable());
    }

    public boolean isConnectionCompleted() {
        if (this.m_bLog) {
            Log.v((String)TAG, (String)"isConnectionCompleted() !!!!!!!!!!!!!!!!!!!!!!!!");
        }
        return this.getCurrentWimaxState() == WimaxState.CONNECTED;
    }

    public boolean hasIpAddress() {
        return this.mHaveIpAddress;
    }

    public void notifyStateChange(WimaxState newWimaxState, DeviceStatusInfo.ConnectionProgressInfo newInfo) {
        Message msg = Message.obtain((Handler)this, (int)1, (Object)new WimaxStateChangeResult(newWimaxState, newInfo));
        msg.sendToTarget();
    }

    public void notifyIpRenew() {
        if (!this.mUseStaticIp) {
            if (this.mIpRenew) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"mIpRenew == true, return");
                }
                return;
            }
            if (this.mHaveIpAddress && this.getCurrentWimaxState() == WimaxState.CONNECTED) {
                this.mObtainingIpAddress = true;
                this.mDhcpTarget.sendEmptyMessage(10);
            }
        }
    }

    void notifyAuthFail(int nErrorCode, int nLength, ByteBuffer bDataArray) {
        Message.obtain((Handler)this, (int)11, (int)nErrorCode, (int)nLength, (Object)bDataArray).sendToTarget();
    }

    public void notifyDriverStopped() {
        this.mRunState = 4;
        Message.obtain((Handler)this, (int)9, (int)0, (int)0).sendToTarget();
    }

    void notifyDriverStarted() {
        Message.obtain((Handler)this, (int)9, (int)1, (int)0).sendToTarget();
    }

    public void notifyOMADMResponse(ByteBuffer bDataArray, int nDataLen, int odbMngState) {
        Message.obtain((Handler)this, (int)12, (int)nDataLen, (int)odbMngState, (Object)bDataArray).sendToTarget();
    }

    public void notifyRadioInfoResponse() {
        Message.obtain((Handler)this, (int)13).sendToTarget();
    }

    public void notifyLinkWeakInformation() {
        Message.obtain((Handler)this, (int)14).sendToTarget();
    }

    public void notifyMoCallInformation() {
        Message.obtain((Handler)this, (int)15).sendToTarget();
    }

    private synchronized void setPollTimer() {
        if (this.m_bScreenOff) {
            return;
        }
        if (!this.hasMessages(4)) {
            this.sendEmptyMessageDelayed(4, 1000L);
        }
    }

    private synchronized boolean isDriverStopped() {
        return this.mRunState == 4 || this.mRunState == 3;
    }

    private void noteRunState() {
        if (this.m_bLog) {
            Log.v((String)TAG, (String)"[noteRunState]");
        }
    }

    public void releaseWakeLock() {
        if (this.mReleaseWakeLockCallback != null) {
            this.mReleaseWakeLockCallback.run();
        }
    }

    public void setWakeLock(PowerManager.WakeLock wl) {
        sWakeLock = wl;
    }

    public void acquire_WakeLock() {
        block7: {
            try {
                if (sWakeLock == null) {
                    return;
                }
                if (sWakeLock.isHeld()) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"------WakeLock already acquired----------------");
                    }
                } else {
                    if (this.m_bLog) {
                        Log.i((String)TAG, (String)"------WakeLock will be acquired----------------");
                    }
                    sWakeLock.acquire();
                }
            }
            catch (NullPointerException e) {
                if (!this.m_bLog) break block7;
                Log.e((String)TAG, (String)"------WakeLock NullPointerException----------------");
            }
        }
    }

    public void setReleaseWakeLockCallback(Runnable callback) {
        this.mReleaseWakeLockCallback = callback;
    }

    public void setUsbUnPlugged() {
        WimaxNative.setDeviceStateToVirtualIdle();
        Intent intent = new Intent("android.net.wimax.WIMAX_STATE_CHANGE");
        intent.addFlags(0x10000000);
        intent.putExtra("WimaxState", WimaxState.DISCONNECTED.ordinal());
        this.mContext.sendStickyBroadcast(intent);
        if (this.hasMessages(8)) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"[setUsbUnPlugged] removeMessage(EVENT_VI_REQ)");
            }
            this.removeMessages(8);
        }
        this.sendEmptyMessageDelayed(8, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWimaxStateChanged(WimaxStateChangeResult newWimaxState) {
        switch (newWimaxState.state) {
            case UNKNOWN: {
                this.sendWimaxStateChangeBroadcast();
                break;
            }
            case INITIALIZING: {
                if (this.hasMessages(17)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[INITIALIZING] removeMessage(EVENT_START_INITIALIZING)");
                    }
                    this.removeMessages(17);
                }
                this.mIpRenew = false;
                if (this.mIsTetheredmode) {
                    this.sendModeChangeBroadcast(1);
                } else {
                    this.sendModeChangeBroadcast(0);
                }
                this.m_bUserDisconnect = false;
                this.mWM.setWimaxStatus(3);
                this.sendWimaxStateChangeBroadcast();
                int nMode = this.mWM.getWimaxMode();
                if (nMode == 4 || nMode == 2 || nMode == 1) {
                    WimaxNative.setBackhaulMode(true);
                } else {
                    WimaxNative.setBackhaulMode(false);
                }
                if (nMode == 4 || nMode == 3) {
                    WimaxNative.setDMMode(true);
                } else {
                    WimaxNative.setDMMode(false);
                }
                WimaxNative.setRctMode(this.m_bRct);
                this.m_bReject = false;
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.DISCONNECTED_USB && this.mEnableUSB && !this.mTetheredModeUsbPlugged) {
                    this.setUsbUnPlugged();
                }
                this.mRunState = 2;
                this.m_bUserDisconnect = false;
                this.mTornDownByConnMgr = false;
                this.nRetryFlag = 0;
                this.m_strErrorMsg = null;
                this.nScanAttempt = 0;
                break;
            }
            case INITIALIZED: {
                if (this.hasMessages(17)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[INITIALIZED] removeMessage(EVENT_START_INITIALIZING)");
                    }
                    this.removeMessages(17);
                }
                this.sendWimaxStateChangeBroadcast();
                if (this.mWimaxStateOld == WimaxState.UNKNOWN || this.mWimaxStateOld == WimaxState.INITIALIZING) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[handleMessageWimaxStateChanged] nRetryFlag = 0, nScanAttempt = 0");
                    }
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                }
                this.m_bUserDisconnect = false;
                int[] nOdbCfgData = WimaxNative.getOdbConfigData();
                this.WIMAX_SCAN_RETRY_SECONDS = nOdbCfgData[1];
                this.WIMAX_SCAN_ATTEMPT_TIMEOUT = nOdbCfgData[2];
                this.WIMAX_ENTRY_DELAY = nOdbCfgData[5];
                this.noteRunState();
                DeviceInfo di = this.mWM.getDeviceInformation();
                String macAddress = di == null ? null : di.getMacAddressString();
                SystemProperties.set((String)"net.wimax.mac.address", (String)macAddress);
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)("macAddress : " + macAddress));
                }
                if (!this.mEnableUSB) {
                    this.checkUseStaticIp();
                    HandlerThread dhcpThread = new HandlerThread("Wimax DHCP Handler Thread");
                    dhcpThread.start();
                    WimaxStateTracker wimaxStateTracker = this;
                    synchronized (wimaxStateTracker) {
                        if (this.mDhcpTarget != null) {
                            this.mDhcpTarget.getLooper().quit();
                            this.mDhcpTarget = null;
                        }
                    }
                    this.mDhcpTarget = new DhcpHandler(dhcpThread.getLooper(), (Handler)this);
                    if (this.m_bLog) {
                        Log.v((String)TAG, (String)"Wimax DhcpHandler Started");
                    }
                }
                this.mTornDownByConnMgr = false;
                WimaxManager.MulticastLock l = this.mWM.createMulticastLock(TAG);
                l.acquire();
                l.release();
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = WimaxState.SCANNING;
                this.mWimaxStateDetail = null;
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.SCANNING);
                if (!this.m_bNoBackOff && this.getDataEnabled() && !this.mWM.isWiFiConnect()) {
                    this.mWM.startScan();
                    break;
                }
                this.acquire_WakeLock();
                WimaxNative.VirtualIdleReq(-1, (byte)1);
                if (this.hasMessages(6)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                    }
                    this.removeMessages(6);
                }
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
            case SCANNING: {
                this.sendWimaxStateChangeBroadcast();
                this.isIdleState = false;
                this.isHaveLinkInfo = false;
                this.setTornDownByConnMgr(false);
                this.setDetailedState(NetworkInfo.DetailedState.SCANNING);
                break;
            }
            case READY: {
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.IDLE);
                this.mHaveIpAddress = false;
                this.mObtainingIpAddress = false;
                this.checkUseStaticIp();
                this.requestPolledInfo(this.mWimaxInfo, false);
                this.setPollTimer();
                if (this.m_bUserDisconnect) {
                    if (!this.m_bLog) break;
                    Log.d((String)TAG, (String)"[handleWimaxStateChanged : READY] USER Disconnect!!!!!!!!!!!!!!!!!!!!!!!!!");
                    break;
                }
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.CONNECTING);
                if (this.mWM.connect("", "", "", "") == 0) break;
                if (this.m_bLog) {
                    Log.e((String)TAG, (String)"[handleWimaxStateChanged : READY] connect() returns fail.");
                }
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = WimaxState.DISCONNECTED;
                this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Timeout_NE;
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                break;
            }
            case CONNECTING: {
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.CONNECTING);
                break;
            }
            case OBTAINING_IPADDR: {
                this.configureInterface();
                this.mDhcpStart = new Date().getTime();
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage : DhcpStart is " + this.mDhcpStart + "ms"));
                }
                this.sendWimaxStateChangeBroadcast();
                this.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                break;
            }
            case CONNECTED: {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("mHaveIpAddress :" + this.mHaveIpAddress));
                }
                if (this.isIdleState) {
                    if (this.hasMessages(16)) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"[handleMessageWimaxStateChanged] removeMessage(EVENT_MOCALL_FAIL)");
                        }
                        this.removeMessages(16);
                    }
                    this.isIdleState = false;
                    this.setPollTimer();
                }
                if (!this.mEnableUSB) {
                    if (this.mHaveIpAddress) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)("[handleMessageWimaxStateChanged] nRetryFlag = " + this.nRetryFlag + " -> 0"));
                        }
                        this.configureInterface();
                        this.nRetryFlag = 0;
                        this.nScanAttempt = 0;
                        if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Idle) {
                            this.isIdleState = true;
                        }
                        this.sendWimaxStateChangeBroadcast();
                        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                        this.mWM.release_sWakeLock();
                    } else {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"[handleMessageWimaxStateChanged] No IP Address -> setDetailedState.OBTAINING_IPADDR");
                        }
                        this.mWimaxState = WimaxState.OBTAINING_IPADDR;
                        this.mWimaxStateDetail = null;
                        this.configureInterface();
                        this.mDhcpStart = new Date().getTime();
                        this.sendWimaxStateChangeBroadcast();
                        this.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                    }
                } else if (this.mWimaxStateOld != WimaxState.CONNECTED && this.mWimaxStateOld != WimaxState.OBTAINING_IPADDR) {
                    this.mWimaxState = WimaxState.OBTAINING_IPADDR;
                    this.mWimaxStateDetail = null;
                    this.sendWimaxStateChangeBroadcast();
                    this.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                } else if (this.mWimaxStateOld == WimaxState.OBTAINING_IPADDR) {
                    if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.IP_USB) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)("[handleMessageWimaxStateChanged] Tethered mode : nRetryFlag = " + this.nRetryFlag + " -> 0"));
                        }
                        this.nRetryFlag = 0;
                        this.nScanAttempt = 0;
                        this.sendWimaxStateChangeBroadcast();
                        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                        this.mWM.release_sWakeLock();
                    }
                } else {
                    if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Idle) {
                        this.isIdleState = true;
                    }
                    this.sendWimaxStateChangeBroadcast();
                    this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                }
                if (this.isIdleState) break;
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[CONNECTED] m_bScreenOff :" + this.m_bScreenOff));
                }
                this.SetScreenOff(this.m_bScreenOff);
                break;
            }
            case DISCONNECTING: {
                this.sendWimaxStateChangeBroadcast();
                break;
            }
            case DISCONNECTED: {
                this.acquire_WakeLock();
                if (this.hasMessages(16)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[DISCONNECTED] removeMessage(EVENT_MOCALL_FAIL)");
                    }
                    this.removeMessages(16);
                }
                if (newWimaxState.info != null && newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Abnormal_State) {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)"-------- Abnormal_State  ----------");
                    }
                    this.mModemReset = true;
                    this.isHaveLinkInfo = false;
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    this.resetInterface();
                    this.mWimaxInfo.setBSID("00:00:00:00:00:00");
                    this.mWimaxInfo.setFREQ(0);
                    this.mWimaxInfo.setRssi(-9999);
                    this.mWimaxInfo.setCINR(0);
                    this.mWimaxInfo.setTxPower(0);
                    this.nOldSignalLevel = -1;
                    this.mWM.setWimaxEnabled(true);
                    return;
                }
                this.isHaveLinkInfo = false;
                this.resetLinkStatusInfo();
                this.sendWimaxStateChangeBroadcast();
                if (this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[handleMessageWimaxStateChanged] ^^^ DetailedState.DISCONNECTED ^^^");
                    }
                    this.updateWimaxNotiMsg();
                    this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                } else {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[handleMessageWimaxStateChanged] ^^^ DetailedState.FAILED ^^^");
                    }
                    this.setDetailedState(NetworkInfo.DetailedState.FAILED);
                }
                if (this.m_bUserDisconnect) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"USER Disconnect!!!!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    this.setTornDownByConnMgr(false);
                    if (this.mWM.getWimaxStatus() != 0) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"setWimaxStatus(WIMAX_STATUS_DISABLING)");
                        }
                        this.mWM.setWimaxStatus(0);
                    }
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    this.resetInterface();
                    if (!WimaxNative.stopWimax() && this.m_bLog) {
                        Log.e((String)TAG, (String)"Failed to stop Wimax.");
                    }
                    if (!WimaxNative.loadDriver((byte)0)) {
                        if (this.m_bLog) {
                            Log.e((String)TAG, (String)"[handleMessageWimaxStateChanged] Failed to unload Wimax driver.");
                        }
                        this.mWM.release_sWakeLock();
                    } else {
                        this.notifyDriverStopped();
                    }
                    this.m_bUserDisconnect = false;
                    break;
                }
                if (this.mWimaxStateOld != WimaxState.DISCONNECTED) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"Fail for Connect command !!!!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Timeout_Sync || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Timeout_NE) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)("Connection Time out !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)((Object)newWimaxState.info)));
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Syncup_PHY || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Syncup_MAC) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)("Sync Fail !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)((Object)newWimaxState.info)));
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_Device || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_User) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)("Auth Fail !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)((Object)newWimaxState.info)));
                    }
                    this.RetryProcess();
                    break;
                }
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"Virtual IDLE!!!!!!!!!!!!!! ");
                }
                if (this.hasMessages(8)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[DISCONNECTED] removeMessage(EVENT_VI_REQ)");
                    }
                    this.removeMessages(8);
                }
                if (this.hasMessages(6)) break;
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
        }
    }

    private static void putAddress(StringBuffer buf, int addr) {
        StringBuffer stringBuffer = buf.append(addr & 0xFF).append('.');
        int n = addr >>> 8;
        addr = n;
        addr = addr >>> 8;
        stringBuffer.append(n & 0xFF).append('.').append(addr & 0xFF).append('.').append((addr >>>= 8) & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleMessage(Message msg) {
        if (this.m_bLog) {
            Log.d((String)"WimaxStateTracker", (String)("[handleMessage] Received msg = " + msg.what));
        }
        switch (msg.what) {
            case 1: {
                result = (WimaxStateChangeResult)msg.obj;
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = result.state;
                this.mWimaxStateDetail = result.info;
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage] Old state is " + (Object)this.mWimaxStateOld));
                }
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage] New state is " + (Object)this.mWimaxState + " New detailed info is " + (Object)this.mWimaxStateDetail));
                }
                this.updateNetworkInfo();
                this.handleWimaxStateChanged(result);
                break;
            }
            case 4: {
                if (this.isHaveLinkInfo) {
                    if (!this.isIdleState) {
                        this.requestPolledInfo(this.mWimaxInfo, true);
                        this.setPollTimer();
                        break;
                    }
                    if (!this.m_bLog) break;
                    Log.d((String)"WimaxStateTracker", (String)"[handleMessage:EVENT_POLL_INTERVAL] ^^^^^ IDLE MODE ^^^^^");
                    break;
                }
                if (!this.m_bLog) break;
                Log.d((String)"WimaxStateTracker", (String)"[handleMessage:EVENT_POLL_INTERVAL] ^^^^^ DISCONNECTED ^^^^^");
                break;
            }
            case 6: {
                this.mWM.release_sWakeLock();
                break;
            }
            case 7: {
                this.mWM.startScan();
                break;
            }
            case 8: {
                WimaxNative.VirtualIdleReq(-1, (byte)1);
                if (this.hasMessages(6)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[EVENT_VI_REQ] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                    }
                    this.removeMessages(6);
                }
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
            case 2: {
                this.mIpRenew = false;
                str = new StringBuffer();
                WimaxStateTracker.putAddress(str, this.mDhcpInfo.netmask);
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("mDhcpInfo.netmask:" + this.mDhcpInfo.netmask));
                }
                if (this.mDhcpInfo.netmask == -1) {
                    if (this.m_bLog) {
                        Log.w((String)"WimaxStateTracker", (String)"SystemProperties.set wimax_route");
                    }
                    SystemProperties.set((String)"ctl.start", (String)"wimax_route");
                }
                this.mDhcpEnd = new Date().getTime();
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage : DhcpEnd is " + this.mDhcpEnd + "ms"));
                }
                this.mDiffDhcpTime = (int)(this.mDhcpEnd - this.mDhcpStart);
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage : DHCP Difference is " + this.mDiffDhcpTime + "ms"));
                }
                this.sendDHCPTimeBroadcast(this.mDiffDhcpTime);
                this.mHaveIpAddress = true;
                this.mObtainingIpAddress = false;
                this.mWimaxInfo.setIpAddress(this.mDhcpInfo.ipAddress);
                if (this.m_bLog) {
                    Log.v((String)"WimaxStateTracker", (String)("mNetworkInfo.getDetailedState() " + this.mNetworkInfo.getDetailedState()));
                }
                if (this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTED) {
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    this.mWimaxState = WimaxState.CONNECTED;
                    this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Registered;
                    WimaxNative.IpObtained();
                    this.sendWimaxStateChangeBroadcast();
                    this.updateWimaxNotiMsg();
                    this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                } else {
                    WimaxNative.IpObtained();
                    msg2 = this.mTarget.obtainMessage(4, (Object)this.mNetworkInfo);
                    msg2.sendToTarget();
                    if (!this.mEnableUSB && this.isIdleState) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"mEnableUSB == false, isIdleState == true");
                        }
                        this.isIdleState = false;
                        this.setPollTimer();
                        this.mWimaxState = WimaxState.CONNECTED;
                        this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Registered;
                        WimaxNative.IpObtained();
                        this.sendWimaxStateChangeBroadcast();
                        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                    }
                }
                if (this.m_bLog) {
                    Log.i((String)"WimaxStateTracker", (String)("[handleMessage] >>> IP configuration <<< " + this.mDhcpInfo));
                }
                if (ActivityManagerNative.isSystemReady()) {
                    this.mContext.sendBroadcast(new Intent("android.net.wimax.NETWORK_IP_CHANGED"));
                }
                this.mWM.release_sWakeLock();
                break;
            }
            case 3: {
                this.mIpRenew = false;
                if (this.m_bLog) {
                    Log.e((String)"WimaxStateTracker", (String)"[handleMessage] >>> IP configuration...  failed <<< ");
                }
                this.mHaveIpAddress = false;
                this.mWimaxInfo.setIpAddress(0);
                this.mObtainingIpAddress = false;
                this.mDiffDhcpTime = -1;
                this.sendDHCPTimeBroadcast(this.mDiffDhcpTime);
                if (this.mDhcpTarget != null) {
                    this.mDhcpTarget.setCancelCallback(true);
                    if (this.mDhcpTarget.hasMessages(5)) {
                        this.mDhcpTarget.removeMessages(5);
                    }
                    if (this.mDhcpTarget.hasMessages(10)) {
                        this.mDhcpTarget.removeMessages(10);
                    }
                }
                if (!NetworkUtils.stopDhcp((String)this.mInterfaceName) && this.m_bLog) {
                    Log.e((String)"WimaxStateTracker", (String)"Could not stop DHCP");
                }
                NetworkUtils.disableInterface((String)this.mInterfaceName);
                msg2 = this;
                synchronized (msg2) {
                    if ((this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.OBTAINING_IPADDR) && this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"[handleMessage:EVENT_INTERFACE_CONFIGURATION_FAILED] b4 disconnectWimax()");
                    }
                    WimaxNative.disconnectWimax();
                    break;
                }
            }
            case 9: {
                v0 = driverStarted = msg.arg1 != 0;
                if (this.m_bLog) {
                    Log.v((String)"WimaxStateTracker", (String)("[handleMessage:EVENT_DRIVER_STATE_CHANGED] (" + driverStarted + ")"));
                }
                if (!driverStarted) {
                    this.m_bUserDisconnect = false;
                    this.mWM.setWimaxStatus(1);
                    if (this.hasMessages(8)) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"[EVENT_DRIVER_STATE_CHANGED] removeMessage(EVENT_VI_REQ)");
                        }
                        this.removeMessages(8);
                    }
                    if (this.hasMessages(7)) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"[EVENT_DRIVER_STATE_CHANGED] removeMessage(EVENT_SCAN_DELAY)");
                        }
                        this.removeMessages(7);
                    }
                    if (this.m_bLog) {
                        Log.i((String)"WimaxStateTracker", (String)"!!!!!!!!!!!!!!!!!set DISCONNECTED state When 4G is turned off  before scanning step!!!!!!!!!!!!!!!!!!");
                    }
                    this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                    this.mWM.release_sWakeLock();
                    if (this.mEnableUSB) {
                        if (this.m_bLog) {
                            Log.i((String)"WimaxStateTracker", (String)"!!!!!!!!!!!!!!!!! Tethered Mode Start !!!!!!!!!!!!!!!!!!");
                        }
                        this.setUSBTo(this.mEnableUSB);
                        this.mTetheredModeUsbPlugged = true;
                        this.mModemReset = false;
                        this.mWimaxState = WimaxState.DISCONNECTED;
                        this.mWimaxStateOld = WimaxState.DISCONNECTED;
                        this.mWM.setWimaxEnabled(true);
                    }
                }
                this.noteRunState();
                break;
            }
            case 11: {
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage] AUTH_FAIL  nErrorCode : " + msg.arg1 + ", Length :" + msg.arg2));
                }
                nLength = msg.arg2;
                if (msg.arg1 != 5 || nLength <= 0) ** GOTO lbl214
                tempbf = ByteBuffer.allocate(nLength);
                respDataArray = new byte[nLength];
                tempbf = (ByteBuffer)msg.obj;
                respDataArray = tempbf.array();
                strtest = "";
                try {
                    strtest = temp = new String(respDataArray, "UTF-8");
                }
                catch (NullPointerException ne) {
                    if (this.m_bLog) {
                        Log.e((String)"STR_CONVERT", (String)"encoding NullPointerException");
                    }
                }
                catch (UnsupportedEncodingException ue) {
                    if (!this.m_bLog) ** GOTO lbl204
                    Log.e((String)"STR_CONVERT", (String)"encoding UnsupportedEncodingException");
                }
lbl204:
                // 4 sources

                if (this.m_strErrorMsg != null && this.m_strErrorMsg.equals(strtest)) {
                    if (!this.m_bLog) break;
                    Log.d((String)"WimaxStateTracker", (String)"m_strErrorMsg == strtest");
                    break;
                }
                this.m_strErrorMsg = strtest;
                t = Toast.makeText((Context)this.mContext, (CharSequence)strtest, (int)1);
                t.show();
                new Thread(new Runnable(){

                    public void run() {
                        for (int i = 0; i < 1; ++i) {
                            try {
                                Thread.sleep(2000L);
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.d((String)WimaxStateTracker.TAG, (String)("thread toast(" + i + ")"));
                                }
                                t.show();
                                continue;
                            }
                            catch (InterruptedException e) {
                                if (!WimaxStateTracker.this.m_bLog) break;
                                Log.e((String)WimaxStateTracker.TAG, (String)"------EVENT_AUTH_FAIL InterruptedException----------------");
                                break;
                            }
                        }
                    }
                }).start();
                break;
lbl214:
                // 1 sources

                if (msg.arg1 != 4) break;
                this.setRejectionCode(true);
                break;
            }
            case 12: {
                this.sendWimaxOMADMResponseBroadcast((ByteBuffer)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 13: {
                this.sendWimaxRadioInfoResponseBroadcast();
                break;
            }
            case 14: {
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage] EVENT_LINK_WEAK_INFO : 4G will disconnect. (currentState :" + (Object)this.mWimaxState + ")"));
                }
                this.mWM.disconnect();
                break;
            }
            case 15: {
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)"[handleMessage] EVENT_MOCALL_INFO : wait 5sec. ");
                }
                this.acquire_WakeLock();
                if (this.hasMessages(16)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[handleMessage] removeMessage(EVENT_MOCALL_FAIL)");
                    }
                    this.removeMessages(16);
                }
                this.sendEmptyMessageDelayed(16, 5000L);
                break;
            }
            case 16: {
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage] EVENT_MOCALL_FAIL : 4G will disconnect. (currentState :" + (Object)this.mWimaxState + ")"));
                }
                this.mWM.disconnect();
                break;
            }
            case 17: {
                if (this.m_bLog) {
                    Log.e((String)"WimaxStateTracker", (String)"-------- EVENT_START_INITIALIZING >>>>> Abnormal_State  ----------");
                }
                if (this.hasMessages(17)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[INITIALIZED] removeMessage(EVENT_START_INITIALIZING)");
                    }
                    this.removeMessages(17);
                }
                this.mModemReset = true;
                this.isHaveLinkInfo = false;
                this.nRetryFlag = 0;
                this.nScanAttempt = 0;
                this.resetInterface();
                this.mWimaxInfo.setBSID("00:00:00:00:00:00");
                this.mWimaxInfo.setFREQ(0);
                this.mWimaxInfo.setRssi(-9999);
                this.mWimaxInfo.setCINR(0);
                this.mWimaxInfo.setTxPower(0);
                this.nOldSignalLevel = -1;
                this.mWM.setWimaxEnabled(true);
                break;
            }
        }
    }

    public boolean getNoBackoff() {
        return this.m_bNoBackOff;
    }

    public void SetNoBackOff(boolean bNoBackOff) {
        this.m_bNoBackOff = bNoBackOff;
    }

    private void RetryProcess() {
        this.resetInterface();
        if (this.m_bNoBackOff) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] m_bNoBackOff --return");
            }
            this.acquire_WakeLock();
            WimaxNative.VirtualIdleReq(-1, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
            return;
        }
        if (this.mTornDownByConnMgr || this.mWM.isWiFiConnect() || !this.getDataEnabled()) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] mTornDownByConnMgr && mWM.isWiFiConnect()--return");
            }
            if (this.mWM.isWiFiConnect()) {
                this.setTornDownByConnMgr(true);
            }
            this.acquire_WakeLock();
            WimaxNative.VirtualIdleReq(-1, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
            return;
        }
        if (this.m_bMruWorking) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] m_bMruWorking --return");
            }
            this.mWM.release_sWakeLock();
            return;
        }
        if (this.m_bLog) {
            Log.i((String)TAG, (String)"[RetryProcess] >>>>>>>>>>>> WELCOME to RetryProcess <<<<<<<<<<<<<<<<<<");
        }
        int nMode = this.mWM.getWimaxMode();
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[RetryProcess] nMode : " + nMode));
        }
        if (nMode == 2 || nMode == 4 || nMode == 1) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"BACKHAUL mode......!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            WimaxNative.setBackhaulMode(true);
        } else {
            WimaxNative.setBackhaulMode(false);
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[RetryProcess] ++++ nRetryFlag =  " + this.nRetryFlag + " ++++"));
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[RetryProcess] ++++ nScanAttempt =  " + this.nScanAttempt + " ++++"));
        }
        if (this.nScanAttempt < this.WIMAX_SCAN_ATTEMPT_TIMEOUT) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)("++++ " + this.nScanAttempt + "<" + this.WIMAX_SCAN_ATTEMPT_TIMEOUT + " ++++"));
            }
            if (this.hasMessages(7)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_SCAN_DELAY)");
                }
                this.removeMessages(7);
            }
            this.sendEmptyMessageDelayed(7, 1000L);
        } else {
            int nWaitTime = this.WIMAX_SCAN_RETRY_SECONDS + this.nRetryFlag * this.WIMAX_SCAN_RETRY_SECONDS;
            if (this.m_bLog) {
                Log.d((String)TAG, (String)("++++ time = " + nWaitTime + " ++++"));
            }
            if (nWaitTime <= 1800) {
                ++this.nRetryFlag;
            } else {
                nWaitTime = 1800;
            }
            this.nScanAttempt = 0;
            WimaxNative.VirtualIdleReq(nWaitTime, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
        }
    }

    public void clearRetryFlag() {
        this.nRetryFlag = 0;
        this.nScanAttempt = 0;
        if (this.hasMessages(7)) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"[clearRetryFlag] removeMessage(EVENT_SCAN_DELAY)");
            }
            this.removeMessages(7);
        }
    }

    public void configureInterface() {
        this.setPollTimer();
        if (this.mEnableUSB) {
            return;
        }
        if (!this.mUseStaticIp) {
            if (!this.mHaveIpAddress && !this.mObtainingIpAddress) {
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)"[configureInterface] !mHaveIpAddress && !mObtainingIpAddress");
                }
                this.mObtainingIpAddress = true;
                this.mDhcpTarget.sendEmptyMessage(5);
            }
        } else if (!this.mHaveIpAddress) {
            int event;
            if (NetworkUtils.configureInterface((String)this.mInterfaceName, (DhcpInfo)this.mDhcpInfo)) {
                this.mHaveIpAddress = true;
                event = 2;
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)"Static IP configuration succeeded");
                }
            } else {
                this.mHaveIpAddress = false;
                event = 3;
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)"Static IP configuration failed");
                }
            }
            this.sendEmptyMessage(event);
        }
    }

    public void resetLinkStatusInfo() {
        this.mWimaxInfo.setBSID("00:00:00:00:00:00");
        this.mWimaxInfo.setFREQ(0);
        this.mWimaxInfo.setRssi(-9999);
        this.mWimaxInfo.setCINR(0);
        this.mWimaxInfo.setTxPower(0);
        this.nOldSignalLevel = -1;
        this.mWimaxState = WimaxState.DISCONNECTED;
        this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
        this.sendWimaxStateChangeBroadcast();
    }

    public void resetOldState() {
        this.mWimaxMonitor.resetOldState();
    }

    public void resetInterface() {
        this.isHaveLinkInfo = false;
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mWimaxInfo.setIpAddress(0);
        this.mIpRenew = false;
        if (!this.mEnableUSB) {
            this.mAlarmManager.cancel(this.mDhcpRenewIntent);
            NetworkUtils.resetConnections((String)this.mInterfaceName);
            if (this.mDhcpTarget != null) {
                this.mDhcpTarget.setCancelCallback(true);
                if (this.mDhcpTarget.hasMessages(5)) {
                    this.mDhcpTarget.removeMessages(5);
                }
                if (this.mDhcpTarget.hasMessages(10)) {
                    this.mDhcpTarget.removeMessages(10);
                }
            }
            if (!NetworkUtils.stopDhcp((String)this.mInterfaceName) && this.m_bLog) {
                Log.e((String)TAG, (String)"[resetInterface] Could not stop DHCP");
            }
            NetworkUtils.disableInterface((String)this.mInterfaceName);
        }
        this.mDhcpInfo.ipAddress = 0;
        this.mDhcpInfo.gateway = 0;
        this.mDhcpInfo.netmask = 0;
        this.mDhcpInfo.dns1 = 0;
        this.mDhcpInfo.dns2 = 0;
        this.mDhcpInfo.serverAddress = 0;
        this.mDhcpInfo.leaseDuration = 0;
    }

    public DhcpInfo getDhcpInfo() {
        return this.mDhcpInfo;
    }

    public WimaxState getCurrentWimaxState() {
        return this.mWimaxState;
    }

    public WimaxInfo requestConnectionInfo() {
        this.requestPolledInfo(this.mWimaxInfo, false);
        return this.mWimaxInfo;
    }

    public void SetScreenOff(boolean bScreenOff) {
        this.m_bScreenOff = bScreenOff;
        if (this.isIdleState) {
            return;
        }
        if (!(this.mWimaxState != WimaxState.CONNECTING && this.mWimaxState != WimaxState.OBTAINING_IPADDR && this.mWimaxState != WimaxState.CONNECTED && this.mWimaxState != WimaxState.READY || this.m_bScreenOff)) {
            WimaxNative.setLinkInfo(true);
        }
        if (this.m_bScreenOff) {
            WimaxNative.setLinkInfo(false);
        }
    }

    private synchronized void requestPolledInfo(WimaxInfo info, boolean periodic) {
        if (this.m_bScreenOff) {
            return;
        }
        if (periodic) {
            long nNewRxBytes = this.mConnectionStatistics.getTotalRxBytes();
            long nNewTxBytes = this.mConnectionStatistics.getTotalTxBytes();
            int nExtra = 0;
            if (this.mTotalRxBytes != nNewRxBytes && this.mTotalTxBytes == nNewTxBytes) {
                this.mTotalRxBytes = nNewRxBytes;
                nExtra = 2;
            } else if (this.mTotalRxBytes == nNewRxBytes && this.mTotalTxBytes != nNewTxBytes) {
                this.mTotalTxBytes = nNewTxBytes;
                nExtra = 1;
            } else if (this.mTotalRxBytes != nNewRxBytes && this.mTotalTxBytes != nNewTxBytes) {
                this.mTotalRxBytes = nNewRxBytes;
                this.mTotalTxBytes = nNewTxBytes;
                nExtra = 3;
            } else if (this.mTotalRxBytes == nNewRxBytes && this.mTotalTxBytes == nNewTxBytes) {
                nExtra = 0;
            }
            this.sendDataUsedBroadcast(nExtra);
        }
        String sBsid = null;
        int nTxpower = 0;
        int nCF = 0;
        int sRssi = 0;
        int sCinr = 0;
        String rev_info = null;
        String rev_time = null;
        rev_info = WimaxNative.getLinkInfo();
        rev_time = WimaxNative.getConnectionTime();
        if (rev_info == null) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[requestPolledInfo] getLinkInfo() returns null");
            }
            return;
        }
        StringTokenizer st = new StringTokenizer(rev_info, "#");
        if (st.hasMoreTokens()) {
            nCF = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                sRssi = Integer.parseInt(st.nextToken());
                if (sRssi == -123) {
                    return;
                }
                if (st.hasMoreTokens()) {
                    sCinr = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        nTxpower = Integer.parseInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            sBsid = st.nextToken();
                        }
                    }
                }
            }
        }
        if (!info.getBSID().equals(sBsid)) {
            info.setBSID(sBsid);
            this.sendBSIDChangeBroadcast(sBsid);
        }
        if (info.getFREQ() != nCF) {
            info.setFREQ(nCF);
            this.sendFrequencyChangeBroadcast(nCF);
        }
        int oldRssi = info.getRssi();
        int oldCinr = info.getCINR();
        if (oldRssi != sRssi || oldCinr != sCinr) {
            int nNewSignalLevel;
            if (oldRssi != sRssi) {
                info.setRssi(sRssi);
                this.sendSignalChangeBroadcast(sRssi);
            }
            if (oldCinr != sCinr) {
                info.setCINR(sCinr);
            }
            if (this.nOldSignalLevel != (nNewSignalLevel = WimaxManager.calculateSignalLevel(sRssi, sCinr, 4))) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("nNewSignalLevel ====> " + nNewSignalLevel));
                }
                this.sendSignalLevelChangeBroadcast(nNewSignalLevel);
                this.nOldSignalLevel = nNewSignalLevel;
            }
        }
        if (info.getTxPower() != nTxpower) {
            info.setTxPower(nTxpower);
        }
    }

    private synchronized void requestConnectionTime(WimaxInfo info) {
        String rev_time = null;
        rev_time = WimaxNative.getConnectionTime();
        int newTime = Integer.parseInt(rev_time);
        this.sendConnectionTimeChangeBroadcast(newTime);
    }

    private void sendBSIDChangeBroadcast(String newBsid) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.BSID_CHANGED");
            intent.putExtra("newBSID", newBsid);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendFrequencyChangeBroadcast(int newFreq) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.FREQUENCY_CHANGED");
            intent.putExtra("newFrequency", newFreq);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendSignalChangeBroadcast(int newRssi) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.RSSI_CHANGED");
            intent.putExtra("newRSSI", newRssi);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendSignalLevelChangeBroadcast(int newSignalLevel) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.SIGNAL_LEVEL_CHANGED");
            intent.putExtra("newSignalLevel", newSignalLevel);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendDataUsedBroadcast(int noUpDown) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.WIMAX_DATA_USED");
            intent.putExtra("upDownData", noUpDown);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendModeChangeBroadcast(int usbMode) {
        Intent intent = new Intent("android.net.wimax.MODE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("usbMode", usbMode);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendWimaxStateChangeBroadcast() {
        Intent intent = new Intent("android.net.wimax.WIMAX_STATE_CHANGE");
        intent.addFlags(0x10000000);
        intent.putExtra("WimaxState", this.mWimaxState.ordinal());
        if ((this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.CONNECTED || this.mWimaxState == WimaxState.DISCONNECTED) && this.mWimaxStateDetail != null) {
            intent.putExtra("WimaxStateDetail", this.mWimaxStateDetail.ordinal());
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendConnectionTimeChangeBroadcast(int newTime) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.TIME_CHANGED");
            intent.putExtra("newTime", newTime);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendDHCPTimeBroadcast(int newDHCPTime) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.WIMAX_DHCP_TIME");
            intent.putExtra("newDHCPTime", newDHCPTime);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    void sendMruListBroadcast(int nlistSize) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.addFlags(0x10000000);
        intent.putExtra("MruList", nlistSize);
        this.mContext.sendBroadcast(intent);
    }

    void sendMruUpdateBroadcast(int subType, int ErrorValue) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.addFlags(0x10000000);
        intent.putExtra("subType", subType);
        intent.putExtra("ErrorValue", ErrorValue);
        this.mContext.sendBroadcast(intent);
    }

    void sendWimaxRadioInfoResponseBroadcast() {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.putExtra("WimaxRadioInfo", 1);
        this.mContext.sendBroadcast(intent);
    }

    public void sendWorkModeBroadCast(int workMode) {
        Intent intent = new Intent("android.net.wimax.WIMAX_WORK_MODE");
        intent.putExtra("WimaxWorkMode", workMode);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendWimaxOMADMResponseBroadcast(ByteBuffer respDataAray, int nRetType, int odbMngState) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.putExtra("WimaxOMADMRespData", respDataAray.array());
        intent.putExtra("WimaxOMADMRespState", odbMngState);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUSBTo(boolean enable) {
        byte[] data = enable ? WiMAX : PDA;
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("setUSBTo  enable: " + enable));
        }
        FileOutputStream out = null;
        out = new FileOutputStream(USB_PATH);
        out.write(data);
        Object var6_4 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"------setUSBTo IOException----------------");
        }
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var6_5 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)"------setUSBTo IOException----------------");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)"------setUSBTo IOException----------------");
            }
            throw throwable;
        }
    }

    public boolean teardown() {
        if (!this.mTornDownByConnMgr) {
            if (this.mWimaxState == WimaxState.CONNECTED || this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.OBTAINING_IPADDR) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[teardown] state(" + (Object)((Object)this.mWimaxState) + ") DisconnectWimax"));
                }
                this.resetInterface();
                if (this.mWM.disconnect()) {
                    this.setTornDownByConnMgr(true);
                    return true;
                }
                return true;
            }
            int wimaxStatus = this.mWM.getWimaxStatus();
            if ((wimaxStatus == 3 || wimaxStatus == 2) && this.m_bLog) {
                Log.d((String)TAG, (String)("[teardown] state(" + (Object)((Object)this.mWimaxState) + ") stopWimax"));
            }
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[teardown] already turned off");
            }
            return true;
        }
        if (this.m_bLog) {
            Log.w((String)TAG, (String)"[teardown] ========mTornDownByConnMgr is already true===========");
        }
        return true;
    }

    public void isBootCompleted(boolean bCompleted) {
        this.m_isBootCompleted = bCompleted;
    }

    public boolean getDataEnabled() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"mobile_data") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            return true;
        }
    }

    public boolean reconnect() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[reconnect] mTornDownByConnMgr = " + this.mTornDownByConnMgr + "  getCurrentWimaxState() = " + (Object)((Object)this.getCurrentWimaxState()) + " getWimaxStatus()  = " + this.mWM.getWimaxStatus()));
        }
        if (!this.mWM.getPersistedWimaxEnabled()) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[reconnect] This is NOT by User request.... reject...");
            }
            return false;
        }
        if (!this.m_isBootCompleted) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[reconnect] m_isBootCompleted is false ");
            }
            return false;
        }
        if (this.mWM.isWiFiConnect()) {
            return false;
        }
        if (!this.getDataEnabled()) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[reconnect] !getDataEnabled.... reject...");
            }
            return false;
        }
        if (this.mWM.getWimaxStatus() == 1 || this.mWM.getWimaxStatus() == 0 || this.mWM.getWimaxStatus() == 2 || this.mWM.getWimaxStatus() == 4) {
            return false;
        }
        if (this.m_bLog) {
            Log.w((String)TAG, (String)"[reconnect] 4G want to reconnect by backoff algorithm.");
        }
        if (this.mWM.getWimaxState() == WimaxState.DISCONNECTED) {
            this.setTornDownByConnMgr(false);
            this.mWM.startScan(false);
            return true;
        }
        return false;
    }

    public synchronized boolean disconnectAndStop() {
        if (this.mRunState != 3 && this.mRunState != 4) {
            this.mRunState = 3;
            this.isHaveLinkInfo = false;
            this.m_bUserDisconnect = true;
            return WimaxNative.disconnectWimax();
        }
        this.releaseWakeLock();
        return true;
    }

    public synchronized boolean restart() {
        if (this.mRunState == 4) {
            this.mRunState = 1;
            return true;
        }
        if (this.mRunState == 3) {
            this.mRunState = 1;
        }
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        int nWimaxStatus = this.mWM.getWimaxStatus();
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[setRadio]  nWimaxStatus =" + nWimaxStatus));
        }
        if (nWimaxStatus == 3 || nWimaxStatus == 2) {
            return false;
        }
        return this.mWM.setWimaxEnabled(turnOn);
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setEnableLog(boolean blog) {
        this.m_bLog = blog;
        WimaxNative.setEnableLog(this.m_bLog);
        this.mWimaxMonitor.setEnableLog(this.m_bLog);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("interface ").append(this.mInterfaceName);
        sb.append(" runState=");
        if (this.mRunState >= 1 && this.mRunState <= mRunStateNames.length) {
            sb.append(mRunStateNames[this.mRunState - 1]);
        } else {
            sb.append(this.mRunState);
        }
        sb.append(LS).append(this.mWimaxInfo).append(LS);
        sb.append(this.mDhcpInfo).append(LS);
        sb.append("haveIpAddress=").append(this.mHaveIpAddress).append(", obtainingIpAddress=").append(this.mObtainingIpAddress).append(", explicitlyDisabled=").append(this.mTornDownByConnMgr);
        return sb.toString();
    }

    private static int stringToIpAddr(String addrString) throws UnknownHostException {
        try {
            String[] parts = addrString.split("\\.");
            if (parts.length != 4) {
                throw new UnknownHostException(addrString);
            }
            int a = Integer.parseInt(parts[0]);
            int b = Integer.parseInt(parts[1]) << 8;
            int c = Integer.parseInt(parts[2]) << 16;
            int d = Integer.parseInt(parts[3]) << 24;
            return a | b | c | d;
        }
        catch (NumberFormatException ex) {
            throw new UnknownHostException(addrString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkUseStaticIp() {
        FileInputStream fis;
        BufferedReader br;
        block31: {
            boolean fnfe2222;
            block30: {
                boolean fnfe2222;
                block29: {
                    boolean fnfe2222;
                    block28: {
                        boolean fnfe2222;
                        block27: {
                            this.mUseStaticIp = false;
                            ContentResolver cr = this.mContext.getContentResolver();
                            String msg = null;
                            Object backup_ip = null;
                            Object backup_gateway = null;
                            Object backup_netmask = null;
                            Object backup_dns1 = null;
                            Object backup_dns2 = null;
                            br = null;
                            fis = null;
                            try {
                                fis = new FileInputStream("/data/wimax_ip.txt");
                            }
                            catch (FileNotFoundException fnfe2222) {
                                if (!this.m_bLog) return false;
                                Log.d((String)TAG, (String)":)-------------------Use DHCP for WiMAX\n");
                                return false;
                            }
                            try {
                                try {
                                    block39: {
                                        block40: {
                                            block37: {
                                                block38: {
                                                    block35: {
                                                        block36: {
                                                            block33: {
                                                                block34: {
                                                                    block32: {
                                                                        br = new BufferedReader(new InputStreamReader(fis));
                                                                        msg = br.readLine();
                                                                        if (msg == null) break block32;
                                                                        this.mDhcpInfo.ipAddress = WimaxStateTracker.stringToIpAddr(msg);
                                                                        msg = br.readLine();
                                                                        if (msg == null) break block33;
                                                                        break block34;
                                                                    }
                                                                    if (this.m_bLog) {
                                                                        Log.e((String)TAG, (String)":)------ip-none----------Use DHCP for WiMAX\n");
                                                                    }
                                                                    fnfe2222 = false;
                                                                    Object var13_16 = null;
                                                                    break block27;
                                                                }
                                                                this.mDhcpInfo.gateway = WimaxStateTracker.stringToIpAddr(msg);
                                                                msg = br.readLine();
                                                                if (msg == null) break block35;
                                                                break block36;
                                                            }
                                                            if (this.m_bLog) {
                                                                Log.e((String)TAG, (String)":)------gateway-none-----Use DHCP for WiMAX\n");
                                                            }
                                                            this.mDhcpInfo.ipAddress = 0;
                                                            fnfe2222 = false;
                                                            break block28;
                                                        }
                                                        this.mDhcpInfo.netmask = WimaxStateTracker.stringToIpAddr(msg);
                                                        msg = br.readLine();
                                                        if (msg == null) break block37;
                                                        break block38;
                                                    }
                                                    if (this.m_bLog) {
                                                        Log.e((String)TAG, (String)":)------netmask-none-----Use DHCP for WiMAX\n");
                                                    }
                                                    this.mDhcpInfo.ipAddress = 0;
                                                    this.mDhcpInfo.gateway = 0;
                                                    fnfe2222 = false;
                                                    break block29;
                                                }
                                                this.mDhcpInfo.dns1 = WimaxStateTracker.stringToIpAddr(msg);
                                                msg = br.readLine();
                                                if (msg == null) break block39;
                                                break block40;
                                            }
                                            if (this.m_bLog) {
                                                Log.e((String)TAG, (String)":)------dns1-none--------Use DHCP for WiMAX\n");
                                            }
                                            this.mDhcpInfo.ipAddress = 0;
                                            this.mDhcpInfo.gateway = 0;
                                            this.mDhcpInfo.netmask = 0;
                                            fnfe2222 = false;
                                            break block30;
                                        }
                                        this.mDhcpInfo.dns2 = WimaxStateTracker.stringToIpAddr(msg);
                                        break block31;
                                    }
                                    this.mDhcpInfo.dns2 = 0;
                                    break block31;
                                }
                                catch (IOException e) {
                                    if (this.m_bLog) {
                                        Log.d((String)TAG, (String)":)-------exception---Use DHCP for WiMAX\n");
                                    }
                                    this.mDhcpInfo.ipAddress = 0;
                                    this.mDhcpInfo.gateway = 0;
                                    this.mDhcpInfo.netmask = 0;
                                    this.mDhcpInfo.dns1 = 0;
                                    this.mDhcpInfo.dns2 = 0;
                                    boolean bl = false;
                                    Object var13_21 = null;
                                    try {
                                        br.close();
                                        fis.close();
                                        return bl;
                                    }
                                    catch (IOException ioe) {
                                        if (this.m_bLog) {
                                            Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                                        }
                                        ioe.printStackTrace();
                                        return false;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_22 = null;
                                try {}
                                catch (IOException ioe) {
                                    if (this.m_bLog) {
                                        Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                                    }
                                    ioe.printStackTrace();
                                    return false;
                                }
                                br.close();
                                fis.close();
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException ioe) {
                            if (this.m_bLog) {
                                Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                            }
                            ioe.printStackTrace();
                            return false;
                        }
                        br.close();
                        fis.close();
                        return fnfe2222;
                    }
                    Object var13_17 = null;
                    try {}
                    catch (IOException ioe) {
                        if (this.m_bLog) {
                            Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                        }
                        ioe.printStackTrace();
                        return false;
                    }
                    br.close();
                    fis.close();
                    return fnfe2222;
                }
                Object var13_18 = null;
                try {}
                catch (IOException ioe) {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                    }
                    ioe.printStackTrace();
                    return false;
                }
                br.close();
                fis.close();
                return fnfe2222;
            }
            Object var13_19 = null;
            try {}
            catch (IOException ioe) {
                if (this.m_bLog) {
                    Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                }
                ioe.printStackTrace();
                return false;
            }
            br.close();
            fis.close();
            return fnfe2222;
        }
        Object var13_20 = null;
        try {}
        catch (IOException ioe) {
            if (this.m_bLog) {
                Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
            }
            ioe.printStackTrace();
            return false;
        }
        br.close();
        fis.close();
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"Use Static IP for WiMAX\n");
        }
        this.mUseStaticIp = true;
        return true;
    }

    private int getMaxDhcpRetries() {
        return this.WIMAX_SCAN_ATTEMPT_TIMEOUT;
    }

    public void setHaveLinkInfo(boolean mHaveLinkInfo) {
        this.isHaveLinkInfo = mHaveLinkInfo;
    }

    public void setIdleState(boolean mIdleState) {
        this.isIdleState = mIdleState;
    }

    public void setRctMode(boolean bRct) {
        this.m_bRct = bRct;
    }

    public void setRejectionCode(boolean bReject) {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("m_bReject = " + this.m_bReject));
        }
        this.m_bReject = bReject;
        this.nScanAttempt = this.WIMAX_SCAN_ATTEMPT_TIMEOUT;
    }

    private void updateWimaxNotiMsg() {
        if (this.mWM.isWimaxNotificationEnabled() && !this.mWM.isWiFiConnect()) {
            switch (this.mWimaxState) {
                case CONNECTED: {
                    this.setNotificationVisible(this.mContext, ICON_WIMAX_CONNECTED, null, "4G network connected");
                    break;
                }
                case DISCONNECTED: {
                    this.setNotificationVisible(this.mContext, ICON_WIMAX_DISCONNECTED, null, "4G network disconnected");
                }
            }
        }
    }

    public void setNotificationVisible(Context context, int iconID, CharSequence bodyMessage, CharSequence tickerMessage) {
        if (this.getValue()) {
            this.mNotification.icon = iconID;
            if (tickerMessage != null) {
                this.mNotification.tickerText = tickerMessage;
            }
            this.mNotification.setLatestEventInfo(context, null, bodyMessage, this.mWimaxSettingIntent);
            this.mWimaxNotifyManager.notify(iconID, this.mNotification);
            this.mWimaxNotifyManager.cancel(iconID);
        }
    }

    private boolean getValue() {
        return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wimax_networks_available_notification_on", (int)0) == 1;
    }

    static {
        PDA = new byte[]{80, 68, 65, 0};
        WiMAX = new byte[]{87, 73, 77, 65, 88, 0};
    }

    private class DhcpHandler
    extends Handler {
        private Handler mTarget;
        private boolean mCancelCallback;

        public DhcpHandler(Looper looper, Handler target) {
            super(looper);
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    int event;
                    DhcpHandler dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        this.mCancelCallback = false;
                    }
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.d((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START]" + WimaxStateTracker.this.mInterfaceName));
                    }
                    WimaxStateTracker.this.mAlarmManager.cancel(WimaxStateTracker.this.mDhcpRenewIntent);
                    WimaxStateTracker.this.mIpRenew = false;
                    if (NetworkUtils.runDhcp((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfo)WimaxStateTracker.this.mDhcpInfo)) {
                        event = 2;
                    } else {
                        event = 3;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START] DHCP request failed: " + NetworkUtils.getDhcpError()));
                        }
                    }
                    dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        if (!this.mCancelCallback) {
                            if (event == 2) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START] mDhcpInfo.leaseDuration = " + ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.leaseDuration));
                                }
                                long triggerTime = System.currentTimeMillis() + (long)((((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.leaseDuration - 30) * 1000);
                                WimaxStateTracker.this.mAlarmManager.set(0, triggerTime, WimaxStateTracker.this.mDhcpRenewIntent);
                            }
                            this.mTarget.sendEmptyMessage(event);
                        }
                        break;
                    }
                }
                case 10: {
                    int event;
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.v((String)WimaxStateTracker.TAG, (String)"[DhcpHandler:EVENT_IP_RENEW]");
                    }
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.i((String)WimaxStateTracker.TAG, (String)("old IP : " + WimaxStateTracker.this.mDhcpInfo.toString()));
                    }
                    WimaxStateTracker.this.mnOldIP = ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.ipAddress;
                    DhcpHandler dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        if (this.mCancelCallback) {
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.w((String)WimaxStateTracker.TAG, (String)"[DhcpHandler:EVENT_IP_RENEW] mCancelCallback is true... ignore this");
                            }
                            break;
                        }
                    }
                    if (WimaxStateTracker.this.mEnableUSB) break;
                    WimaxStateTracker.this.mDhcpStart = new Date().getTime();
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.d((String)WimaxStateTracker.TAG, (String)("[handleMessage : DhcpStart is " + WimaxStateTracker.this.mDhcpStart + "ms"));
                    }
                    WimaxStateTracker.this.acquire_WakeLock();
                    WimaxStateTracker.this.mAlarmManager.cancel(WimaxStateTracker.this.mDhcpRenewIntent);
                    WimaxStateTracker.this.mIpRenew = true;
                    if (NetworkUtils.runDhcpRenew((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfo)WimaxStateTracker.this.mDhcpInfo)) {
                        event = 2;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.v((String)WimaxStateTracker.TAG, (String)("New IP : " + WimaxStateTracker.this.mDhcpInfo.toString()));
                        }
                        int nNewIP = ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.ipAddress;
                        if (WimaxStateTracker.this.mnOldIP != nNewIP) {
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.v((String)WimaxStateTracker.TAG, (String)"mnOldIP != nNewIP");
                            }
                            WimaxStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED);
                        }
                    } else {
                        event = 3;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] DHCP request failed: " + NetworkUtils.getDhcpError()));
                        }
                        WimaxStateTracker.this.mDhcpStart = new Date().getTime();
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.d((String)WimaxStateTracker.TAG, (String)("[handleMessage : 2nd DhcpStart is " + WimaxStateTracker.this.mDhcpStart + "ms"));
                        }
                        if (NetworkUtils.runDhcpRenew((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfo)WimaxStateTracker.this.mDhcpInfo)) {
                            event = 2;
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.v((String)WimaxStateTracker.TAG, (String)("2nd New IP : " + WimaxStateTracker.this.mDhcpInfo.toString()));
                            }
                            int nNewIP = ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.ipAddress;
                            if (WimaxStateTracker.this.mnOldIP != nNewIP) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.v((String)WimaxStateTracker.TAG, (String)"2nd mnOldIP != nNewIP");
                                }
                                WimaxStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED);
                            }
                        } else {
                            event = 3;
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] 2nd DHCP request failed: " + NetworkUtils.getDhcpError()));
                            }
                        }
                    }
                    DhcpHandler dhcpHandler2 = this;
                    synchronized (dhcpHandler2) {
                        if (!this.mCancelCallback) {
                            if (event == 2) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] mDhcpInfo.leaseDuration = " + ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.leaseDuration));
                                }
                                long triggerTime = System.currentTimeMillis() + (long)((((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfo.leaseDuration - 30) * 1000);
                                WimaxStateTracker.this.mAlarmManager.set(0, triggerTime, WimaxStateTracker.this.mDhcpRenewIntent);
                            }
                            this.mTarget.sendEmptyMessage(event);
                        }
                        break;
                    }
                }
            }
        }

        public synchronized void setCancelCallback(boolean cancelCallback) {
            this.mCancelCallback = cancelCallback;
        }
    }

    private static class WimaxAuthFail {
        int nErrorCode;
        String strError;

        WimaxAuthFail(int nErrorCode, String strError) {
            this.nErrorCode = nErrorCode;
            this.strError = strError;
        }
    }

    private static class WimaxStateChangeResult {
        WimaxState state;
        DeviceStatusInfo.ConnectionProgressInfo info;

        WimaxStateChangeResult(WimaxState state, DeviceStatusInfo.ConnectionProgressInfo info) {
            this.state = state;
            this.info = info;
        }
    }
}

