/*
 * Decompiled with CFR 0.152.
 */
package android.net.wimax;

import android.net.NetworkStateTracker;
import android.net.wimax.DeviceStatusInfo;
import android.net.wimax.MruList;
import android.net.wimax.WimaxNative;
import android.net.wimax.WimaxState;
import android.net.wimax.WimaxStateTracker;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WimaxMonitor
implements Handler.Callback {
    private static final String TAG = "WimaxMonitor";
    private boolean m_bLog = false;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int STATE_CHANGE = 3;
    private static final int LINK_SPEED = 5;
    private static final int TERMINATING = 6;
    private static final int DRIVER_STATE = 7;
    private static final int UNKNOWN = 8;
    static final int EVENT_DEVICE_STATUS = 0;
    static final int EVENT_CARD_PRESENCE = 1;
    static final int EVENT_POWER_STATE = 2;
    static final int EVENT_AUTH_FAIL_MSG = 3;
    static final int EVENT_MRU_LIST_MSG = 4;
    static final int EVENT_MRU_UPDATE_MSG = 5;
    static final int EVENT_OMADM_RESPONSE = 6;
    static final int EVENT_RADIO_INFO_RESPONSE = 7;
    static final int EVENT_LINK_WEAK_INFO = 8;
    static final int EVENT_AUTH_UTC_TIME = 9;
    static final int EVENT_AUTH_REJECTION_CODE = 10;
    private final WimaxStateTracker mWimaxStateTracker;
    protected EventHandler mEventHandler = new EventHandler(this);
    private DeviceStatusInfo.DeviceStatus oldState = DeviceStatusInfo.DeviceStatus.RF_OFF_HW_SW;
    private DeviceStatusInfo.ConnectionProgressInfo oldInfo = DeviceStatusInfo.ConnectionProgressInfo.De_registration;

    public WimaxMonitor(WimaxStateTracker tracker) {
        this.mWimaxStateTracker = tracker;
        WimaxNative.SetHandler(this.mEventHandler);
    }

    public void startMonitoring() {
        new MonitorThread().start();
    }

    public NetworkStateTracker getNetworkStateTracker() {
        return this.mWimaxStateTracker;
    }

    public DeviceStatusInfo.DeviceStatus getDeviceStatusInfo() {
        return this.oldState;
    }

    public void setEnableLog(boolean blog) {
        this.m_bLog = blog;
    }

    public void resetOldState() {
        this.oldState = DeviceStatusInfo.DeviceStatus.RF_OFF_HW_SW;
        this.oldInfo = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
    }

    private void handleWimaxStateChange(WimaxState newWimaxState, DeviceStatusInfo.ConnectionProgressInfo newInfo) {
        this.mWimaxStateTracker.notifyStateChange(newWimaxState, newInfo);
    }

    private void handleIpRenew() {
        this.mWimaxStateTracker.notifyIpRenew();
    }

    private void handleMruListMsg(List<MruList> mruList) {
        this.mWimaxStateTracker.sendMruListBroadcast(mruList.size());
    }

    private void handleMruUpdateMsg(int nSubType, int nErrorValue) {
        this.mWimaxStateTracker.sendMruUpdateBroadcast(nSubType, nErrorValue);
    }

    private void handleDriverEvent(String state) {
        if (state == null) {
            return;
        }
        if ("STOPPED".equals(state)) {
            this.mWimaxStateTracker.notifyDriverStopped();
        } else if ("STARTED".equals(state)) {
            this.mWimaxStateTracker.notifyDriverStarted();
        }
    }

    public static void nap(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleNormalStatus(DeviceStatusInfo.DeviceStatus status, DeviceStatusInfo.ConnectionProgressInfo info) {
        switch (status) {
            case UnInitialized: {
                if (this.oldState != DeviceStatusInfo.DeviceStatus.UnInitialized) {
                    this.handleWimaxStateChange(WimaxState.INITIALIZING, null);
                    break;
                }
                this.handleDriverEvent("STARTED");
                this.handleWimaxStateChange(WimaxState.INITIALIZING, null);
                break;
            }
            case Initialized: {
                if (this.oldState == DeviceStatusInfo.DeviceStatus.Initialized) break;
                this.handleWimaxStateChange(WimaxState.INITIALIZED, null);
                break;
            }
            case Scanning: {
                if (this.oldState != DeviceStatusInfo.DeviceStatus.Initialized) break;
                this.handleWimaxStateChange(WimaxState.SCANNING, null);
                break;
            }
            case Ready: {
                if (this.oldState != DeviceStatusInfo.DeviceStatus.Scanning && this.oldState != DeviceStatusInfo.DeviceStatus.Disconnected) break;
                this.handleWimaxStateChange(WimaxState.READY, null);
                break;
            }
            case Connecting: {
                this.handleWimaxStateChange(WimaxState.CONNECTING, info);
                break;
            }
            case Data_Connected: {
                if (info == DeviceStatusInfo.ConnectionProgressInfo.Registered) {
                    this.handleWimaxStateChange(WimaxState.CONNECTED, info);
                    break;
                }
                if (info == DeviceStatusInfo.ConnectionProgressInfo.Idle) {
                    if (this.oldInfo == DeviceStatusInfo.ConnectionProgressInfo.Idle) break;
                    this.handleWimaxStateChange(WimaxState.CONNECTED, info);
                    break;
                }
                if (info == DeviceStatusInfo.ConnectionProgressInfo.IP_Renew) {
                    this.handleIpRenew();
                    break;
                }
                if (info == DeviceStatusInfo.ConnectionProgressInfo.IP_USB) {
                    this.handleWimaxStateChange(WimaxState.CONNECTED, info);
                    break;
                }
                if (info != DeviceStatusInfo.ConnectionProgressInfo.Ranging) break;
                this.mWimaxStateTracker.acquire_WakeLock();
                break;
            }
            case Disconnecting: {
                this.handleWimaxStateChange(WimaxState.DISCONNECTING, null);
                break;
            }
            case Disconnected: {
                this.handleWimaxStateChange(WimaxState.DISCONNECTED, info);
                break;
            }
            case RF_OFF_SW: {
                this.handleWimaxStateChange(WimaxState.DISCONNECTED, info);
                break;
            }
        }
    }

    private void handleDeviceStatus(DeviceStatusInfo result) {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("+ Received " + result));
        }
        DeviceStatusInfo.DeviceStatus status = result.getDeviceStatus();
        DeviceStatusInfo.StatusReason reason = result.getStatusReason();
        DeviceStatusInfo.ConnectionProgressInfo info = result.getConnectionProgressInfo();
        switch (reason) {
            case Normal: {
                this.handleNormalStatus(status, info);
                this.oldState = status;
                this.oldInfo = info;
                break;
            }
            case Fail: {
                if (status == DeviceStatusInfo.DeviceStatus.UnInitialized) {
                    info = DeviceStatusInfo.ConnectionProgressInfo.DISCONNECTED_USB;
                    this.handleWimaxStateChange(WimaxState.INITIALIZING, info);
                    this.oldState = status;
                    this.oldInfo = info;
                    break;
                }
                if (status == DeviceStatusInfo.DeviceStatus.RF_OFF_HW_SW) {
                    info = DeviceStatusInfo.ConnectionProgressInfo.Abnormal_State;
                }
                this.handleWimaxStateChange(WimaxState.DISCONNECTED, info);
                this.oldState = status;
                this.oldInfo = info;
                break;
            }
        }
    }

    public boolean handleMessage(Message msg) {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("+ Received " + msg));
        }
        switch (msg.what) {
            case 0: {
                this.handleDeviceStatus((DeviceStatusInfo)msg.obj);
                break;
            }
            case 1: {
                if (msg.arg1 != 0) break;
                this.handleDriverEvent("STOPPED");
                break;
            }
            case 2: {
                if (msg.arg1 != 1) break;
                this.oldState = DeviceStatusInfo.DeviceStatus.RF_OFF_SW;
                break;
            }
            case 3: {
                this.mWimaxStateTracker.notifyAuthFail(msg.arg1, msg.arg2, (ByteBuffer)msg.obj);
                break;
            }
            case 10: {
                this.mWimaxStateTracker.setRejectionCode(true);
                break;
            }
            case 4: {
                this.handleMruListMsg((List)msg.obj);
                break;
            }
            case 5: {
                this.handleMruUpdateMsg(msg.arg1, msg.arg2);
                break;
            }
            case 6: {
                this.mWimaxStateTracker.notifyOMADMResponse((ByteBuffer)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 7: {
                this.mWimaxStateTracker.notifyRadioInfoResponse();
                break;
            }
            case 8: {
                if (msg.arg1 == 0) {
                    this.mWimaxStateTracker.notifyLinkWeakInformation();
                    break;
                }
                this.mWimaxStateTracker.notifyMoCallInformation();
                break;
            }
            case 9: {
                Date now = Calendar.getInstance().getTime();
                SimpleDateFormat formatter = null;
                formatter = new SimpleDateFormat("yyMMddHHmmss");
                if (formatter == null) break;
                String strUTCtime = formatter.format(now);
                if (this.m_bLog) {
                    Log.d((String)"UTCTIME", (String)("time : " + strUTCtime));
                }
                WimaxNative.SendUTCTime(strUTCtime);
                break;
            }
        }
        return false;
    }

    class EventHandler
    extends Handler {
        EventHandler(Handler.Callback callback) {
            super(callback);
        }
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(WimaxMonitor.TAG);
        }

        public void run() {
            if (WimaxMonitor.this.m_bLog) {
                Log.d((String)WimaxMonitor.TAG, (String)"<----- MonitorThread Start ----->");
            }
        }
    }
}

