/*
 * Decompiled with CFR 0.152.
 */
package android.net.wimax;

import android.net.DhcpInfo;
import android.net.wimax.ConnectionStatistics;
import android.net.wimax.DeviceInfo;
import android.net.wimax.IWimaxManager;
import android.net.wimax.MruList;
import android.net.wimax.RadioInfo;
import android.net.wimax.WimaxInfo;
import android.net.wimax.WimaxState;
import android.net.wimax.structs.NspInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WimaxManager {
    public static final String WIMAX_SERVICE = "WiMax";
    public static final int ERROR_AUTHENTICATING = 1;
    public static final String WIMAX_STATUS_CHANGED_ACTION = "android.net.wimax.WIMAX_STATUS_CHANGED";
    public static final String EXTRA_WIMAX_STATUS = "wimax_status";
    public static final String EXTRA_PREVIOUS_WIMAX_STATUS = "previous_wimax_status";
    public static final int WIMAX_STATUS_DISABLING = 0;
    public static final int WIMAX_STATUS_DISABLED = 1;
    public static final int WIMAX_STATUS_ENABLING = 2;
    public static final int WIMAX_STATUS_ENABLED = 3;
    public static final int WIMAX_STATUS_UNKNOWN = 4;
    public static final int WORK_MODE_STATE_0 = 0;
    public static final int WORK_MODE_STATE_1 = 1;
    public static final int WORK_MODE_STATE_2 = 2;
    public static final int WORK_MODE_STATE_3 = 3;
    public static final String WIMAX_STATE_CHANGED_ACTION = "android.net.wimax.WIMAX_STATE_CHANGE";
    public static final String EXTRA_WIMAX_STATE = "WimaxState";
    public static final String EXTRA_WIMAX_STATE_DETAIL = "WimaxStateDetail";
    public static final String BSID_CHANGED_ACTION = "android.net.wimax.BSID_CHANGED";
    public static final String EXTRA_NEW_BSID = "newBSID";
    public static final String FREQUENCY_CHANGED_ACTION = "android.net.wimax.FREQUENCY_CHANGED";
    public static final String EXTRA_NEW_FREQUENCY = "newFrequency";
    public static final String RSSI_CHANGED_ACTION = "android.net.wimax.RSSI_CHANGED";
    public static final String EXTRA_NEW_RSSI = "newRSSI";
    public static final String MODE_CHANGED_ACTION = "android.net.wimax.MODE_CHANGED";
    public static final String EXTRA_MODE = "usbMode";
    public static final int WIMAX_MODE_NORMAL = 0;
    public static final int WIMAX_MODE_TETHERED = 1;
    public static final int WIMAX_MODE_BACKHAUL = 2;
    public static final int WIMAX_MODE_DM_NORMAL = 3;
    public static final int WIMAX_MODE_DM_BACKHAUL = 4;
    public static final String NETWORK_IDS_CHANGED_ACTION = "android.net.wimax.NETWORK_IDS_CHANGED";
    public static final String NETWORK_IP_CHANGED_ACTION = "android.net.wimax.NETWORK_IP_CHANGED";
    public static final String TIME_CHANGED_ACTION = "android.net.wimax.TIME_CHANGED";
    public static final String EXTRA_NEW_TIME = "newTime";
    public static final String SIGNAL_LEVEL_CHANGED_ACTION = "android.net.wimax.SIGNAL_LEVEL_CHANGED";
    public static final String EXTRA_NEW_SIGNAL_LEVEL = "newSignalLevel";
    public static final String WIMAX_DHCP_TIME_ACTION = "android.net.wimax.WIMAX_DHCP_TIME";
    public static final String EXTRA_WIMAX_DHCP_TIME = "newDHCPTime";
    public static final String EXTRA_WIMAX_MRU_LIST = "MruList";
    public static final String EXTRA_WIMAX_MRU_UPDATE_SUBTYPE = "subType";
    public static final String EXTRA_WIMAX_MRU_UPDATE_ERRORVALUE = "ErrorValue";
    public static final String EXTRA_WIMAX_OMADM_RESP_DATA = "WimaxOMADMRespData";
    public static final String EXTRA_WIMAX_OMADM_RESP_STATE = "WimaxOMADMRespState";
    public static final String WIMAX_RESPONSE_ACTION = "android.net.wimax.WIMAX_RESPONSE";
    public static final String EXTRA_WIMAX_RADIO_INFO = "WimaxRadioInfo";
    public static final String WIMAX_WORK_MODE_ACTION = "android.net.wimax.WIMAX_WORK_MODE";
    public static final String EXTRA_WIMAX_WORK_MODE = "WimaxWorkMode";
    public static final String ACTION_PICK_WIMAX_NETWORK = "android.net.wimax.PICK_WIMAX_NETWORK";
    public static final String WIMAX_AUTH_ERROR = "android.net.wimax.WIMAX_AUTH_ERROR";
    public static final String EXTRA_WIMAX_AUTH_ERROR = "auth_error";
    public static final String EXTRA_WIMAX_AUTH_ERROR_BYTE = "auth_error_byte";
    public static final String EXTRA_WIMAX_AUTH_ERROR_LENGTH = "auth_error_length";
    public static final String WIMAX_DATA_USED_ACTION = "android.net.wimax.WIMAX_DATA_USED";
    public static final String EXTRA_UP_DOWN_DATA = "upDownData";
    public static final int NO_DATA = 0;
    public static final int UP_DATA = 1;
    public static final int DOWN_DATA = 2;
    public static final int UP_DOWN_DATA = 3;
    public static final String WIMAX_DATA_THROUGHPUT_ACTION = "android.net.wimax.WIMAX_DATA_THROUGHPUT";
    public static final String EXTRA_TIME = "time";
    public static final String EXTRA_DATA = "data";
    public static final String EXTRA_THROUGHPUT = "throughput";
    public static final int WIMAX_MODE_FULL = 1;
    public static final int WIMAX_MODE_SCAN_ONLY = 2;
    private static IWimaxManager mService;
    Handler mHandler;
    private static final int MAX_ACTIVE_LOCKS = 50;
    private int mActiveLockCount;
    private static final int METHOD_NOT_IMPLEMENTED = -1;
    private static final int INDICATES_SUCCESSFUL_COMPLETION_OF_THE_OPERATION = 0;
    private static final int DEVICE_ALREADY_CONNECTED = 1;
    private static final int COVERAGE_NOT_AVAILABLE = 2;
    private static final int ROAMING_NOT_SUPPORTED = 3;
    private static final int AUTHENTICATION_FAILED = 4;
    private static final int DEVICE_NOT_PROVISIONED = 5;
    private static final int INVALID_PARAMETER_PASSED = 6;
    private static final int LINK_NOT_CONNECTED = 7;
    private static final int LINK_ALREADY_CONNECTED = 8;
    private static final int INVALID_DEVICE_PROFILE = 9;
    private static final int CONNECTION_IN_PROGRESS = 10;
    private static final int SYNCHRONOUS_SCAN_REQUEST_TAKING_TOO_LONG = 11;
    private static final int WIMAX_RADIO_OVERHEAT = 12;
    private static final int RADIO_POLICY_VIOLATED = 13;
    private static final int RADIO_IS_TURNED_OFF = 14;
    public static final int WIMAX_FACTORY_DEFAULT_GDB = 0;
    public static final int WIMAX_FACTORY_DEFAULT_ODB = 1;
    public static final int WIMAX_FACTORY_DEFAULT_ALL = 2;
    public static final int WIMAX_IDLE = 6;
    public static final int WIMAX_DEREGISTRATION = 8;
    private static final String TAG = "WimaxManager";
    private static WimaxManager instance;
    public static final int WIMAX_VI_WHILE_AP_SLEEP = 0;
    public static final int WIMAX_IDLE_WHILE_AP_SLEEP = 1;

    public WimaxManager() {
        if (mService == null) {
            IBinder b = ServiceManager.getService((String)WIMAX_SERVICE);
            mService = IWimaxManager.Stub.asInterface(b);
        }
    }

    public static synchronized WimaxManager getInstance() {
        if (instance == null) {
            instance = new WimaxManager();
        }
        return instance;
    }

    public WimaxInfo getConnectionInfo() {
        try {
            return mService.getConnectionInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int[] getNetworkEntryCompleteTimes() {
        try {
            return mService.getNetworkEntryCompleteTimes();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public DhcpInfo getDhcpInfo() {
        try {
            return mService.getDhcpInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void getNeighborList() {
        try {
            mService.getNeighborList();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------getNeighborList RemoteException----------------");
        }
    }

    public void getRadioInfo() {
        try {
            mService.getRadioInfo();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------getRadioInfo RemoteException----------------");
        }
    }

    public void getRadioInfoTemperature() {
        try {
            mService.getRadioInfo();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------getRadioInfoTemperature RemoteException----------------");
        }
    }

    public RadioInfo getRadioInfoResponse() {
        try {
            return mService.getRadioInfoResponse();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int getWorkModeState() {
        try {
            return mService.getWorkModeState();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public boolean setWorkModeState(int workMode) {
        try {
            return mService.setWorkModeState(workMode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void getMruList() {
        try {
            mService.getMruList();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------getMruList RemoteException----------------");
        }
    }

    public List<MruList> getMruListRsp() {
        try {
            return mService.getMruListRsp();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean getMruUpdate(List<MruList> list, int nSize) {
        try {
            if (nSize == 0) {
                return mService.getMruUpdate("", nSize);
            }
            int nListSize = list.size();
            if (nSize != nListSize) {
                return false;
            }
            StringBuffer strUpdate = new StringBuffer("");
            for (int i = 0; i < nSize; ++i) {
                MruList temp = list.get(i);
                int nCF = temp.getCenterfrequency();
                byte bw = temp.getBW();
                byte fft = temp.getFFTSize();
                strUpdate.append(nCF).append("#").append(bw).append("#").append(fft).append("#@");
            }
            return mService.getMruUpdate(strUpdate.toString(), nSize);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setMruWorking(boolean bWorking) {
        try {
            mService.setMruWorking(bWorking);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------setMruWorking RemoteException----------------");
        }
    }

    public boolean getPersistedWimaxEnabled() {
        try {
            return mService.getPersistedWimaxEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isWimaxNotificationEnabled() {
        try {
            return mService.getPersistedWimaxNotificationEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setWimaxEnabled(boolean enabled) {
        try {
            return mService.setWimaxEnabled(enabled);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setWimaxNotificationEnabled(boolean enabled) {
        try {
            mService.persistWimaxNotificationEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getWimaxStatus() {
        try {
            return mService.getWimaxEnabledStatus();
        }
        catch (RemoteException e) {
            return 4;
        }
    }

    public void setWimaxStatus(int Wimaxstatus) {
        try {
            mService.setWimaxStatus(Wimaxstatus);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------setWimaxStatus RemoteException----------------");
        }
    }

    public boolean isWimaxEnabled() {
        return this.getWimaxStatus() == 3;
    }

    public WimaxState getWimaxState() {
        try {
            return mService.getWimaxState();
        }
        catch (RemoteException e) {
            return WimaxState.UNKNOWN;
        }
    }

    public static int calculateSignalLevel(int nRSSI, int nCINR, int numLevels) {
        if (numLevels != 4) {
            return 6;
        }
        int dwRssiStep = 0;
        dwRssiStep = WimaxManager.CheckRSSILevel(nRSSI);
        return dwRssiStep;
    }

    private static int CheckRSSILevel(int nRSSI) {
        if (nRSSI < -93) {
            return 0;
        }
        if (-93 <= nRSSI && nRSSI < -75) {
            return 1;
        }
        if (-75 <= nRSSI && nRSSI < -60) {
            return 2;
        }
        if (-60 <= nRSSI) {
            return 3;
        }
        return 3;
    }

    public int connectDefaultNetwork() {
        return this.connect("", "", "", "");
    }

    public int connect(String homeNspName, String roamingNspName, String userName, String passWord) {
        if (roamingNspName != "") {
            return 6;
        }
        try {
            return mService.connect(homeNspName, roamingNspName, userName, passWord);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean disconnect() {
        try {
            return mService.disconnect();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean startScan() {
        return this.startScan(false);
    }

    public boolean startScan(boolean bUserReq) {
        try {
            return mService.startScan(bUserReq);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean CheckWimaxState() {
        try {
            return mService.CheckWimaxState();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static int compareSignalLevel(int rssiA, int rssiB) {
        return rssiA - rssiB;
    }

    public void release_sWakeLock() {
        try {
            mService.release_sWakeLock();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------release_sWakeLock RemoteException----------------");
        }
    }

    public int getWimaxMode() {
        try {
            return mService.getWimaxMode();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int setWimaxMode(int nMode, boolean enable) {
        try {
            return mService.setWimaxMode(nMode, enable);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public void setRctMode(boolean enable) {
        try {
            mService.setRctMode(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setRejectionCode(boolean enable) {
        try {
            mService.setRejectionCode(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean checkUSBstate() {
        try {
            return mService.checkUSBstate();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setWiFiConnect(boolean bConnect) {
        try {
            mService.setWiFiConnect(bConnect);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"------setWiFiConnect RemoteException----------------");
        }
    }

    public boolean isWiFiConnect() {
        try {
            return mService.isWiFiConnect();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public List<NspInfo> getAvailableNetworks() {
        try {
            return mService.getAvailableNetworks();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public List<NspInfo> getNetworkList() {
        try {
            return mService.getNetworkList();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NspInfo getConnectedNSP() {
        try {
            return mService.getConnectedNSP();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public String getConnectedNspName() {
        try {
            return mService.getConnectedNspName();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ConnectionStatistics getConnectionStatistics() {
        try {
            return mService.getConnectionStatistics();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public DeviceInfo getDeviceInformation() {
        try {
            return mService.getDeviceInformation();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int makeOdbTlvData(byte[] pBuffer, int nBufferIndex, int wBufferLen, int wTag, int wLength, byte[] pbValue) {
        try {
            return mService.makeOdbTlvData(pBuffer, nBufferIndex, wBufferLen, wTag, wLength, pbValue);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbReadReq(byte[] tlvDataArray) {
        try {
            return mService.OdbReadReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbWriteReq(byte[] tlvDataArray) {
        try {
            return mService.OdbWriteReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbUpdateReq() {
        try {
            return mService.OdbUpdateReq();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbAddReq(byte[] tlvDataArray) {
        try {
            return mService.OdbAddReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbDeleteReq(byte[] tlvDataArray) {
        try {
            return mService.OdbDeleteReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean setFactoryDefault(int nType) {
        try {
            return mService.setFactoryDefault(nType);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int setVirtualIdleWhileAPsleep(byte bMode) {
        if (bMode == 0 || bMode == 1) {
            try {
                return mService.setVirtualIdleWhileAPsleep(bMode);
            }
            catch (RemoteException e) {
                return -1;
            }
        }
        return -2;
    }

    public int getNetworkConnectionSetting() {
        try {
            return mService.getNetworkConnectionSetting();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public WimaxLock createWimaxLock(int lockType, String tag) {
        return new WimaxLock(lockType, tag);
    }

    public WimaxLock createWimaxLock(String tag) {
        return new WimaxLock(1, tag);
    }

    public MulticastLock createMulticastLock(String tag) {
        return new MulticastLock(tag);
    }

    public boolean isMulticastEnabled() {
        try {
            return mService.isMulticastEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int saveStaticIP(String ip, String gateway, String netmask, String dns1, String dns2) {
        try {
            return mService.saveStaticIP(ip, gateway, netmask, dns1, dns2);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public String readStaticIP(int nIndex) {
        try {
            return mService.readStaticIP(nIndex);
        }
        catch (RemoteException e) {
            return "error";
        }
    }

    public int deleteStaticIP() {
        try {
            return mService.deleteStaticIP();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public class MulticastLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        private boolean mRefCounted;
        private boolean mHeld;

        private MulticastLock(String tag) {
            this.mTag = tag;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount > 0 : !this.mHeld) {
                    try {
                        mService.acquireMulticastLock(this.mBinder, this.mTag);
                        WimaxManager wimaxManager = WimaxManager.this;
                        synchronized (wimaxManager) {
                            if (WimaxManager.this.mActiveLockCount >= 50) {
                                mService.releaseMulticastLock();
                                throw new UnsupportedOperationException("Exceeded maximum number of wimax locks");
                            }
                            WimaxManager.this.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException ignore) {
                        Log.e((String)WimaxManager.TAG, (String)"------MulticastLock - acquire RemoteException----------------");
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        mService.releaseMulticastLock();
                        WimaxManager wimaxManager = WimaxManager.this;
                        synchronized (wimaxManager) {
                            WimaxManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException ignore) {
                        Log.e((String)WimaxManager.TAG, (String)"------MulticastLock - release RemoteException----------------");
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("MulticastLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }
    }

    public class WimaxLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        int mLockType;
        private boolean mRefCounted;
        private boolean mHeld;

        private WimaxLock(int lockType, String tag) {
            this.mTag = tag;
            this.mLockType = lockType;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount > 0 : !this.mHeld) {
                    try {
                        mService.acquireWimaxLock(this.mBinder, this.mLockType, this.mTag);
                        WimaxManager wimaxManager = WimaxManager.this;
                        synchronized (wimaxManager) {
                            if (WimaxManager.this.mActiveLockCount >= 50) {
                                mService.releaseWimaxLock(this.mBinder);
                                throw new UnsupportedOperationException("Exceeded maximum number of Wimax locks");
                            }
                            WimaxManager.this.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException ignore) {
                        Log.e((String)WimaxManager.TAG, (String)"------WimaxLock - acquire RemoteException----------------");
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        mService.releaseWimaxLock(this.mBinder);
                        WimaxManager wimaxManager = WimaxManager.this;
                        synchronized (wimaxManager) {
                            WimaxManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException ignore) {
                        Log.e((String)WimaxManager.TAG, (String)"------WimaxLock - release RemoteException----------------");
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("WimaxLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "WimaxLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        mService.releaseWimaxLock(this.mBinder);
                        WimaxManager wimaxManager = WimaxManager.this;
                        synchronized (wimaxManager) {
                            WimaxManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException ignore) {
                        Log.e((String)WimaxManager.TAG, (String)"------WimaxLock - finalize RemoteException----------------");
                    }
                }
            }
        }
    }
}

