/*
 * Decompiled with CFR 0.152.
 */
package android.net.wimax;

import android.os.Parcel;
import android.os.Parcelable;

public class WimaxInfo
implements Parcelable {
    private static final String TAG = "WimaxInfo";
    private int mNSPID = 0;
    private String mBSID = "00:00:00:00:00:00";
    private String mNAPID = "000000";
    private int mFrequency = 0;
    private int mRSSI = -9999;
    private int mCINR = 0;
    private int mTxPower = 0;
    private int mIPAddress = 0;
    private String mConnectionTime = "00:00:00";
    private int mLinkSpeed = -1;
    private String mMacAddress;
    public static final Parcelable.Creator<WimaxInfo> CREATOR = new Parcelable.Creator<WimaxInfo>(){

        public WimaxInfo createFromParcel(Parcel in) {
            WimaxInfo info = new WimaxInfo();
            info.mNSPID = in.readInt();
            info.mBSID = in.readString();
            info.mNAPID = in.readString();
            info.setFREQ(in.readInt());
            info.setRssi(in.readInt());
            info.setCINR(in.readInt());
            info.setTxPower(in.readInt());
            info.setIPAddress(in.readInt());
            info.mConnectionTime = in.readString();
            info.setLinkSpeed(in.readInt());
            info.mMacAddress = in.readString();
            return info;
        }

        public WimaxInfo[] newArray(int size) {
            return new WimaxInfo[size];
        }
    };

    WimaxInfo() {
    }

    void setNSPID(int NSPID) {
        this.mNSPID = NSPID;
    }

    public int getNSPID() {
        return this.mNSPID;
    }

    void setBSID(String BSID) {
        this.mBSID = BSID;
        if (BSID != null) {
            char[] cNAPID = new char[]{BSID.charAt(0), BSID.charAt(1), BSID.charAt(3), BSID.charAt(4), BSID.charAt(6), BSID.charAt(7)};
            this.mNAPID = new String(cNAPID);
        } else {
            this.mNAPID = null;
        }
    }

    public String getBSID() {
        return this.mBSID;
    }

    public String getNAPID() {
        return this.mNAPID;
    }

    void setFREQ(int FREQ) {
        this.mFrequency = FREQ;
    }

    public int getFREQ() {
        return this.mFrequency;
    }

    void setRssi(int rssi) {
        this.mRSSI = rssi;
    }

    public int getRssi() {
        return this.mRSSI;
    }

    void setCINR(int cinr) {
        this.mCINR = cinr;
    }

    public int getCINR() {
        return this.mCINR;
    }

    void setTxPower(int TxPower) {
        this.mTxPower = TxPower;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    void setIPAddress(int IPAddress) {
        this.mIPAddress = IPAddress;
    }

    public int getIPAddress() {
        return this.mIPAddress;
    }

    void setConnectionTime(String ConnectionTime) {
        this.mConnectionTime = ConnectionTime;
    }

    public String getConnectionTime() {
        return this.mConnectionTime;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    void setLinkSpeed(int linkSpeed) {
        this.mLinkSpeed = linkSpeed;
    }

    void setMacAddress(String macAddress) {
        this.mMacAddress = macAddress;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    void setIpAddress(int address) {
        this.mIPAddress = address;
    }

    public int getIpAddress() {
        return this.mIPAddress;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("NSPID: ").append(this.mNSPID).append("BSID: ").append(this.mBSID == null ? none : this.mBSID).append(", NAPID: ").append(this.mNAPID == null ? none : this.mNAPID).append(", Frequency: ").append(this.mFrequency).append(", RSSI: ").append(this.mRSSI).append(", CINR: ").append(this.mCINR).append(", Tx Power: ").append(this.mTxPower).append(", IP Address: ").append(this.mIPAddress).append(", Connection Time: ").append(this.mConnectionTime == null ? none : this.mConnectionTime).append(", Link speed: ").append(this.mLinkSpeed).append(", MAC: ").append(this.mMacAddress == null ? none : this.mMacAddress);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNSPID);
        dest.writeString(this.mBSID);
        dest.writeString(this.mNAPID);
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mRSSI);
        dest.writeInt(this.mCINR);
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mIPAddress);
        dest.writeString(this.mConnectionTime);
        dest.writeInt(this.mLinkSpeed);
        dest.writeString(this.mMacAddress);
    }
}

