/*
 * Decompiled with CFR 0.152.
 */
package android.net.wimax;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ConnectionStatistics
implements Parcelable {
    private static final String TAG = "ConnectionStatistics";
    private long m_nTotalRxBytes = 0L;
    private long m_nTotalRxPackets = 0L;
    private long m_nTotalTxBytes = 0L;
    private long m_nTotalTxPackets = 0L;
    private static final File[] WIMAX_TX_PACKETS = ConnectionStatistics.WimaxFiles("tx_packets");
    private static final File[] WIMAX_RX_PACKETS = ConnectionStatistics.WimaxFiles("rx_packets");
    private static final File[] WIMAX_TX_BYTES = ConnectionStatistics.WimaxFiles("tx_bytes");
    private static final File[] WIMAX_RX_BYTES = ConnectionStatistics.WimaxFiles("rx_bytes");
    private static final byte[] buf = new byte[16];
    public static final Parcelable.Creator<ConnectionStatistics> CREATOR = new Parcelable.Creator<ConnectionStatistics>(){

        public ConnectionStatistics createFromParcel(Parcel in) {
            ConnectionStatistics info = new ConnectionStatistics();
            info.m_nTotalRxBytes = in.readLong();
            info.m_nTotalRxPackets = in.readLong();
            info.m_nTotalTxBytes = in.readLong();
            info.m_nTotalTxPackets = in.readLong();
            return info;
        }

        public ConnectionStatistics[] newArray(int size) {
            return new ConnectionStatistics[size];
        }
    };

    public long getTotalRxBytes() {
        this.m_nTotalRxBytes = ConnectionStatistics.getWimaxStat(WIMAX_RX_BYTES);
        return this.m_nTotalRxBytes;
    }

    public long getTotalRxPackets() {
        this.m_nTotalRxPackets = ConnectionStatistics.getWimaxStat(WIMAX_RX_PACKETS);
        return this.m_nTotalRxPackets;
    }

    public long getTotalTxBytes() {
        this.m_nTotalTxBytes = ConnectionStatistics.getWimaxStat(WIMAX_TX_BYTES);
        return this.m_nTotalTxBytes;
    }

    public long getTotalTxPackets() {
        this.m_nTotalTxPackets = ConnectionStatistics.getWimaxStat(WIMAX_TX_PACKETS);
        return ConnectionStatistics.getWimaxStat(WIMAX_TX_PACKETS);
    }

    public static long getUplinkThroughput() {
        return -1L;
    }

    public static long getDownlinkThroughput() {
        return -1L;
    }

    private static File[] WimaxFiles(String whatStat) {
        File[] files = new File[5];
        files[0] = new File("/sys/class/net/uwbr0/statistics/" + whatStat);
        return files;
    }

    private static long getWimaxStat(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) continue;
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                return ConnectionStatistics.getNumberFromFile(raf, file.getAbsolutePath());
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Exception opening TCP statistics file " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long getNumberFromFile(RandomAccessFile raf, String filename) {
        try {
            raf.read(buf);
            raf.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Exception getting TCP bytes from " + filename), (Throwable)e);
            long l = 0L;
            return l;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Exception closing " + filename), (Throwable)e);
                }
            }
        }
        long num = 0L;
        for (int i = 0; i < buf.length && buf[i] >= 48 && buf[i] <= 57; ++i) {
            num *= 10L;
            num += (long)(buf[i] - 48);
        }
        return num;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("m_nTotalRxBytes: ").append(this.m_nTotalRxBytes).append(", m_nTotalRxPackets: ").append(this.m_nTotalRxPackets).append(", m_nTotalTxBytes: ").append(this.m_nTotalTxBytes).append(", m_nTotalTxPackets: ").append(this.m_nTotalTxPackets);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.m_nTotalRxBytes);
        dest.writeLong(this.m_nTotalRxPackets);
        dest.writeLong(this.m_nTotalTxBytes);
        dest.writeLong(this.m_nTotalTxPackets);
    }
}

