/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.DhcpInfo;
import android.net.NetworkStateTracker;
import android.net.Uri;
import android.net.fourG.wimax.DeviceStatusInfo;
import android.net.fourG.wimax.IWimax4GManager;
import android.net.fourG.wimax.MruList;
import android.net.fourG.wimax.Wimax4GBaseStationInfo;
import android.net.fourG.wimax.Wimax4GConfiguration;
import android.net.fourG.wimax.Wimax4GDeviceInfo;
import android.net.fourG.wimax.Wimax4GInfo;
import android.net.fourG.wimax.Wimax4GManager;
import android.net.fourG.wimax.WimaxMonitor;
import android.net.fourG.wimax.WimaxNative;
import android.net.fourG.wimax.WimaxState;
import android.net.fourG.wimax.WimaxStateTracker;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import com.android.server.am.BatteryStatsService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WimaxService
extends IWimax4GManager.Stub {
    private static final String TAG = "WimaxService";
    private boolean m_bLog = false;
    private final WimaxStateTracker mWimaxStateTracker;
    private WimaxMonitor mWimaxMonitor;
    private Context mContext;
    private int mWimax4GState;
    private int m_nPluggedType;
    private boolean mAirplaneModeOverwridden;
    private final LockList mLocks = new LockList();
    private int mFullLocksAcquired;
    private int mFullLocksReleased;
    private final List<Multicaster> mMulticasters = new ArrayList<Multicaster>();
    private int mMulticastEnabled;
    private int mMulticastDisabled;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private int mDiffTime = 0;
    private long mRxStart = 0L;
    private long mRxEnd = 0L;
    private long mDiffRxsize = 0L;
    private int mThroughput = 0;
    private final IBatteryStats mBatteryStats;
    private static final long DEFAULT_IDLE_MILLIS = 900000L;
    private static final String WAKELOCK_TAG = "WimaxService";
    private static final int DEFAULT_WAKELOCK_TIMEOUT = 8000;
    private static PowerManager.WakeLock sDriverStopWakeLock;
    private static PowerManager.WakeLock sWakeLock;
    private static final int MESSAGE_ENABLE_WIMAX = 0;
    private static final int MESSAGE_DISABLE_WIMAX = 1;
    private static final int MESSAGE_STOP_WIMAX = 2;
    private static final int MESSAGE_START_WIMAX = 3;
    private static final int MESSAGE_RELEASE_WAKELOCK = 4;
    private final WimaxHandler mWimaxHandler;
    private List<Wimax4GConfiguration> mAvailableList = new ArrayList<Wimax4GConfiguration>();
    private List<Wimax4GBaseStationInfo> mNetworkList = new ArrayList<Wimax4GBaseStationInfo>();
    Wimax4GConfiguration m4GConfiguration = new Wimax4GConfiguration();
    Wimax4GBaseStationInfo mConnected4GBaseStationInfo = new Wimax4GBaseStationInfo();
    Wimax4GManager.WimaxConnectionStatistics mConnectionStatistics = new Wimax4GManager.WimaxConnectionStatistics();
    Wimax4GDeviceInfo mDeviceInfo = new Wimax4GDeviceInfo();
    private static boolean mIsTetheredmode;
    private static boolean mIsDMmode;
    private static boolean mIsBackhaulMode;
    private static boolean mbUSBTethered;
    private static byte mModeWhieAPsleep;
    private static final String USB_STATE = "/sys/class/sec/switch/usb_state";
    private static final byte[] USB_CONNECTED;
    private int mLastEnableUid = Process.myUid();
    TelephonyManager telMgr;
    int m_nCallState = 0;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"ACTION_SCREEN_ON");
                }
                WimaxService.this.mWimaxStateTracker.SetScreenOff(false);
                WimaxNative.getLinkState();
                return;
            }
            if (action.equals("android.intent.action.SCREEN_OFF")) {
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"ACTION_SCREEN_OFF");
                }
                WimaxService.this.mWimaxStateTracker.SetScreenOff(true);
                return;
            }
            WimaxService.this.mWimaxStateTracker;
            if (action.equals("com.android.server.Wimax4GManager.action.WIMAX_DHCP_RENEW")) {
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"-----------ACTION_WIMAX_DHCP_RENEW------------");
                }
                WimaxService.this.acquire_WakeLock(sWakeLock);
                WimaxService.this.mWimaxStateTracker.notifyIpRenew();
                return;
            }
            if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"ACTION_BATTERY_CHANGED");
                }
                int nPluggedType = intent.getIntExtra("plugged", 0);
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)("[nPluggedType] : " + nPluggedType + " getWimaxMode() :" + WimaxService.this.getWimaxMode() + " m_nPluggedType : " + WimaxService.this.m_nPluggedType + " mbUSBTethered : " + mbUSBTethered));
                }
                if (WimaxService.this.m_nPluggedType != 2 && nPluggedType == 2) {
                    WimaxService.this.m_nPluggedType = nPluggedType;
                    if (WimaxService.this.m_bLog) {
                        Log.d((String)"WimaxService", (String)"ACTION_BATTERY_CHANGED : USB CABLE IS PLUGGED");
                    }
                    if (WimaxService.this.getWimaxMode() == 1) {
                        if (WimaxService.this.m_bLog) {
                            Log.w((String)"WimaxService", (String)"discard - already tethered mode");
                        }
                    } else if (mbUSBTethered && WimaxService.this.get4GState() == 3) {
                        WimaxService.this.setWimaxMode(1, true);
                        WimaxService.this.mWimaxStateTracker.clearRetryFlag();
                        if (WimaxService.this.getWimaxState() == WimaxState.DISCONNECTED) {
                            if (WimaxService.this.m_bLog) {
                                Log.i((String)"WimaxService", (String)"it will connect as tethered mode");
                            }
                            WimaxService.this.startScan(true);
                        } else if (WimaxService.this.getWimaxState() == WimaxState.SCANNING || WimaxService.this.getWimaxState() == WimaxState.READY || WimaxService.this.getWimaxState() == WimaxState.CONNECTING || WimaxService.this.getWimaxState() == WimaxState.OBTAINING_IPADDR || WimaxService.this.getWimaxState() == WimaxState.CONNECTED) {
                            if (WimaxService.this.m_bLog) {
                                Log.i((String)"WimaxService", (String)"it will disconnect for re-connecting as tethered mode");
                            }
                            WimaxService.this.disconnect();
                        }
                    }
                } else if (WimaxService.this.m_nPluggedType == 2 && nPluggedType != 2) {
                    WimaxService.this.m_nPluggedType = nPluggedType;
                    if (WimaxService.this.m_bLog) {
                        Log.d((String)"WimaxService", (String)"ACTION_BATTERY_CHANGED : USB CABLE IS UNPLUGGED");
                    }
                    mbUSBTethered = false;
                    if (WimaxService.this.getWimaxMode() == 1) {
                        if (WimaxService.this.get4GState() == 3) {
                            WimaxService.this.setWimaxMode(1, false);
                            WimaxService.this.mWimaxStateTracker.clearRetryFlag();
                            if (WimaxService.this.getWimaxState() == WimaxState.DISCONNECTED) {
                                if (WimaxService.this.m_bLog) {
                                    Log.i((String)"WimaxService", (String)"it will connect as normal mode");
                                }
                                WimaxService.this.startScan(true);
                            } else if (WimaxService.this.getWimaxState() == WimaxState.SCANNING || WimaxService.this.getWimaxState() == WimaxState.READY || WimaxService.this.getWimaxState() == WimaxState.CONNECTING || WimaxService.this.getWimaxState() == WimaxState.OBTAINING_IPADDR || WimaxService.this.getWimaxState() == WimaxState.CONNECTED) {
                                if (WimaxService.this.m_bLog) {
                                    Log.i((String)"WimaxService", (String)"it will disconnect for re-connecting as normal mode");
                                }
                                WimaxService.this.disconnect();
                            }
                        }
                    } else if (WimaxService.this.m_bLog) {
                        Log.w((String)"WimaxService", (String)"discard - already NOT tethered mode");
                    }
                }
                return;
            }
            if (action.equals("android.net.wifi.WIFI_AP_STATE_CHANGED")) {
                int nApState = intent.getIntExtra("wifi_state", 14);
                Log.d((String)"WimaxService", (String)("WIFI_AP_STATE_CHANGED_ACTION = " + nApState));
                switch (nApState) {
                    case 11: 
                    case 14: {
                        if (WimaxService.this.getWimaxMode() == 2 || WimaxService.this.getWimaxMode() == 4) break;
                        if (WimaxService.this.m_bLog) {
                            Log.w((String)"WimaxService", (String)"discard - WIFI_AP_STATE_CHANGED_ACTION intent.");
                        }
                        return;
                    }
                    case 13: {
                        if (WimaxService.this.getWimaxMode() != 1) break;
                        if (WimaxService.this.m_bLog) {
                            Log.w((String)"WimaxService", (String)"discard - WIFI_AP_STATE_CHANGED_ACTION intent. current mode is wimax tethered.");
                        }
                        return;
                    }
                    default: {
                        if (WimaxService.this.m_bLog) {
                            Log.w((String)"WimaxService", (String)"discard - WIFI_AP_STATE_CHANGED_ACTION intent.");
                        }
                        return;
                    }
                }
                WimaxService.this.setWimaxMode(2, nApState == 13);
                if (WimaxService.this.get4GState() == 3) {
                    WimaxService.this.mWimaxStateTracker.clearRetryFlag();
                    if (WimaxService.this.getWimaxState() == WimaxState.DISCONNECTED) {
                        if (nApState == 13) {
                            if (WimaxService.this.m_bLog) {
                                Log.i((String)"WimaxService", (String)"it will be start scan to connect as backhaul mode");
                            }
                            WimaxService.this.startScan(true);
                        }
                    } else {
                        if (nApState == 13) {
                            if (WimaxService.this.m_bLog) {
                                Log.i((String)"WimaxService", (String)"it will be disconnect to re-connect as backhaul mode");
                            } else if (WimaxService.this.m_bLog) {
                                Log.i((String)"WimaxService", (String)"it will be disconnect to re-connect as normal mode");
                            }
                        }
                        WimaxService.this.disconnect();
                    }
                }
            } else {
                if (action.equals("com.android.settings.TETHERING_WIMAX_REALM_CHANGE_ACTION")) {
                    boolean usbTethered = intent.getBooleanExtra("tethering", false);
                    if (mbUSBTethered == usbTethered) {
                        return;
                    }
                    if (WimaxService.this.m_bLog) {
                        Log.i((String)"WimaxService", (String)"TETHERING_WIMAX_REALM_CHANGE_ACTION");
                    }
                    mbUSBTethered = usbTethered;
                    context.removeStickyBroadcast(intent);
                    if (WimaxService.this.m_bLog) {
                        Log.d((String)"WimaxService", (String)("usbTethered = " + usbTethered));
                    }
                    if (mbUSBTethered) {
                        if (WimaxService.this.m_bLog) {
                            Log.d((String)"WimaxService", (String)"Tethering option is checked");
                        }
                        if (WimaxService.this.getWimaxMode() == 1) {
                            if (WimaxService.this.m_bLog) {
                                Log.w((String)"WimaxService", (String)"discard - already tethered mode");
                            }
                        } else if (WimaxService.this.m_nPluggedType == 2 && WimaxService.this.get4GState() == 3) {
                            WimaxService.this.setWimaxMode(1, true);
                            WimaxService.this.mWimaxStateTracker.clearRetryFlag();
                            if (WimaxService.this.getWimaxState() == WimaxState.DISCONNECTED) {
                                if (WimaxService.this.m_bLog) {
                                    Log.i((String)"WimaxService", (String)"it will connect as tethered mode");
                                }
                                WimaxService.this.startScan(true);
                            } else if (WimaxService.this.getWimaxState() == WimaxState.SCANNING || WimaxService.this.getWimaxState() == WimaxState.READY || WimaxService.this.getWimaxState() == WimaxState.CONNECTING || WimaxService.this.getWimaxState() == WimaxState.OBTAINING_IPADDR || WimaxService.this.getWimaxState() == WimaxState.CONNECTED) {
                                if (WimaxService.this.m_bLog) {
                                    Log.i((String)"WimaxService", (String)"it will disconnect for re-connecting as tethered mode");
                                }
                                WimaxService.this.disconnect();
                            }
                        }
                    } else {
                        if (WimaxService.this.m_bLog) {
                            Log.d((String)"WimaxService", (String)"Tethering option is unchecked");
                        }
                        if (WimaxService.this.getWimaxMode() == 1) {
                            if (WimaxService.this.get4GState() == 3) {
                                WimaxService.this.setWimaxMode(1, false);
                                WimaxService.this.mWimaxStateTracker.clearRetryFlag();
                                if (WimaxService.this.getWimaxState() == WimaxState.DISCONNECTED) {
                                    if (WimaxService.this.m_bLog) {
                                        Log.i((String)"WimaxService", (String)"it will connect as normal mode");
                                    }
                                    WimaxService.this.startScan(true);
                                } else if (WimaxService.this.getWimaxState() == WimaxState.SCANNING || WimaxService.this.getWimaxState() == WimaxState.READY || WimaxService.this.getWimaxState() == WimaxState.CONNECTING || WimaxService.this.getWimaxState() == WimaxState.OBTAINING_IPADDR || WimaxService.this.getWimaxState() == WimaxState.CONNECTED) {
                                    if (WimaxService.this.m_bLog) {
                                        Log.i((String)"WimaxService", (String)"it will disconnect for re-connecting as normal mode");
                                    }
                                    WimaxService.this.disconnect();
                                }
                            }
                        } else if (WimaxService.this.m_bLog) {
                            Log.w((String)"WimaxService", (String)"discard - already NOT tethered mode");
                        }
                    }
                    return;
                }
                if (action.equals("android.intent.action.ACTION_SHUTDOWN")) {
                    if (WimaxService.this.m_bLog) {
                        Log.d((String)"WimaxService", (String)"@@@@@ ACTION_SHUTDOWN @@@@@");
                    }
                    if (WimaxService.this.get4GState() == 3 || WimaxService.this.get4GState() == 2) {
                        if (WimaxService.this.getWimaxMode() == 1) {
                            WimaxService.this.setWimaxMode(1, false);
                        }
                        WimaxService.this.mWimaxStateTracker.disconnectAndStop();
                        return;
                    }
                } else {
                    return;
                }
            }
            WimaxService.this.updateWimaxStatus();
        }
    };

    WimaxService(Context context, WimaxStateTracker tracker) {
        this.mContext = context;
        this.mWimaxStateTracker = tracker;
        this.mBatteryStats = BatteryStatsService.getService();
        HandlerThread WimaxThread = new HandlerThread("WimaxService");
        WimaxThread.start();
        this.mWimaxHandler = new WimaxHandler(WimaxThread.getLooper());
        this.mWimax4GState = 1;
        boolean WimaxEnabled = this.getPersistedWimaxEnabled();
        this.mWimaxStateTracker.m_bPoweroff = false;
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        sWakeLock = powerManager.newWakeLock(1, "WimaxService");
        sDriverStopWakeLock = powerManager.newWakeLock(1, "WimaxService");
        this.mWimaxStateTracker.setReleaseWakeLockCallback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WimaxService.this.mWimaxHandler.removeMessages(4);
                PowerManager.WakeLock wakeLock = sDriverStopWakeLock;
                synchronized (wakeLock) {
                    if (sDriverStopWakeLock.isHeld()) {
                        if (WimaxService.this.m_bLog) {
                            Log.i((String)"WimaxService", (String)"[setReleaseWakeLockCallback] sDriverStopWakeLock.release()");
                        }
                        sDriverStopWakeLock.release();
                    }
                }
            }
        });
        if (this.m_bLog) {
            Log.i((String)"WimaxService", (String)("WimaxService starting up with Wimax" + (WimaxEnabled ? "enabled" : "disabled")));
        }
        this.mWimaxStateTracker.isBootCompleted(false);
        this.mWimaxStateTracker.setWakeLock(sWakeLock);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WimaxService.this.mAirplaneModeOverwridden = false;
                WimaxService.this.updateWimaxStatus();
            }
        }, new IntentFilter("android.intent.action.AIRPLANE_MODE"));
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Uri data = intent.getData();
                String pkgName = data.getEncodedSchemeSpecificPart();
                if (WimaxService.this.m_bLog) {
                    Log.i((String)"WimaxService", (String)(action + " " + pkgName));
                }
                if (!"com.samsung.wimax.widget4G".equals(pkgName)) {
                    return;
                }
                if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action)) {
                    // empty if block
                }
            }
        }, filter);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (WimaxService.this.m_bLog) {
                    Log.i((String)"WimaxService", (String)"Intent.ACTION_BOOT_COMPLETED");
                }
                boolean WimaxEnabled = WimaxService.this.getPersistedWimaxEnabled();
                WimaxService.this.mWimaxStateTracker.isBootCompleted(true);
                WimaxService.this.setWimaxEnabledBlocking(WimaxEnabled, false, Process.myUid());
            }
        }, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
        this.m_bLog = this.getEnableLog();
        this.telMgr = (TelephonyManager)this.mContext.getSystemService("phone");
        PhoneStateListener listener = new PhoneStateListener(){

            public void onCallStateChanged(int state, String incomingNumber) {
                if (WimaxService.this.m_bLog) {
                    Log.d((String)"WimaxService", (String)("onCallStateChanged : " + state));
                }
                WimaxService.this.m_nCallState = state;
                int nWimaxMode = WimaxService.this.getWimaxMode();
                if (nWimaxMode == 2 || nWimaxMode == 4) {
                    WimaxState wimaxState = WimaxService.this.getWimaxState();
                    int wimax4GState = WimaxService.this.get4GState();
                    if (state == 2) {
                        WimaxService.this.mWimaxStateTracker.SetNoBackOff(true);
                        if (wimaxState == WimaxState.CONNECTING || wimaxState == WimaxState.OBTAINING_IPADDR || wimaxState == WimaxState.CONNECTED) {
                            if (WimaxService.this.m_bLog) {
                                Log.d((String)"WimaxService", (String)"CALL_STATE_OFFHOOK, disconnect");
                            }
                            WimaxService.this.disconnect();
                        }
                    } else if (state == 0) {
                        boolean bNoBackOff = WimaxService.this.mWimaxStateTracker.getNoBackoff();
                        WimaxService.this.mWimaxStateTracker.SetNoBackOff(false);
                        if (wimaxState == WimaxState.DISCONNECTED && wimax4GState == 3 && bNoBackOff) {
                            if (WimaxService.this.m_bLog) {
                                Log.d((String)"WimaxService", (String)"CALL_STATE_IDLE, reconnect");
                            }
                            WimaxService.this.startScan(false);
                        }
                    }
                }
            }
        };
        this.telMgr.listen(listener, 32);
    }

    @Override
    public boolean getPersistedWimaxEnabled() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)"wimax_on") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_on", (int)0);
            return false;
        }
    }

    private void persistWimaxEnabled(boolean enabled) {
        ContentResolver cr = this.mContext.getContentResolver();
        Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_on", (int)(enabled ? 1 : 0));
    }

    private boolean getPersistedNetworkConnectionEnabled() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)"wimax_network_connection") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_network_connection", (int)1);
            return true;
        }
    }

    private void persistNetworkConnectionEnabled(boolean enabled) {
        ContentResolver cr = this.mContext.getContentResolver();
        Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_network_connection", (int)(enabled ? 1 : 0));
    }

    NetworkStateTracker getNetworkStateTracker() {
        return this.mWimaxStateTracker;
    }

    @Override
    public int getNetworkConnectionSetting() {
        return mModeWhieAPsleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set4GEnabled(boolean enable) {
        this.enforceChangePermission();
        this.enforceRadioDisablePermission();
        if (this.mWimaxHandler == null) {
            return false;
        }
        WimaxHandler wimaxHandler = this.mWimaxHandler;
        synchronized (wimaxHandler) {
            long ident = Binder.clearCallingIdentity();
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)"acquire sWakeLock----------------------");
            }
            this.acquire_WakeLock(sWakeLock);
            Binder.restoreCallingIdentity((long)ident);
            this.mLastEnableUid = Binder.getCallingUid();
            boolean bl = this.mAirplaneModeOverwridden = enable && this.isAirplaneModeOn() && this.isAirplaneToggleable();
            if (enable && this.isAirplaneModeOn() && !this.mAirplaneModeOverwridden) {
                if (this.m_bLog) {
                    Log.e((String)"WimaxService", (String)"[set4GEnabled] can't enable 4G because isAirplaneModeOn() is true");
                }
                return false;
            }
            this.sendEnableMessage(enable, true, Binder.getCallingUid());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setWimaxEnabledBlocking(boolean enable, boolean persist, int uid) {
        int nWimaxEnabledState = this.get4GState();
        if (!(enable || nWimaxEnabledState != 1 && nWimaxEnabledState != 0)) {
            if (this.m_bLog) {
                Log.w((String)"WimaxService", (String)"[setWimaxEnabledBlocking] already disabled");
            }
            return true;
        }
        boolean bl = this.mAirplaneModeOverwridden = enable && this.isAirplaneModeOn() && this.isAirplaneToggleable();
        if (enable && this.isAirplaneModeOn() && !this.mAirplaneModeOverwridden) {
            if (this.m_bLog) {
                Log.e((String)"WimaxService", (String)"[set4GEnabled] can't enable 4G because isAirplaneModeOn() is true");
            }
            return false;
        }
        if (!this.mWimaxStateTracker.mModemReset && enable && (nWimaxEnabledState == 3 || nWimaxEnabledState == 2)) {
            if (this.m_bLog) {
                Log.w((String)"WimaxService", (String)"[setWimaxEnabledBlocking] already enabled");
            }
            return true;
        }
        int nWorkModeState = this.getWorkModeState();
        if (this.m_bLog) {
            Log.i((String)"WimaxService", (String)("[setWimaxEnabledBlocking] Workmode = " + nWorkModeState));
        }
        this.setWimaxEnabledState(enable ? 2 : 0, uid);
        WimaxHandler wimaxHandler = this.mWimaxHandler;
        synchronized (wimaxHandler) {
            if (this.m_bLog) {
                Log.e((String)"WimaxService", (String)"synchronized wimax..");
            }
            if (enable) {
                if (this.m_bLog) {
                    Log.i((String)"WimaxService", (String)("wimax ON ---mModeWhieAPsleep = " + mModeWhieAPsleep + " mModemReset = " + this.mWimaxStateTracker.mModemReset + " mIsDMmode = " + mIsDMmode + " mbUSBTethered = " + mbUSBTethered + " m_nPluggedType : " + this.m_nPluggedType));
                }
                mModeWhieAPsleep = this.getPersistedNetworkConnectionEnabled() ? (byte)1 : 0;
                if (!this.mWimaxStateTracker.mModemReset) {
                    this.registerForBroadcasts();
                    this.mWimaxStateTracker.startEventLoop();
                } else {
                    this.mWimaxStateTracker.mModemReset = false;
                }
                WimaxNative.setVirtualIdleWhileAPsleep(mModeWhieAPsleep);
                if (mbUSBTethered && this.m_nPluggedType == 2) {
                    this.setWimaxMode(1, true);
                } else {
                    this.setWimaxMode(1, false);
                }
                if (mIsDMmode) {
                    WimaxNative.setWimaxTethered((byte)4);
                } else {
                    WimaxNative.setWimaxTethered((byte)0);
                }
                this.mWimaxStateTracker.m_bPoweroff = false;
                if (!WimaxNative.startWimax()) {
                    WimaxNative.loadDriver((byte)0);
                    if (this.m_bLog) {
                        Log.e((String)"WimaxService", (String)("Failed to start Wimax. m_bPoweroff = " + this.mWimaxStateTracker.m_bPoweroff));
                    }
                    this.mContext.unregisterReceiver(this.mReceiver);
                    if (this.mWimaxStateTracker.m_bPoweroff) {
                        if (this.m_bLog) {
                            Log.e((String)"WimaxService", (String)("mWimax4GState = " + this.mWimax4GState));
                        }
                        this.setWimaxEnabledState(1, uid);
                    } else {
                        this.setWimaxEnabledState(4, uid);
                    }
                    this.release_sWakeLock();
                    return false;
                }
                int nWimaxMode = this.getWimaxMode();
                if ((nWimaxMode == 4 || nWimaxMode == 2) && this.m_nCallState == 2) {
                    this.mWimaxStateTracker.SetNoBackOff(true);
                }
            } else {
                WimaxState wimaxState;
                this.mWimaxStateTracker.m_bPoweroff = true;
                this.mWimaxStateTracker.nRetryFlag = 0;
                this.mWimaxStateTracker.resetOldState();
                if (4 != nWimaxEnabledState) {
                    try {
                        this.mContext.unregisterReceiver(this.mReceiver);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if ((wimaxState = this.mWimaxStateTracker.getCurrentWimaxState()) == WimaxState.CONNECTED || wimaxState == WimaxState.CONNECTING || wimaxState == WimaxState.OBTAINING_IPADDR) {
                    if (this.m_bLog) {
                        Log.i((String)"WimaxService", (String)("state(" + (Object)((Object)wimaxState) + ") :  DisconnectWimax before turn off"));
                    }
                    this.mWimaxStateTracker.resetInterface();
                    this.mWimaxStateTracker.mIsTetheredmode = mIsTetheredmode;
                    this.mWimaxStateTracker.disconnectAndStop();
                } else {
                    if (this.m_bLog) {
                        Log.i((String)"WimaxService", (String)("state(" + (Object)((Object)wimaxState) + ") : stopWimax"));
                    }
                    this.mWimaxStateTracker.mIsTetheredmode = mIsTetheredmode;
                    if (!WimaxNative.stopWimax() && this.m_bLog) {
                        Log.e((String)"WimaxService", (String)"fail to stop wimax..");
                    }
                    if (WimaxNative.loadDriver((byte)0)) {
                        this.mWimaxStateTracker.notifyDriverStopped();
                    }
                }
            }
            if (persist) {
                if (this.m_bLog) {
                    Log.i((String)"WimaxService", (String)("[setWimaxEnabledBlocking] persist = " + persist));
                }
                this.persistWimaxEnabled(enable);
            }
        }
        return true;
    }

    private void setWimaxEnabledState(int Wimax4GState, int uid) {
        int previousWimaxStatus = this.mWimax4GState;
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)"[setWimaxEnabledState] ");
        }
        long ident = Binder.clearCallingIdentity();
        this.mWimax4GState = Wimax4GState;
        Intent intent = new Intent("android.net.fourG.NET_4G_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("4g_state", Wimax4GState);
        intent.putExtra("4G_previous_state", previousWimaxStatus);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_4G_STATE", "WimaxService");
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_4G_STATE", "WimaxService");
    }

    private void enforceRadioDisablePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_4G_RADIO_DISABLE", "WimaxService");
    }

    private void enforceMulticastChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIMAX_MULTICAST_STATE", "WimaxService");
    }

    @Override
    public int get4GState() {
        this.enforceAccessPermission();
        return this.mWimax4GState;
    }

    @Override
    public void setWimaxStatus(int wimaxStatus) {
        this.enforceChangePermission();
        this.setWimaxEnabledState(wimaxStatus, Process.myUid());
    }

    @Override
    public WimaxState getWimaxState() {
        this.enforceAccessPermission();
        return this.mWimaxStateTracker.getCurrentWimaxState();
    }

    @Override
    public int getWimaxStateDetail() {
        this.enforceAccessPermission();
        return this.mWimaxStateTracker.getCurrentWimaxStateDetail();
    }

    private void acquire_WakeLock(PowerManager.WakeLock wl) {
        this.enforceAccessPermission();
        if (wl.isHeld()) {
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)"------WakeLock already acquired----------------");
            }
        } else {
            if (this.m_bLog) {
                Log.i((String)"WimaxService", (String)"------WakeLock will be acquired----------------");
            }
            wl.acquire();
        }
    }

    @Override
    public void release_sWakeLock() {
        this.enforceAccessPermission();
        if (sWakeLock.isHeld()) {
            if (this.m_bLog) {
                Log.i((String)"WimaxService", (String)"------release WakeLock----------------");
            }
            sWakeLock.release();
        }
    }

    @Override
    public int getWimaxMode() {
        this.enforceAccessPermission();
        int nMode = 0;
        nMode = mIsTetheredmode ? 1 : (mIsDMmode ? (mIsBackhaulMode ? 4 : 3) : (mIsBackhaulMode ? 2 : 0));
        return nMode;
    }

    @Override
    public int setWimaxMode(int nMode, boolean enable) {
        this.enforceChangePermission();
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("setWimaxMode nMode: " + nMode + " enable: " + enable));
        }
        int nRet = -1;
        switch (nMode) {
            case 0: {
                if (!this.mWimaxStateTracker.getNoBackoff()) break;
                this.mWimaxStateTracker.SetNoBackOff(false);
                break;
            }
            case 1: {
                mIsTetheredmode = enable;
                nRet = 0;
                WimaxNative.setBackhaulMode(enable);
                break;
            }
            case 2: {
                mIsBackhaulMode = enable;
                WimaxNative.setBackhaulMode(enable);
                break;
            }
            case 3: 
            case 4: {
                if (this.get4GState() == 3) break;
                mIsDMmode = enable;
                nRet = 0;
            }
        }
        return nRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkUSBstate() {
        String msg = null;
        BufferedReader br = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(USB_STATE);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        try {
            try {
                br = new BufferedReader(new InputStreamReader(fis));
                msg = br.readLine();
            }
            catch (IOException e) {
                if (this.m_bLog) {
                    Log.e((String)"WimaxService", (String)("File error : " + e));
                }
                boolean bl = false;
                Object var7_7 = null;
                try {
                    br.close();
                    fis.close();
                    return bl;
                }
                catch (IOException ioe) {
                    if (this.m_bLog) {
                        Log.e((String)"WimaxService", (String)"file close error");
                    }
                    ioe.printStackTrace();
                    return false;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (IOException ioe) {
                if (this.m_bLog) {
                    Log.e((String)"WimaxService", (String)"file close error");
                }
                ioe.printStackTrace();
                return false;
            }
            br.close();
            fis.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            if (this.m_bLog) {
                Log.e((String)"WimaxService", (String)"file close error");
            }
            ioe.printStackTrace();
            return false;
        }
        br.close();
        fis.close();
        if (!msg.equals("USB_STATE_CONFIGURED")) return false;
        if (this.m_nPluggedType != 2) return false;
        return true;
    }

    @Override
    public List<Wimax4GConfiguration> getAvailableNetworks() {
        this.mAvailableList.clear();
        WimaxNative.setAvailableList(this.mAvailableList);
        WimaxNative.getAvailableNetworks(this.m4GConfiguration);
        return this.mAvailableList;
    }

    @Override
    public Wimax4GBaseStationInfo getConnectedNSP() {
        WimaxNative.getConnectedNSP(this.mConnected4GBaseStationInfo);
        return this.mConnected4GBaseStationInfo;
    }

    @Override
    public Wimax4GManager.WimaxConnectionStatistics createConnectionStatistics() {
        this.mConnectionStatistics.getTotalRxBytes();
        this.mConnectionStatistics.getTotalRxPackets();
        this.mConnectionStatistics.getTotalTxBytes();
        this.mConnectionStatistics.getTotalTxPackets();
        return this.mConnectionStatistics;
    }

    @Override
    public Wimax4GDeviceInfo getDeviceInformation() {
        WimaxNative.getDeviceInformation(this.mDeviceInfo);
        return this.mDeviceInfo;
    }

    @Override
    public Wimax4GInfo getConnectionInfo() {
        this.enforceAccessPermission();
        return this.mWimaxStateTracker.requestConnectionInfo();
    }

    @Override
    public int[] getNetworkEntryCompleteTimes() {
        this.enforceAccessPermission();
        return WimaxNative.getNetworkEntryCompleteTimes();
    }

    @Override
    public int connect(String homeNspName, String roamingNspName, String userName, String passWord) {
        int result;
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[connect] homeNspName: " + homeNspName));
        }
        if ((result = WimaxNative.connectmWimax(homeNspName, "", "", 0, "")) == 0) {
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)"^^^^^ Connection req. is success ^^^^^");
            }
        } else {
            if (this.m_bLog) {
                Log.e((String)"WimaxService", (String)"connectmWimax() returns fail.");
            }
            result = -1;
            return result;
        }
        result = 0;
        this.mWimaxStateTracker.setHaveLinkInfo(true);
        this.mWimaxStateTracker.setIdleState(false);
        return result;
    }

    @Override
    public boolean disconnect() {
        this.mWimaxStateTracker.resetInterface();
        return WimaxNative.disconnectWimax();
    }

    @Override
    public boolean reassociate() {
        this.mWimaxStateTracker.resetInterface();
        if (WimaxNative.disconnectWimax()) {
            return this.set4GEnabled(true);
        }
        return false;
    }

    @Override
    public boolean startScan(boolean bUserReq) {
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[startScan] bUserReq : " + bUserReq + " nScanAttempt = " + this.mWimaxStateTracker.nScanAttempt));
        }
        this.acquire_WakeLock(sWakeLock);
        this.mWimaxStateTracker.notifyStateChange(WimaxState.SCANNING, null);
        if (WimaxNative.scanCommand()) {
            if (bUserReq) {
                this.mWimaxStateTracker.clearRetryFlag();
            }
            ++this.mWimaxStateTracker.nScanAttempt;
            return true;
        }
        this.mWimaxStateTracker.notifyStateChange(WimaxState.DISCONNECTED, DeviceStatusInfo.ConnectionProgressInfo.Syncup_PHY);
        this.release_sWakeLock();
        return false;
    }

    public boolean CheckWimaxState() {
        this.enforceAccessPermission();
        return WimaxNative.getLinkState();
    }

    @Override
    public void enableLogLevel(int nLoglevel) {
        char Loglevel;
        switch (nLoglevel) {
            case 1: {
                Loglevel = '\u0001';
                break;
            }
            case 2: {
                Loglevel = '\u0002';
                break;
            }
            case 3: {
                Loglevel = '\u0003';
                break;
            }
            case 4: {
                Loglevel = '\u0004';
                break;
            }
            default: {
                Loglevel = '\u0001';
            }
        }
        WimaxNative.setEnableLogLevel(Loglevel);
    }

    @Override
    public DhcpInfo getDhcpInfo() {
        this.enforceAccessPermission();
        return this.mWimaxStateTracker.getDhcpInfo();
    }

    @Override
    public void getNeighborList() {
        WimaxNative.getNeighborList();
    }

    @Override
    public void getRadioInfoTemperature() {
        WimaxNative.getRadioInfo();
    }

    @Override
    public Wimax4GManager.WimaxRadioInfoTemperature getRadioInfoTemperatureResponse() {
        return WimaxNative.radioInfo;
    }

    @Override
    public int getWorkModeState() {
        Object selectedMode = null;
        int mode = 0;
        return mode;
    }

    @Override
    public boolean setWorkModeState(int workMode) {
        return true;
    }

    @Override
    public void getMruList() {
        WimaxNative.mMruListRsp.clear();
        WimaxNative.getMruList();
    }

    @Override
    public List<MruList> getMruListRsp() {
        return WimaxNative.mMruListRsp;
    }

    @Override
    public boolean getMruUpdate(String strUpdate, int nSize) {
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("getMruUpdate nSize: " + nSize));
        }
        if (nSize == 0) {
            return WimaxNative.getMruUpdate(null, null, null, nSize);
        }
        StringTokenizer st = new StringTokenizer(strUpdate, "@");
        int[] arCF = new int[nSize];
        byte[] arBW = new byte[nSize];
        byte[] arFFT = new byte[nSize];
        for (int i = 0; i < nSize; ++i) {
            StringTokenizer stList;
            String temp;
            if (!st.hasMoreTokens() || (temp = st.nextToken()) == null || !(stList = new StringTokenizer(temp, "#")).hasMoreTokens()) continue;
            arCF[i] = Integer.parseInt(stList.nextToken());
            if (!stList.hasMoreTokens()) continue;
            arBW[i] = Byte.parseByte(stList.nextToken());
            if (!stList.hasMoreTokens()) continue;
            arFFT[i] = Byte.parseByte(stList.nextToken());
        }
        return WimaxNative.getMruUpdate(arCF, arBW, arFFT, nSize);
    }

    @Override
    public void setMruWorking(boolean bWorking) {
        this.mWimaxStateTracker.m_bMruWorking = bWorking;
    }

    @Override
    public int makeOdbTlvData(byte[] pBuffer, int nBufferIndex, int wBufferLen, int wTag, int wLength, byte[] pbValue) {
        this.enforceAccessPermission();
        byte highByte = (byte)(wTag >> 0 & 0xFF);
        byte lowByte = (byte)(wTag >> 8 & 0xFF);
        pBuffer[nBufferIndex + 0] = highByte;
        pBuffer[nBufferIndex + 1] = lowByte;
        highByte = (byte)(wLength >> 0 & 0xFF);
        lowByte = (byte)(wLength >> 8 & 0xFF);
        pBuffer[nBufferIndex + 2] = highByte;
        pBuffer[nBufferIndex + 3] = lowByte;
        System.arraycopy(pbValue, 0, pBuffer, nBufferIndex + 4, wLength);
        return (short)(4 + wLength);
    }

    @Override
    public int OdbReadReq(byte[] tlvDataArray) {
        this.enforceChangePermission();
        return WimaxNative.OdbReadReq(tlvDataArray);
    }

    @Override
    public int OdbWriteReq(byte[] tlvDataArray) {
        this.enforceChangePermission();
        return WimaxNative.OdbWriteReq(tlvDataArray);
    }

    @Override
    public int OdbUpdateReq() {
        this.enforceChangePermission();
        return WimaxNative.OdbUpdateReq();
    }

    @Override
    public int OdbAddReq(byte[] tlvDataArray) {
        this.enforceChangePermission();
        return WimaxNative.OdbAddReq(tlvDataArray);
    }

    @Override
    public int OdbDeleteReq(byte[] tlvDataArray) {
        this.enforceChangePermission();
        return WimaxNative.OdbDeleteReq(tlvDataArray);
    }

    @Override
    public boolean setFactoryDefault(int nType) {
        this.enforceChangePermission();
        if (nType == 1) {
            return WimaxNative.OdbDefaultReq();
        }
        return false;
    }

    @Override
    public int setVirtualIdleWhileAPsleep(byte bMode) {
        boolean enable = bMode == 1;
        this.persistNetworkConnectionEnabled(enable);
        mModeWhieAPsleep = bMode;
        return 0;
    }

    private void sendEnableMessage(boolean enable, boolean persist, int uid) {
        Message msg = Message.obtain((Handler)this.mWimaxHandler, (int)(enable ? 0 : 1), (int)(persist ? 1 : 0), (int)uid);
        msg.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWimaxStatus() {
        boolean WimaxShouldBeEnabled;
        boolean WimaxEnabled = this.getPersistedWimaxEnabled();
        boolean airplaneMode = this.isAirplaneModeOn() && !this.mAirplaneModeOverwridden;
        boolean bl = WimaxShouldBeEnabled = WimaxEnabled && !airplaneMode;
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[updateWimaxStatus] airplaneMode1 " + airplaneMode));
        }
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[updateWimaxStatus] mAirplaneModeOverwridden " + this.mAirplaneModeOverwridden));
        }
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[updateWimaxStatus] WimaxShouldBeEnabled " + WimaxShouldBeEnabled));
        }
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("[updateWimaxStatus] WimaxEnabled " + WimaxEnabled));
        }
        WimaxHandler wimaxHandler = this.mWimaxHandler;
        synchronized (wimaxHandler) {
            if (this.mWimax4GState == 2 && !airplaneMode) {
                if (this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"[updateWimaxStatus] mWimax4GState == NET_4G_STATE_ENABLING && !airplaneMode return ;");
                }
                return;
            }
            if (WimaxShouldBeEnabled) {
                if (this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"[updateWimaxStatus] WimaxShouldBeEnabled == true");
                }
                this.acquire_WakeLock(sWakeLock);
                this.sendEnableMessage(true, false, this.mLastEnableUid);
            } else {
                if (this.m_bLog) {
                    Log.d((String)"WimaxService", (String)"[updateWiMAXState] WimaxShouldBeEnabled == false acquire sWakeLock");
                }
                this.acquire_WakeLock(sWakeLock);
                this.sendEnableMessage(false, false, this.mLastEnableUid);
            }
        }
    }

    private void registerForBroadcasts() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.net.wifi.WIFI_AP_STATE_CHANGED");
        intentFilter.addAction("com.android.settings.TETHERING_WIMAX_REALM_CHANGE_ACTION");
        intentFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.addAction("com.android.server.Wimax4GManager.action.WIMAX_DHCP_RENEW");
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
    }

    private boolean isAirplaneSensitive() {
        String airplaneModeRadios = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_radios");
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("isAirplaneSensitive return true  " + airplaneModeRadios));
        }
        return airplaneModeRadios == null || airplaneModeRadios.contains("wimax");
    }

    private boolean isAirplaneToggleable() {
        String toggleableRadios = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_toggleable_radios");
        return toggleableRadios != null && toggleableRadios.contains("wimax");
    }

    private boolean isAirplaneModeOn() {
        return this.isAirplaneSensitive() && Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)0) == 1;
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WimaxService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Wimax is " + WimaxService.stateName(this.mWimax4GState));
        pw.println("Stay-awake conditions: " + Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"stay_on_while_plugged_in", (int)0));
        pw.println();
        pw.println("Internal state:");
        pw.println((Object)this.mWimaxStateTracker);
        pw.println();
        pw.println("Locks acquired: " + this.mFullLocksAcquired + " full");
        pw.println("Locks released: " + this.mFullLocksReleased + " full");
        pw.println();
        pw.println("Locks held:");
        this.mLocks.dump(pw);
    }

    private static String stateName(int net4GState) {
        switch (net4GState) {
            case 0: {
                return "disabling";
            }
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabling";
            }
            case 3: {
                return "enabled";
            }
            case 4: {
                return "unknown 4G state";
            }
        }
        return "[invalid state]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireLock(IBinder binder, int lockMode, String tag) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        if (lockMode != 1 && lockMode != 2) {
            return false;
        }
        Lock Lock2 = new Lock(lockMode, tag, binder);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.acquireLockLocked(Lock2);
        }
    }

    private boolean acquireLockLocked(Lock Lock2) {
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("acquireLockLocked: " + Lock2));
        }
        this.mLocks.addLock(Lock2);
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        switch (Lock2.mMode) {
            case 1: {
                ++this.mFullLocksAcquired;
            }
        }
        this.updateWimaxStatus();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseLock(IBinder lock) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.releaseLockLocked(lock);
        }
    }

    private boolean releaseLockLocked(IBinder lock) {
        boolean hadLock;
        Lock wimaxLock = this.mLocks.removeLock(lock);
        if (this.m_bLog) {
            Log.d((String)"WimaxService", (String)("releaseLockLocked: " + wimaxLock));
        }
        boolean bl = hadLock = wimaxLock != null;
        if (hadLock) {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            switch (wimaxLock.mMode) {
                case 1: {
                    ++this.mFullLocksReleased;
                }
            }
        }
        this.updateWimaxStatus();
        return hadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void acquireMulticastLock(IBinder binder, String tag) {
        this.enforceMulticastChangePermission();
        List<Multicaster> list = this.mMulticasters;
        // MONITORENTER : list
        ++this.mMulticastEnabled;
        this.mMulticasters.add(new Multicaster(tag, binder));
        WimaxStateTracker wimaxStateTracker = this.mWimaxStateTracker;
        // MONITORENTER : wimaxStateTracker
        // MONITOREXIT : wimaxStateTracker
        // MONITOREXIT : list
        int uid = Binder.getCallingUid();
        Long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mBatteryStats.noteWifiMulticastEnabled(uid);
            }
            catch (RemoteException e) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var8_6 = null;
            Binder.restoreCallingIdentity((long)ident);
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseMulticastLock() {
        this.enforceMulticastChangePermission();
        int uid = Binder.getCallingUid();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            ++this.mMulticastDisabled;
            int size = this.mMulticasters.size();
            for (int i = size - 1; i >= 0; --i) {
                Multicaster m = this.mMulticasters.get(i);
                if (m == null || m.getUid() != uid) continue;
                this.removeMulticasterLocked(i, uid);
            }
        }
    }

    private void removeMulticasterLocked(int i, int uid) {
        Multicaster removed = this.mMulticasters.remove(i);
        if (removed != null) {
            removed.unlinkDeathRecipient();
        }
        Long ident = Binder.clearCallingIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMulticastEnabled() {
        this.enforceAccessPermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            return this.mMulticasters.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getEnableLog() {
        String msg = null;
        BufferedReader br = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/data/4G.txt");
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        try {
            try {
                br = new BufferedReader(new InputStreamReader(fis));
                msg = br.readLine();
            }
            catch (IOException e) {
                if (this.m_bLog) {
                    Log.e((String)"WimaxService", (String)("File error : " + e));
                }
                boolean bl = false;
                Object var7_8 = null;
                try {
                    br.close();
                    fis.close();
                    return bl;
                }
                catch (IOException ioe) {
                    if (this.m_bLog) {
                        Log.e((String)"WimaxService", (String)"file close error");
                    }
                    ioe.printStackTrace();
                    return false;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (IOException ioe) {
                if (this.m_bLog) {
                    Log.e((String)"WimaxService", (String)"file close error");
                }
                ioe.printStackTrace();
                return false;
            }
            br.close();
            fis.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            if (this.m_bLog) {
                Log.e((String)"WimaxService", (String)"file close error");
            }
            ioe.printStackTrace();
            return false;
        }
        br.close();
        fis.close();
        int i = 0;
        while (i < msg.length()) {
            if (msg.substring(i, i + 1).equals("F")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int saveStaticIP(String ip, String gateway, String netmask, String dns1, String dns2) {
        FileWriter fOut = null;
        try {
            fOut = new FileWriter("/data/wimax_ip.txt");
        }
        catch (IOException e) {
            Log.e((String)"WimaxService", (String)("File wimax_ip.txt not created " + e));
            return -1;
        }
        try {
            BufferedWriter osw = new BufferedWriter(fOut);
            osw.write(ip + "\n");
            osw.write(gateway + "\n");
            osw.write(netmask + "\n");
            osw.write(dns1 + "\n");
            osw.write(dns2);
            osw.flush();
            osw.close();
            fOut.close();
            return 1;
        }
        catch (IOException e) {
            Log.e((String)"WimaxService", (String)("File write error" + e));
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readStaticIP(int nIndex) {
        String msg = null;
        BufferedReader br = null;
        FileReader fis = null;
        try {
            fis = new FileReader("/data/wimax_ip.txt");
        }
        catch (FileNotFoundException fnfe) {
            Log.e((String)"WimaxService", (String)("File Not found exception" + fnfe));
            return "no file error";
        }
        try {
            try {
                br = new BufferedReader(fis);
                do {
                    msg = br.readLine();
                } while (nIndex-- > 0);
            }
            catch (IOException e) {
                Log.e((String)"WimaxService", (String)("Read file error : " + e));
                String string = "read file error";
                Object var8_8 = null;
                try {
                    br.close();
                    fis.close();
                    return string;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Log.e((String)"WimaxService", (String)"Close error");
                    return "close error";
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {}
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.e((String)"WimaxService", (String)"Close error");
                return "close error";
            }
            br.close();
            fis.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            ioe.printStackTrace();
            Log.e((String)"WimaxService", (String)"Close error");
            return "close error";
        }
        br.close();
        fis.close();
        return msg;
    }

    @Override
    public int deleteStaticIP() {
        FileWriter fOut = null;
        try {
            fOut = new FileWriter("/data/wimax_ip.txt");
            BufferedWriter osw = new BufferedWriter(fOut);
            osw.write("");
            osw.flush();
            osw.close();
            return 1;
        }
        catch (IOException e) {
            Log.e((String)"WimaxService", (String)"File wimax_ip.txt not reset");
            return -1;
        }
    }

    @Override
    public void calWiMAXThroughput(boolean bstart) {
        if (bstart) {
            this.mStartTime = new Date().getTime();
            this.mRxStart = this.mConnectionStatistics.getTotalRxBytes();
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)("Start Calculate WiMAX Throughput, StartTime is " + this.mStartTime + " RxSize is " + this.mRxStart));
            }
        } else {
            this.mEndTime = new Date().getTime();
            this.mRxEnd = this.mConnectionStatistics.getTotalRxBytes();
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)("End Calculate WiMAX Throughput, EndTime is " + this.mEndTime + " RxSize is " + this.mRxEnd));
            }
            this.mDiffTime = (int)(this.mEndTime - this.mStartTime);
            this.mDiffRxsize = this.mRxEnd - this.mRxStart;
            this.mThroughput = (int)(this.mDiffRxsize * 8L) / (this.mDiffTime / 1000);
            if (this.m_bLog) {
                Log.d((String)"WimaxService", (String)("DiffTime is " + this.mDiffTime / 1000 + "s, DiffRxsize is " + this.mDiffRxsize * 8L + "bit, Throughput is " + this.mThroughput + "bps"));
            }
            Intent intent = new Intent("android.net.wimax.WIMAX_DATA_THROUGHPUT");
            intent.addFlags(0x10000000);
            intent.putExtra("android.net.wimax.EXTRA_TIME", this.mDiffTime);
            intent.putExtra("android.net.wimax.EXTRA_DATA", this.mDiffRxsize);
            intent.putExtra("android.net.wimax.EXTRA_THROUGHPUT", this.mThroughput);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    @Override
    public int getMinTemperature() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)"wimax_min_radio_temperature");
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_min_radio_temperature", (int)1000);
            return 1000;
        }
    }

    @Override
    public int getMaxTemperature() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)"wimax_max_radio_temperature");
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_max_radio_temperature", (int)-100);
            return -100;
        }
    }

    @Override
    public boolean setMinTemperature(int temp) {
        ContentResolver cr = this.mContext.getContentResolver();
        Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_min_radio_temperature", (int)temp);
        return true;
    }

    @Override
    public boolean setMaxTemperature(int temp) {
        ContentResolver cr = this.mContext.getContentResolver();
        Settings.Secure.putInt((ContentResolver)cr, (String)"wimax_max_radio_temperature", (int)temp);
        return true;
    }

    @Override
    public boolean reconnect() {
        return this.mWimaxStateTracker.reconnect();
    }

    @Override
    public boolean setRoamingEnabled(boolean enabled) {
        return WimaxNative.setRoamingEnabled(enabled);
    }

    @Override
    public boolean isRoamingEnabled() {
        return WimaxNative.isRoamingEnabled();
    }

    static {
        mIsTetheredmode = false;
        mIsDMmode = false;
        mIsBackhaulMode = false;
        mbUSBTethered = false;
        mModeWhieAPsleep = 1;
        USB_CONNECTED = new byte[]{85, 83, 66, 95, 83, 84, 65, 84, 69, 95, 67, 79, 78, 70, 73, 71, 85, 82, 69, 68};
    }

    private class Multicaster
    extends DeathRecipient {
        Multicaster(String tag, IBinder binder) {
            super(Binder.getCallingUid(), tag, binder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            if (WimaxService.this.m_bLog) {
                Log.e((String)"WimaxService", (String)"Multicaster binderDied");
            }
            List list = WimaxService.this.mMulticasters;
            synchronized (list) {
                int i = WimaxService.this.mMulticasters.indexOf(this);
                if (i != -1) {
                    WimaxService.this.removeMulticasterLocked(i, this.mMode);
                }
            }
        }

        public String toString() {
            return "Multicaster{" + this.mTag + " binder=" + this.mBinder + "}";
        }

        public int getUid() {
            return this.mMode;
        }
    }

    private abstract class DeathRecipient
    implements IBinder.DeathRecipient {
        String mTag;
        int mMode;
        IBinder mBinder;

        DeathRecipient(int mode, String tag, IBinder binder) {
            this.mTag = tag;
            this.mMode = mode;
            this.mBinder = binder;
            try {
                this.mBinder.linkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }
    }

    private class LockList {
        private List<Lock> mList = new ArrayList<Lock>();

        private LockList() {
        }

        private synchronized boolean hasLocks() {
            return !this.mList.isEmpty();
        }

        private synchronized int getStrongestLockMode() {
            if (this.mList.isEmpty()) {
                return 1;
            }
            for (Lock l : this.mList) {
                if (l.mMode != 1) continue;
                return 1;
            }
            return 2;
        }

        private void addLock(Lock lock) {
            if (this.findLockByBinder(lock.mBinder) < 0) {
                this.mList.add(lock);
            }
        }

        private Lock removeLock(IBinder binder) {
            int index = this.findLockByBinder(binder);
            if (index >= 0) {
                Lock ret = this.mList.remove(index);
                ret.unlinkDeathRecipient();
                return ret;
            }
            return null;
        }

        private int findLockByBinder(IBinder binder) {
            int size = this.mList.size();
            for (int i = size - 1; i >= 0; --i) {
                if (this.mList.get((int)i).mBinder != binder) continue;
                return i;
            }
            return -1;
        }

        private void dump(PrintWriter pw) {
            for (Lock l : this.mList) {
                pw.print("    ");
                pw.println(l);
            }
        }
    }

    private class Lock
    extends DeathRecipient {
        Lock(int lockMode, String tag, IBinder binder) {
            super(lockMode, tag, binder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            LockList lockList = WimaxService.this.mLocks;
            synchronized (lockList) {
                WimaxService.this.releaseLockLocked(this.mBinder);
            }
        }

        public String toString() {
            return "Lock{" + this.mTag + " type=" + this.mMode + " binder=" + this.mBinder + "}";
        }
    }

    private class WimaxHandler
    extends Handler {
        public WimaxHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (WimaxService.this.m_bLog) {
                Log.d((String)"WimaxService", (String)("+ Received " + msg));
            }
            switch (msg.what) {
                case 0: {
                    WimaxService.this.m_bLog = WimaxService.this.getEnableLog();
                    WimaxService.this.mWimaxStateTracker.setEnableLog(WimaxService.this.m_bLog);
                    if (WimaxService.this.m_bLog) {
                        Log.d((String)"WimaxService", (String)"MESSAGE_ENABLE_WIMAX >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    }
                    WimaxService.this.setWimaxEnabledBlocking(true, msg.arg1 == 1, msg.arg2);
                    break;
                }
                case 1: {
                    WimaxService.this.setWimaxEnabledBlocking(false, msg.arg1 == 1, msg.arg2);
                    WimaxService.this.release_sWakeLock();
                    break;
                }
                case 2: {
                    WimaxService.this.mWimaxStateTracker.disconnectAndStop();
                    break;
                }
                case 4: {
                    PowerManager.WakeLock wakeLock = sDriverStopWakeLock;
                    synchronized (wakeLock) {
                        if (sDriverStopWakeLock.isHeld()) {
                            if (WimaxService.this.m_bLog) {
                                Log.d((String)"WimaxService", (String)"release sDriverStopWakeLock----------------------");
                            }
                            sDriverStopWakeLock.release();
                        }
                        break;
                    }
                }
            }
        }
    }
}

