/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG.wimax;

import android.net.fourG.net4GInfo;
import android.net.fourG.net4GSupplicantState;
import android.net.fourG.wimax.Wimax4GBaseStationInfo;
import android.os.Parcel;
import android.os.Parcelable;

public class Wimax4GInfo
extends net4GInfo {
    private static final String TAG = "Wimax4GInfo";
    private int m_nNSPID = 0;
    private String m_strNAPID = "000000";
    private int m_nFrequency = 0;
    private String m_strConnectionTime = "00:00:00";
    private Wimax4GBaseStationInfo m_wm4GBaseStationInfo;
    public static final Parcelable.Creator<Wimax4GInfo> CREATOR = new Parcelable.Creator<Wimax4GInfo>(){

        public Wimax4GInfo createFromParcel(Parcel in) {
            Wimax4GInfo info = new Wimax4GInfo();
            info.setRssi(in.readInt());
            info.setCinr(in.readInt());
            info.setIpAddress(in.readInt());
            info.setLinkSpeed(in.readInt());
            info.setNetworkId(in.readInt());
            info.setTxPower(in.readInt());
            info.set4GState(in.readInt());
            info.setNSPID(in.readInt());
            info.setFREQ(in.readInt());
            info.m_strBSID = in.readString();
            info.m_strMacAddress = in.readString();
            mLinkStateDetail = net4GInfo.LINK_STATE_DETAIL.valueOf(in.readString());
            mLinkStateReason = net4GInfo.LINK_STATE_REASON.valueOf(in.readString());
            info.m_strNAPID = in.readString();
            info.m_strConnectionTime = in.readString();
            info.m_net4GSupplicantState = (net4GSupplicantState)((Object)net4GSupplicantState.CREATOR.createFromParcel(in));
            return info;
        }

        public Wimax4GInfo[] newArray(int size) {
            return new Wimax4GInfo[size];
        }
    };

    Wimax4GInfo() {
        this.m_net4GSupplicantState = net4GSupplicantState.UNINITIALIZED;
    }

    public void setNSPID(int NSPID) {
        this.m_nNSPID = NSPID;
    }

    public int getNSPID() {
        return this.m_nNSPID;
    }

    public void setBSID(String strBSID) {
        this.m_strBSID = strBSID;
        if (strBSID != null) {
            char[] cNAPID = new char[]{strBSID.charAt(0), strBSID.charAt(1), strBSID.charAt(3), strBSID.charAt(4), strBSID.charAt(6), strBSID.charAt(7)};
            this.m_strNAPID = new String(cNAPID);
        } else {
            this.m_strNAPID = null;
        }
    }

    public String getNAPID() {
        return this.m_strNAPID;
    }

    public void setFREQ(int FREQ) {
        this.m_nFrequency = FREQ;
    }

    public int getFREQ() {
        return this.m_nFrequency;
    }

    public void setConnectionTime(String ConnectionTime) {
        this.m_strConnectionTime = ConnectionTime;
    }

    public String getConnectionTime() {
        return this.m_strConnectionTime;
    }

    public net4GSupplicantState getSupplicantState() {
        return this.m_net4GSupplicantState;
    }

    public void setSupplicantState(net4GSupplicantState stateName) {
        this.m_net4GSupplicantState = stateName;
    }

    public Wimax4GBaseStationInfo get4GBaseStationInfoServing() {
        return this.m_wm4GBaseStationInfo;
    }

    public void set4GBaseStationInfo(Wimax4GBaseStationInfo info) {
        if (info == null) {
            return;
        }
        this.m_net4GBaseStationInfo = info;
        this.m_wm4GBaseStationInfo = info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Wimax4GInfo: ");
        String none = "<none>";
        sb.append(", BSID: ").append(this.m_strBSID == null ? none : this.m_strBSID).append(", RSSI: ").append(this.m_nRssi).append(", CINR: ").append(this.m_nCinr).append(", net4GSupplicant state: ").append(this.m_net4GSupplicantState == null ? none : this.m_net4GSupplicantState).append(", IP Address: ").append(this.m_nIpAddress).append(", Link speed: ").append(this.m_nLinkSpeed).append(", LINK_STATE_DETAIL: ").append(mLinkStateDetail == null ? none : mLinkStateDetail).append(", LINK_STATE_REASON: ").append(mLinkStateReason == null ? none : mLinkStateReason).append(", MAC: ").append(this.m_strMacAddress == null ? none : this.m_strMacAddress).append(", Net ID: ").append(this.m_nNetworkId).append(", Tx Power: ").append(this.m_nTxPower).append(", 4G State: ").append(this.m_n4GState).append(", NSP ID: ").append(this.m_nNSPID).append(", NAP ID: ").append(this.m_strNAPID).append(", Frequency: ").append(this.m_nFrequency).append(", Connection Time: ").append(this.m_strConnectionTime);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.m_nRssi);
        dest.writeInt(this.m_nCinr);
        dest.writeInt(this.m_nIpAddress);
        dest.writeInt(this.m_nLinkSpeed);
        dest.writeInt(this.m_nNetworkId);
        dest.writeInt(this.m_nTxPower);
        dest.writeInt(this.m_n4GState);
        dest.writeInt(this.m_nNSPID);
        dest.writeInt(this.m_nFrequency);
        dest.writeString(this.m_strBSID);
        dest.writeString(this.m_strMacAddress);
        if (mLinkStateDetail != null) {
            dest.writeString(mLinkStateDetail.name());
        } else {
            dest.writeString(net4GInfo.LINK_STATE_DETAIL.valueOf("LINK_ST_DETAIL_UNDEFINED").toString());
        }
        if (mLinkStateReason != null) {
            dest.writeString(mLinkStateReason.name());
        } else {
            dest.writeString(net4GInfo.LINK_STATE_REASON.valueOf("LINK_ST_REASON_FAILURE_UNKNOWN_CAUSE").toString());
        }
        dest.writeString(this.m_strNAPID);
        dest.writeString(this.m_strConnectionTime);
        this.m_net4GSupplicantState.writeToParcel(dest, flags);
    }
}

