/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG;

import android.net.NetworkInfo;
import android.net.fourG.net4GBaseStationInfo;
import android.net.fourG.net4GSupplicantState;
import android.net.fourG.wimax.DeviceStatusInfo;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;

public abstract class net4GInfo
implements Parcelable {
    private static final EnumMap<net4GSupplicantState, NetworkInfo.DetailedState> stateMap = new EnumMap(net4GSupplicantState.class);
    protected String m_strBSID = "00:00:00:00:00:00";
    protected int m_nRssi = -9999;
    protected int m_nCinr = -9999;
    protected net4GSupplicantState m_net4GSupplicantState = net4GSupplicantState.UNINITIALIZED;
    protected int m_nIpAddress = 0;
    public static final String LINK_SPEED_UNITS = "Mbps";
    protected int m_nLinkSpeed = -1;
    protected static LINK_STATE_DETAIL mLinkStateDetail;
    protected static LINK_STATE_REASON mLinkStateReason;
    protected String m_strMacAddress;
    protected int m_nNetworkId;
    protected int m_nTxPower;
    protected int m_n4GState;
    protected net4GBaseStationInfo m_net4GBaseStationInfo;
    public static final EnumMap<DeviceStatusInfo.ConnectionProgressInfo, LINK_STATE_DETAIL> linkStateMap;

    public net4GInfo() {
        mLinkStateDetail = LINK_STATE_DETAIL.LINK_ST_DETAIL_NOT_CONNECTED;
        mLinkStateReason = LINK_STATE_REASON.LINK_ST_REASON_FAILURE_UNKNOWN_CAUSE;
        this.m_strMacAddress = "00:00:00:00:00:00";
        this.m_nNetworkId = -1;
        this.m_nTxPower = -9999;
        this.m_n4GState = -1;
        this.m_net4GBaseStationInfo = null;
    }

    public void setBSID(String strBSID) {
        this.m_strBSID = strBSID;
    }

    public String getBSID() {
        return this.m_strBSID;
    }

    public void setCinr(int nCinr) {
        this.m_nCinr = nCinr;
    }

    public int getCinr() {
        return this.m_nCinr;
    }

    public int getRssi() {
        return this.m_nRssi;
    }

    public void setRssi(int rssi) {
        this.m_nRssi = rssi;
    }

    public int getLinkSpeed() {
        return this.m_nLinkSpeed;
    }

    public void setLinkSpeed(int linkSpeed) {
        this.m_nLinkSpeed = linkSpeed;
    }

    public void setMacAddress(String macAddress) {
        this.m_strMacAddress = macAddress;
    }

    public String getMacAddress() {
        return this.m_strMacAddress;
    }

    public void setNetworkId(int id) {
        this.m_nNetworkId = id;
    }

    public int getNetworkId() {
        return this.m_nNetworkId;
    }

    public abstract net4GSupplicantState getSupplicantState();

    public abstract void setSupplicantState(net4GSupplicantState var1);

    public void setIpAddress(int address) {
        this.m_nIpAddress = address;
    }

    public int getIpAddress() {
        return this.m_nIpAddress;
    }

    public InetAddress getInetAddress() {
        InetAddress inetAddress;
        byte[] addrBytes = new byte[4];
        int addr = this.m_nIpAddress;
        addrBytes[0] = (byte)(addr & 0xFF);
        addrBytes[1] = (byte)(addr >> 8 & 0xFF);
        addrBytes[2] = (byte)(addr >> 16 & 0xFF);
        addrBytes[3] = (byte)(addr >> 24 & 0xFF);
        try {
            inetAddress = InetAddress.getByAddress(addrBytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return inetAddress;
    }

    public void setTxPower(int nTxPower) {
        this.m_nTxPower = nTxPower;
    }

    public int getTxPower() {
        return this.m_nTxPower;
    }

    public abstract net4GBaseStationInfo get4GBaseStationInfoServing();

    public void set4GBaseStationInfo(net4GBaseStationInfo info) {
        this.m_net4GBaseStationInfo = info;
    }

    public void set4GState(int n4GState) {
        this.m_n4GState = n4GState;
    }

    public int get4GState() {
        return this.m_n4GState;
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(net4GSupplicantState suppState) {
        return stateMap.get((Object)suppState);
    }

    static net4GSupplicantState valueOf(String stateName) {
        try {
            return net4GSupplicantState.valueOf(stateName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return net4GSupplicantState.INVALID;
        }
    }

    public void setLinkStateDetailed(LINK_STATE_DETAIL linkStateDetail) {
        mLinkStateDetail = linkStateDetail;
    }

    public static LINK_STATE_DETAIL getLinkStateDetailed() {
        return mLinkStateDetail;
    }

    void setLinkStateReason(LINK_STATE_REASON linkStateReason) {
        mLinkStateReason = linkStateReason;
    }

    public static LINK_STATE_REASON getLinkStateReason() {
        return mLinkStateReason;
    }

    static {
        stateMap.put(net4GSupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(net4GSupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(net4GSupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(net4GSupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(net4GSupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTED);
        stateMap.put(net4GSupplicantState.HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(net4GSupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(net4GSupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(net4GSupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(net4GSupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        linkStateMap = new EnumMap(DeviceStatusInfo.ConnectionProgressInfo.class);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Ranging, LINK_STATE_DETAIL.LINK_ST_DETAIL_RANGING);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.SBC, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.PKM, LINK_STATE_DETAIL.LINK_ST_DETAIL_EAP_AUTHENTICATION);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Registration, LINK_STATE_DETAIL.LINK_ST_DETAIL_REGISTRATION);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.DSX, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Registered, LINK_STATE_DETAIL.LINK_ST_DETAIL_OPERATIONAL);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Idle, LINK_STATE_DETAIL.LINK_ST_DETAIL_IDLE);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.IP_Renew, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.De_registration, LINK_STATE_DETAIL.LINK_ST_DETAIL_DEREGISTRATION);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Syncup_PHY, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Syncup_MAC, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_Device, LINK_STATE_DETAIL.LINK_ST_DETAIL_EAP_AUTHENTICATION);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_User, LINK_STATE_DETAIL.LINK_ST_DETAIL_EAP_AUTHENTICATION);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Timeout_Sync, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Timeout_NE, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Timeout_NDREG, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.IP_USB, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.CONNECTED_USB, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.RESUME_USB, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.SUSPEND_USB, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Met_Exit_Criteria, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
        linkStateMap.put(DeviceStatusInfo.ConnectionProgressInfo.Abnormal_State, LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LINK_STATE_REASON {
        LINK_ST_REASON_FAILURE_NW_CONNECTION,
        LINK_ST_REASON_FAILURE_RANGING,
        LINK_ST_REASON_FAILURE_EAP_AUTHENTICATION,
        LINK_ST_REASON_FAILURE_3WAY_HANDSHAKE,
        LINK_ST_REASON_FAILURE_REGISTRATION,
        LINK_ST_REASON_FAILURE_DEREGISTRATION,
        LINK_ST_REASON_FAILURE_NO_COVERAGE_AVAILABLE,
        LINK_ST_REASON_FAILURE_ROAMING_NOT_ALLOWED,
        LINK_ST_REASON_FAILURE_PROVISIONING_DATA_ERROR,
        LINK_ST_REASON_FAILURE_RADIO_POLICY_VIOLATION,
        LINK_ST_REASON_FAILURE_RADIO_OFF,
        LINK_ST_REASON_FAILURE_SIGNAL_LOSS,
        LINK_ST_REASON_FAILURE_DISCONNECT_CALLED,
        LINK_ST_REASON_FAILURE_UNKNOWN_CAUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LINK_STATE_DETAIL {
        LINK_ST_DETAIL_DL_SYNC,
        LINK_ST_DETAIL_HANDOVER_SYNC,
        LINK_ST_DETAIL_UL_ACQUISITION,
        LINK_ST_DETAIL_RANGING,
        LINK_ST_DETAIL_HANDOVER_RANGING,
        LINK_ST_DETAIL_CAPABILITIES_NEGOTIATION,
        LINK_ST_DETAIL_EAP_AUTHENTICATION,
        LINK_ST_DETAIL_3WAY_HANDSHAKE,
        LINK_ST_DETAIL_REGISTRATION,
        LINK_ST_DETAIL_DHCP,
        LINK_ST_DETAIL_OPERATIONAL,
        LINK_ST_DETAIL_SLEEP,
        LINK_ST_DETAIL_IDLE,
        LINK_ST_DETAIL_DEREGISTRATION,
        LINK_ST_DETAIL_CONNECTION_FAILURE,
        LINK_ST_DETAIL_ABORTED,
        LINK_ST_DETAIL_NOT_CONNECTED,
        LINK_ST_DETAIL_UNDEFINED;

    }
}

