/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG.wimax;

import android.net.DhcpInfo;
import android.net.fourG.wimax.DeviceStatusInfo;
import android.net.fourG.wimax.MruList;
import android.net.fourG.wimax.Wimax4GBaseStationInfo;
import android.net.fourG.wimax.Wimax4GConfiguration;
import android.net.fourG.wimax.Wimax4GDeviceInfo;
import android.net.fourG.wimax.Wimax4GManager;
import android.os.Handler;
import android.util.Log;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WimaxNative {
    static final int EVENT_DEVICE_STATUS = 0;
    static final int EVENT_CARD_PRESENCE = 1;
    static final int EVENT_POWER_STATE = 2;
    static final int EVENT_AUTH_FAIL_MSG = 3;
    static final int EVENT_MRU_LIST_MSG = 4;
    static final int EVENT_MRU_UPDATE_MSG = 5;
    static final int EVENT_OMADM_RESPONSE = 6;
    static final int EVENT_RADIO_INFO_RESPONSE = 7;
    static final int EVENT_LINK_WEAK_INFO = 8;
    static final int EVENT_AUTH_UTC_TIME = 9;
    static final int EVENT_BS_INFO_RESPONSE = 10;
    private static boolean m_bLog;
    private static Handler mHandler;
    private static List<Wimax4GConfiguration> mAvailableList;
    public static List<MruList> mMruListRsp;
    public static byte[] mOdbReadRsp;
    public static Wimax4GManager.WimaxRadioInfoTemperature radioInfo;
    public static List<Wimax4GBaseStationInfo> wimaxBSList;
    public static DeviceStatusInfo dsInfo;

    private static native void classInitNative();

    public static native byte[] getErrorString();

    public static native boolean loadDriver(byte var0);

    public static native boolean startWimax();

    public static native boolean stopWimax();

    public static native void setBackhaulMode(boolean var0);

    public static native void setDMMode(boolean var0);

    public static native void setRctMode(boolean var0);

    public static native int connectmWimax(String var0, String var1, String var2, int var3, String var4);

    public static native boolean scanCommand();

    public static native boolean disconnectWimax();

    public static native String getMacAddressCommand();

    public static native boolean doDhcpRequest(DhcpInfo var0);

    public static native boolean setWimaxTethered(byte var0);

    public static native String getLinkInfo();

    public static native boolean getLinkState();

    public static native String getConnectionTime();

    public static native void setEnableLog(boolean var0);

    public static native boolean IdleReq();

    public static native boolean VirtualIdleReq(int var0, byte var1);

    public static native boolean IpObtained();

    public static native int[] getNetworkEntryCompleteTimes();

    public static native boolean OdbDefaultReq();

    public static native int OdbReadReq(byte[] var0);

    public static native int OdbWriteReq(byte[] var0);

    public static native int OdbUpdateReq();

    public static native int OdbAddReq(byte[] var0);

    public static native int OdbDeleteReq(byte[] var0);

    public static native boolean setVirtualIdleWhileAPsleep(byte var0);

    public static native void setDeviceStateToVirtualIdle();

    public static native void setDeviceStateToInitComplete();

    public static native void setLinkInfo(boolean var0);

    public static void enableLog(boolean flag) {
        m_bLog = flag;
        WimaxNative.setEnableLog(flag);
    }

    public static void SetHandler(Handler handler) {
        mHandler = handler;
    }

    private static synchronized void NotifyDeviceStatusChange(int deviceStatus, int statusReason, int connectionProgressInfo) {
        if (dsInfo != null) {
            dsInfo.setDeviceStatus(deviceStatus, statusReason, connectionProgressInfo);
            mHandler.obtainMessage(0, (Object)dsInfo).sendToTarget();
        }
    }

    private static synchronized void NotifyDeviceInsertRemove(boolean cardPresence) {
        mHandler.obtainMessage(1, (Object)(cardPresence ? 1 : 0)).sendToTarget();
    }

    private static synchronized void NotifyPowerManagement(int powerState) {
        mHandler.obtainMessage(2, powerState, -1, (Object)0).sendToTarget();
    }

    private static synchronized void NotifyMruListMsg(int nSize, String strMruList) {
        if (nSize == 0) {
            mHandler.obtainMessage(4, 0, -1, mMruListRsp).sendToTarget();
            return;
        }
        if (m_bLog) {
            Log.d((String)"WimaxNative:", (String)("NotifyMruListMsg strMruList = " + strMruList));
        }
        StringTokenizer st = new StringTokenizer(strMruList, "@");
        int nCF = 0;
        byte BW = 0;
        byte FFTSize = 0;
        for (int i = 0; i < nSize; ++i) {
            StringTokenizer stList;
            if (!st.hasMoreTokens()) continue;
            String temp = st.nextToken();
            if (temp != null && (stList = new StringTokenizer(temp, "#")).hasMoreTokens()) {
                nCF = Integer.parseInt(stList.nextToken());
                if (m_bLog) {
                    Log.d((String)"WimaxNative :", (String)("NotifyMruListMsg nCF = " + nCF));
                }
                if (stList.hasMoreTokens()) {
                    BW = Byte.parseByte(stList.nextToken());
                    if (m_bLog) {
                        Log.d((String)"WimaxNative :", (String)("NotifyMruListMsg BW = " + BW));
                    }
                    if (stList.hasMoreTokens()) {
                        FFTSize = Byte.parseByte(stList.nextToken());
                        if (m_bLog) {
                            Log.d((String)"WimaxNative :", (String)("NotifyMruListMsg FFTSize = " + FFTSize));
                        }
                    }
                }
            }
            MruList mruList = new MruList();
            mruList.setValue(nCF, BW, FFTSize);
            mMruListRsp.add(mruList);
        }
        if (m_bLog) {
            Log.d((String)"WimaxNative Ends:", (String)"NotifyMruListMsg  = ");
        }
        mHandler.obtainMessage(4, 0, -1, mMruListRsp).sendToTarget();
    }

    private static synchronized void NotifyWimaxBaseStationInfoRsp(int nSize, String strWimaxBSList) {
        if (nSize == 0) {
            mHandler.obtainMessage(10, 0, -1, wimaxBSList).sendToTarget();
            if (m_bLog) {
                Log.d((String)"WimaxNative:CSAHOO", (String)("NotifyWimaxBaseStationInfoRsp nSize = " + nSize));
            }
            return;
        }
        wimaxBSList.clear();
        int m_Frequency = 0;
        int m_FFTSize = 0;
        int m_BandWidth = 0;
        int m_CINR = 0;
        int m_RSSI = 0;
        int m_Preamble = 0;
        String m_NapId = "";
        String sBsid = null;
        StringTokenizer st = new StringTokenizer(strWimaxBSList, "@");
        for (int i = 0; i < nSize; ++i) {
            StringTokenizer stList;
            if (m_bLog) {
                Log.d((String)"WimaxNative", (String)(" i = " + i));
            }
            if (!st.hasMoreTokens()) continue;
            String temp = st.nextToken();
            if (temp != null && (stList = new StringTokenizer(temp, "#")).hasMoreTokens()) {
                m_Frequency = Integer.parseInt(stList.nextToken());
                if (m_bLog) {
                    Log.d((String)"WimaxNative", (String)(" m_Frequency = " + m_Frequency));
                }
                if (stList.hasMoreTokens()) {
                    m_FFTSize = Integer.parseInt(stList.nextToken());
                    if (m_bLog) {
                        Log.d((String)"WimaxNative", (String)(" m_FFTSize = " + m_FFTSize));
                    }
                    if (stList.hasMoreTokens()) {
                        m_BandWidth = Integer.parseInt(stList.nextToken());
                        if (m_bLog) {
                            Log.d((String)"WimaxNative", (String)(" m_BandWidth = " + m_BandWidth));
                        }
                        if (stList.hasMoreTokens()) {
                            m_CINR = Integer.parseInt(stList.nextToken());
                            if (m_bLog) {
                                Log.d((String)"WimaxNative", (String)(" m_CINR = " + m_CINR));
                            }
                            if (stList.hasMoreTokens()) {
                                m_RSSI = Integer.parseInt(stList.nextToken());
                                if (m_bLog) {
                                    Log.d((String)"WimaxNative", (String)(" m_RSSI = " + m_RSSI));
                                }
                                if (stList.hasMoreTokens()) {
                                    m_Preamble = Integer.parseInt(stList.nextToken());
                                    if (m_bLog) {
                                        Log.d((String)"WimaxNative", (String)(" m_Preamble = " + m_Preamble));
                                    }
                                    if (stList.hasMoreTokens()) {
                                        m_NapId = stList.nextToken();
                                        if (m_bLog) {
                                            Log.d((String)"WimaxNative", (String)(" m_NapId = " + m_NapId));
                                        }
                                        if (stList.hasMoreTokens()) {
                                            sBsid = stList.nextToken();
                                            if (m_bLog) {
                                                Log.d((String)"WimaxNative", (String)(" sBsid = " + sBsid));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Wimax4GBaseStationInfo wimaxBSInfo = new Wimax4GBaseStationInfo();
            wimaxBSInfo.setValue(m_CINR, 0, "", m_RSSI, false, sBsid, m_NapId, m_Preamble, 0, "", m_Frequency, m_Frequency, 0);
            if (m_bLog) {
                Log.d((String)"WimaxNative", (String)(" m_Frequency: " + m_Frequency + " m_FFTSize: " + m_FFTSize + " m_BandWidth: " + m_BandWidth + " m_CINR: " + m_CINR + " m_RSSI: " + m_RSSI + " m_Preamble: " + m_Preamble + " m_NapId: " + m_NapId + " sBsid: " + sBsid));
            }
            wimaxBSList.add(wimaxBSInfo);
        }
        mHandler.obtainMessage(10, 0, -1, wimaxBSList).sendToTarget();
    }

    private static synchronized void NotifyMruUpdateMsg(int subType, int ErrorValue) {
        mHandler.obtainMessage(5, subType, ErrorValue, (Object)0).sendToTarget();
    }

    private static synchronized void NotifyAuthFailMsg(int errorCode, String errorMsg) {
        mHandler.obtainMessage(3, errorCode, -1, (Object)errorMsg).sendToTarget();
    }

    private static synchronized void NotifyOdbMngResponse(byte[] respDataArray, int nLen, int odbMngState) {
        if (m_bLog) {
            Log.d((String)"WimaxNative NotifyOdbMngResponse", (String)(" nLen: " + nLen + " odbMngState: " + odbMngState));
        }
        if (nLen == 0) {
            byte[] bDataArray = new byte[]{1};
            ByteBuffer respData = ByteBuffer.allocate(bDataArray.length);
            respData.put(bDataArray, 0, bDataArray.length);
            mHandler.obtainMessage(6, 1, odbMngState, (Object)respData).sendToTarget();
        } else if (nLen == -1) {
            byte[] bDataArray = new byte[]{2};
            ByteBuffer respData = ByteBuffer.allocate(bDataArray.length);
            respData.put(bDataArray, 0, bDataArray.length);
            mHandler.obtainMessage(6, 0, -1, (Object)respData).sendToTarget();
        } else if (respDataArray.length > 0) {
            byte[] bDataArray = new byte[]{1};
            ByteBuffer respData = ByteBuffer.allocate(respDataArray.length + bDataArray.length);
            respData.put(bDataArray, 0, bDataArray.length);
            respData.put(respDataArray, 0, respDataArray.length);
            mHandler.obtainMessage(6, 1, odbMngState, (Object)respData).sendToTarget();
        }
    }

    private static synchronized void NotifyRadioInfoResponse(String strRadioInfoList) {
        int nTemperature = 0;
        int nbIdleMode = 0;
        int nSleepMode = 0;
        int nIdleModeTimer = 0;
        int nPseudoId = 0;
        StringTokenizer st = new StringTokenizer(strRadioInfoList, "@");
        if (st.hasMoreTokens()) {
            StringTokenizer stList;
            String temp = st.nextToken();
            if (temp != null && (stList = new StringTokenizer(temp, "#")).hasMoreTokens()) {
                nTemperature = Integer.parseInt(stList.nextToken());
                if (stList.hasMoreTokens()) {
                    nbIdleMode = Integer.parseInt(stList.nextToken());
                    if (stList.hasMoreTokens()) {
                        nSleepMode = Integer.parseInt(stList.nextToken());
                        if (stList.hasMoreTokens()) {
                            nIdleModeTimer = Integer.parseInt(stList.nextToken());
                            nPseudoId = Integer.parseInt(stList.nextToken());
                        }
                    }
                }
            }
            radioInfo.setValue(nTemperature, nbIdleMode, nSleepMode, nIdleModeTimer, nPseudoId);
            mHandler.obtainMessage(7).sendToTarget();
        }
    }

    private static synchronized void NotifyLinkWeakInformation(int subType) {
        mHandler.obtainMessage(8, subType, -1, (Object)0).sendToTarget();
    }

    public static native boolean getAvailableNetworks(Wimax4GConfiguration var0);

    public static native int getConnectedNSP(Wimax4GBaseStationInfo var0);

    public static native boolean getDeviceInformation(Wimax4GDeviceInfo var0);

    public static void setAvailableList(List<Wimax4GConfiguration> list) {
        mAvailableList = list;
    }

    public static native boolean getMruList();

    public static native boolean getMruUpdate(int[] var0, byte[] var1, byte[] var2, int var3);

    public static native boolean getNeighborList();

    public static native boolean getRadioInfo();

    public static native int[] getOdbConfigData();

    public static native boolean setRoamingEnabled(boolean var0);

    public static native boolean isRoamingEnabled();

    private static synchronized void AddAvailableList(Wimax4GConfiguration Config) {
        Wimax4GConfiguration tmp = new Wimax4GConfiguration();
        tmp.setValue(Config.getNspId(), Config.getNspName(), Config.getUsername(), Config.getPassword());
        mAvailableList.add(tmp);
    }

    private static synchronized void getUTCTime() {
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
        String strUTCtime = formatter.format(now);
        if (m_bLog) {
            Log.d((String)"UTCTIME", (String)("time : " + strUTCtime));
        }
        mHandler.sendEmptyMessageDelayed(9, 10L);
    }

    public static native void SendUTCTime(String var0);

    public static native void setEnableLogLevel(char var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroyNative();
        }
        finally {
            super.finalize();
        }
    }

    private native void destroyNative();

    static {
        mMruListRsp = new ArrayList<MruList>();
        radioInfo = new Wimax4GManager.WimaxRadioInfoTemperature();
        wimaxBSList = new ArrayList<Wimax4GBaseStationInfo>();
        dsInfo = new DeviceStatusInfo();
        System.loadLibrary("SECmWiMAXcAPI");
        WimaxNative.classInitNative();
    }
}

