/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG.wimax;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.DhcpInfoInternal;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.fourG.net4GInfo;
import android.net.fourG.net4GSupplicantState;
import android.net.fourG.wimax.DeviceStatusInfo;
import android.net.fourG.wimax.Wimax4GBaseStationInfo;
import android.net.fourG.wimax.Wimax4GDeviceInfo;
import android.net.fourG.wimax.Wimax4GInfo;
import android.net.fourG.wimax.Wimax4GManager;
import android.net.fourG.wimax.WimaxMonitor;
import android.net.fourG.wimax.WimaxNative;
import android.net.fourG.wimax.WimaxState;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WimaxStateTracker
extends Handler
implements NetworkStateTracker {
    private NetworkInfo mNetworkInfo;
    private NetworkInfo.State mLastState = NetworkInfo.State.UNKNOWN;
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private boolean m_bLog = false;
    private Context mContext;
    private int m_nAutoConnectEnabled = 1;
    private static final String TAG = "WimaxStateTracker";
    private static final int EVENT_WIMAX_STATE_CHANGED = 1;
    private static final int EVENT_INTERFACE_CONFIGURATION_SUCCEEDED = 2;
    private static final int EVENT_INTERFACE_CONFIGURATION_FAILED = 3;
    private static final int EVENT_POLL_INTERVAL = 4;
    private static final int EVENT_DHCP_START = 5;
    private static final int EVENT_AFTER_VI_REQ_NEED_DELAY = 6;
    private static final int EVENT_SCAN_DELAY = 7;
    private static final int EVENT_VI_REQ = 8;
    private static final int EVENT_DRIVER_STATE_CHANGED = 9;
    private static final int EVENT_IP_RENEW = 10;
    private static final int EVENT_AUTH_FAIL = 11;
    private static final int EVENT_OMADM_RESP_DATA = 12;
    private static final int EVENT_RADIO_INFO_RESP_DATA = 13;
    private static final int EVENT_LINK_WEAK_INFO = 14;
    private static final int EVENT_MOCALL_INFO = 15;
    private static final int EVENT_MOCALL_FAIL = 16;
    private static final int m_nwaitLU = 5;
    private static final int POLL_STATUS_INTERVAL_MSECS = 2000;
    private static final int DEFAULT_MAX_DHCP_RETRIES = 2;
    private WimaxState mWimaxState = WimaxState.UNKNOWN;
    private WimaxState mWimaxStateOld = WimaxState.UNKNOWN;
    private DeviceStatusInfo.ConnectionProgressInfo mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
    private DeviceStatusInfo.ConnectionProgressInfo mWimaxStateDetailOld = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
    private WimaxMonitor mWimaxMonitor;
    private Wimax4GInfo mWimax4GInfo;
    private Wimax4GManager mWM;
    private boolean mHaveIpAddress;
    private boolean mObtainingIpAddress;
    private boolean mUseStaticIp = false;
    private boolean mTornDownByConnMgr;
    private boolean m_bUserDisconnect = false;
    private DhcpHandler mDhcpTarget;
    private DhcpInfoInternal mDhcpInfoInt;
    private long mDhcpStart = 0L;
    private long mDhcpEnd = 0L;
    private int mDiffDhcpTime = 0;
    private int mnOldIP = 0;
    private int mWimaxTemperature = 0;
    private int mWimaxLinkState = 0;
    private int nOldSignalLevel = -1;
    private boolean isHaveLinkInfo = false;
    private boolean isIdleState = false;
    private Handler mCsHandler;
    public int nRetryFlag = 0;
    public int nScanAttempt = 0;
    private int WIMAX_SCAN_ATTEMPT_TIMEOUT = 2;
    private int WIMAX_SCAN_RETRY_SECONDS = 120;
    private int WIMAX_ENTRY_DELAY = 300;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_STOPPING = 3;
    private static final int RUN_STATE_STOPPED = 4;
    private static final String[] mRunStateNames = new String[]{"Starting", "Running", "Stopping", "Stopped"};
    private int mRunState;
    private final IBatteryStats mBatteryStats;
    private String mInterfaceName;
    private static String LS = System.getProperty("line.separator");
    private Runnable mReleaseWakeLockCallback;
    private static PowerManager.WakeLock sWakeLock = null;
    private AlarmManager mAlarmManager;
    private PendingIntent mDhcpRenewIntent;
    private static final int WIMAX_DHCP_RENEW_INTERVAL = 0;
    public static final String ACTION_WIMAX_DHCP_RENEW = "com.android.server.Wimax4GManager.action.WIMAX_DHCP_RENEW";
    private static String[] sDnsPropNames;
    public boolean mIsTetheredmode = false;
    public boolean mTetheredModeUsbPlugged = false;
    private static final String USB_PATH = "/sys/class/sec/switch/usb_sel";
    private static final byte[] PDA;
    private static final byte[] WiMAX;
    private static int nOdbReqCount;
    public boolean m_bMruWorking = false;
    public boolean mModemReset = false;
    private boolean m_bScreenOff = false;
    private boolean m_isBootCompleted = false;
    private boolean m_bNoBackOff = false;
    private boolean m_bExitCriteria = false;
    private boolean m_bEntryDelaySet = false;
    public boolean m_bSkipEntryDelayOnce = false;
    public boolean m_bSkipEntryMet = false;
    public boolean m_bPoweroff = false;
    private Notification mNotification;
    private NotificationManager mWimaxNotifyManager;
    private PendingIntent mWimaxSettingIntent;
    private static int ICON_WIMAX_CONNECTED;
    private static int ICON_WIMAX_DISCONNECTED;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private static final String NETWORKTYPE = "WIMAX";
    private INetworkManagementService nwService;

    public WimaxStateTracker(Context context, Handler target) {
        this.mContext = context;
        this.mWimax4GInfo = new Wimax4GInfo();
        this.mWimaxMonitor = new WimaxMonitor(this);
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mNetworkInfo = new NetworkInfo(6, 0, NETWORKTYPE, "");
        TelephonyManager tm = TelephonyManager.getDefault();
        this.setTornDownByConnMgr(false);
        this.mDhcpInfoInt = new DhcpInfoInternal();
        this.mRunState = 1;
        this.mInterfaceName = SystemProperties.get((String)"wimax.interface", (String)"uwbr0");
        sDnsPropNames = new String[]{"dhcp." + this.mInterfaceName + ".dns1", "dhcp." + this.mInterfaceName + ".dns2"};
        this.mBatteryStats = IBatteryStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"batteryinfo"));
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent DhcpRenewIntent = new Intent(ACTION_WIMAX_DHCP_RENEW, null);
        this.mDhcpRenewIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)DhcpRenewIntent, (int)0);
        IBinder b = ServiceManager.getService((String)"network_management");
        this.nwService = INetworkManagementService.Stub.asInterface((IBinder)b);
        this.mWimaxNotifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotification = new Notification(ICON_WIMAX_DISCONNECTED, null, 0L);
        this.mWimaxSettingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent("android.settings.WIMAX_SETTINGS"), (int)0);
        ICON_WIMAX_CONNECTED = this.mContext.getResources().getIdentifier("stat_sys_data_wimax_signal_3_fully", "drawable", this.mContext.getPackageName());
        ICON_WIMAX_DISCONNECTED = this.mContext.getResources().getIdentifier("stat_sys_data_wimax_signal_disconnected", "drawable", this.mContext.getPackageName());
    }

    public void setPolicyDataEnable(boolean enabled) {
        if (this.m_bLog) {
            Log.e((String)TAG, (String)("ignoring setPolicyDataEnable(" + enabled + ")"));
        }
    }

    public void setUserDataEnable(boolean enabled) {
        if (this.m_bLog) {
            Log.e((String)TAG, (String)("ignoring setUserDataEnable(" + enabled + ")"));
        }
    }

    private void updateWimaxNotiMsg() {
        if (this.m_bLog) {
            Log.e((String)TAG, (String)("getValue() within updateWimaxNotiMsg() :" + this.getValue()));
        }
        if (this.getValue()) {
            switch (this.mWimaxState) {
                case CONNECTED: {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)("4G Network Connected :" + this.getValue()));
                    }
                    this.setNotificationVisible(this.mContext, ICON_WIMAX_CONNECTED, null, "4G network connected");
                    break;
                }
                case DISCONNECTED: {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)("4G Network Disconnected :" + this.getValue()));
                    }
                    this.setNotificationVisible(this.mContext, ICON_WIMAX_DISCONNECTED, null, "4G network disconnected");
                }
            }
        }
    }

    public void setNotificationVisible(Context context, int iconID, CharSequence bodyMessage, CharSequence tickerMessage) {
        if (this.m_bLog) {
            Log.e((String)TAG, (String)("getValue() within setNotificationVisible :" + this.getValue()));
        }
        if (this.getValue()) {
            this.mNotification.icon = iconID;
            if (tickerMessage != null) {
                this.mNotification.tickerText = tickerMessage;
            }
            this.mNotification.setLatestEventInfo(context, null, bodyMessage, this.mWimaxSettingIntent);
            this.mWimaxNotifyManager.notify(iconID, this.mNotification);
            this.mWimaxNotifyManager.cancel(iconID);
        }
    }

    private boolean getValue() {
        if (this.m_bLog) {
            Log.e((String)TAG, (String)("getValue() called : " + Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wimax_networks_available_notification_on", (int)0)));
        }
        return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wimax_networks_available_notification_on", (int)0) == 1;
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"mTeardownRequested.set(isRequested)");
        }
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public void setDataEnable(boolean enabled) {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("setDataEnabled: IGNORING enabled=" + enabled));
        }
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    private void setTornDownByConnMgr(boolean flag) {
        this.mTeardownRequested.set(flag);
        this.mTornDownByConnMgr = flag;
        this.updateNetworkInfo();
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wimax";
    }

    public void startMonitoring() {
        this.mWM = Wimax4GManager.getInstance();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mCsHandler = target;
        this.mWM = Wimax4GManager.getInstance();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.fourG.wimax.NETWORK_STATE_CHANGED");
        WimaxStateReceiver mWimaxStateReceiver = new WimaxStateReceiver();
        this.mContext.registerReceiver((BroadcastReceiver)mWimaxStateReceiver, filter);
    }

    public void startEventLoop() {
        this.mWimaxMonitor.startMonitoring();
    }

    public synchronized boolean isAvailable() {
        boolean bRet;
        boolean bl = bRet = this.getCurrentWimaxState() != WimaxState.UNKNOWN && this.getCurrentWimaxState() != WimaxState.INITIALIZING || this.mTornDownByConnMgr || !this.isDriverStopped();
        if (this.m_bLog) {
            Log.i((String)TAG, (String)("isTeardownRequested() " + this.isTeardownRequested()));
        }
        if (this.m_bLog) {
            Log.i((String)TAG, (String)("isDriverStopped " + this.isDriverStopped()));
        }
        if (this.m_bLog) {
            Log.i((String)TAG, (String)("(isTeardownRequested() || !isDriverStopped()  " + (this.isTeardownRequested() || !this.isDriverStopped())));
        }
        if (this.m_bLog) {
            Log.i((String)TAG, (String)("isAvailable() !!!!!!!!!!!!!!!!!!!!!!!! return " + bRet));
        }
        return bRet;
    }

    public int getNetworkSubtype() {
        return 0;
    }

    private void updateNetworkInfo() {
        this.mNetworkInfo.setIsAvailable(this.isAvailable());
    }

    public boolean isConnectionCompleted() {
        if (this.m_bLog) {
            Log.v((String)TAG, (String)"isConnectionCompleted() !!!!!!!!!!!!!!!!!!!!!!!!");
        }
        return this.getCurrentWimaxState() == WimaxState.CONNECTED;
    }

    public boolean hasIpAddress() {
        return this.mHaveIpAddress;
    }

    public void notifyStateChange(WimaxState newWimaxState, DeviceStatusInfo.ConnectionProgressInfo newInfo) {
        Message msg = Message.obtain((Handler)this, (int)1, (Object)new WimaxStateChangeResult(newWimaxState, newInfo));
        msg.sendToTarget();
    }

    public void notifyIpRenew() {
        if (!this.mUseStaticIp && this.mHaveIpAddress && this.getCurrentWimaxState() == WimaxState.CONNECTED) {
            this.mObtainingIpAddress = true;
            this.mDhcpTarget.sendEmptyMessage(10);
        }
    }

    void notifyAuthFail(int nErrorCode, String strError) {
        Message msg = Message.obtain((Handler)this, (int)11, (Object)new WimaxAuthFail(nErrorCode, strError));
        msg.sendToTarget();
    }

    public void notifyDriverStopped() {
        this.mRunState = 4;
        Message.obtain((Handler)this, (int)9, (int)0, (int)0).sendToTarget();
    }

    void notifyDriverStarted() {
        Message.obtain((Handler)this, (int)9, (int)1, (int)0).sendToTarget();
    }

    public void notifyOMADMResponse(ByteBuffer bDataArray, int nDataLen, int odbMngState) {
        Message.obtain((Handler)this, (int)12, (int)nDataLen, (int)odbMngState, (Object)bDataArray).sendToTarget();
    }

    public void notifyRadioInfoResponse() {
        Message.obtain((Handler)this, (int)13).sendToTarget();
    }

    public void notifyLinkWeakInformation() {
        Message.obtain((Handler)this, (int)14).sendToTarget();
    }

    public void notifyMoCallInformation() {
        Message.obtain((Handler)this, (int)15).sendToTarget();
    }

    private synchronized void setPollTimer() {
        if (this.m_bScreenOff) {
            return;
        }
        if (!this.hasMessages(4)) {
            this.sendEmptyMessageDelayed(4, 2000L);
        }
    }

    private synchronized boolean isDriverStopped() {
        return this.mRunState == 4 || this.mRunState == 3;
    }

    private void noteRunState() {
    }

    public void releaseWakeLock() {
        if (this.mReleaseWakeLockCallback != null) {
            this.mReleaseWakeLockCallback.run();
        }
    }

    public void setWakeLock(PowerManager.WakeLock wl) {
        sWakeLock = wl;
    }

    public void acquire_WakeLock() {
        block7: {
            try {
                if (sWakeLock == null) {
                    return;
                }
                if (sWakeLock.isHeld()) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"------WakeLock already acquired----------------");
                    }
                } else {
                    if (this.m_bLog) {
                        Log.i((String)TAG, (String)"------WakeLock will be acquired----------------");
                    }
                    sWakeLock.acquire();
                }
            }
            catch (NullPointerException e) {
                if (!this.m_bLog) break block7;
                Log.e((String)TAG, (String)"------WakeLock NullPointerException----------------");
            }
        }
    }

    public void setReleaseWakeLockCallback(Runnable callback) {
        this.mReleaseWakeLockCallback = callback;
    }

    public void setUsbUnPlugged() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"setUsbUnPlugged");
        }
        WimaxNative.setDeviceStateToVirtualIdle();
        Intent intent = new Intent("android.net.fourG.wimax.WIMAX_NETWORK_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("4g_state", WimaxState.DISCONNECTED.ordinal());
        this.mContext.sendStickyBroadcast(intent);
        if (this.hasMessages(8)) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"[setUsbUnPlugged] removeMessage(EVENT_VI_REQ)");
            }
            this.removeMessages(8);
        }
        this.sendEmptyMessageDelayed(8, 3000L);
    }

    /*
     * Unable to fully structure code
     */
    public void handleWimaxStateChanged(WimaxStateChangeResult newWimaxState) {
        switch (1.$SwitchMap$android$net$fourG$wimax$WimaxState[newWimaxState.state.ordinal()]) {
            case 3: {
                this.sendWimaxStateChangeBroadcast();
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.INVALID);
                break;
            }
            case 4: {
                if (this.mIsTetheredmode) {
                    this.sendModeChangeBroadcast(1);
                } else {
                    this.sendModeChangeBroadcast(0);
                }
                this.m_bUserDisconnect = false;
                this.mWM.setWimax4GState(3);
                this.sendWimaxStateChangeBroadcast();
                nMode = this.mWM.getWimaxMode();
                if (nMode == 4 || nMode == 2 || nMode == 1) {
                    WimaxNative.setBackhaulMode(true);
                }
                if (nMode == 4 || nMode == 3) {
                    WimaxNative.setDMMode(true);
                } else {
                    WimaxNative.setDMMode(false);
                }
                this.mRunState = 2;
                this.m_bUserDisconnect = false;
                this.mTornDownByConnMgr = false;
                this.mTeardownRequested.set(false);
                this.nRetryFlag = 0;
                this.nScanAttempt = 0;
                break;
            }
            case 5: {
                this.sendWimaxStateChangeBroadcast();
                if (this.mWimaxStateOld == WimaxState.UNKNOWN || this.mWimaxStateOld == WimaxState.INITIALIZING) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)("[handleMessageWimaxStateChanged] modified nRetryFlag = 0, nScanAttempt = 0, bUserReq = true m_bSkipEntryDelayOnce = " + this.m_bSkipEntryDelayOnce));
                    }
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                }
                this.m_bUserDisconnect = false;
                nOdbCfgData = WimaxNative.getOdbConfigData();
                if (nOdbCfgData != null) {
                    this.WIMAX_SCAN_RETRY_SECONDS = nOdbCfgData[1];
                    this.WIMAX_SCAN_ATTEMPT_TIMEOUT = nOdbCfgData[2];
                    this.WIMAX_ENTRY_DELAY = nOdbCfgData[5];
                }
                this.noteRunState();
                devInfo = this.mWM.getDeviceInformation();
                macAddress = devInfo.getMacAddress();
                SystemProperties.set((String)"net.wimax.mac.address", (String)macAddress);
                if (this.m_bLog) {
                    Log.v((String)"WimaxStateTracker", (String)("macAddress : " + macAddress));
                }
                this.checkUseStaticIp();
                dhcpThread = new HandlerThread("DHCP Handler Thread");
                dhcpThread.start();
                this.mDhcpTarget = new DhcpHandler(dhcpThread.getLooper(), this);
                this.mTornDownByConnMgr = false;
                this.mTeardownRequested.set(false);
                l = this.mWM.createMulticastLock("WimaxStateTracker");
                l.acquire();
                l.release();
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = WimaxState.SCANNING;
                this.mWimaxStateDetail = null;
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SCANNING, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.SCANNING);
                if (!this.m_bNoBackOff && !this.isWifiConnected()) {
                    this.mWM.startScan();
                    break;
                }
                this.acquire_WakeLock();
                WimaxNative.VirtualIdleReq(-1, (byte)1);
                if (this.hasMessages(6)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                    }
                    this.removeMessages(6);
                }
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
            case 6: {
                this.sendWimaxStateChangeBroadcast();
                this.isIdleState = false;
                this.isHaveLinkInfo = false;
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SCANNING, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.SCANNING);
                break;
            }
            case 7: {
                if (this.m_bLog) {
                    Log.e((String)"WimaxStateTracker", (String)("[handleWimaxStateChanged : READY] WIMAX SCAN ATTEMPT TIMEOUT : " + this.nScanAttempt));
                }
                if (this.nScanAttempt == this.WIMAX_SCAN_ATTEMPT_TIMEOUT && this.m_bExitCriteria) {
                    if (this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"[handleWimaxStateChanged : READY] Reset m_bExitCriteria ");
                    }
                    this.m_bExitCriteria = false;
                }
                nMode = this.mWM.getWimaxMode();
                if (this.m_bLog) {
                    Log.i((String)"WimaxStateTracker", (String)("[handleMessageWimaxStateChanged] >>>> READY : WimaxMode = " + nMode + " m_bSkipEntryDelayOnce = " + this.m_bSkipEntryDelayOnce + " <<<<"));
                }
                if (nMode == 1) ** GOTO lbl-1000
                if (nMode == 2) ** GOTO lbl-1000
                if (nMode == 4) lbl-1000:
                // 3 sources

                {
                    v0 = true;
                } else {
                    v0 = bTethering = false;
                }
                if (this.m_bLog) {
                    Log.i((String)"WimaxStateTracker", (String)("[READY] >>>> m_bExitCriteria ***********<<<<  " + this.m_bExitCriteria + "[READY] >>>> m_bEntryDelaySet ***********<<<<  " + this.m_bEntryDelaySet));
                }
                if (this.m_bExitCriteria && !bTethering && !this.m_bSkipEntryDelayOnce) {
                    if (this.m_bLog) {
                        Log.i((String)"WimaxStateTracker", (String)"[RetryProcess] >>>> m_bExitCriteria <<<<");
                    }
                    WimaxNative.VirtualIdleReq(this.WIMAX_ENTRY_DELAY, (byte)1);
                    if (this.hasMessages(6)) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                        }
                        this.removeMessages(6);
                    }
                    this.sendEmptyMessageDelayed(6, 3000L);
                    this.m_bExitCriteria = false;
                    this.m_bEntryDelaySet = true;
                    if (this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"[handleWimaxStateChanged : READY] m_bExitCriteria ON.");
                    }
                    this.mWimaxStateOld = this.mWimaxState;
                    this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                    this.mWimaxState = WimaxState.DISCONNECTED;
                    this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Not_Met_Entry_Criteria;
                    this.sendWimaxStateChangeBroadcast();
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.DISCONNECTED);
                    break;
                }
                if (this.nScanAttempt == this.WIMAX_SCAN_ATTEMPT_TIMEOUT) {
                    if (this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"[handleWimaxStateChanged : READY] WIMAX SCAN ATTEMPT TIMEOUT");
                    }
                    this.m_bSkipEntryDelayOnce = false;
                }
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.IDLE, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.INACTIVE);
                this.mHaveIpAddress = false;
                this.mObtainingIpAddress = false;
                this.checkUseStaticIp();
                this.requestPolledInfo(this.mWimax4GInfo);
                this.setPollTimer();
                if (this.m_bUserDisconnect) {
                    if (!this.m_bLog) break;
                    Log.d((String)"WimaxStateTracker", (String)"[handleWimaxStateChanged : READY] USER Disconnect!!!!!!!!!!!!!!!!!!!!!!!!!");
                    break;
                }
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTING, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATING);
                if (this.mWM.connect("", "", "", "") == 0) break;
                if (this.m_bLog) {
                    Log.e((String)"WimaxStateTracker", (String)"[handleWimaxStateChanged : READY] connect() returns fail.");
                }
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = WimaxState.DISCONNECTED;
                this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Timeout_NE;
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.DISCONNECTED);
                break;
            }
            case 8: {
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTING, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATING);
                break;
            }
            case 9: {
                this.configureInterface();
                this.mDhcpStart = new Date().getTime();
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[handleMessage : DhcpStart is " + this.mDhcpStart + "ms"));
                }
                this.sendWimaxStateChangeBroadcast();
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR, null, null);
                this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATED);
                break;
            }
            case 1: {
                this.nRetryFlag = 0;
                this.nScanAttempt = 0;
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("mHaveIpAddress :" + this.mHaveIpAddress));
                }
                if (this.isIdleState) {
                    if (this.hasMessages(16)) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"[handleMessageWimaxStateChanged] removeMessage(EVENT_MOCALL_FAIL)");
                        }
                        this.removeMessages(16);
                    }
                    this.isIdleState = false;
                    this.setPollTimer();
                }
                if (this.mHaveIpAddress) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)("[handleMessageWimaxStateChanged] nRetryFlag = " + this.nRetryFlag + " -> 0"));
                    }
                    this.configureInterface();
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Idle) {
                        this.isIdleState = true;
                    }
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.COMPLETED);
                    this.mWimax4GInfo.set4GBaseStationInfo(this.mWM.getConnectedNSP());
                    this.sendWimaxStateChangeBroadcast();
                    this.mWM.release_sWakeLock();
                } else {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[handleMessageWimaxStateChanged]  No IP Address -> setDetailedState.OBTAINING_IPADDR");
                    }
                    this.mWimaxState = WimaxState.OBTAINING_IPADDR;
                    this.mWimaxStateDetail = null;
                    this.configureInterface();
                    this.mDhcpStart = new Date().getTime();
                    this.sendWimaxStateChangeBroadcast();
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR, null, null);
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATED);
                }
                if (this.isIdleState) break;
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)("[CONNECTED] m_bScreenOff :" + this.m_bScreenOff));
                }
                this.SetScreenOff(this.m_bScreenOff);
                break;
            }
            case 10: {
                this.sendWimaxStateChangeBroadcast();
                break;
            }
            case 2: {
                this.acquire_WakeLock();
                if (this.hasMessages(16)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[DISCONNECTED] removeMessage(EVENT_MOCALL_FAIL)");
                    }
                    this.removeMessages(16);
                }
                if (newWimaxState.info != null && newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Abnormal_State) {
                    if (this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"-------- Abnormal_State  ----------");
                    }
                    if (this.mWM.get4GState() == 1 || this.mWM.get4GState() == 0) {
                        if (this.m_bLog) {
                            Log.e((String)"WimaxStateTracker", (String)"-------- discard Abnormal_State  ----------");
                        }
                    } else {
                        this.mModemReset = true;
                        this.isHaveLinkInfo = false;
                        this.nRetryFlag = 0;
                        this.nScanAttempt = 0;
                        this.resetInterface();
                        this.mWimax4GInfo.setBSID("00:00:00:00:00:00");
                        this.mWimax4GInfo.setFREQ(0);
                        this.mWimax4GInfo.setRssi(-9999);
                        this.mWimax4GInfo.setCinr(0);
                        this.mWimax4GInfo.setTxPower(0);
                        this.nOldSignalLevel = -1;
                        this.mWM.set4GEnabled(true);
                        return;
                    }
                }
                this.isHaveLinkInfo = false;
                this.resetLinkStatusInfo();
                this.sendWimaxStateChangeBroadcast();
                if (this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[handleMessageWimaxStateChanged] ^^^ DetailedState.DISCONNECTED ^^^");
                    }
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                    this.updateWimaxNotiMsg();
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.DISCONNECTED);
                } else {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[handleMessageWimaxStateChanged] ^^^ DetailedState.FAILED ^^^");
                    }
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR, null, null);
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.INVALID);
                }
                if (this.m_bUserDisconnect) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"USER Disconnect!!!!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    if (this.mWM.get4GState() != 0) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)"setWimaxStatus(NET_4G_STATE_DISABLING)");
                        }
                        this.mWM.setWimax4GState(0);
                    }
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    this.resetInterface();
                    if (!WimaxNative.stopWimax() && this.m_bLog) {
                        Log.e((String)"WimaxStateTracker", (String)"Failed to stop Wimax.");
                    }
                    if (!WimaxNative.loadDriver((byte)0)) {
                        if (this.m_bLog) {
                            Log.e((String)"WimaxStateTracker", (String)"[handleMessageWimaxStateChanged] Failed to unload Wimax driver.");
                        }
                        this.mWM.release_sWakeLock();
                    } else {
                        this.notifyDriverStopped();
                    }
                    this.m_bUserDisconnect = false;
                    break;
                }
                if (this.mWimaxStateOld != WimaxState.DISCONNECTED) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)(" connection fail :: newWimaxState.info ********  " + (Object)newWimaxState.info));
                    }
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)" !!!!!!!!!!!!!!!!!!!!!!!!!WimaxState.DISCONNECTED");
                    }
                    if (!this.m_bEntryDelaySet) {
                        if (this.m_bLog) {
                            Log.d((String)"WimaxStateTracker", (String)" m_bEntryDelaySet!!!!!!!!!!!!!!!!!!!!!!!!!");
                        }
                        this.m_bExitCriteria = true;
                    }
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"Fail for Connect command !!!!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Timeout_Sync || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Timeout_NE) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)("Connection Time out !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)newWimaxState.info));
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Syncup_PHY || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.Syncup_MAC) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)("Sync Fail !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)newWimaxState.info));
                    }
                    this.RetryProcess();
                    break;
                }
                if (newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_Device || newWimaxState.info == DeviceStatusInfo.ConnectionProgressInfo.EAP_authentication_User) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)("Auth Fail !!!!!!!!!!!!!!!!!!!!!!!!! " + (Object)newWimaxState.info));
                    }
                    this.RetryProcess();
                    break;
                }
                if (this.m_bLog) {
                    Log.d((String)"WimaxStateTracker", (String)"Virtual IDLE!!!!!!!!!!!!!! ");
                }
                if (this.hasMessages(8)) {
                    if (this.m_bLog) {
                        Log.d((String)"WimaxStateTracker", (String)"[DISCONNECTED] removeMessage(EVENT_VI_REQ)");
                    }
                    this.removeMessages(8);
                }
                if (this.hasMessages(6)) break;
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
        }
    }

    public void SendWimaxLinkStateChangeBroadcast() {
        if (Wimax4GInfo.linkStateMap.get((Object)this.mWimaxStateDetail) == net4GInfo.LINK_STATE_DETAIL.LINK_ST_DETAIL_UNDEFINED) {
            return;
        }
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.LINK_STATE_DETAIL_CHANGED");
            intent.putExtra("link_state_detail", (Serializable)Wimax4GInfo.linkStateMap.get((Object)this.mWimaxStateDetail));
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private static void putAddress(StringBuffer buf, int addr) {
        StringBuffer stringBuffer = buf.append(addr & 0xFF).append('.');
        int n = addr >>> 8;
        addr = n;
        addr = addr >>> 8;
        stringBuffer.append(n & 0xFF).append('.').append(addr & 0xFF).append('.').append((addr >>>= 8) & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("testhere [handleMessage] Received msg = " + msg.what));
        }
        switch (msg.what) {
            case 1: {
                WimaxStateChangeResult result = (WimaxStateChangeResult)msg.obj;
                this.mWimaxStateOld = this.mWimaxState;
                this.mWimaxStateDetailOld = this.mWimaxStateDetail;
                this.mWimaxState = result.state;
                this.mWimaxStateDetail = result.info;
                this.mWimax4GInfo.setLinkStateDetailed((net4GInfo.LINK_STATE_DETAIL)((Object)Wimax4GInfo.linkStateMap.get((Object)result.info)));
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] Old state is " + (Object)((Object)this.mWimaxStateOld)));
                }
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] New state is " + (Object)((Object)this.mWimaxState) + " New detailed info is " + (Object)((Object)this.mWimaxStateDetail)));
                }
                this.updateNetworkInfo();
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] result(New Wimax State ::: )  " + (Object)((Object)result.state)));
                }
                this.handleWimaxStateChanged(result);
                this.sendNetworkStateChangeBroadcast();
                this.sendSupplicantStateChangeBroadcast();
                if (this.mWimaxStateDetail == this.mWimaxStateDetailOld) break;
                if (this.mWimaxStateDetail == DeviceStatusInfo.ConnectionProgressInfo.Abnormal_State) {
                    this.mWM.setLastError(13);
                }
                this.SendWimaxLinkStateChangeBroadcast();
                break;
            }
            case 4: {
                if (this.isHaveLinkInfo) {
                    if (!this.isIdleState) {
                        this.requestPolledInfo(this.mWimax4GInfo);
                        this.setPollTimer();
                        break;
                    }
                    if (!this.m_bLog) break;
                    Log.d((String)TAG, (String)"[handleMessage:EVENT_POLL_INTERVAL] ^^^^^ IDLE MODE ^^^^^");
                    break;
                }
                if (!this.m_bLog) break;
                Log.d((String)TAG, (String)"[handleMessage:EVENT_POLL_INTERVAL] ^^^^^ DISCONNECTED ^^^^^");
                break;
            }
            case 6: {
                this.mWM.release_sWakeLock();
                break;
            }
            case 7: {
                this.mWM.startScan();
                break;
            }
            case 8: {
                WimaxNative.VirtualIdleReq(-1, (byte)1);
                if (this.hasMessages(6)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[EVENT_VI_REQ] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                    }
                    this.removeMessages(6);
                }
                this.sendEmptyMessageDelayed(6, 3000L);
                break;
            }
            case 2: {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("mDhcpInfo.netmask:" + NetworkUtils.prefixLengthToNetmaskInt((int)this.mDhcpInfoInt.prefixLength)));
                }
                if (NetworkUtils.prefixLengthToNetmaskInt((int)this.mDhcpInfoInt.prefixLength) == -1) {
                    if (this.m_bLog) {
                        Log.w((String)TAG, (String)"SystemProperties.set wimax_route");
                    }
                    SystemProperties.set((String)"ctl.start", (String)"wimax_route");
                }
                this.mDhcpEnd = new Date().getTime();
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage : DhcpEnd is " + this.mDhcpEnd + "ms"));
                }
                this.mDiffDhcpTime = (int)(this.mDhcpEnd - this.mDhcpStart);
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage : DHCP Difference is " + this.mDiffDhcpTime + "ms"));
                }
                this.sendDHCPTimeBroadcast(this.mDiffDhcpTime);
                this.mHaveIpAddress = true;
                this.mObtainingIpAddress = false;
                this.mWimax4GInfo.setIpAddress(WimaxStateTracker.stringToIpAddr(this.mDhcpInfoInt.ipAddress));
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)("mNetworkInfo.getDetailedState(.) " + this.mNetworkInfo.getDetailedState() + " - " + this.mNetworkInfo.getState()));
                }
                if (this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTED) {
                    this.nRetryFlag = 0;
                    this.nScanAttempt = 0;
                    this.mWimaxState = WimaxState.CONNECTED;
                    this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Registered;
                    WimaxNative.IpObtained();
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                    this.sendWimaxStateChangeBroadcast();
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATED);
                } else {
                    WimaxNative.IpObtained();
                    msg = this.mCsHandler.obtainMessage(3, (Object)this.mNetworkInfo);
                    msg.sendToTarget();
                    if (this.isIdleState) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"isIdleState == true");
                        }
                        this.isIdleState = false;
                        this.setPollTimer();
                        this.mWimaxState = WimaxState.CONNECTED;
                        this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.Registered;
                        WimaxNative.IpObtained();
                        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                        this.sendWimaxStateChangeBroadcast();
                        this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.ASSOCIATED);
                    }
                }
                this.configureLinkProperties();
                this.sendNetworkStateChangeBroadcast();
                this.updateWimaxNotiMsg();
                if (this.m_bLog) {
                    Log.i((String)TAG, (String)("[handleMessage] >>> IP configuration << " + this.mDhcpInfoInt));
                }
                if (ActivityManagerNative.isSystemReady()) {
                    this.mContext.sendBroadcast(new Intent("android.net.wimax.NETWORK_IP_CHANGED"));
                }
                this.mWM.release_sWakeLock();
                break;
            }
            case 3: {
                if (this.m_bLog) {
                    Log.e((String)TAG, (String)"[handleMessage] >>> IP configuration...  failed <<< ");
                }
                this.mHaveIpAddress = false;
                this.mWimax4GInfo.setIpAddress(0);
                this.mObtainingIpAddress = false;
                this.mDiffDhcpTime = -1;
                this.sendDHCPTimeBroadcast(this.mDiffDhcpTime);
                if (this.mDhcpTarget != null) {
                    this.mDhcpTarget.setCancelCallback(true);
                    if (this.mDhcpTarget.hasMessages(5)) {
                        this.mDhcpTarget.removeMessages(5);
                    }
                    if (this.mDhcpTarget.hasMessages(10)) {
                        this.mDhcpTarget.removeMessages(10);
                    }
                }
                if (!NetworkUtils.stopDhcp((String)this.mInterfaceName) && this.m_bLog) {
                    Log.e((String)TAG, (String)"Could not stop DHCP");
                }
                NetworkUtils.disableInterface((String)this.mInterfaceName);
                WimaxStateTracker wimaxStateTracker = this;
                synchronized (wimaxStateTracker) {
                    if ((this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.OBTAINING_IPADDR) && this.m_bLog) {
                        Log.d((String)TAG, (String)"[handleMessage:EVENT_INTERFACE_CONFIGURATION_FAILED] b4 disconnectWimax()");
                    }
                    WimaxNative.disconnectWimax();
                    break;
                }
            }
            case 9: {
                boolean driverStarted;
                boolean bl = driverStarted = msg.arg1 != 0;
                if (this.m_bLog) {
                    Log.v((String)TAG, (String)("[handleMessage:EVENT_DRIVER_STATE_CHANGED] (" + driverStarted + ")"));
                }
                if (!driverStarted) {
                    this.m_bUserDisconnect = false;
                    this.m_bExitCriteria = false;
                    this.mWM.setWimax4GState(1);
                    if (this.hasMessages(8)) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"[EVENT_DRIVER_STATE_CHANGED] removeMessage(EVENT_VI_REQ)");
                        }
                        this.removeMessages(8);
                    }
                    if (this.hasMessages(7)) {
                        if (this.m_bLog) {
                            Log.d((String)TAG, (String)"[EVENT_DRIVER_STATE_CHANGED] removeMessage(EVENT_SCAN_DELAY)");
                        }
                        this.removeMessages(7);
                    }
                    if (this.m_bLog) {
                        Log.i((String)TAG, (String)"!!!!!!!!!!!!!!!!!set DISCONNECTED state When 4G is turned off  before scanning step!!!!!!!!!!!!!!!!!!");
                    }
                    this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                    this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.DISCONNECTED);
                    this.mWM.release_sWakeLock();
                }
                this.noteRunState();
                break;
            }
            case 11: {
                WimaxAuthFail auth = (WimaxAuthFail)msg.obj;
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] AUTH_FAIL  nErrorCode : " + auth.nErrorCode + ", strError :" + auth.strError));
                }
                Intent intent = new Intent("android.net.wimax.WIMAX_AUTH_ERROR");
                intent.putExtra("auth_error", auth.nErrorCode);
                this.mWM.setLastError(1);
                this.mContext.sendBroadcast(intent);
                break;
            }
            case 12: {
                this.sendWimaxOMADMResponseBroadcast((ByteBuffer)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 13: {
                this.sendWimaxRadioInfoResponseBroadcast();
                this.sendWimaxRadioInfoTemperatureResponseBroadcast();
                break;
            }
            case 14: {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] EVENT_LINK_WEAK_INFO : 4G will disconnect. (currentState :" + (Object)((Object)this.mWimaxState) + ")"));
                }
                this.m_bExitCriteria = true;
                this.mWM.disconnect();
                this.mWM.setLastError(6);
                break;
            }
            case 15: {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[handleMessage] EVENT_MOCALL_INFO : wait 5sec. ");
                }
                this.acquire_WakeLock();
                if (this.hasMessages(16)) {
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)"[handleMessage] removeMessage(EVENT_MOCALL_FAIL)");
                    }
                    this.removeMessages(16);
                }
                this.sendEmptyMessageDelayed(16, 5000L);
                break;
            }
            case 16: {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[handleMessage] EVENT_MOCALL_FAIL : 4G will disconnect. (currentState :" + (Object)((Object)this.mWimaxState) + ")"));
                }
                this.m_bExitCriteria = true;
                this.mWM.disconnect();
            }
        }
    }

    public boolean getNoBackoff() {
        return this.m_bNoBackOff;
    }

    public void SetNoBackOff(boolean bNoBackOff) {
        this.m_bNoBackOff = bNoBackOff;
    }

    private void RetryProcess() {
        this.resetInterface();
        if (this.m_bNoBackOff) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] m_bNoBackOff --return");
            }
            this.acquire_WakeLock();
            WimaxNative.VirtualIdleReq(-1, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
            return;
        }
        if (this.isWifiConnected()) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] mTornDownByConnMgr && mWM.isWiFiConnect()--return");
            }
            if (this.isWifiConnected()) {
                this.setTornDownByConnMgr(true);
            }
            this.acquire_WakeLock();
            WimaxNative.VirtualIdleReq(-1, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
            return;
        }
        if (this.m_bMruWorking) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[RetryProcess] m_bMruWorking --return");
            }
            this.mWM.release_sWakeLock();
            return;
        }
        if (this.m_bEntryDelaySet) {
            if (this.m_bLog) {
                Log.i((String)TAG, (String)"[RetryProcess] >>>>>>>>>>>> About to ENTRY to RetryProcess <<<<<<<<<<<<<<<<<<");
            }
            this.m_bEntryDelaySet = false;
            this.m_bExitCriteria = true;
        }
        if (this.m_bLog) {
            Log.i((String)TAG, (String)"[RetryProcess] >>>>>>>>>>>> WELCOME to RetryProcess <<<<<<<<<<<<<<<<<<");
        }
        if ((this.mWM.getWimaxMode() == 2 || this.mWM.getWimaxMode() == 4) && this.m_bLog) {
            Log.d((String)TAG, (String)"BACKHAUL mode......!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[RetryProcess] ++++ nRetryFlag =  " + this.nRetryFlag + " ++++"));
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[RetryProcess] ++++ nScanAttempt =  " + this.nScanAttempt + " ++++"));
        }
        if (this.nScanAttempt < this.WIMAX_SCAN_ATTEMPT_TIMEOUT) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)("++++ " + this.nScanAttempt + "<" + this.WIMAX_SCAN_ATTEMPT_TIMEOUT + " ++++"));
            }
            if (this.hasMessages(7)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_SCAN_DELAY)");
                }
                this.removeMessages(7);
            }
            this.sendEmptyMessageDelayed(7, 1000L);
        } else {
            int nWaitTime = this.WIMAX_SCAN_RETRY_SECONDS + this.nRetryFlag * this.WIMAX_SCAN_RETRY_SECONDS;
            if (this.m_bLog) {
                Log.d((String)TAG, (String)("++++ time = " + nWaitTime + " ++++"));
            }
            if (nWaitTime <= 1800) {
                ++this.nRetryFlag;
            } else {
                nWaitTime = 1800;
            }
            this.nScanAttempt = 0;
            WimaxNative.VirtualIdleReq(nWaitTime, (byte)1);
            if (this.hasMessages(6)) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)"[RetryProcess] removeMessage(EVENT_AFTER_VI_REQ_NEED_DELAY)");
                }
                this.removeMessages(6);
            }
            this.sendEmptyMessageDelayed(6, 3000L);
        }
    }

    public void clearRetryFlag() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"[clearRetryFlag] Called ********** ");
        }
        this.nRetryFlag = 0;
        this.nScanAttempt = 0;
        if (this.hasMessages(7)) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"[clearRetryFlag] removeMessage(EVENT_SCAN_DELAY)");
            }
            this.removeMessages(7);
        }
        this.m_bSkipEntryDelayOnce = true;
    }

    public void configureInterface() {
        block10: {
            this.setPollTimer();
            if (!this.mUseStaticIp) {
                if (!this.mHaveIpAddress && !this.mObtainingIpAddress) {
                    if (this.m_bLog) {
                        Log.v((String)TAG, (String)"[configureInterface] !mHaveIpAddress && !mObtainingIpAddress");
                    }
                    this.mObtainingIpAddress = true;
                    this.mDhcpTarget.sendEmptyMessage(5);
                }
            } else if (!this.mHaveIpAddress) {
                InterfaceConfiguration ifcg = null;
                try {
                    ifcg = this.nwService.getInterfaceConfig(this.mInterfaceName);
                    if (ifcg != null) {
                        ifcg.addr = new LinkAddress(NetworkUtils.numericToInetAddress((String)this.mDhcpInfoInt.ipAddress), 24);
                        ifcg.interfaceFlags = "[up]";
                        this.nwService.setInterfaceConfig(this.mInterfaceName, ifcg);
                        this.mHaveIpAddress = true;
                        int event = 2;
                        if (this.m_bLog) {
                            Log.v((String)TAG, (String)"Static IP configuration succeeded");
                        }
                    }
                }
                catch (Exception e) {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)("Error configuring interface " + this.mInterfaceName + ", :" + e));
                    }
                    this.mHaveIpAddress = false;
                    int event = 3;
                    if (!this.m_bLog) break block10;
                    Log.v((String)TAG, (String)"Static IP configuration failed");
                }
            }
        }
    }

    public void resetLinkStatusInfo() {
        this.mWimax4GInfo.setBSID("00:00:00:00:00:00");
        this.mWimax4GInfo.setFREQ(0);
        this.mWimax4GInfo.setRssi(-9999);
        this.mWimax4GInfo.setCinr(0);
        this.mWimax4GInfo.setTxPower(0);
        this.nOldSignalLevel = -1;
        this.mWimaxState = WimaxState.DISCONNECTED;
        this.mWimaxStateDetail = DeviceStatusInfo.ConnectionProgressInfo.De_registration;
        this.sendWimaxStateChangeBroadcast();
    }

    public void resetOldState() {
        this.mWimaxMonitor.resetOldState();
    }

    public void resetInterface() {
        this.isHaveLinkInfo = false;
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mWimax4GInfo.setIpAddress(0);
        this.mAlarmManager.cancel(this.mDhcpRenewIntent);
        if (this.mDhcpTarget != null) {
            this.mDhcpTarget.setCancelCallback(true);
            if (this.mDhcpTarget.hasMessages(5)) {
                this.mDhcpTarget.removeMessages(5);
            }
            if (this.mDhcpTarget.hasMessages(10)) {
                this.mDhcpTarget.removeMessages(10);
            }
        }
        if (!NetworkUtils.stopDhcp((String)this.mInterfaceName) && this.m_bLog) {
            Log.e((String)TAG, (String)"[resetInterface] Could not stop DHCP");
        }
        NetworkUtils.disableInterface((String)this.mInterfaceName);
        String EMPTY_IP = "0.0.0.0";
        RouteInfo EMPTY_ROUTE = new RouteInfo(new LinkAddress(NetworkUtils.numericToInetAddress((String)"0.0.0.0"), 0), null);
        this.mDhcpInfoInt = new DhcpInfoInternal();
        this.mDhcpInfoInt.ipAddress = "0.0.0.0";
        this.mDhcpInfoInt.addRoute(EMPTY_ROUTE);
        this.mDhcpInfoInt.prefixLength = 0;
        this.mDhcpInfoInt.dns1 = "0.0.0.0";
        this.mDhcpInfoInt.dns2 = "0.0.0.0";
        this.mDhcpInfoInt.serverAddress = "0.0.0.0";
        this.mDhcpInfoInt.leaseDuration = 0;
    }

    public DhcpInfo getDhcpInfo() {
        return this.mDhcpInfoInt.makeDhcpInfo();
    }

    public WimaxState getCurrentWimaxState() {
        return this.mWimaxState;
    }

    public int getCurrentWimaxStateDetail() {
        return this.mWimaxStateDetail != null ? this.mWimaxStateDetail.ordinal() : -1;
    }

    public Wimax4GInfo requestConnectionInfo() {
        this.requestPolledInfo(this.mWimax4GInfo);
        DhcpInfo dhcp = this.getDhcpInfo();
        this.mWimax4GInfo.setIpAddress(WimaxStateTracker.stringToIpAddr(this.mDhcpInfoInt.ipAddress));
        Wimax4GDeviceInfo devInfo = this.mWM.getDeviceInformation();
        this.mWimax4GInfo.setMacAddress(devInfo.getMacAddress());
        return this.mWimax4GInfo;
    }

    public void SetScreenOff(boolean bScreenOff) {
        this.m_bScreenOff = bScreenOff;
        if (this.isIdleState) {
            return;
        }
        if (!(this.mWimaxState != WimaxState.CONNECTING && this.mWimaxState != WimaxState.OBTAINING_IPADDR && this.mWimaxState != WimaxState.CONNECTED && this.mWimaxState != WimaxState.READY || this.m_bScreenOff)) {
            WimaxNative.setLinkInfo(true);
        }
        if (this.m_bScreenOff) {
            WimaxNative.setLinkInfo(false);
        }
    }

    private synchronized void requestPolledInfo(Wimax4GInfo info) {
        if (this.m_bScreenOff) {
            return;
        }
        String sBsid = null;
        int nTxpower = 0;
        int nCF = 0;
        int sRssi = 0;
        int sCinr = 0;
        int ulspeed = 0;
        boolean dlspeed = false;
        String rev_info = null;
        String rev_time = null;
        rev_info = WimaxNative.getLinkInfo();
        rev_time = WimaxNative.getConnectionTime();
        WimaxNative.getRadioInfo();
        if (rev_info == null) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[requestPolledInfo] getLinkInfo() returns null");
            }
            return;
        }
        StringTokenizer st = new StringTokenizer(rev_info, "#");
        if (this.m_bLog) {
            Log.w((String)TAG, (String)("[rev_info] " + rev_info));
        }
        if (st.hasMoreTokens()) {
            nCF = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                sRssi = Integer.parseInt(st.nextToken());
                if (sRssi == -123) {
                    return;
                }
                if (st.hasMoreTokens()) {
                    sCinr = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        nTxpower = Integer.parseInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            ulspeed = Integer.parseInt(st.nextToken());
                            if (st.hasMoreTokens()) {
                                ulspeed = Integer.parseInt(st.nextToken());
                                if (st.hasMoreTokens()) {
                                    sBsid = st.nextToken();
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!info.getBSID().equals(sBsid)) {
            info.setBSID(sBsid);
            this.sendBSIDChangeBroadcast(sBsid);
        }
        if (info.getFREQ() != nCF) {
            info.setFREQ(nCF);
            this.sendFrequencyChangeBroadcast(nCF);
        }
        int oldRssi = info.getRssi();
        int oldCinr = info.getCinr();
        if (oldRssi != sRssi || oldCinr != sCinr) {
            int nNewSignalLevel;
            if (oldRssi != sRssi) {
                info.setRssi(sRssi);
                this.sendSignalChangeBroadcast(sRssi);
            }
            if (oldCinr != sCinr) {
                info.setCinr(sCinr);
                this.sendCINRSignalChangeBroadcast(sCinr);
            }
            if (this.nOldSignalLevel != (nNewSignalLevel = Wimax4GManager.calculateSignalLevel(sRssi, sCinr, 4))) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("nNewSignalLevel ====> " + nNewSignalLevel));
                }
                this.sendSignalLevelChangeBroadcast(nNewSignalLevel);
                this.nOldSignalLevel = nNewSignalLevel;
            }
        }
        if (info.getTxPower() != nTxpower) {
            info.setTxPower(nTxpower);
        }
        if (info.getLinkSpeed() != ulspeed) {
            info.setLinkSpeed(ulspeed);
        }
    }

    private synchronized void requestConnectionTime(Wimax4GInfo info) {
        String rev_time = null;
        rev_time = WimaxNative.getConnectionTime();
        int newTime = Integer.parseInt(rev_time);
        this.sendConnectionTimeChangeBroadcast(newTime);
    }

    private void sendBSIDChangeBroadcast(String newBsid) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.NET_4G_HANDOVER_COMPLETE_ACTION");
            intent.putExtra("newBSID", (Parcelable)this.mWM.getConnectedNSP());
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendFrequencyChangeBroadcast(int newFreq) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.FREQUENCY_CHANGED");
            intent.putExtra("newFrequency", newFreq);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendSignalChangeBroadcast(int newRssi) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.RSSI_CHANGED");
            intent.putExtra("newRSSI", newRssi);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendCINRSignalChangeBroadcast(int newCINR) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.CINR_CHANGED");
            intent.putExtra("newCINR", newCINR);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendSignalLevelChangeBroadcast(int newSignalLevel) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.SIGNAL_LEVEL_CHANGED");
            intent.putExtra("newSignalLevel", newSignalLevel);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendModeChangeBroadcast(int usbMode) {
        Intent intent = new Intent("android.net.wimax.MODE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("usbMode", usbMode);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendWimaxStateChangeBroadcast() {
        Intent intent = new Intent("android.net.fourG.wimax.WIMAX_NETWORK_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("WimaxState", this.mWimaxState.ordinal());
        if ((this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.CONNECTED || this.mWimaxState == WimaxState.DISCONNECTED) && this.mWimaxStateDetail != null) {
            intent.putExtra("WimaxStateDetail", this.mWimaxStateDetail.ordinal());
        }
        if (this.m_bLog) {
            Log.d((String)"mytag", (String)("sendWimaxStateChangeBroadcast intent 1 - " + intent), (Throwable)new Throwable());
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("sendWimaxStateChangeBroadcast intent - " + intent), (Throwable)new Throwable());
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendNetworkStateChangeBroadcast() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("testhere sendNetworkStateChangeBroadcast  entered: " + this.mNetworkInfo.getState() + " - " + this.mNetworkInfo.getDetailedState()), (Throwable)new Throwable());
        }
        Intent intent = new Intent("android.net.fourG.wimax.NETWORK_STATE_CHANGED");
        intent.addFlags(0x30000000);
        intent.putExtra("linkProperties", (Parcelable)this.mLinkProperties);
        intent.putExtra("networkInfo", (Parcelable)this.mNetworkInfo);
        if (this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
            intent.putExtra("fourG_info", (Parcelable)this.mWimax4GInfo);
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendSupplicantStateChangeBroadcast() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"sendSupplicantStateChangeBroadcast  entered: ");
        }
        Intent intent = new Intent("android.net.fourG.NET_4G_SUPPLICANT_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("4g_supplicant_state", (Parcelable)this.mWimax4GInfo.getSupplicantState());
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendConnectionTimeChangeBroadcast(int newTime) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.TIME_CHANGED");
            intent.putExtra("newTime", newTime);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendDHCPTimeBroadcast(int newDHCPTime) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wimax.WIMAX_DHCP_TIME");
            intent.putExtra("newDHCPTime", newDHCPTime);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    void sendMruListBroadcast(int nlistSize) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.addFlags(0x10000000);
        intent.putExtra("MruList", nlistSize);
        this.mContext.sendBroadcast(intent);
    }

    void sendMruUpdateBroadcast(int subType, int ErrorValue) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.addFlags(0x10000000);
        intent.putExtra("subType", subType);
        intent.putExtra("ErrorValue", ErrorValue);
        this.mContext.sendBroadcast(intent);
    }

    void sendWimaxRadioInfoResponseBroadcast() {
        Wimax4GManager.WimaxRadioInfoTemperature radioInfoObj = (Wimax4GManager.WimaxRadioInfoTemperature)this.mWM.getRadioInfoTemperature();
        this.mWimaxTemperature = radioInfoObj.getCurrent();
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.putExtra("WimaxRadioInfo", this.mWimaxTemperature);
        this.mContext.sendBroadcast(intent);
    }

    public void sendWorkModeBroadCast(int workMode) {
        Intent intent = new Intent("android.net.wimax.WIMAX_WORK_MODE");
        intent.putExtra("WimaxWorkMode", workMode);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendWimaxOMADMResponseBroadcast(ByteBuffer respDataAray, int nRetType, int odbMngState) {
        Intent intent = new Intent("android.net.wimax.WIMAX_RESPONSE");
        intent.putExtra("WimaxOMADMRespData", respDataAray.array());
        intent.putExtra("WimaxOMADMRespState", odbMngState);
        this.mContext.sendBroadcast(intent);
    }

    private void sendWimaxRadioInfoTemperatureResponseBroadcast() {
        Wimax4GManager.WimaxRadioInfoTemperature radioInfoObj = (Wimax4GManager.WimaxRadioInfoTemperature)this.mWM.getRadioInfoTemperature();
        this.mWimaxTemperature = radioInfoObj.getCurrent();
        if (radioInfoObj.isRadioOverheat()) {
            Intent intent = new Intent("android.net.RADIO_OVERHEAT");
            intent.putExtra("radio_temperature", this.mWimaxTemperature);
            this.mContext.sendBroadcast(intent);
        }
    }

    void sendWimaxBSListBroadcast(List<Wimax4GBaseStationInfo> nlist) {
        Intent intent = new Intent("android.net.SCAN_RESULTS_AVAILABLE");
        intent.putExtra("bs_scan_result", (Parcelable)nlist);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUSBTo(boolean enable) {
        byte[] data = enable ? WiMAX : PDA;
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("setUSBTo  enable: " + enable));
        }
        FileOutputStream out = null;
        out = new FileOutputStream(USB_PATH);
        out.write(data);
        Object var6_4 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var6_5 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean teardown() {
        if (!this.isTeardownRequested()) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)("[teardown] state(" + (Object)((Object)this.mWimaxState) + ") DisconnectWimax"), (Throwable)new Throwable());
            }
            this.resetInterface();
            if (this.mWimaxState == WimaxState.CONNECTED || this.mWimaxState == WimaxState.CONNECTING || this.mWimaxState == WimaxState.OBTAINING_IPADDR) {
                if (this.m_bLog) {
                    Log.d((String)TAG, (String)("[teardown] state(" + (Object)((Object)this.mWimaxState) + ") DisconnectWimax"));
                }
                if (this.disconnectAndStop()) {
                    this.setTornDownByConnMgr(true);
                    this.mTeardownRequested.set(true);
                    this.m_bSkipEntryDelayOnce = true;
                    return true;
                }
            } else {
                int wimaxStatus = this.mWM.get4GState();
                if (wimaxStatus == 3 || wimaxStatus == 2) {
                    this.m_bPoweroff = true;
                    if (this.m_bLog) {
                        Log.d((String)TAG, (String)("[teardown] state(" + (Object)((Object)this.mWimaxState) + ") stopWimax"));
                    }
                    if (!WimaxNative.stopWimax() && this.m_bLog) {
                        Log.e((String)TAG, (String)"[teardown] fail to stop wimax..");
                    }
                    if (WimaxNative.loadDriver((byte)0)) {
                        this.setTornDownByConnMgr(true);
                        this.mTeardownRequested.set(true);
                        this.notifyDriverStopped();
                        this.m_bSkipEntryDelayOnce = true;
                        return true;
                    }
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)"[teardown] fail to turn wimax off");
                    }
                }
                if (this.m_bLog) {
                    Log.w((String)TAG, (String)"[teardown] already turned off");
                }
                return true;
            }
        }
        return false;
    }

    public void isBootCompleted(boolean bCompleted) {
        this.m_isBootCompleted = bCompleted;
    }

    public boolean reconnect() {
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[reconnect] isWifiConnected " + this.isWifiConnected()));
        }
        if (this.isWifiConnected()) {
            if (this.m_bLog) {
                Log.d((String)TAG, (String)"[reconnect] isAvailable false ignore reconnect");
            }
            return false;
        }
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[reconnect] mTornDownByConnMgr = " + this.mTornDownByConnMgr + "  getCurrentWimaxState() = " + (Object)((Object)this.getCurrentWimaxState()) + " getWimaxStatus()  = " + this.mWM.get4GState()), (Throwable)new Throwable());
        }
        this.mTeardownRequested.set(false);
        this.setTornDownByConnMgr(false);
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"mTeardownRequested.set(false)");
        }
        if (!this.mWM.getPersistedWimaxEnabled()) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[reconnect] This is NOT by User request.... reject...");
            }
            return false;
        }
        if (!this.m_isBootCompleted) {
            if (this.m_bLog) {
                Log.w((String)TAG, (String)"[reconnect] m_isBootCompleted is false ");
            }
            return false;
        }
        if (this.mWM.get4GState() == 1 || this.mWM.get4GState() == 0 || this.mWM.get4GState() == 2 || this.mWM.get4GState() == 4) {
            boolean bRet = this.mWM.set4GEnabled(true);
            if (bRet) {
                this.mTeardownRequested.set(false);
                this.mTornDownByConnMgr = false;
            }
            return bRet;
        }
        if (this.m_bLog) {
            Log.w((String)TAG, (String)("[reconnect] mWimaxState " + (Object)((Object)this.mWimaxState)));
        }
        if (this.mWimaxState == WimaxState.DISCONNECTED) {
            this.setTornDownByConnMgr(false);
            this.mWM.startScan(false);
            return true;
        }
        return false;
    }

    public synchronized boolean disconnectAndStop() {
        if (this.m_bLog) {
            Log.w((String)TAG, (String)"[disconnectAndStop] called ****** ");
        }
        if (this.mRunState != 3 && this.mRunState != 4) {
            this.mRunState = 3;
            this.isHaveLinkInfo = false;
            this.m_bUserDisconnect = true;
            return WimaxNative.disconnectWimax();
        }
        this.releaseWakeLock();
        return true;
    }

    public synchronized boolean restart() {
        if (this.mRunState == 4) {
            this.mRunState = 1;
            return true;
        }
        if (this.mRunState == 3) {
            this.mRunState = 1;
        }
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        int nWimaxStatus = this.mWM.get4GState();
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("[setRadio]  nWimaxStatus =" + nWimaxStatus));
        }
        if (nWimaxStatus == 3 || nWimaxStatus == 2) {
            return false;
        }
        return this.mWM.set4GEnabled(turnOn);
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setEnableLog(boolean blog) {
        this.m_bLog = blog;
        WimaxNative.setEnableLog(this.m_bLog);
        this.mWimaxMonitor.setEnableLog(this.m_bLog);
        if (this.mWM == null) {
            this.mWM = Wimax4GManager.getInstance();
        }
        this.mWM.enableLog(this.m_bLog);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("interface ").append(this.mInterfaceName);
        sb.append(" runState=");
        if (this.mRunState >= 1 && this.mRunState <= mRunStateNames.length) {
            sb.append(mRunStateNames[this.mRunState - 1]);
        } else {
            sb.append(this.mRunState);
        }
        sb.append(LS).append(this.mWimax4GInfo).append(LS);
        sb.append(this.mDhcpInfoInt).append(LS);
        sb.append("haveIpAddress=").append(this.mHaveIpAddress).append(", obtainingIpAddress=").append(this.mObtainingIpAddress).append(", explicitlyDisabled=").append(this.mTornDownByConnMgr);
        return sb.toString();
    }

    private static int stringToIpAddr(String addrString) {
        try {
            String[] parts = addrString.split("\\.");
            if (parts.length != 4) {
                return -1;
            }
            int a = Integer.parseInt(parts[0]);
            int b = Integer.parseInt(parts[1]) << 8;
            int c = Integer.parseInt(parts[2]) << 16;
            int d = Integer.parseInt(parts[3]) << 24;
            return a | b | c | d;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkUseStaticIp() {
        RouteInfo route;
        String dns2;
        String dns1;
        int prefixLength;
        String ip;
        FileInputStream fis;
        BufferedReader br;
        block33: {
            boolean bl;
            block32: {
                boolean bl2;
                block31: {
                    boolean bl3;
                    block30: {
                        boolean bl4;
                        block29: {
                            this.mUseStaticIp = false;
                            ContentResolver cr = this.mContext.getContentResolver();
                            String msg = null;
                            Object backup_ip = null;
                            Object backup_gateway = null;
                            Object backup_netmask = null;
                            Object backup_dns1 = null;
                            Object backup_dns2 = null;
                            br = null;
                            fis = null;
                            try {
                                fis = new FileInputStream("/data/wimax_ip.txt");
                            }
                            catch (FileNotFoundException fnfe) {
                                if (!this.m_bLog) return false;
                                Log.d((String)TAG, (String)":)-------------------Use DHCP for WiMAX\n");
                                return false;
                            }
                            String EMPTY_IP = "0.0.0.0";
                            RouteInfo EMPTY_ROUTE = new RouteInfo(new LinkAddress(NetworkUtils.numericToInetAddress((String)"0.0.0.0"), 0), null);
                            ip = "0.0.0.0";
                            prefixLength = 0;
                            dns1 = "0.0.0.0";
                            dns2 = "0.0.0.0";
                            route = EMPTY_ROUTE;
                            try {
                                try {
                                    block41: {
                                        block39: {
                                            block40: {
                                                block37: {
                                                    block38: {
                                                        block35: {
                                                            block36: {
                                                                block34: {
                                                                    br = new BufferedReader(new InputStreamReader(fis));
                                                                    msg = br.readLine();
                                                                    if (msg == null) break block34;
                                                                    ip = msg;
                                                                    msg = br.readLine();
                                                                    if (msg == null) break block35;
                                                                    break block36;
                                                                }
                                                                if (this.m_bLog) {
                                                                    Log.e((String)TAG, (String)":)------ip-none----------Use DHCP for WiMAX\n");
                                                                }
                                                                bl4 = false;
                                                                Object var20_23 = null;
                                                                break block29;
                                                            }
                                                            route = RouteInfo.makeHostRoute((InetAddress)InetAddress.parseNumericAddress((String)msg));
                                                            msg = br.readLine();
                                                            if (msg == null) break block37;
                                                            break block38;
                                                        }
                                                        if (this.m_bLog) {
                                                            Log.e((String)TAG, (String)":)------gateway-none-----Use DHCP for WiMAX\n");
                                                        }
                                                        ip = "0.0.0.0";
                                                        bl3 = false;
                                                        break block30;
                                                    }
                                                    prefixLength = WimaxStateTracker.stringToIpAddr(msg);
                                                    msg = br.readLine();
                                                    if (msg == null) break block39;
                                                    break block40;
                                                }
                                                if (this.m_bLog) {
                                                    Log.e((String)TAG, (String)":)------netmask-none-----Use DHCP for WiMAX\n");
                                                }
                                                route = EMPTY_ROUTE;
                                                ip = "0.0.0.0";
                                                bl2 = false;
                                                break block31;
                                            }
                                            dns1 = msg;
                                            if (!this.m_bLog) break block41;
                                            Log.e((String)TAG, (String)(":)------dns1-msg--------Use DHCP for WiMAX\n " + this.mDhcpInfoInt.dns1));
                                            break block41;
                                        }
                                        if (this.m_bLog) {
                                            Log.e((String)TAG, (String)":)------dns1-none--------Use DHCP for WiMAX\n");
                                        }
                                        ip = "0.0.0.0";
                                        route = EMPTY_ROUTE;
                                        prefixLength = 0;
                                        bl = false;
                                        break block32;
                                    }
                                    if ((msg = br.readLine()) != null) {
                                        dns2 = msg;
                                        if (this.m_bLog) {
                                            Log.e((String)TAG, (String)(":)------dns21-msg--------Use DHCP for WiMAX\n " + this.mDhcpInfoInt.dns2));
                                        }
                                        break block33;
                                    }
                                    dns2 = "0.0.0.0";
                                    break block33;
                                }
                                catch (IOException e) {
                                    if (this.m_bLog) {
                                        Log.d((String)TAG, (String)":)-------exception---Use DHCP for WiMAX\n");
                                    }
                                    ip = "0.0.0.0";
                                    route = EMPTY_ROUTE;
                                    prefixLength = 0;
                                    dns1 = "0.0.0.0";
                                    dns2 = "0.0.0.0";
                                    boolean bl5 = false;
                                    Object var20_28 = null;
                                    try {
                                        br.close();
                                        fis.close();
                                        return bl5;
                                    }
                                    catch (IOException ioe) {
                                        if (this.m_bLog) {
                                            Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                                        }
                                        ioe.printStackTrace();
                                        return false;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var20_29 = null;
                                try {}
                                catch (IOException ioe) {
                                    if (this.m_bLog) {
                                        Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                                    }
                                    ioe.printStackTrace();
                                    return false;
                                }
                                br.close();
                                fis.close();
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException ioe) {
                            if (this.m_bLog) {
                                Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                            }
                            ioe.printStackTrace();
                            return false;
                        }
                        br.close();
                        fis.close();
                        return bl4;
                    }
                    Object var20_24 = null;
                    try {}
                    catch (IOException ioe) {
                        if (this.m_bLog) {
                            Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                        }
                        ioe.printStackTrace();
                        return false;
                    }
                    br.close();
                    fis.close();
                    return bl3;
                }
                Object var20_25 = null;
                try {}
                catch (IOException ioe) {
                    if (this.m_bLog) {
                        Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                    }
                    ioe.printStackTrace();
                    return false;
                }
                br.close();
                fis.close();
                return bl2;
            }
            Object var20_26 = null;
            try {}
            catch (IOException ioe) {
                if (this.m_bLog) {
                    Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
                }
                ioe.printStackTrace();
                return false;
            }
            br.close();
            fis.close();
            return bl;
        }
        Object var20_27 = null;
        try {}
        catch (IOException ioe) {
            if (this.m_bLog) {
                Log.e((String)TAG, (String)":)----- wimax_static_ip_config file close error\n");
            }
            ioe.printStackTrace();
            return false;
        }
        br.close();
        fis.close();
        this.mDhcpInfoInt = new DhcpInfoInternal();
        this.mDhcpInfoInt.ipAddress = ip;
        this.mDhcpInfoInt.addRoute(route);
        this.mDhcpInfoInt.prefixLength = prefixLength;
        this.mDhcpInfoInt.dns1 = dns1;
        this.mDhcpInfoInt.dns2 = dns2;
        if (this.m_bLog) {
            Log.d((String)TAG, (String)"Use Static IP for WiMAX\n");
        }
        this.mUseStaticIp = true;
        return true;
    }

    private int getMaxDhcpRetries() {
        return this.WIMAX_SCAN_ATTEMPT_TIMEOUT;
    }

    public void setHaveLinkInfo(boolean mHaveLinkInfo) {
        this.isHaveLinkInfo = mHaveLinkInfo;
    }

    public void setIdleState(boolean mIdleState) {
        this.isIdleState = mIdleState;
    }

    public void setDependencyMet(boolean met) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLinkProperties() {
        DhcpInfoInternal dhcpInfoInternal = this.mDhcpInfoInt;
        synchronized (dhcpInfoInternal) {
            this.mLinkProperties = this.mDhcpInfoInt.makeLinkProperties();
        }
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        if (this.m_bLog) {
            Log.d((String)TAG, (String)("configureLinkProperties : Link configured: " + this.mLinkProperties.toString()));
        }
    }

    private boolean isWifiConnected() {
        try {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            if (connManager == null) {
                Log.d((String)TAG, (String)"isWifiConnected connManager == null");
                return false;
            }
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi == null) {
                Log.d((String)TAG, (String)"isWifiConnected mWifi == null");
                return false;
            }
            if (mWifi.isConnected()) {
                return true;
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("e " + e));
        }
        return false;
    }

    static {
        PDA = new byte[]{80, 68, 65, 0};
        WiMAX = new byte[]{87, 73, 77, 65, 88, 0};
        nOdbReqCount = 0;
    }

    private class WimaxStateReceiver
    extends BroadcastReceiver {
        private WimaxStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (WimaxStateTracker.this.m_bLog) {
                Log.d((String)WimaxStateTracker.TAG, (String)("testhere WimaxStateReceiver onReceive  " + intent.getAction()));
            }
            if (intent.getAction().equals("android.net.fourG.wimax.NETWORK_STATE_CHANGED")) {
                WimaxStateTracker.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                WimaxStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                if (WimaxStateTracker.this.mLinkProperties == null) {
                    WimaxStateTracker.this.mLinkProperties = new LinkProperties();
                }
                WimaxStateTracker.this.mLinkCapabilities = (LinkCapabilities)intent.getParcelableExtra("linkCapabilities");
                if (WimaxStateTracker.this.mLinkCapabilities == null) {
                    WimaxStateTracker.this.mLinkCapabilities = new LinkCapabilities();
                }
                NetworkInfo.State state = WimaxStateTracker.this.mNetworkInfo.getState();
                if (WimaxStateTracker.this.mLastState == state) {
                    return;
                }
                WimaxStateTracker.this.mLastState = state;
                if (WimaxStateTracker.this.m_bLog) {
                    Log.d((String)WimaxStateTracker.TAG, (String)("testhere sending EVENT_STATE_CHANGED state " + state));
                }
                Message msg = WimaxStateTracker.this.mCsHandler.obtainMessage(1, (Object)WimaxStateTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        }
    }

    private class DhcpHandler
    extends Handler {
        private Handler mTarget;
        private boolean mCancelCallback;
        private boolean mIsRenewing;

        public DhcpHandler(Looper looper, Handler target) {
            super(looper);
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    int event;
                    DhcpHandler dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        this.mCancelCallback = false;
                        this.mIsRenewing = false;
                    }
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.d((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START]" + WimaxStateTracker.this.mInterfaceName));
                    }
                    WimaxStateTracker.this.mAlarmManager.cancel(WimaxStateTracker.this.mDhcpRenewIntent);
                    DhcpInfoInternal newInfo = new DhcpInfoInternal();
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.i((String)"mydhcp", (String)"dhcp start");
                    }
                    if (NetworkUtils.runDhcp((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfoInternal)newInfo)) {
                        WimaxStateTracker.this.mDhcpInfoInt = newInfo;
                        event = 2;
                    } else {
                        event = 3;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START] DHCP request failed: " + NetworkUtils.getDhcpError()));
                        }
                    }
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.i((String)"mydhcp", (String)("dhcp over " + WimaxStateTracker.this.mDhcpInfoInt));
                    }
                    DhcpHandler dhcpHandler2 = this;
                    synchronized (dhcpHandler2) {
                        if (!this.mCancelCallback) {
                            if (event == 2) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_DHCP_START] mDhcpInfo.leaseDuration = " + ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.leaseDuration));
                                }
                                long triggerTime = System.currentTimeMillis() + (long)((((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.leaseDuration - 30) * 1000);
                                WimaxStateTracker.this.mAlarmManager.set(0, triggerTime, WimaxStateTracker.this.mDhcpRenewIntent);
                            }
                            this.mTarget.sendEmptyMessage(event);
                        }
                        break;
                    }
                }
                case 10: {
                    int nNewIP;
                    int event;
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.v((String)WimaxStateTracker.TAG, (String)"[DhcpHandler:EVENT_IP_RENEW]");
                    }
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.i((String)WimaxStateTracker.TAG, (String)("old IP : " + WimaxStateTracker.this.mDhcpInfoInt.toString()));
                    }
                    WimaxStateTracker.this.mnOldIP = WimaxStateTracker.stringToIpAddr(((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.ipAddress);
                    DhcpHandler dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        if (this.mCancelCallback) {
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.w((String)WimaxStateTracker.TAG, (String)"[DhcpHandler:EVENT_IP_RENEW] mCancelCallback is true... ignore this");
                            }
                            break;
                        }
                        if (this.mIsRenewing) {
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.w((String)WimaxStateTracker.TAG, (String)"[DhcpHandler:EVENT_IP_RENEW] mIsRenewing is true... ignore this");
                            }
                            break;
                        }
                        this.mIsRenewing = true;
                    }
                    WimaxStateTracker.this.mDhcpStart = new Date().getTime();
                    if (WimaxStateTracker.this.m_bLog) {
                        Log.d((String)WimaxStateTracker.TAG, (String)("[handleMessage : DhcpStart is " + WimaxStateTracker.this.mDhcpStart + "ms"));
                    }
                    WimaxStateTracker.this.acquire_WakeLock();
                    WimaxStateTracker.this.mAlarmManager.cancel(WimaxStateTracker.this.mDhcpRenewIntent);
                    DhcpInfoInternal renewInfo = new DhcpInfoInternal();
                    if (NetworkUtils.runDhcpRenew((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfoInternal)renewInfo)) {
                        WimaxStateTracker.this.mDhcpInfoInt = renewInfo;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.i((String)"mydhcp", (String)("dhcp runDhcpRenew1 " + WimaxStateTracker.this.mDhcpInfoInt));
                        }
                        event = 2;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.v((String)WimaxStateTracker.TAG, (String)("New IP : " + WimaxStateTracker.this.mDhcpInfoInt.toString()));
                        }
                        nNewIP = WimaxStateTracker.stringToIpAddr(((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.ipAddress);
                        if (WimaxStateTracker.this.mnOldIP != nNewIP) {
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.v((String)WimaxStateTracker.TAG, (String)"mnOldIP != nNewIP");
                            }
                            WimaxStateTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.FAILED, null, null);
                            WimaxStateTracker.this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.INVALID);
                        }
                    } else {
                        event = 3;
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] DHCP request failed: " + NetworkUtils.getDhcpError()));
                        }
                        WimaxStateTracker.this.mDhcpStart = new Date().getTime();
                        if (WimaxStateTracker.this.m_bLog) {
                            Log.d((String)WimaxStateTracker.TAG, (String)("[handleMessage : 2nd DhcpStart is " + WimaxStateTracker.this.mDhcpStart + "ms"));
                        }
                        if (NetworkUtils.runDhcpRenew((String)WimaxStateTracker.this.mInterfaceName, (DhcpInfoInternal)renewInfo)) {
                            WimaxStateTracker.this.mDhcpInfoInt = renewInfo;
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.i((String)"mydhcp", (String)("dhcp runDhcpRenew2 " + WimaxStateTracker.this.mDhcpInfoInt));
                            }
                            event = 2;
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.v((String)WimaxStateTracker.TAG, (String)("2nd New IP : " + WimaxStateTracker.this.mDhcpInfoInt.toString()));
                            }
                            nNewIP = WimaxStateTracker.stringToIpAddr(((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.ipAddress);
                            if (WimaxStateTracker.this.mnOldIP != nNewIP) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.v((String)WimaxStateTracker.TAG, (String)"2nd mnOldIP != nNewIP");
                                }
                                WimaxStateTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.FAILED, null, null);
                                WimaxStateTracker.this.mWimax4GInfo.setSupplicantState(net4GSupplicantState.INVALID);
                            }
                        } else {
                            event = 3;
                            if (WimaxStateTracker.this.m_bLog) {
                                Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] 2nd DHCP request failed: " + NetworkUtils.getDhcpError()));
                            }
                        }
                    }
                    DhcpHandler dhcpHandler3 = this;
                    synchronized (dhcpHandler3) {
                        if (!this.mCancelCallback) {
                            if (event == 2) {
                                if (WimaxStateTracker.this.m_bLog) {
                                    Log.i((String)WimaxStateTracker.TAG, (String)("[DhcpHandler:EVENT_IP_RENEW] mDhcpInfo.leaseDuration = " + ((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.leaseDuration));
                                }
                                long triggerTime = System.currentTimeMillis() + (long)((((WimaxStateTracker)WimaxStateTracker.this).mDhcpInfoInt.leaseDuration - 30) * 1000);
                                WimaxStateTracker.this.mAlarmManager.set(0, triggerTime, WimaxStateTracker.this.mDhcpRenewIntent);
                            }
                            this.mTarget.sendEmptyMessage(event);
                        }
                        this.mIsRenewing = false;
                        break;
                    }
                }
            }
        }

        public synchronized void setCancelCallback(boolean cancelCallback) {
            this.mCancelCallback = cancelCallback;
        }
    }

    private static class WimaxAuthFail {
        int nErrorCode;
        String strError;

        WimaxAuthFail(int nErrorCode, String strError) {
            this.nErrorCode = nErrorCode;
            this.strError = strError;
        }
    }

    private static class WimaxStateChangeResult {
        WimaxState state;
        DeviceStatusInfo.ConnectionProgressInfo info;

        WimaxStateChangeResult(WimaxState state, DeviceStatusInfo.ConnectionProgressInfo info) {
            this.state = state;
            this.info = info;
        }
    }
}

