/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG.wimax;

import android.net.DhcpInfo;
import android.net.fourG.net4GManager;
import android.net.fourG.wimax.IWimax4GManager;
import android.net.fourG.wimax.MruList;
import android.net.fourG.wimax.Wimax4GBaseStationInfo;
import android.net.fourG.wimax.Wimax4GConfiguration;
import android.net.fourG.wimax.Wimax4GDeviceInfo;
import android.net.fourG.wimax.Wimax4GInfo;
import android.net.fourG.wimax.WimaxState;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wimax4GManager
extends net4GManager {
    private static final String TAG = "Wimax4GManager";
    public static final String WIMAX_SERVICE = "WiMax";
    public static final int NETWORK_SPRINT = 0;
    public static final int NETWORK_PRIVATE = 1;
    public static boolean m_bLog;
    public static final int WORK_MODE_STATE_0 = 0;
    public static final int WORK_MODE_STATE_1 = 1;
    public static final int WORK_MODE_STATE_2 = 2;
    public static final int WORK_MODE_STATE_3 = 3;
    public static final String NET_4G_HANDOVER_COMPLETE_ACTION = "android.net.wimax.NET_4G_HANDOVER_COMPLETE_ACTION";
    public static final String EXTRA_4G_CURRENT_SERVING_BS = "newBSID";
    public static final String FREQUENCY_CHANGED_ACTION = "android.net.wimax.FREQUENCY_CHANGED";
    public static final String EXTRA_NEW_FREQUENCY = "newFrequency";
    public static final String MODE_CHANGED_ACTION = "android.net.wimax.MODE_CHANGED";
    public static final String EXTRA_MODE = "usbMode";
    public static final int WIMAX_MODE_NORMAL = 0;
    public static final int WIMAX_MODE_TETHERED = 1;
    public static final int WIMAX_MODE_BACKHAUL = 2;
    public static final int WIMAX_MODE_DM_NORMAL = 3;
    public static final int WIMAX_MODE_DM_BACKHAUL = 4;
    protected static IWimax4GManager mService;
    protected static Wimax4GManager instance;
    protected static Handler mHandler;
    public static final String NETWORK_IP_CHANGED_ACTION = "android.net.wimax.NETWORK_IP_CHANGED";
    public static final String TIME_CHANGED_ACTION = "android.net.wimax.TIME_CHANGED";
    public static final String EXTRA_NEW_TIME = "newTime";
    public static final String SIGNAL_LEVEL_CHANGED_ACTION = "android.net.wimax.SIGNAL_LEVEL_CHANGED";
    public static final String EXTRA_NEW_SIGNAL_LEVEL = "newSignalLevel";
    public static final String WIMAX_DHCP_TIME_ACTION = "android.net.wimax.WIMAX_DHCP_TIME";
    public static final String EXTRA_WIMAX_DHCP_TIME = "newDHCPTime";
    public static final String EXTRA_WIMAX_MRU_LIST = "MruList";
    public static final String EXTRA_WIMAX_MRU_UPDATE_SUBTYPE = "subType";
    public static final String EXTRA_WIMAX_MRU_UPDATE_ERRORVALUE = "ErrorValue";
    public static final String EXTRA_WIMAX_OMADM_RESP_DATA = "WimaxOMADMRespData";
    public static final String EXTRA_WIMAX_OMADM_RESP_STATE = "WimaxOMADMRespState";
    public static final String WIMAX_RESPONSE_ACTION = "android.net.wimax.WIMAX_RESPONSE";
    public static final String EXTRA_WIMAX_RADIO_INFO = "WimaxRadioInfo";
    public static final String WIMAX_WORK_MODE_ACTION = "android.net.wimax.WIMAX_WORK_MODE";
    public static final String EXTRA_WIMAX_WORK_MODE = "WimaxWorkMode";
    public static final String WIMAX_DATA_THROUGHPUT_ACTION = "android.net.wimax.WIMAX_DATA_THROUGHPUT";
    public static final String EXTRA_TIME = "android.net.wimax.EXTRA_TIME";
    public static final String EXTRA_DATA = "android.net.wimax.EXTRA_DATA";
    public static final String EXTRA_THROUGHPUT = "android.net.wimax.EXTRA_THROUGHPUT";
    public static final String WIMAX_AUTH_ERROR = "android.net.wimax.WIMAX_AUTH_ERROR";
    public static final String EXTRA_WIMAX_AUTH_ERROR = "auth_error";
    public static final int WIMAX_FACTORY_DEFAULT_GDB = 0;
    public static final int WIMAX_FACTORY_DEFAULT_ODB = 1;
    public static final int WIMAX_FACTORY_DEFAULT_ALL = 2;
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_LINK_PROPERTIES = "linkProperties";
    public static final String EXTRA_LINK_CAPABILITIES = "linkCapabilities";
    public static final int WIMAX_VI_WHILE_AP_SLEEP = 0;
    public static final int WIMAX_IDLE_WHILE_AP_SLEEP = 1;

    public Wimax4GManager() {
        if (mService == null) {
            IBinder b = ServiceManager.getService((String)WIMAX_SERVICE);
            mService = IWimax4GManager.Stub.asInterface(b);
        }
    }

    public static synchronized Wimax4GManager getInstance() {
        if (instance == null) {
            instance = new Wimax4GManager();
        }
        return instance;
    }

    public Wimax4GManager(IWimax4GManager service, Handler handler) {
        mService = service;
        mHandler = handler;
        instance = this;
    }

    public int connectDefaultNetwork() {
        int nWimaxEnabledState = this.get4GState();
        if (nWimaxEnabledState == 3 || nWimaxEnabledState == 2) {
            if (m_bLog) {
                Log.w((String)TAG, (String)"[connectDefaultNetwork] already enabled");
            }
            this.setLastError(5);
            return 5;
        }
        this.set4GEnabled(true);
        return 0;
    }

    @Override
    public boolean disconnect() {
        int nWimaxEnabledState = this.get4GState();
        if (nWimaxEnabledState == 3 || nWimaxEnabledState == 2) {
            try {
                return mService.disconnect();
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean reassociate() {
        try {
            return mService.reassociate();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean reconnect() {
        try {
            return mService.reconnect();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public Wimax4GInfo getConnectionInfo() {
        try {
            return mService.getConnectionInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public net4GManager.ConnectionStatistics createConnectionStatistics() {
        try {
            return mService.createConnectionStatistics();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public Wimax4GDeviceInfo getDeviceInformation() {
        try {
            return mService.getDeviceInformation();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public DhcpInfo getDhcpInfo() {
        try {
            return mService.getDhcpInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public boolean set4GEnabled(boolean enabled) {
        try {
            return mService.set4GEnabled(enabled);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean is4GEnabled() {
        return this.get4GState() == 3;
    }

    public int[] getNetworkEntryCompleteTimes() {
        try {
            return mService.getNetworkEntryCompleteTimes();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void getNeighborList() {
        try {
            mService.getNeighborList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public net4GManager.RadioInfoTemperature getRadioInfoTemperature() {
        try {
            return mService.getRadioInfoTemperatureResponse();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void getRadioInfo() {
        try {
            mService.getRadioInfoTemperature();
        }
        catch (RemoteException e) {
            return;
        }
    }

    public int getWorkModeState() {
        try {
            return mService.getWorkModeState();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public boolean setWorkModeState(int workMode) {
        try {
            return mService.setWorkModeState(workMode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void getMruList() {
        if (m_bLog) {
            Log.d((String)"getMruList", (String)"getMruList entered");
        }
        try {
            mService.getMruList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public List<MruList> getMruListRsp() {
        if (m_bLog) {
            Log.d((String)"getMruListRsp", (String)"getMruListRsp entered");
        }
        try {
            return mService.getMruListRsp();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean getMruUpdate(List<MruList> list, int nSize) {
        if (m_bLog) {
            Log.d((String)"getMruUpdate", (String)("getMruUpdate nSize : " + nSize));
        }
        try {
            if (nSize == 0) {
                return mService.getMruUpdate("", nSize);
            }
            int nListSize = list.size();
            if (nSize != nListSize) {
                return false;
            }
            String strUpdate = "";
            for (int i = 0; i < nSize; ++i) {
                MruList temp = list.get(i);
                int nCF = temp.getCenterfrequency();
                strUpdate = strUpdate + nCF;
                strUpdate = strUpdate + "#";
                byte bw = temp.getBW();
                strUpdate = strUpdate + bw;
                strUpdate = strUpdate + "#";
                byte fft = temp.getFFTSize();
                strUpdate = strUpdate + fft;
                strUpdate = strUpdate + "#@";
            }
            return mService.getMruUpdate(strUpdate, nSize);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setMruWorking(boolean bWorking) {
        try {
            mService.setMruWorking(bWorking);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean getPersistedWimaxEnabled() {
        try {
            return mService.getPersistedWimaxEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public int get4GState() {
        try {
            return mService.get4GState();
        }
        catch (RemoteException e) {
            return 4;
        }
    }

    public void setWimax4GState(int nWimax4GState) {
        try {
            mService.setWimaxStatus(nWimax4GState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public WimaxState getWimaxState() {
        try {
            return mService.getWimaxState();
        }
        catch (RemoteException e) {
            return WimaxState.UNKNOWN;
        }
    }

    public int getWimaxStateDetail() {
        try {
            return mService.getWimaxStateDetail();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public List<Wimax4GConfiguration> getAvailableNetworks() {
        try {
            return mService.getAvailableNetworks();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void enableLogLevel(int nLoglevel) {
        try {
            mService.enableLogLevel(nLoglevel);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static int calculateSignalLevel(int rssi, int numLevels) {
        return Wimax4GManager.calculateSignalLevel(rssi, 0, numLevels);
    }

    public static int calculateSignalLevel(int nRSSI, int nCINR, int numLevels) {
        if (numLevels != 4) {
            return -1;
        }
        int dwRssiStep = 0;
        dwRssiStep = Wimax4GManager.CheckRSSILevel(nRSSI);
        return dwRssiStep;
    }

    private static int CheckRSSILevel(int nRSSI) {
        if (nRSSI < -93) {
            return 0;
        }
        if (-93 <= nRSSI && nRSSI < -75) {
            return 1;
        }
        if (-75 <= nRSSI && nRSSI < -60) {
            return 2;
        }
        if (-60 <= nRSSI) {
            return 3;
        }
        return 3;
    }

    public void calWiMAXThroughput(boolean bstart) {
        try {
            mService.calWiMAXThroughput(bstart);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public int connect(String homeNspName, String roamingNspName, String userName, String passWord) {
        if (roamingNspName != "") {
            return -1;
        }
        try {
            return mService.connect(homeNspName, roamingNspName, userName, passWord);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    @Override
    public boolean setRoamingEnabled(boolean enabled) {
        try {
            return mService.setRoamingEnabled(enabled);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isRoamingEnabled() {
        try {
            return mService.isRoamingEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean startScan() {
        return this.startScan(false);
    }

    public boolean startScan(boolean bUserReq) {
        try {
            return mService.startScan(bUserReq);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void release_sWakeLock() {
        try {
            mService.release_sWakeLock();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getWimaxMode() {
        try {
            return mService.getWimaxMode();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int setWimaxMode(int nMode, boolean enable) {
        try {
            return mService.setWimaxMode(nMode, enable);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean checkUSBstate() {
        try {
            return mService.checkUSBstate();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Wimax4GBaseStationInfo getConnectedNSP() {
        try {
            return mService.getConnectedNSP();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int makeOdbTlvData(byte[] pBuffer, int nBufferIndex, int wBufferLen, int wTag, int wLength, byte[] pbValue) {
        try {
            return mService.makeOdbTlvData(pBuffer, nBufferIndex, wBufferLen, wTag, wLength, pbValue);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbReadReq(byte[] tlvDataArray) {
        try {
            return mService.OdbReadReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbWriteReq(byte[] tlvDataArray) {
        try {
            return mService.OdbWriteReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbUpdateReq() {
        try {
            return mService.OdbUpdateReq();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbAddReq(byte[] tlvDataArray) {
        try {
            return mService.OdbAddReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int OdbDeleteReq(byte[] tlvDataArray) {
        try {
            return mService.OdbDeleteReq(tlvDataArray);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean setFactoryDefault(int nType) {
        try {
            return mService.setFactoryDefault(nType);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int setVirtualIdleWhileAPsleep(byte bMode) {
        if (bMode == 0 || bMode == 1) {
            try {
                return mService.setVirtualIdleWhileAPsleep(bMode);
            }
            catch (RemoteException e) {
                return -1;
            }
        }
        return -2;
    }

    public int getNetworkConnectionSetting() {
        try {
            return mService.getNetworkConnectionSetting();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int saveStaticIP(String ip, String gateway, String netmask, String dns1, String dns2) {
        try {
            return mService.saveStaticIP(ip, gateway, netmask, dns1, dns2);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public String readStaticIP(int nIndex) {
        try {
            return mService.readStaticIP(nIndex);
        }
        catch (RemoteException e) {
            return "error";
        }
    }

    public int deleteStaticIP() {
        try {
            return mService.deleteStaticIP();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    @Override
    public Lock createLock(int lockType, String tag) {
        return new Lock(lockType, tag);
    }

    @Override
    public Lock createLock(String tag) {
        return new Lock(1, tag);
    }

    public MulticastLock createMulticastLock(String tag) {
        return new MulticastLock(tag);
    }

    public void enableLog(boolean flag) {
        m_bLog = flag;
    }

    public class MulticastLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        private boolean mRefCounted;
        private boolean mHeld;

        private MulticastLock(String tag) {
            this.mTag = tag;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount > 0 : !this.mHeld) {
                    block10: {
                        try {
                            mService.acquireMulticastLock(this.mBinder, this.mTag);
                            Wimax4GManager wimax4GManager = Wimax4GManager.this;
                            synchronized (wimax4GManager) {
                                if (Wimax4GManager.this.mActiveLockCount >= 50) {
                                    mService.releaseMulticastLock();
                                    throw new UnsupportedOperationException("Exceeded maximum number of wimax locks");
                                }
                                Wimax4GManager.this.mActiveLockCount++;
                            }
                        }
                        catch (RemoteException ignore) {
                            if (!m_bLog) break block10;
                            Log.e((String)Wimax4GManager.TAG, (String)"------MulticastLock - acquire RemoteException----------------");
                        }
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    block10: {
                        try {
                            mService.releaseMulticastLock();
                            Wimax4GManager wimax4GManager = Wimax4GManager.this;
                            synchronized (wimax4GManager) {
                                Wimax4GManager.this.mActiveLockCount--;
                            }
                        }
                        catch (RemoteException ignore) {
                            if (!m_bLog) break block10;
                            Log.e((String)Wimax4GManager.TAG, (String)"------MulticastLock - release RemoteException----------------");
                        }
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("MulticastLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }
    }

    public class Lock
    extends net4GManager.Lock {
        private final IBinder mBinder;

        private Lock(int lockType, String tag) {
            this.mTag = tag;
            this.mLockType = lockType;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount > 0 : !this.mHeld) {
                    try {
                        mService.acquireLock(this.mBinder, this.mLockType, this.mTag);
                        Wimax4GManager wimax4GManager = Wimax4GManager.this;
                        synchronized (wimax4GManager) {
                            if (Wimax4GManager.this.mActiveLockCount >= 50) {
                                mService.releaseLock(this.mBinder);
                                throw new UnsupportedOperationException("Exceeded maximum number of Wimax locks");
                            }
                            Wimax4GManager.this.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        mService.releaseLock(this.mBinder);
                        Wimax4GManager wimax4GManager = Wimax4GManager.this;
                        synchronized (wimax4GManager) {
                            Wimax4GManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("WimaxLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "Lock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        mService.releaseLock(this.mBinder);
                        Wimax4GManager wimax4GManager = Wimax4GManager.this;
                        synchronized (wimax4GManager) {
                            Wimax4GManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class WimaxConnectionStatistics
    extends net4GManager.ConnectionStatistics {
        private static final String TAG = "WimaxConnectionStatistics";
        private static final File[] WIMAX_TX_PACKETS = WimaxConnectionStatistics.WimaxFiles("tx_packets");
        private static final File[] WIMAX_RX_PACKETS = WimaxConnectionStatistics.WimaxFiles("rx_packets");
        private static final File[] WIMAX_TX_BYTES = WimaxConnectionStatistics.WimaxFiles("tx_bytes");
        private static final File[] WIMAX_RX_BYTES = WimaxConnectionStatistics.WimaxFiles("rx_bytes");
        private static final byte[] buf = new byte[16];
        public static final Parcelable.Creator<WimaxConnectionStatistics> CREATOR = new Parcelable.Creator<WimaxConnectionStatistics>(){

            public WimaxConnectionStatistics createFromParcel(Parcel in) {
                WimaxConnectionStatistics info = new WimaxConnectionStatistics();
                info.m_lTotalRxBytes = in.readLong();
                info.m_lTotalRxPackets = in.readLong();
                info.m_lTotalTxBytes = in.readLong();
                info.m_lTotalTxPackets = in.readLong();
                return info;
            }

            public WimaxConnectionStatistics[] newArray(int size) {
                return new WimaxConnectionStatistics[size];
            }
        };

        public long getTotalRxBytes() {
            this.m_lTotalRxBytes = WimaxConnectionStatistics.getWimaxStat(WIMAX_RX_BYTES);
            return this.m_lTotalRxBytes;
        }

        public long getTotalRxPackets() {
            this.m_lTotalRxPackets = WimaxConnectionStatistics.getWimaxStat(WIMAX_RX_PACKETS);
            return this.m_lTotalRxPackets;
        }

        public long getTotalTxBytes() {
            this.m_lTotalTxBytes = WimaxConnectionStatistics.getWimaxStat(WIMAX_TX_BYTES);
            return this.m_lTotalTxBytes;
        }

        public long getTotalTxPackets() {
            this.m_lTotalTxPackets = WimaxConnectionStatistics.getWimaxStat(WIMAX_TX_PACKETS);
            return WimaxConnectionStatistics.getWimaxStat(WIMAX_TX_PACKETS);
        }

        public int getDownlinkModulation() {
            return -1;
        }

        public int getUplinkModulation() {
            return -1;
        }

        public int getDownlinkThroughput() throws Exception {
            long mRxStart = this.getTotalRxBytes();
            Thread.sleep(1000L);
            long mRxStop = this.getTotalRxBytes();
            long mDiffRxsize = mRxStop - mRxStart;
            int mThroughput = (int)(mDiffRxsize * 8L);
            return mThroughput;
        }

        public int getUplinkThroughput() throws Exception {
            long mTxStart = this.getTotalTxBytes();
            Thread.sleep(1000L);
            long mTxStop = this.getTotalTxBytes();
            long mDiffTxsize = mTxStop - mTxStart;
            int mThroughput = (int)(mDiffTxsize * 8L);
            return mThroughput;
        }

        private static File[] WimaxFiles(String whatStat) {
            File[] files = new File[5];
            files[0] = new File("/sys/class/net/uwbr0/statistics/" + whatStat);
            return files;
        }

        private static long getWimaxStat(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.exists()) continue;
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    return WimaxConnectionStatistics.getNumberFromFile(raf, file.getAbsolutePath());
                }
                catch (IOException e) {
                    if (!m_bLog) continue;
                    Log.e((String)TAG, (String)("Exception opening TCP statistics file " + file.getAbsolutePath()), (Throwable)e);
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static synchronized long getNumberFromFile(RandomAccessFile raf, String filename) {
            try {
                raf.read(buf);
                raf.close();
            }
            catch (IOException e) {
                if (m_bLog) {
                    Log.e((String)TAG, (String)("Exception getting TCP bytes from " + filename), (Throwable)e);
                }
                long l = 0L;
                return l;
            }
            finally {
                block15: {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {
                            if (!m_bLog) break block15;
                            Log.e((String)TAG, (String)("Exception closing " + filename), (Throwable)e);
                        }
                    }
                }
            }
            long num = 0L;
            for (int i = 0; i < buf.length && buf[i] >= 48 && buf[i] <= 57; ++i) {
                num *= 10L;
                num += (long)(buf[i] - 48);
            }
            return num;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(TAG);
            String none = "<none>";
            sb.append("TotalRxBytes: ").append(this.m_lTotalRxBytes).append(", TotalRxPackets: ").append(this.m_lTotalRxPackets).append(", TotalTxBytes: ").append(this.m_lTotalTxBytes).append(", TotalTxPackets: ").append(this.m_lTotalTxPackets);
            return sb.toString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.m_lTotalRxBytes);
            dest.writeLong(this.m_lTotalRxPackets);
            dest.writeLong(this.m_lTotalTxBytes);
            dest.writeLong(this.m_lTotalTxPackets);
        }
    }

    public static class WimaxRadioInfoTemperature
    extends net4GManager.RadioInfoTemperature {
        int m_nIdleMode;
        int m_nSleepMode;
        int m_nIdleModeTimer;
        int m_nPseudoMode;
        public static final Parcelable.Creator<WimaxRadioInfoTemperature> CREATOR = new Parcelable.Creator<WimaxRadioInfoTemperature>(){

            public WimaxRadioInfoTemperature createFromParcel(Parcel in) {
                WimaxRadioInfoTemperature radioInfo = new WimaxRadioInfoTemperature();
                radioInfo.m_nTemperature = in.readInt();
                radioInfo.m_nIdleMode = in.readInt();
                radioInfo.m_nSleepMode = in.readInt();
                radioInfo.m_nIdleModeTimer = in.readInt();
                radioInfo.m_nPseudoMode = in.readInt();
                radioInfo.m_nMaxTemp = in.readInt();
                radioInfo.m_nMinTemp = in.readInt();
                return radioInfo;
            }

            public WimaxRadioInfoTemperature[] newArray(int size) {
                return new WimaxRadioInfoTemperature[size];
            }
        };

        WimaxRadioInfoTemperature() {
        }

        void setValue(int nTemperature, int nIdleMode, int nSleepMode, int nIdleModeTimer, int npseudoMode) {
            this.m_nTemperature = nTemperature;
            this.m_nIdleMode = nIdleMode;
            this.m_nSleepMode = nSleepMode;
            this.m_nIdleModeTimer = nIdleModeTimer;
            this.m_nPseudoMode = npseudoMode;
            try {
                this.m_nMaxTemp = mService.getMaxTemperature();
                this.m_nMinTemp = mService.getMinTemperature();
                if (nTemperature > this.m_nMaxTemp) {
                    this.m_nMaxTemp = this.m_nTemperature;
                    mService.setMaxTemperature(this.m_nTemperature);
                }
                if (nTemperature < this.m_nMinTemp) {
                    this.m_nMinTemp = this.m_nTemperature;
                    mService.setMinTemperature(this.m_nTemperature);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        public int describeContents() {
            return 0;
        }

        public int getCurrent() {
            return this.m_nTemperature;
        }

        public float getWimaxRadioTemperature() {
            return this.m_nTemperature;
        }

        public boolean resetMinMax() {
            try {
                mService.setMaxTemperature(-9999);
                mService.setMinTemperature(9999);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return true;
        }

        public boolean getWimaxIdleMode() {
            return this.m_nIdleMode != 0;
        }

        public boolean getWimaxSleepMode() {
            return this.m_nSleepMode != 0;
        }

        public long getWimaxIdleModeTimer() {
            return this.m_nIdleModeTimer;
        }

        public boolean getPseudoIdentityEnabled() {
            return this.m_nPseudoMode != 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("WimaxRadioInfoTemperature: ");
            builder.append("Temperature: ").append(this.m_nTemperature).append(", IdleMode: ").append(this.m_nIdleMode).append(", SleepMode: ").append(this.m_nSleepMode).append(", IdleModeTimer").append(this.m_nIdleModeTimer).append(", m_nMaxTemp").append(this.m_nMaxTemp).append(", m_nMinTemp").append(this.m_nMinTemp).append(", PseudoMode").append(this.m_nPseudoMode);
            return builder.toString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.m_nTemperature);
            dest.writeInt(this.m_nIdleMode);
            dest.writeInt(this.m_nSleepMode);
            dest.writeInt(this.m_nIdleModeTimer);
            dest.writeInt(this.m_nPseudoMode);
            dest.writeInt(this.m_nMaxTemp);
            dest.writeInt(this.m_nMinTemp);
        }

        protected void finalize() throws Throwable {
            try {
                mService.setMaxTemperature(this.m_nMaxTemp);
                mService.setMinTemperature(this.m_nMinTemp);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            super.finalize();
        }
    }
}

