/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG;

import android.os.Parcelable;

public abstract class net4GBaseStationInfo
implements Parcelable {
    protected String m_strBSID;
    protected boolean m_bIsConnected;
    protected int m_nRSSI;
    protected int m_nCINR;
    protected int m_lNspId;
    protected long m_nFrequencyUplink;
    protected long m_nFrequencyDownlink;
    protected int networkType;

    public NSP_NETWORK_TYPE getNetworkType() {
        if (!this.m_bIsConnected) {
            return NSP_NETWORK_TYPE.NSP_NETWORK_TYPE_UNKNOWN;
        }
        switch (this.networkType) {
            case 0: {
                return NSP_NETWORK_TYPE.NSP_NETWORK_TYPE_HOME;
            }
            case 1: {
                return NSP_NETWORK_TYPE.NSP_NETWORK_TYPE_PARTNER;
            }
            case 2: {
                return NSP_NETWORK_TYPE.NSP_NETWORK_TYPE_ROAMING_PARTNER;
            }
        }
        return NSP_NETWORK_TYPE.NSP_NETWORK_TYPE_UNKNOWN;
    }

    public long getFrequencyUplink() {
        if (!this.m_bIsConnected) {
            return -1L;
        }
        return this.m_nFrequencyUplink;
    }

    public long getFrequencyDownlink() {
        if (!this.m_bIsConnected) {
            return -1L;
        }
        return this.m_nFrequencyDownlink;
    }

    public String getBSID() {
        return this.m_strBSID;
    }

    void setIsConnected(boolean bIsConnected) {
        this.m_bIsConnected = bIsConnected;
    }

    public boolean isConnected() {
        return this.m_bIsConnected;
    }

    public int getRSSI() {
        if (!this.m_bIsConnected) {
            return -1;
        }
        return this.m_nRSSI;
    }

    public int getCINR() {
        if (!this.m_bIsConnected) {
            return -1;
        }
        return this.m_nCINR;
    }

    public int getNspId() {
        if (!this.m_bIsConnected) {
            return -1;
        }
        return this.m_lNspId;
    }

    float getLongitude() {
        return 999.0f;
    }

    float getLatitude() {
        return 999.0f;
    }

    int getRTD() {
        return -1;
    }

    int getRTDMeasurementAge() {
        return -1;
    }

    int getRTDMeasurementError() {
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("net4GBaseStationInfo: ");
        String none = "<none>";
        sb.append(", BSID: ").append(this.m_strBSID == null ? none : this.m_strBSID).append(", IsConnected: ").append(this.m_bIsConnected ? "true" : "false").append(", RSSI: ").append(this.m_nRSSI).append(", CINR: ").append(this.m_nCINR).append(", Nsp ID: ").append(this.m_lNspId).append(", Frequency: ").append(this.m_nFrequencyDownlink);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NSP_NETWORK_TYPE {
        NSP_NETWORK_TYPE_HOME,
        NSP_NETWORK_TYPE_PARTNER,
        NSP_NETWORK_TYPE_ROAMING_PARTNER,
        NSP_NETWORK_TYPE_UNKNOWN;

    }
}

