#ifndef __AMS403GF01_ACL_H__
#define __AMS403GF01_ACL_H__


typedef enum 
{
    ACL_STATUS_0P = 0,
    ACL_STATUS_40P,    
    ACL_STATUS_43P,    
    ACL_STATUS_45P,    
    ACL_STATUS_47P,    
    ACL_STATUS_48P,    
    ACL_STATUS_50P,   
    ACL_STATUS_MAX
} ACL_STATUS;


const unsigned char acl_cutoff_0p_param_set[] = {   /* DUMMY */
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,
};

const unsigned char acl_cutoff_40p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x0E, 0x1B, 0x26, 0x2E,       	
	0x36, 0x3B, 0x41, 0x46,
};

const unsigned char acl_cutoff_43p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x10, 0xAC, 0x28, 0x31,       	
	0x3A, 0x40, 0x46, 0x4B,
};

const unsigned char acl_cutoff_45p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x10, 0x20, 0x2B, 0x35,       	
	0x3D, 0x44, 0x4A, 0x50,
};

const unsigned char acl_cutoff_47p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x11, 0x21, 0x2D, 0x38,      	
	0x41, 0x49, 0x4F, 0x55,
};

const unsigned char acl_cutoff_48p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x11, 0x21, 0x2E, 0x39,       	
	0x42, 0x4A, 0x51, 0x57,
};

const unsigned char acl_cutoff_50p_param_set[] = {
	0xC1,
	0x4D, 0x4B,	0x1D, 0x4B,
	0x00, 0x00,	0x01, 0xDF,
	0x03, 0x20,	0x03, 0x7B,
	0x00, 0x00, 0x00, 0x00,       	
	0x00, 0x00, 0x00, 0x00,       	
	0x13, 0x23, 0x30, 0x3C,       	
	0x45, 0x4C, 0x54, 0x5A,
};

const unsigned char * acl_cutoff_param_set_tbl[ACL_STATUS_MAX] = {
    acl_cutoff_0p_param_set,
	acl_cutoff_40p_param_set,
	acl_cutoff_43p_param_set,
	acl_cutoff_45p_param_set,
	acl_cutoff_47p_param_set,
	acl_cutoff_48p_param_set,
	acl_cutoff_50p_param_set, 
};

#endif /* __AMS403GF01_ACL_H__ */
