#ifndef __GPIO_SETTINGS_H_
#define __GPIO_SETTINGS_H_

#define S3C_GPIO_SETPIN_ZERO	0
#define S3C_GPIO_SETPIN_ONE 	1
#define S3C_GPIO_SETPIN_NONE	2

#define S3C_GPIO_EINT S3C_GPIO_SPECIAL(0xF)

//	GPIO Initialization table
//	{pin number,      pin conf,        pin value,            pullup/down config}
static unsigned int initial_gpio_table[][4] =
{
#if 0
	// GPB ---------------------------------------------------------------------
	{S5PV210_GPB(0),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPB(1),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
        {S5PV210_GPB(2),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPB(3),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPB(4),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPB(5),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPB(6),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPB(7),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 

	// GPC0 --------------------------------------------------------------------
	{S5PV210_GPC0(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC0(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC0(4), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 

	// GPC1 --------------------------------------------------------------------
	{S5PV210_GPC1(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC1(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC1(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC1(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPC1(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPD0 --------------------------------------------------------------------
	{S5PV210_GPD0(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD0(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},  //check
	{S5PV210_GPD0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPD1 --------------------------------------------------------------------
	{S5PV210_GPD1(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD1(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD1(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD1(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD1(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPD1(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPE0 --------------------------------------------------------------------
	{S5PV210_GPE0(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE0(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPE1 --------------------------------------------------------------------
	{S5PV210_GPE1(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE1(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE1(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE1(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPE1(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPF3 --------------------------------------------------------------------
	{S5PV210_GPF3(4), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPF3(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPG0 --------------------------------------------------------------------
	{S5PV210_GPG0(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG0(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG0(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG0(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG0(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPG1 --------------------------------------------------------------------
	{S5PV210_GPG1(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG1(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG1(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG1(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG1(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG1(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG1(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPG2 --------------------------------------------------------------------
	{S5PV210_GPG2(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG2(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG2(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPG2(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG2(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG2(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG2(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPG3 --------------------------------------------------------------------
	{S5PV210_GPG3(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPG3(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPH0 --------------------------------------------------------------------
	{S5PV210_GPH0(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH0(6), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPH0(7), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 

	// GPH1 --------------------------------------------------------------------
	{S5PV210_GPH1(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH1(7), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 

	// GPH2 --------------------------------------------------------------------
#ifdef CONFIG_S5PV210_GARNETT_DELTA
	{S5PV210_GPH2(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
#else
	{S5PV210_GPH2(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
#endif
	{S5PV210_GPH2(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPH2(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH2(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP}, 	// DOWN
	{S5PV210_GPH2(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH2(5), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH2(6), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP}, 
	{S5PV210_GPH2(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 

	// GPH3 --------------------------------------------------------------------
	{S5PV210_GPH3(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
#ifdef CONFIG_S5PV210_GARNETT_DELTA
	{S5PV210_GPH3(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
#else
	{S5PV210_GPH3(1), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
#endif
	{S5PV210_GPH3(2), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPH3(3), S3C_GPIO_EINT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH3(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH3(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPH3(6), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPH3(7), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_DOWN}, 

	// GPI ---------------------------------------------------------------------
	{S5PV210_GPI(0),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPI(1),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPI(2),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPI(3),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPI(4),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPI(5),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPI(6),  S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPJ0 --------------------------------------------------------------------
	{S5PV210_GPJ0(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ0(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ0(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ0(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ0(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ0(5), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ0(6), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ0(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// GPJ1 --------------------------------------------------------------------
	{S5PV210_GPJ1(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ1(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ1(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ1(3), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ1(4), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ1(5), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 

	// GPJ2 --------------------------------------------------------------------
	{S5PV210_GPJ2(0),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
        {S5PV210_GPJ2(1),  S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ2(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ2(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ2(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ2(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ2(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ2(7), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 

	// GPJ3 --------------------------------------------------------------------
	{S5PV210_GPJ3(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ3(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ3(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_GPJ3(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_GPJ3(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_GPJ3(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_GPJ3(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_GPJ3(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},

	// GPJ4 --------------------------------------------------------------------
	{S5PV210_GPJ4(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ4(1), S3C_GPIO_EINT,   S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},  
	{S5PV210_GPJ4(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ4(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, 
	{S5PV210_GPJ4(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// MP01 --------------------------------------------------------------------
	{S5PV210_MP01(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP01(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP01(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP01(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP01(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP01(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP01(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP01(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// MP02 --------------------------------------------------------------------
	{S5PV210_MP02(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP02(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP02(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// MP03 --------------------------------------------------------------------
//	{S5PV210_MP03(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP03(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
//	{S5PV210_MP03(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP03(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP03(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP03(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP03(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// MP04 --------------------------------------------------------------------
	{S5PV210_MP04(0), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP04(1), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_MP04(2), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP04(3), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
	{S5PV210_MP04(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP04(5), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP04(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP04(7), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 

	// MP05 --------------------------------------------------------------------
	{S5PV210_MP05(4), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
	{S5PV210_MP05(6), S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, 
#else
//==========================================================================================
// Forte
	{S5PV210_GPG3(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ONE, S3C_GPIO_PULL_NONE},//GPIO_DISPLAY_BL_EN,,,
	{S5PV210_GPJ3(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BL_SCL_28V, 
        {S5PV210_GPJ3(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BL_SDA_28V,,
	 {S5PV210_MP01(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_DISPLAY_CS,,,

	{S5PV210_GPG0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_CLK,
        {S5PV210_GPG0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_CMD,,
        {S5PV210_GPG0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D0,,
       {S5PV210_GPG0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D1,
        {S5PV210_GPG0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D2,,
        {S5PV210_GPG0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D3,,

        {S5PV210_GPH0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_ACC_INT,
        {S5PV210_GPA0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN6,
        {S5PV210_GPJ0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_MEGA_EN,
        {S5PV210_GPG3(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_TA_CURRENT_SEL_AP,
        {S5PV210_GPA1(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CP_RST,,
        {S5PV210_GPA1(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN7,,
        {S5PV210_GPB(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//PIO_GPB0/*GPIO_LTE_SPI_CLK*/,
        {S5PV210_GPD0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},// GPIO_GPD00/* NC */
        {S5PV210_GPD0(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPD02/*GPIO_LTE_SPI_CS*/ 
        {S5PV210_GPB(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},// GPIO_GPB2/*GPIO_LTE_SPI_MISO*/ 
        {S5PV210_GPA0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},// GPIO_GPA04/* NC MBjclee 2011.02.25 */ 
        {S5PV210_GPA0(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPA07/* NC MBjclee 2011.02.25 *//*GPIO_LTE_SPI_MOSI*/ 
        {S5PV210_GPJ3(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BL_SCL_28V, 
        {S5PV210_GPJ3(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BL_SDA_28V,, 
        {S5PV210_GPH0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BUCK_1_EN_A,,, 
        {S5PV210_GPB(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BUCK_2_EN,, 
        {S5PV210_GPC0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC00,,, 
        {S5PV210_GPC1(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC10, 
        {S5PV210_GPC1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC11,, 
        {S5PV210_GPC1(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC12,,, 
        {S5PV210_GPC1(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC13,, 
        {S5PV210_GPC1(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPC14,,, 
        {S5PV210_GPB(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BOOT_MODE,,, 
        {S5PV210_GPD0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_VIBTONE_PWM,,,, 
        {S5PV210_GPB(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ONE, S3C_GPIO_PULL_NONE},//GPIO_MSENSE_nRST,, 
        {S5PV210_GPJ0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP},//GPIO_TOUCH_INT,, 
        {S5PV210_GPD1(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_CAM_SDA_28V,,, 
        {S5PV210_GPD1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_CAM_SCL_28V,,, 
        {S5PV210_GPJ3(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_AP_SDA_28V,,,, 

{S5PV210_GPJ3(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_AP_SCL_28V,,, 
        {S5PV210_GPD1(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_TSP_SDA_28V,,,, 
        {S5PV210_GPD1(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_TSP_SCL_28V,, 
        {S5PV210_GPE0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_PCLK,,, 
        {S5PV210_GPE0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_VSYNC,,, 
        {S5PV210_GPE0(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_HSYNC,,,, 
        {S5PV210_GPE0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D0,,,,, 
        {S5PV210_GPE0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D1,,, 
        {S5PV210_GPE0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D2,,,, 
        {S5PV210_GPE0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D3,,,,, 
        {S5PV210_GPE0(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D4,,,,, 
        {S5PV210_GPE1(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D5,,,,, 
        {S5PV210_GPE1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D6,,, 
        {S5PV210_GPE1(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_D7,,, 
        {S5PV210_GPE1(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_MCLK,, 
        {S5PV210_GPJ1(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CAM_MEGA_nRST,,, 
        {S5PV210_GPF3(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CODEC_LDO_EN,, 
        {S5PV210_GPF3(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPF35/*GPIO_LTE_WAKE_INT*/,, 
        {S5PV210_GPG0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_CLK,
        {S5PV210_GPG0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_CMD,,
        {S5PV210_GPJ4(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_AP_PMIC_SCL,,
        {S5PV210_GPG0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D0,,
        {S5PV210_GPG0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D1,
        {S5PV210_GPG0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D2,,
        {S5PV210_GPG0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_NAND_D3,,

// WLAN PART 
        {S5PV210_GPG1(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_CLK,,,
        {S5PV210_GPG1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_CMD,,,,
        {S5PV210_GPG1(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_nRST,,,,,
        {S5PV210_GPG1(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_D0,,,
        {S5PV210_GPG1(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_D1,,
        {S5PV210_GPG1(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_D2,,,
        {S5PV210_GPG1(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_SDIO_D3,,,
//

        {S5PV210_GPG2(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_CLK,,
        {S5PV210_GPG2(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_CMD,,,
        {S5PV210_GPG3(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ONE, S3C_GPIO_PULL_NONE},//GPIO_DISPLAY_BL_EN,,,
        {S5PV210_GPG2(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_D0,,
        {S5PV210_GPG2(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_D1,,
        {S5PV210_GPG2(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_D2,,
        {S5PV210_GPG2(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_T_FLASH_D3,,
        {S5PV210_GPG2(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_FM_SDA_28V,,,
        {S5PV210_GPJ2(7), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},//GPIO_MASSMEMORY_EN,,,,
        {S5PV210_GPG0(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_FM_SCL_28V,,,
        {S5PV210_GPB(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BT_nRST,,,
        {S5PV210_GPG3(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BT_WAKE,,,,
        {S5PV210_GPB(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_WLAN_BT_EN,,,
        {S5PV210_GPJ4(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_PMIC_SDA,,

//Alive is ignored , Add later here
#if 0
//Nilesh
        {S5PV210_GPH0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_AP_PS_HOLD,,,
        {S5PV210_GPH0(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_PS_VOUT,,,
        {S5PV210_GPH1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_3P_SEND_END,,,
        {S5PV210_GPH1(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_WLAN_HOST_WAKE,,,
        {S5PV210_GPH1(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_BT_HOST_WAKE,,
        {S5PV210_GPH0(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_HALL_SW,,,
        {S5PV210_GPH0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_EAR_DET,,,,
        {S5PV210_GPH0(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_AP_PMIC_IRQ,,,,,
        {S5PV210_MP03(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_MP033/*GPIO_LTE_ACTIVE*/,,
        {S5PV210_GPJ0(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ01/* NC */
        {S5PV210_GPH1(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_GAUGE_ALT,
        {S5PV210_GPH1(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_nINT_ONEDRAM_AP,,
  //      {S5PV210_GPB(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPB6/* NC */,,,
        {S5PV210_GPH1(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_EAR_SEND_END,
        {S5PV210_GPA0(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_DOWN},//GPIO_GPA06,,
        {S5PV210_GPH1(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_PHONE_ACTIVE,,,
        #if 1
        {S5PV210_GPH2(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN0,,,,
        {S5PV210_GPH2(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN1,,,
        {S5PV210_GPH2(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN2,,,
        {S5PV210_GPH2(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN3,,,,
        {S5PV210_GPH2(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN4,,,,,
        {S5PV210_GPH2(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSCAN5,,,
        #endif
        {S5PV210_GPH2(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_nPOWER,,,
        {S5PV210_GPH2(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_JACK_nINT,,,,
        #if 1
        {S5PV210_GPH3(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP},//GPIO_KEYSENSE0,,,,,
        {S5PV210_GPH3(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE1,,,,,
        {S5PV210_GPH3(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE2,,,,,
        {S5PV210_GPH3(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE3,,,,,
        {S5PV210_GPH3(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE4,,,,,
        {S5PV210_GPH3(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE5,,,,,
        {S5PV210_GPH3(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE6,,,,,
        {S5PV210_GPH3(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_KEYSENSE6,,,,,
        #endif

#endif
//
        {S5PV210_GPI(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CODEC_I2S_CLK,,,
        {S5PV210_GPI(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPI1,,
        {S5PV210_GPI(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CODEC_I2S_WS,,,
        {S5PV210_GPI(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CODEC_I3S_DI,,
        {S5PV210_GPI(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_CODEC_I3S_DO,,,
        {S5PV210_GPI(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPI5,,
        {S5PV210_GPI(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPI6,,,
        {S5PV210_GPJ0(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_POPUP_WN_EN,,,,
        {S5PV210_GPH0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_BUCK_1_EN_B,,,,,
        {S5PV210_GPJ0(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ02,,,,
        {S5PV210_GPJ0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ03,,,,
        {S5PV210_GPJ0(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ04,,,,
        {S5PV210_GPJ2(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ20/*GPIO_GPJ05*/,,
        {S5PV210_GPD0(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPD03/*GPIO_GPJ06*/
        {S5PV210_GPJ0(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ07
        {S5PV210_GPJ1(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_PHONE_ON,
        {S5PV210_GPJ1(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_VIBTONE_EN1,,
        {S5PV210_GPJ4(2), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},//GPIO_MICBIAS_EN,,,
        {S5PV210_GPJ1(3), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},//GPIO_TOUCH_EN,,,,
        {S5PV210_GPJ1(4), S3C_GPIO_INPUT/* NC */, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_DOWN},//GPIO_GPJ14,,
        {S5PV210_GPJ1(2)/*GPIO_GPJ15*/, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_GPJ12/,,

/* memory part */
	{S5PV210_MP01(0), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},//GPIO_MAIN_KEY_LED_EN,,,
        {S5PV210_MP01(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_DISPLAY_CS,,,
        {S5PV210_MP01(2)/*GPIO_LTE_OP_MODE_0*/, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP012/,,
        //{S5PV210_MP01(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_UART_SEL1,, //
	//above pin must b output

//--------------------------------------------------------------------------------------------------------------	
//        {S5PV210_MP01(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_NANDCS,,,
#if 0
        {S5PV210_MP01(5)/*GPIO_LTE_OP_MODE_1*/, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP015/,,, //

	{S5PV210_MP01(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP016,,,, 			   //these 3 		
        {S5PV210_MP01(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP017,,,			   //lines for 
        //{S5PV210_MP02(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_ALS_EN,,,,
	//above pin shud nt b IP Pul dwn , as it is nt NC , its ALS_EN which is OUT Pin
        //{S5PV210_MP02(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_USB_SEL,,,
	////above pin shud nt b IP Pul dwn , as it is nt NC , its USB_EN which is OUT Pin
        //{S5PV210_MP02(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_VCC_18V_PDA,,,,
	//above pin is VCC_18V , its same as ATLAS n it is nt configured in atlas also

        {S5PV210_MP02(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP023,,,,, NC  /
        {S5PV210_MP03(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP030,,,a  NC  / These four lines
        {S5PV210_MP03(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP031,,,,  NC  / are responsible for FSR fail
        {S5PV210_MP03(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP032,,,,, NC  /
        //{S5PV210_MP03(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},//GPIO_VCC_28V_PDA,,,,,,
	//above pin is VCC_18V , its same as ATLAS n it is nt configured in atlas also
        {S5PV210_MP03(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP035,,,, NC
        {S5PV210_MP03(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP036,,,,,NC
        {S5PV210_MP03(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP037,,,,NC
        {S5PV210_MP04(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP040,,,,, NC 
#endif
#if 0
	{S5PV210_MP04(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP042,,,
        {S5PV210_MP04(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP043,,,,
        {S5PV210_MP04(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP044,,,
        {S5PV210_MP04(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP045,,,
        {S5PV210_MP04(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP046,,,
        {S5PV210_MP04(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP047,,,
        {S5PV210_MP05(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//FUEL_SCL_18V,,,,
        {S5PV210_MP05(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//FUEL_SDA_18V,,,,
        {S5PV210_MP05(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_SDA_18V,,,,,
        {S5PV210_MP05(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_SCL_18V,,,
        {S5PV210_MP05(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP054,,,,
        {S5PV210_MP05(5)/*GPIO_LTE_DP_INT*/, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP055/,,,,
        {S5PV210_MP05(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP056,,,,,
        {S5PV210_MP06(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP060,,,,
        {S5PV210_MP06(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP061,,,,
        {S5PV210_MP06(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP062,,,,
        {S5PV210_MP06(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP063,,,,
        {S5PV210_MP06(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP064,,,,
        {S5PV210_MP06(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP065,,,,
        {S5PV210_MP06(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP066,,,,
        {S5PV210_MP06(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP067,,,,


	{S5PV210_MP07(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP070,,,,,
        {S5PV210_MP07(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP071,,,,,
        {S5PV210_MP07(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP072,,,,,
        {S5PV210_MP07(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP073,,,,,
        {S5PV210_MP07(4), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP074,,,,,
        {S5PV210_MP07(5), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP075,,,,,
        {S5PV210_MP07(6), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP076,,,,,
        {S5PV210_MP07(7), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_MP077,,,,,

#endif

	{S5PV210_MP04(1), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_DOWN},//GPIO_MAIN_KEY_LED_REV03_EN,,,,,,
        
	{S5PV210_MP05(0), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//FUEL_SCL_18V,,,,
        {S5PV210_MP05(1), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//FUEL_SDA_18V,,,,
        {S5PV210_MP05(3), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_SDA_18V,,,,,
        {S5PV210_MP05(2), S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},//GPIO_AP_SCL_18V,,,

#endif //main #if 
/**/

};



//	off part GPIO Sleep Control table
//	{pin number,      sleep mode conf,    sleep pullup/down config}
static unsigned int sleep_gpio_table[][3] =
{
	// GPA0 -------------------------------------------------
	{GPIO_BT_UART_RXD, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},
    	{GPIO_BT_UART_TXD, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},
    	{GPIO_BT_UART_CTS, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},
    	{GPIO_BT_UART_RTS, S3C_GPIO_SLP_OUT1, S3C_GPIO_PULL_NONE},
    	{GPIO_ACC_INT, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},    /* ACC_INT */
	{GPIO_GPA04, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
//	{GPIO_KEYSCAN6, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},
	{GPIO_GPA06, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
    	{GPIO_CAM_MEGA_EN, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},  /* CAM_MEGA_EN */
    	{GPIO_TA_CURRENT_SEL_AP, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},    /* TA_CURRENT_SEL(CHG_DET) */

	// GPA1 -------------------------------------------------
	{GPIO_AP_RXD, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_AP_RXD
	{GPIO_AP_TXD, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_AP_TXD
    	{GPIO_CP_RST, S3C_GPIO_SLP_OUT1, S3C_GPIO_PULL_NONE},   /* CP_RST */
//	{GPIO_KEYSCAN7, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_AP_FLM_TXD

	// GPB	-------------------------------------------------
	{GPIO_GPB0/* NC */, S3C_GPIO_SLP_INPUT/*S3C_GPIO_SLP_OUT0*/, S3C_GPIO_PULL_DOWN},  /* CMC_CLK_2.8V */
        {GPIO_GPD02/* NC *//*GPIO_LTE_SPI_CS*/, S3C_GPIO_SLP_INPUT/*S3C_GPIO_SLP_OUT0*/, S3C_GPIO_PULL_DOWN},    /* CMC_CS_2.8V  */
//        {GPIO_GPB2/*GPIO_LTE_SPI_MISO*/, S3C_GPIO_SLP_OUT0/*S3C_GPIO_SLP_OUT0*/, S3C_GPIO_PULL_NONE},  /* CMC_DO_2.8V  */   // TODO:YUNG_TEST SLEEP_CURRENT  //MBjclee 2011.02.25
	{GPIO_BT_nRST,  S3C_GPIO_SLP_PREV,  S3C_GPIO_PULL_NONE},	//GPIO_BT_nRST
	{GPIO_WLAN_BT_EN,  S3C_GPIO_SLP_PREV,  S3C_GPIO_PULL_NONE},	//GPIO_WLAN_BT_EN

        {GPIO_GPA07/* NC MBjclee 2011.02.23 *//*GPIO_LTE_SPI_MOSI*/, S3C_GPIO_SLP_INPUT/*OUT0->INPUT*//*S3C_GPIO_SLP_OUT0*/, S3C_GPIO_PULL_DOWN/*PN->PD*/},  /* CMC_DI_2.8V  */   // TODO:YUNG_TEST SLEEP_CURRENT
     {GPIO_GPB2, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */			//MBjclee 2011.02.23
     {GPIO_GPB6, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
     {GPIO_GPD00, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
     {GPIO_GPD12, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
     {GPIO_GPD13, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */

	{GPIO_BL_SCL_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* BL_SCL HW PULL_UP */
        {GPIO_BL_SDA_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* BL_SDA HW PULL_UP */
        {GPIO_BUCK_1_EN_A, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* BUCK1_EN_A */
		{GPIO_BUCK_2_EN, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* BUCK2_EN */

	// GPC0 -------------------------------------------------
	{GPIO_GPC00, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
        {GPIO_DISPLAY_CLK, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* LCD_CLK */
        {GPIO_DISPLAY_ID, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* LCD_ID */
        {GPIO_DISPLAY_SI, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* LCD_SI */
        {GPIO_DISPLAY_RST, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},    /* LCD_RST */

	// GPC1 -------------------------------------------------
	{GPIO_GPC10, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPC10
	{GPIO_GPC11, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPC11
	{GPIO_GPC12, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPC12
	{GPIO_GPC13, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPC13
	{GPIO_GPC14, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPC14

    	{GPIO_GPE14, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */		//MBjclee 2011.02.23
    	{GPIO_GPG30, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
    	{GPIO_GPG31, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
    	{GPIO_GPG35, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
    	{GPIO_GPG36, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	/* NC */
	{GPIO_BOOT_MODE, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},      /* BOOT_MODE */
        {GPIO_VIBTONE_PWM, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* VIBTONZ_PWM */
        {GPIO_MSENSE_nRST, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},    /* MSENSE_nRST */
        {GPIO_TOUCH_INT, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* TS_INT HW PULL_UP */

	// GPD1 -------------------------------------------------
	{GPIO_CAM_SDA_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},      /* CAM_SDA_2.8V */
        {GPIO_CAM_SCL_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* CAM_SCL_2.8V */
        {GPIO_AP_SDA_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE}, /*SM:*/
        {GPIO_AP_SCL_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* AP_SCL_2.8V */
//	{GPIO_GPD13, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
        {GPIO_TSP_SDA_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* TSP_SDA_2.8V */
        {GPIO_TSP_SCL_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* TSP_SCL_2.8V */

	// GPE0 -------------------------------------------------
	{GPIO_CAM_PCLK, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},      /* CAM_PCLK */
        {GPIO_CAM_VSYNC, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* CAM_VSYNC */
        {GPIO_CAM_HSYNC, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* CAM_HSYNC */
        {GPIO_CAM_D0, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* CAM_D(0) */
        {GPIO_CAM_D1, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},
        {GPIO_CAM_D2, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},
        {GPIO_CAM_D3, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},
        {GPIO_CAM_D4, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* CAM_D(4) */

	// GPE1 -------------------------------------------------
	{GPIO_CAM_D5, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},
        {GPIO_CAM_D6, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},
        {GPIO_CAM_D7, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* CAM_D(7) */
        {GPIO_CAM_MCLK, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* CAM_MCLK */
        {GPIO_CAM_MEGA_nRST, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},    /* CAM_RST */

	// GPF0 -------------------------------------------------
	{GPIO_DISPLAY_HSYNC, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_DISPLAY_HSYNC
	{GPIO_DISPLAY_VSYNC, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_DISPLAY_VSYNC
	{GPIO_DISPLAY_DE, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_DISPLAY_DE
	{GPIO_DISPLAY_PCLK, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_DISPLAY_PCLK
	{GPIO_LCD_D0, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D0
	{GPIO_LCD_D1, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D1
	{GPIO_LCD_D2, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D2
	{GPIO_LCD_D3, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D3

	// GPF1 -------------------------------------------------
	{GPIO_LCD_D4, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D4
	{GPIO_LCD_D5, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D5
	{GPIO_LCD_D6, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D6
	{GPIO_LCD_D7, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D7
	{GPIO_LCD_D8, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D8
        {GPIO_LCD_D9, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D9
	{GPIO_LCD_D10, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D10
	{GPIO_LCD_D11, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D11

	// GPF2 -------------------------------------------------
	{GPIO_LCD_D12, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D12
	{GPIO_LCD_D13, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D13
	{GPIO_LCD_D14, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D14
	{GPIO_LCD_D15, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D15
	{GPIO_LCD_D16, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D16
	{GPIO_LCD_D17, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D17
	{GPIO_LCD_D18, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D18
	{GPIO_LCD_D19, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D19

	// GPF3 -------------------------------------------------
	{GPIO_LCD_D20, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D20
	{GPIO_LCD_D21, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D21
	{GPIO_LCD_D22, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D22
	{GPIO_LCD_D23, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_LCD_D23
	{GPIO_CODEC_LDO_EN, S3C_GPIO_SLP_PREV,  S3C_GPIO_PULL_NONE},	//GPIO_CODEC_LDO_EN
	{GPIO_GPF35, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPF35

	// GPG0 -------------------------------------------------
	{GPIO_NAND_CLK, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_CLK
	{GPIO_NAND_CMD, S3C_GPIO_SLP_INPUT,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_CMD
        {GPIO_AP_PMIC_SCL, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* AP_PMIC_SCL */
	{GPIO_NAND_D0, S3C_GPIO_SLP_INPUT,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_D0
	{GPIO_NAND_D1, S3C_GPIO_SLP_INPUT,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_D1
	{GPIO_NAND_D2, S3C_GPIO_SLP_INPUT,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_D2
	{GPIO_NAND_D3, S3C_GPIO_SLP_INPUT,  S3C_GPIO_PULL_NONE},	//GPIO_NAND_D3

	// GPG1 -------------------------------------------------
	{GPIO_WLAN_SDIO_CLK, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* WLAN_SDIO_CLK */
        {GPIO_WLAN_SDIO_CMD, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* WLAN_SDIO_CMD HW PULL_UP */
	{GPIO_WLAN_nRST, S3C_GPIO_SLP_PREV,  S3C_GPIO_PULL_NONE},	//GPIO_WLAN_nRST
        {GPIO_WLAN_SDIO_D0, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* WLAN_SDIO_D(0) HW PULL_UP */
        {GPIO_WLAN_SDIO_D1, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* WLAN_SDIO_D(1) HW PULL_UP */
        {GPIO_WLAN_SDIO_D2, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* WLAN_SDIO_D(2) HW PULL_UP */
        {GPIO_WLAN_SDIO_D3, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* WLAN_SDIO_D(3) HW PULL_UP */

	// GPG2 -------------------------------------------------
	{GPIO_T_FLASH_CLK, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_T_FLASH_CLK
        {GPIO_T_FLASH_CMD, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* T_FLASH_CMD */
        {GPIO_DISPLAY_BL_EN, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* LCD_BL_EN check HW Pull-up */
        {GPIO_T_FLASH_D0, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* T_FLASH_D(0) */
        {GPIO_T_FLASH_D1, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* T_FLASH_D(1) */
        {GPIO_T_FLASH_D2, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* T_FLASH_D(2) */
        {GPIO_T_FLASH_D3, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},  /* T_FLASH_D(3) */

	// GPG3 -------------------------------------------------
	{GPIO_FM_SDA_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* FM_SDA */
        {GPIO_MASSMEMORY_EN, S3C_GPIO_SLP_OUT1, S3C_GPIO_PULL_NONE},  /* MASSMEMORY_EN HW PULL_DOWN */ // iamaj GPIO_MASSMEMORY_EN (always turn on MoviNAND power)
        {GPIO_FM_SCL_28V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* FM_SCL */
        {GPIO_BT_nRST, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},    /* BT_nRST */
	{GPIO_BT_WAKE, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_BT_WAKE
        {GPIO_WLAN_BT_EN, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},   /* WLAN_BT_EN */
        {GPIO_AP_PMIC_SDA, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* PMIC_SDA */


	// GPI --------------------------------------------------
    	{GPIO_CODEC_I2S_CLK, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* AP_I2S_CLK */
	{GPIO_GPI1,  S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPI1
        {GPIO_CODEC_I2S_WS, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* AP_I2S_SYNC */
        {GPIO_CODEC_I3S_DI, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* AP_I2S_DI */
        {GPIO_CODEC_I3S_DO, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},   /* AP_I2S_DO */
	{GPIO_GPI5,  S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPI5
	{GPIO_GPI6,  S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPI6

	// GPJ0 -------------------------------------------------
	{GPIO_POPUP_WN_EN, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},          /* POPUP_SW_EN */
        {GPIO_BUCK_1_EN_B, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* BUCK1_EN_B */
        {GPIO_GPJ01, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */	//MBjclee 2011.02.23
        {GPIO_GPJ02, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
//	{GPIO_TOUCH_INT, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_TOUCH_INT
//	{GPIO_CAM_MEGA_EN, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_CAM_MEGA_EN
        {GPIO_GPJ03, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */

	// GPJ1 -------------------------------------------------
//	{GPIO_PHONE_ON, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_DOWN},
//	{GPIO_VIBTONE_EN1, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_VIBTONE_EN1
        {GPIO_GPJ04, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
//	{GPIO_TOUCH_EN, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_TOUCH_EN
//	{GPIO_GPJ14, S3C_GPIO_SLP_PREV,  S3C_GPIO_PULL_NONE},
//	{GPIO_CAM_MEGA_nRST, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_CAM_MEGA_nRST

	// GPJ2 -------------------------------------------------
	{GPIO_GPJ20, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ20
//	{GPIO_GPJ21, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ21
	{GPIO_GPJ21, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ21
        {GPIO_GPJ22, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */	
	{GPIO_GPJ23, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ23
	{GPIO_GPJ24, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ21
	{GPIO_GPJ25, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ21
	{GPIO_GPJ26, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ21
//	{GPIO_MASSMEMORY_EN, S3C_GPIO_SLP_OUT1,  S3C_GPIO_PULL_NONE},	//GPIO_MASSMEMORY_EN
        {GPIO_GPJ30, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */	
	// GPJ3 -------------------------------------------------
        {GPIO_GPJ31, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
        {GPIO_GPJ32, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	
	{GPIO_GPJ33, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_GPJ33
	{GPIO_GPD03/*GPIO_GPJ06*/, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
        {GPIO_GPJ07, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */
        {GPIO_GPJ41, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */	//MBjclee 2011.02.23
        {GPIO_GPJ44, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},      /* NC */	//MBjclee 2011.02.23

	// GPJ4 -------------------------------------------------
	{GPIO_PHONE_ON, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* PHONE_ON */
        {GPIO_VIBTONE_EN1, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* VIBTONE_EN */
        {GPIO_MICBIAS_EN, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},   /* MICBIAS_EN HW PULL_DOWN */
        {GPIO_TOUCH_EN, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* TSP_LDO_ON */
        {GPIO_GPJ14, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},  /* NC */
        {GPIO_GPJ12/*GPIO_GPJ15*/, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},  /* NC */

	// MP01 -------------------------------------------------
	{GPIO_MAIN_KEY_LED_EN, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* MAIN_KEY_LED_EN */
	{GPIO_DISPLAY_CS, S3C_GPIO_SLP_OUT0,  S3C_GPIO_PULL_NONE},	//GPIO_DISPLAY_CS
	{GPIO_MP012, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP012
        {GPIO_UART_SEL1, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* UART_SEL1 */
	{GPIO_AP_NANDCS, S3C_GPIO_SLP_OUT1,  S3C_GPIO_PULL_NONE},	//GPIO_AP_NANDCS
	{GPIO_MP015, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_DIC_ID
        {GPIO_MP016, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},  /* NC */	//MBjclee 2011.02.23 PU->PD
        {GPIO_MP017, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},  /* NC */ //MBjclee 2011.02.23 PU->PD

	// MP02 -------------------------------------------------
	{GPIO_ALS_EN, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},   /* ALS_EN */
        {GPIO_USB_SEL, S3C_GPIO_SLP_PREV, S3C_GPIO_PULL_NONE},   /* USB_SEL */
	{GPIO_VCC_18V_PDA, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},	//GPIO_MP022
        {GPIO_MP023, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* NC */

	// MP03 -------------------------------------------------
	{GPIO_MP030, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP030
	{GPIO_MP031, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP031
	{GPIO_MP032, S3C_GPIO_SLP_OUT1,  S3C_GPIO_PULL_NONE},	//GPIO_MP032
        {GPIO_PDA_ACTIVE, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* PDA_ACTIVE */
        {GPIO_VCC_28V_PDA, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_UP},  /* VCC_PDA_2.8V */
        {GPIO_MP035, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},  /* NC ~ */
        {GPIO_MP036, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},
        {GPIO_MP037, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},

	// MP04 -------------------------------------------------
	{GPIO_MP040, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},
#if defined(CONFIG_FORTE_HW_REV03)
 	{GPIO_MAIN_KEY_LED_REV03_EN, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_DOWN},
#else
         {GPIO_MP041, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
#endif 
	{GPIO_MP042, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP042
        {GPIO_MP043, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP044, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP044
	{GPIO_MP045, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP045
        {GPIO_MP046, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP047, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP047

	// MP05 -------------------------------------------------
	{FUEL_SCL_18V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},	//FUEL_SCL_18V
	{FUEL_SDA_18V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},	//FUEL_SDA_18V
        {GPIO_AP_SDA_18V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* AP_SDA_1.8V */
	{GPIO_AP_SCL_18V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},	//GPIO_AP_SCL_18V
//	{GPIO_AP_SDA_18V, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},	//GPIO_AP_SDA_18V
	{GPIO_MP054, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP054
        {GPIO_MP055/*GPIO_LTE_DP_INT*/, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_NONE},  /* LTE_DP_INT */ // MBjgnoh 10.12.30 PULL_UP -> PULL NONE
	{GPIO_MP056, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},	//GPIO_MP056
        {GPIO_UART_SEL, S3C_GPIO_SLP_OUT0, S3C_GPIO_PULL_NONE},   /* UART_SEL */

	// MP06 -------------------------------------------------
	{GPIO_MP060, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP061, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP062, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP063, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP064, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP065, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP066, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP067, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},

	// MP07 -------------------------------------------------
	{GPIO_MP070, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP071, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP072, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP073, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP074, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP075, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP076, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
	{GPIO_MP077, S3C_GPIO_SLP_INPUT, S3C_GPIO_PULL_DOWN},
};


//	alive part GPIO Sleep Control table
//	{pin number,      sleep mode conf, sleep pin value,      sleep pullup/down config}
static unsigned int sleep_alive_gpio_table[][4] =
{
//	{GPIO_AP_PS_HOLD, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, //pwr hold
//	{GPIO_ACC_INT, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN},
//        {GPIO_PS_VOUT, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ONE, S3C_GPIO_PULL_UP},

//	{GPIO_BUCK_1_EN_A, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_BUCK_1_EN_A
//	{GPIO_BUCK_1_EN_B, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_BUCK_1_EN_B
//	{GPIO_HALL_SW, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_BUCK_2_EN
        {GPIO_EAR_DET, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},
	{GPIO_AP_PMIC_IRQ, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP}, //NONE}, //GPIO_AP_PMIC_IRQ //cross check

//	{GPIO_PDA_ACTIVE, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_UP},
	{GPIO_3P_SEND_END, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //NONE}, //GPIO_GPH11
	{GPIO_GAUGE_ALT, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_GPH11
        //{GPIO_nINT_ONEDRAM_AP, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},
	{GPIO_WLAN_HOST_WAKE, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_GPH14
	{GPIO_EAR_SEND_END, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_DOWN}, //GPIO_GPH15
        {GPIO_BT_HOST_WAKE, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},
	{GPIO_PHONE_ACTIVE, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},

	{GPIO_KEYSCAN0, S3C_GPIO_OUTPUT,  S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},  //GPIO_GPH20
	{GPIO_KEYSCAN1, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, //GPIO_KBC1
       {GPIO_KEYSCAN2, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
       {GPIO_KEYSCAN3, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE}, 
       {GPIO_KEYSCAN4, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
       {GPIO_KEYSCAN5, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
       {GPIO_KEYSCAN6, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
       {GPIO_KEYSCAN7, S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ZERO, S3C_GPIO_PULL_NONE},
//	{S5PV210_GPH2(3), S3C_GPIO_OUTPUT, S3C_GPIO_SETPIN_ONE,  S3C_GPIO_PULL_UP}, //NONE},		// BATT_ID
 
	{GPIO_nPOWER, S3C_GPIO_EINT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_UP}, //GPIO_nPOWER
//      {GPIO_JACK_nINT, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},

	{GPIO_KEYSENSE0, S3C_GPIO_EINT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},	//GPIO_KBR0
  //      {GPIO_KEYSENSE1, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //NONE},
        {GPIO_KEYSENSE2, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},
	{GPIO_KEYSENSE3, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},	//GPIO_KBR3
	{GPIO_KEYSENSE4, S3C_GPIO_INPUT,  S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE}, //GPIO_T_FLASH_DETECT //cross check
        {GPIO_KEYSENSE5, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE, S3C_GPIO_PULL_NONE},
	{GPIO_T_FLASH_DETECT, S3C_GPIO_INPUT, S3C_GPIO_SETPIN_NONE,  S3C_GPIO_PULL_NONE},	//GPIO_CP_RST
};
#endif
