var canvas;
var ctx;
var fps = 1000/12;

var terrain = new Array();
var ball;

var ball_x = 400;
var ball_y = 0;

var x_dir = 0;
var currSpeed = 0;
var ySpeed = 0;

var button_x_dir = 0;

var grav = 1.0;

var damping = 0.025;

var bounce_thresh = 1.0;

var eSqrd = 25.0;

var skyGradient;

document.onkeyup = keyUp;
document.onkeydown = keyDown;

function output(txt)
{
    document.getElementById('output').innerHTML = txt;
}

function init()
{
    canvas = document.getElementById('stage');
    ctx = canvas.getContext('2d');
    
    ball = new Image();
    ball.src = 'soccer.png';
    
    initSky();
    initGround();
    
    setTimeout(render,fps);    
}

function initSky()
{
    skyGradient = ctx.createLinearGradient(4,0,4,400);
    skyGradient.addColorStop(0,'rgb(0,0,100)');
    //skyGradient.addColorStop(0.2,'rgb(0,0,100)');
    skyGradient.addColorStop(0.8,'rgb(150,150,255)');
    skyGradient.addColorStop(0.9,'rgb(255,255,150)');
    skyGradient.addColorStop(1,'rgb(255,0,0)');
    
}

function initGround()
{
    var start = 400 - Math.random() * 100;
    
    for (var i=0; i<17; i++)
    {
	var x = i/16.0;
	var refVal = x + 0.25*Math.sin(12*x);
	refVal = (1.0 - 0.5*refVal) * 370.0;
	var gain = 2.0;
	var offFromRef = gain*(refVal-start)/780.0;


        start += Math.random() * 40 - 20 + 40*offFromRef;
        if (start > 780) start = 780;
	if (start < 0) start = 0;

        terrain[i] = start;
    }
}

function drawSky()
{
    ctx.fillStyle = skyGradient;
    ctx.fillRect(0,0,800,400);
}

function drawGround()
{
    ctx.fillStyle = "#00ff00";
    ctx.strokeStyle = "#00aa00";
    ctx.beginPath()
    ctx.moveTo(0,400);
    //ctx.lineTo(0,300);
    
    for (var i=0;i<17;i++)
    {
        ctx.lineTo((i*50),terrain[i]);
    }
    
    ctx.lineTo(800,400);
    ctx.closePath();
    ctx.fill();
    ctx.stroke();
    
}

function buttonRight()
{
    button_x_dir += 1;
}

function buttonLeft()
{
    button_x_dir -= 1;
}


function drawBall()
{
    if(button_x_dir != 0)
    {
	x_dir += button_x_dir;
    }
    if (x_dir < 0)
    {
	if(currSpeed < 0)
	{
	    currSpeed = -Math.sqrt(currSpeed*currSpeed + eSqrd);
	} else 	{
	    currSpeed = currSpeed*currSpeed - eSqrd;
	    if(currSpeed < 0.0)
	    {
		currSpeed = -Math.sqrt(-currSpeed);
	    } else {
		currSpeed = Math.sqrt(currSpeed);
	    }
	}
    } else if (x_dir > 0)
    {
	if(currSpeed > 0)
	{
	    currSpeed = Math.sqrt(currSpeed*currSpeed + eSqrd);
	} else 	{
	    currSpeed = currSpeed*currSpeed - eSqrd;
	    if(currSpeed < 0.0)
	    {
		currSpeed = Math.sqrt(-currSpeed);
	    } else {
		currSpeed = -Math.sqrt(currSpeed);
	    }
	}
    }

    if(button_x_dir != 0)
    {
	x_dir -= button_x_dir;
	button_x_dir = 0;
    }

    currSpeed *= (1.0-damping);
  
    var last_ball_x = ball_x;
    
    ball_x += currSpeed;
    if (ball_x > 800-16)
    {
        ball_x = 800-16;
	if(currSpeed > 0.0)
        {
            currSpeed = -0.8*currSpeed;
        }
    }
    if (ball_x < 0)
    {
        ball_x = 0;
        if(currSpeed < 0.0)
        {
            currSpeed = -0.8*currSpeed;
        }
    }
    
    
    var i1 = Math.floor(ball_x / 50);
    
    if (i1 < 16)
    {
        var i2 = i1 + 1;
        
        var ratio = (ball_x - (i1*50)) / 50;
        var currHeight = (terrain[i1] * (1-ratio)) + (terrain[i2]*ratio) -5;
        if(ball_y == 0)
        {
	    ball_y = currHeight;
        }
        if(ball_y +ySpeed  > currHeight)
        {
            var targetSpeed = (currHeight - ball_y);
	    
	    if(ySpeed > bounce_thresh)
	    {
		ySpeed = bounce_thresh - ySpeed;
	    } else {
		ySpeed = targetSpeed; 
	    }
        } else {
            ySpeed += grav;
	}
	ySpeed *= (1.0-damping);
        ball_y += ySpeed;

	if(ball_y > currHeight)
	{
	    ball_y = currHeight;
	}
        
        var theta = ball_x/8;
        
        ctx.translate(ball_x,ball_y);
        ctx.rotate(theta);
        ctx.drawImage(ball,-8,-8);
        ctx.rotate(-theta);
        ctx.translate(-ball_x,-ball_y);
    }
}

function render()
{
    ctx.clearRect(0,0,800,400);
    drawSky();
    drawGround();    
    drawBall();
    setTimeout(render,fps);
}

function keyUp(e)
{
    var theKey;
    
    if (window.event)
    {
        theKey = window.event.keyCode;
    }
    else if (e)
    {
        theKey = e.which;
    }
    
    if (theKey == 37 || theKey == 39)
    {
        x_dir = 0;
    }    
}

function keyDown(e)
{
    var theKey;
    
    if (window.event)
    {
        theKey = window.event.keyCode;
    }
    else if (e)
    {
        theKey = e.which;
    }

    if (theKey == 37)
    {
        x_dir = -1;
    }
    else if (theKey == 39)
    {
        x_dir = 1;
    }
    else if (theKey == 38)
    {
         output('jump');
	 if(ySpeed > 0.0)
	 {
	     ySpeed = ySpeed*ySpeed -eSqrd;
	     if(ySpeed > 0.0)
	     {
		 ySpeed = Math.sqrt(ySpeed);
	     } else {
		 ySpeed = -Math.sqrt(-ySpeed);
	     }
	 } else {
	     ySpeed = -Math.sqrt(ySpeed*ySpeed+eSqrd);
	 }

    }
}