#ifndef _VIEWER_H_
#define _VIEWER_H_

#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>

typedef struct viewerstatus_t {
  SDL_Surface *screen;
  int width;
  int height;
  int bpp;

  unsigned char *buffer;
  
  SDL_mutex *framebuffermutex;
  SDL_Thread *viewer_thread;
  int previewing;
} viewerstatus_t;

#define SDL_USEREVENT_NULL 0
#define SDL_USEREVENT_QUIT 1
#define SDL_USEREVENT_NEWIMAGE 2
#define SDL_USEREVENT_STARTPREVIEW 3
#define SDL_USEREVENT_ENDPREVIEW 4

int init_viewer(void);
int end_viewer(void);
int setup_sdl_window(int width, int height, int bpp);
int close_sdl_window(void);
int viewer_thread(void *data);
int sdl_event_thread(void);
void sdl_update_image();

int start_preview(int width, int height);
int end_preview();
int update_preview();

#endif

