#ifndef _OFLOW_MESSAGE_H_
#define _OFLOW_MESSAGE_H_

#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <net/ethernet.h>

#define MAX_DATA_LENGTH (ETHERMTU - sizeof(struct udphdr) - sizeof(struct iphdr))

typedef struct oflow_message_header_t {
  unsigned long framenum;
  unsigned long startelement; //in 0-indexed 1-D array of size h*w
  unsigned long nelements;
  unsigned long checksum;  //even parity across whole message
} oflow_message_header_t;

#define MAX_VELDATA_LENGTH (MAX_DATA_LENGTH - sizeof(oflow_message_header_t))

#define VELS_PER_MESSAGE (MAX_VELDATA_LENGTH/(2*sizeof(unsigned long)))

typedef struct oflow_message_data_t {
  //element 2*i = i'th velx
  //element 2*i+1 = i'th vely
  unsigned long vel[2*VELS_PER_MESSAGE];
} oflow_message_data_t;

typedef struct oflow_message_t {
  oflow_message_header_t header;
  oflow_message_data_t data;
} oflow_message_t;

#define OFLOW_MESSAGE_SIZE (sizeof(oflow_message_t))

int unpack_oflow_message(oflow_message_t *outmessage, void *indata);
int pack_oflow_message(void *outdata, oflow_message_t *inmessage);
int oflow_udp_open(char *remoteip, int remoteport, int localport);
int oflow_udp_close(int sfd);
int oflow_udp_send(int sfd, void *data, int length);
int oflow_udp_recv(int sfd, void *data, int length);

#endif /* _OFLOW_MESSAGE_H_ */

