#ifndef _OFLOW_H_
#define _OFLOW_H_

#include <xmmintrin.h>
#include <opencv/cv.h>
#include <opencv/cxcore.h>
#include <opencv/highgui.h>

#include "formats.h"
#include "imgconvert.h"
#include "viewer.h"
#include "oflow_messages.h"

typedef struct oflow_options_t {
  /* input options */
  char device[256];
  int width;
  int height;
  int palette;

  /* processing options */
  int windowsize;
  int maxfreq;

  /* output options */
  int avgwindowsize;

  /* transmission options */
  char remoteip[16];
  int remoteport;
  int localport;
} oflow_options_t;

typedef struct oflow_state_t {
  oflow_options_t options;

  CvCapture* capture;
  
  int framenum;
  float fps;
  float acquiredur;
  float previewdur;
  float processdur;

  //for fps differencing
  struct timeval tv_fps;
  int framenum_prev;
  
  int initialized;
  
  unsigned char *tmp_image;
  unsigned char *prev_image;
  CvArr* tmp_header;
  CvArr* prev_header;
  CvArr* preview_header;

  float *velx;
  float *vely;
  CvArr *velx_header;
  CvArr *vely_header;
  float *velx_avg;
  float *vely_avg;
  float velx_fullavg;
  float vely_fullavg;
  float velx_max;
  float vely_max;

  viewerstatus_t *viewer;

  int sfd;
  char *send_data;
  oflow_message_t *send_msg;
  int udp_errors;
} oflow_state_t;

int oflow_init(oflow_state_t *state);

int oflow_start(oflow_state_t *state);

int oflow_process(oflow_state_t *state);

int oflow_stop(oflow_state_t *state);

int oflow_destroy(oflow_state_t *state);

int oflow_send_message(oflow_state_t *state);


#endif /* _OFLOW_H_ */

