
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <ffmpeg/avcodec.h>

#include "imgconvert.h"
#include "formats.h"

int imgconvert(char *input, int input_palette, char *output, int output_palette, int width, int height)
{
  AVPicture inpic, outpic;
  unsigned char *tmpdata;
  int inframesize = width*height*palette_data[input_palette].pixeldepth;
  int outframesize = width*height*palette_data[output_palette].pixeldepth;

//  fprintf(stderr, "imgconvert: insize = %d, outsize = %d\n", inframesize, outframesize);

  if (input_palette == output_palette) {
    memmove(output, input, inframesize);
    return 0;
  }

  if (avpicture_fill(&inpic, input, avcodec_palette_map[input_palette], width, height) < 0) {
    fprintf(stderr, "fill #1 returned error\n");
    return -1;
  }


  tmpdata = malloc(avpicture_get_size(avcodec_palette_map[output_palette], width, height));
  if (tmpdata == NULL) {
    fprintf(stderr, "Unable to allocate temporary image data\n");
    return -1;
  }

  printf("size = %d\n", (avpicture_get_size(avcodec_palette_map[output_palette], width, height)));
//  memset(tmpdata, 0x77, outframesize);

  if (avpicture_fill(&outpic, tmpdata, avcodec_palette_map[output_palette], width, height) < 0) {
    fprintf(stderr, "fill #2 returned error\n");
    free(tmpdata);
    return -1;
  }

  if (img_convert(&outpic, avcodec_palette_map[output_palette], &inpic, avcodec_palette_map[input_palette], width, height) < 0) {
    fprintf(stderr, "img_convert returned error\n");
    free(tmpdata);
    return -1;
  }

  if (avpicture_layout(&outpic, avcodec_palette_map[output_palette], width, height, output, outframesize) < 0) {
    fprintf(stderr, "avpicture_layout returned error\n");
    free(tmpdata);
    return -1;
  }

  free(tmpdata);

  return 0;
}

