#ifndef _FORMATS_H_
#define _FORMATS_H_

#include <ffmpeg/avcodec.h>
#include <linux/videodev.h>

/* Palettes */

enum palette_type {
  PALETTE_GRAY8 = 0,
  PALETTE_RGB565,
  PALETTE_RGB24,
  PALETTE_YUV420P,
  PALETTE_YUV422P,

  N_PALETTE_TYPES
};
 
#define PALETTE_GREY8 PALETTE_GRAY8

typedef struct palette_info {
  const char *name;
  int pixeldepth;
} palette_info;

extern const palette_info palette_data[N_PALETTE_TYPES];
extern const int v4l_palette_map[N_PALETTE_TYPES];
extern const int avcodec_palette_map[N_PALETTE_TYPES];
extern const int palette_map_avcodec[PIX_FMT_NB];

#endif

