
#include "formats.h"
//#include <linux/videodev.h>
//#include <ffmpeg/avcodec.h>

const palette_info palette_data[N_PALETTE_TYPES] = {
  [PALETTE_YUV420P] = {
    .name = "yuv420p",
    .pixeldepth = 2,
  },
  [PALETTE_YUV422P] = {
    .name = "yuv422p",
    .pixeldepth = 2,
  },
  [PALETTE_RGB565] = {
    .name = "rgb565",
    .pixeldepth = 2,
  },
  [PALETTE_GRAY8] = {
    .name = "gray",
    .pixeldepth = 1,
  },
  [PALETTE_RGB24] = {
    .name = "rgb24",
    .pixeldepth = 3,
  },
};

const int v4l_palette_map[N_PALETTE_TYPES] = {
  [PALETTE_YUV420P] = VIDEO_PALETTE_YUV420P,
  [PALETTE_YUV422P] = VIDEO_PALETTE_YUV422P,
  [PALETTE_RGB565] = VIDEO_PALETTE_RGB565,
  [PALETTE_GRAY8] =  VIDEO_PALETTE_GREY,
  [PALETTE_RGB24] = VIDEO_PALETTE_RGB24,
};

const int avcodec_palette_map[N_PALETTE_TYPES] = {
  [PALETTE_YUV420P] = PIX_FMT_YUV420P,
  [PALETTE_YUV422P] = PIX_FMT_YUV422P,
  [PALETTE_RGB565] = PIX_FMT_RGB565,
  [PALETTE_GRAY8] =  PIX_FMT_GRAY8,
  [PALETTE_RGB24] = PIX_FMT_BGR24,
};

const int palette_map_avcodec[PIX_FMT_NB] = {
  [PIX_FMT_YUV420P] = PALETTE_YUV420P,
  [PIX_FMT_YUV422P] = PALETTE_YUV422P,
  [PIX_FMT_RGB565] = PALETTE_RGB565,
  [PIX_FMT_GRAY8] = PALETTE_GRAY8,
  [PIX_FMT_RGB24] = PALETTE_RGB24,
};


