--[[
A bit of help for those willing to tackle this problem:
    : \195\160     : \195\168     : \195\172     : \195\178     : \195\185
    : \195\161     : \195\169     : \195\173     : \195\179     : \195\186
    : \195\162     : \195\170     : \195\174     : \195\180     : \195\187
    : \195\163     : \195\171     : \195\175     : \195\181     : \195\188
    : \195\164                     : \195\177     : \195\182
    : \195\166                     : \195\159     : \195\184
    : \195\167

Add the associated \195\xxx wherever an accent is needed!

Additional notes: 
- hstquotes.healthstone MUST BE lower-case, and be the EXACT SPELLING of the word "healthstone" in your spell tab
- the entries of hsths{} MUST BE lower-case, and be the EXACT SPELLING of the type of healthstone IN THE SPELL, NOT NECESSARILY THE ITEM.  like Create Healthstone (Major) in english - we want "major" for the 5th entry of the table
- hstquotes.warlock MUST BE lower-case, and be the EXACT SPELLING of the translated word for "warlock" as used by Blizzard.
- don't forget to translate the slash commands, loacted at the bottom.  
- if the entry has a space to begin/end it, include it in your translation.  it is joining strings in the code if this happens, such as hstquotes.nohealthstone: the name of the healthstone precedes it, thus a space in its beginning.  sorry for grammar mistakes in foreign languages, it's unavoidable.  
- that's really it, send me a PM on www.curse-gaming.com for further questions.  Also, when you finish your localization, revise THIS FILE and send it to me at ross456@gmail.com.  When I get it, it will be added to the addon.  Include some info about yourself so I can give you credit!
- Thanks for taking the time to do this =]  
 
]]

if GetLocale() == "deDE" then
	-- I would like to thank Cappadozius, 60 Gnome Warlock, Ysera Server, Guild Ancient Dawn for taking the time to make this translation!!  Germans everywhere rejoice!
	hstquotes = {
		addclass = "HST: F\195\188ge Klasse hinzu: ",
		added = " hinzugef\195\188gt zu ",
		addplayer = "HST: F\195\188ge Spieler hinzu: ",
		afkoff = "HST: AFK Status deaktiviert.",
		afkon = "HST: AFK Status aktiviert!",
		afkstatus = "HST: AFK Status: ",
		alreadyin = " schon in ",
		badclass = "Diese Klasse ist auf Deiner Ausschlussliste!  Bitte Taste dr\195\188cken um den Handel abzubrechen.",
		badplayer = "Dieser Spieler ist auf Deiner Ausschlussliste!  Bitte Taste dr\195\188cken um den Handel abzubrechen.",
		badscale = "HST: Bitte w\195\164hle einen Wert zwischen 0,5 und 1,5",
		badthreshold = "HST: Bitte w\195\164hle eine ganze Zahl die gr\195\182\195\159er oder gleich 0 ist",
		ban = "HST: Momentan gebannte Spieler und Klassen:",
		banall = "HST: Healthstone Trader will ignore all requests.",
		banclear = "HST: Ausschlussliste gel\195\182scht!",
		banlist = "HST: Ausschlussliste.",
		banmsg = "HST: Healthstone an Gebannten: ",  -- to review most probably --
		banned = " wurde gebannt, Entschuldigung!",
		bannongroup = "HST: Healthstone Trader wird Anfragen von Nicht-Gruppen Spielern ignorieren.",
		banoff = "HST: Healthstone Trader wird keinerlei Anfragen ignorieren.",
		blocknoshards = "Der Handel wurde abgebrochen da Dir Seelensplitter fehlen.",
		busy = "HST: Ich bin besch\195\164ftigt! ",
		cancelled = "Handel unterbrochen; Transfer abgebrochen.",
		cantclear = "Unm\195\182glich die Tabelle zu l\195\182schen!",
		canttarget = "Bitte in Reichweite kommen! ",
		canttrade = "HST: Bitte in Reichweite des Ziels zum Handeln gehen.",
		class = "Klasse ",
		combat = "Ich bin im Kampf! ",
		confirmall = "HST: Healthstone Trader wird f\195\188r jeden um Best\195\164tigung bitten.",
		confirmmsg = "HST: Healthstone Trader an Best\195\164tiger: ",
		confirmnongroup = "HST: Healthstone Trader wird f\195\188r Nicht-Gruppenmitgliedern um Best\195\164tigung bitten.",
		confirmoff = "HST: Healthstone Trader wird f\195\188r niemanden um Best\195\164tigung bitten.",
		defaultspam = "Healthstone Trader aktiviert! Bitte mit *gstein* anfl\195\188stern um einen zu erhalten!",
		disabled = "HST: Healthstone Trader deaktiviert.",
		enabled = "HST: Healthstone Trader aktiviert!",
		enabledmsg = "HST: Healthstone Trader ist ",
		healthstone = "gesundheitsstein",
		help = "HST: Tippe /hst help f\195\188r das Hilfemen\195\188.",
		hsattempt = "HST: Versuche Dir einen Gesundheitsstein zu geben...",
		hst = "HST: ",
		inqueue = "Dein Name ist schon in der Warteschlange.",
		keyconfirm = "HST: Bitte Taste dr\195\188cken um den Handel zu beenden!.",
		movingcloser = "Du bist ausserhalb der Reichweite zum Handeln, warte bis ich n\195\164her bei Dir bin.",
		noban = "HST: Keine Spieler oder Klassen gebannt.",
		noblock = "Bitte festgelegte Taste dr\195\188cken um normal weiterzumachen.",
		nocban = "HST: Keine Klassen sind gebannt.",
		noconfirm = "HST: Best\195\164tigungszeit abgelaufen.",
		noheader = "HST: Prefix HST: wird nicht bei verschickten Nachrichten angezeigt.",
		nohealthstone = " nicht gefunden, bitte einen herstellen!",
		noqueue = "HST: Keiner in der Warteschlange.",
		noshards = "HST: Du hast wenig Seelensplitter, bitte festgelegte Taste dr\195\188cken um Handel zu starten.",
		notin = " nicht gefunden in ",
		player = "Spieler ",
		queue = "Warteschlange.",
		queueadd = "Dein Name wurde zur Warteschlange hinzugef\195\188gt.",
		queuecleared = "HST: Healthstone Trader's Warteschlange wurde gel\195\182scht.",
		queuelist = "HST: Momentane Spieler in der Warteschlange:",
		queueremove = "Du wurdest aus der Warteschlange entfernt.",
		removed = " entfernt von ",
		resetsettings = "HST: Einstellungen auf Standardwerte gesetzt.",
		resetvars = "HST: Variabeln zur\195\188ckgesetzt.",
		scalechanged = "HST: Skalierung ge\195\164ndert in ",
		scalemsg = "HST: UI Skalierung ist: ",
		secondhs = "HST: Bitte Hotkey dr\195\188cken um einen weiteren Gesundheitsstein zu erschaffen und hinzuzuf\195\188gen!",
		showheader = "Prefix HST: wird bei verschickten Nachrichten angezeigt.",
		silenceoff = "HST: Es werden Nachrichten an andere geschickt.",
		silenceon = "HST: Es werden keine Nachrichten an andere geschickt.", 
		solo = "HST: Du bist in keiner Gruppe!",
		spamsetto = "HST: Spamnachricht ist: ",
		statusmsg = "HST: Status:",
		thresholdchanged = "HST: Seelensplitter Schwellwert ge\195\164ndert auf ",
		thresholdmsg = "HST: Schwellwert f\195\188r Seelensplitter ist: ",
		timedout = "Abgelaufen! ",
		turnon = "HST: Bitte aktiviere das Addon bevor Du irgendetwas \195\164nderst!",
		warlock = "Hexenmeister",
		whisperlist = "HST: Fl\195\188steraktivierungsliste:",
		whispers = "Fl\195\188steraktivierungsliste.",
		whisperself = "HST: Versuche nicht Dich selbst anzufl\195\188stern!",
		zonein = "Healthstone Trader by Asheyla geladen! Tippe /hst help f\195\188r Optionen.",
	}
	hsths = {
		[1] = "schwacher",
		[2] = "geringer",
		[3] = "whatever lolz",
		[4] = "gro\195\159er",
		[5] = "erheblicher"
	}
	hstlocalizedwhispers = {
		[1] = "hs",
		[2] = "gstein",
		[3] = "bonbon",
		[4] = "gs",
	}
	hstwords = {
    	minorhs = "Geringer Gesundheitsstein",
    	lesserhs = "Schwacher Gesundheitsstein",
    	reghs = "Gesundheitsstein",
    	greaterhs = "Gro\195\159er Gesundheitsstein",
    	majorhs = "Erheblicher Gesundheitsstein",
	}
	HSTMenuTooltip = {
	    [1] = "Addon ein- oder ausschalten.\nMomentane Einstellung: ",
	    [2] = "Die Ignorierungsfunktion filtert Chatanfragen.\nMomentane Einstellung: ",
	    [3] = "Die Best\195\164tigungsfunktion filtert Chatanfragen.\nMomentane Einstellung: ",
	    [4] = "Die Spamnachricht ist auf /sagen, /party, or /raid eingestellt.\nMomentane Einstellung: ",
	    [5] = "Wenn der AFK Status aktiviert ist, gehen alle Anfragen direkt in die Warteschlange.\nMomentane Einstellung: ",
	    [6] = "Das Prefix ist \"HST:\" bei verschickten Nachrichten.\nMomentane Einstellung: ",
	    [7] = "Die UI Skalierung gibt an wie gro\195\159 die UI ist.\nMomentane Einstellungg: ",
	    [8] = "Falls die Anzahl Deiner Seelensplitter niedriger als der Schwellwert ist, \nmusst Du weitere Anfragen best\195\164tigen.\nMomentane Einstellung: ",
	    [9] = "When on, no outgoing whispers will be sent.\nCurrent Setting: ",
	    [10] = "Restores all settings to defaults.",
	    [11] = "Anklicken um das Fenster zu verstecken.",
	}
elseif GetLocale() == "frFR" then
	hstquotes={
		addclass="HST: Rajout d'une classe. ",
		added=" ajoute a ",
		addplayer="HST: Ajout d'un joueur: ",
		afkoff="HST: AFK Status desactiv\195\169.",
		afkon="HST: AFK Status activ\195\169!",
		afkstatus="HST: AFK Status: ",
		alreadyin=" d\195\169ja la ",
		badplayer="Ce joueur est dans votre BanList! Appuyer sur une touche pour annuler l'\195\169change.",
		badclass="Cette classe est dans votre BanList! Appuyer sur une touche pour annuler l'\195\169change.",
		badscale="HST: Merci de prendre une valeur entre 0.5 et 1.5",
		badthreshold="HST: Merci de prendre une valeur superieur ou \195\169gale a 0",
		ban="HST: Joueurs et classes actuellement bannis:",
		banall="HST: Healthstone Trader va ignorer toutes les demandes.",
		banclear="HST: BanList vide!",
		banlist="HST: BanList.",
		banmsg="HST: Healthstone whisper ignor\195\169 ",
		banned=" a ete banni, d\195\169sol\195\169!",
		bannongroup="HST: Healthstone Trader va ignorer les demander des personnes non group\195\169es.",
		banoff="HST: Healthstone Trader ne va plus ignorer les demandes.",
		blocknoshards="Votre echange a ete annul\195\169 en raison du manque de fragments.",
		busy="HST: Je suis occup\195\169! ",
		cancelled="Echange annul\195\169; Transfert annul\195\169.",
		cantclear="Impossible de vider la table!",
		canttarget="Merci de vous rapprocher de votre cible! ",
		canttrade="HST: Merci de vous rapprocher de votre cible.",
		class="classe ",
		combat="Je suis en combat! ",
		confirmall="HST: Healthstone Trader va demander une confirmation \195\160 tous.",
		confirmmsg="HST: Healthstone Trader whisper confirm\195\169: ",
		confirmnongroup="HST: Healthstone Trader va confirmer pour les non group\195\169s.",
		confirmoff="HST: Healthstone Trader va demander une confirmation pour personne.",
		defaultspam="Healthstone Trader activ\195\169! Whisper moi avec le mot *healthstone* pour en recevoir une!",
		resetsettings = "HST : Arrangements retourns  l'tat de dfaut.",
		disabled="HST: Healthstone Trader desactiv\195\169.",
		enabled="HST: Healthstone Trader activ\195\169!",
		enabledmsg="HST: Healthstone Trader est ",
		healthstone="pierre de soin",
		help="HST: Taper /hst help pour le menu d'aide.",
		hsattempt="HST: Livraison de pierre de soin en cours...",
		hst="HST: ",
		inqueue="Votre nom est d\195\169ja dans la liste d'attente.",
		keyconfirm="HST: Presser \195\169change pour confirmer le deal!.",
		movingcloser="Vous \195\170tes hors de port\195\169e, Merci d'attendre que je sois plus proche.",
		noban="HST: Il n'y a aucun joueur ou classe banni.",
		noblock="Appuyer sur la touche \195\169change.",
		nocban="HST: Il n'y a aucune classe bannie.",
		noconfirm="HST: Temps de confirmation d\195\169pass\195\169.",
		noheader="HST: L'entete ne va plus montrer les messages arrivant.",
		nohealthstone=" introuvable, cliquer sur \195\169change pour en cr\195\169er une!",
		noqueue="HST: Il y a personne dans la liste d'attente.",
		noshards="HST: Vous n'avez plus assez de fragments, pressez la touche \195\169changer pour initier le deal.",
		notin=" introuvable ",
		player="joueur ",
		queue="liste d'attente.",
		queueadd="Votre nom a \195\169t\195\169 ajout\195\169 \195\160 la liste d'attente.",
		queuecleared="HST: Healthstone Trader liste d'attente nettoy\195\169e.",
		queuelist="HST: Joueurs actuellement dans la liste d'attente:",
		queueremove="Vous avez \195\169t\195\169 r\195\169tir\195\169 de la liste d'attente.",
		removed=" r\195\169tir\195\169 de ",
		resetvars="HST: Variables reset.",
		scalechanged="HST: Scale chang\195\169 \195\160 ",
		scalemsg="HST: UI Scale est: ",
		secondhs="HST: Presser la touche \195\169change dans les secondes suivants pour conjurer une seconde pierre!",
		showheader="HST: L'entete ne montrera plus les messages entrants.",
		silenceoff = "HST : Des chuchotements sortants seront envoys.",
		silenceon = "HST : Aucun chuchotement sortant ne sera envoy.",
		solo="HST: Vous n'\195\170tes pas dans un groupe!",
		spamsetto="HST: Spam msg configur\195\169 a: ",
		statusmsg="HST: Statut:",
		thresholdchanged="HST: Le Seuil a chang\195\169 \195\160 ",
		thresholdmsg="HST: Seuil pour pierre est: ",
		timedout="Temps d\195\169pass\195\169! ",
		turnon="HST: Merci d'activer cet addon avant de faire des changements!",
		warlock="d\195\169moniste",
		whisperlist="HST: Whisper Triggers:",
		whispers="Whisper Checking List.",
		whisperself="HST: N'essayez pas de vous whisper \195\160 vous meme!",
		zonein="Healthstone Trader v2.1 charg\195\169 (par Asheyla)! Taper /hst help pour les options.",
	}
	hsths={
		[1]="mineure",
		[2]="inf\195\169rieure",
		[3]="whatever lolz",
		[4]="sup\195\169rieure",
		[5]="majeure"
	}
	hstlocalizedwhispers={
		[1] = "healthstone",
		[2] = "healstone",
		[3] = "pierre",
		[4] = "cailloux",
		[5] = "pierre de soin",
		[6] = "healthsone",
		[7] = "healtstone"
	}
	hstwords={
		minorhs="Pierre de soin mineure",
		lesserhs="Pierre de soin inf\195\169rieure",
		reghs="Pierre de soin",
		greaterhs="Pierre de soin sup\195\169rieure",
		majorhs="Pierre de soin majeure",
	} 
	HSTMenuTooltip = {
	    [1] = "Turn the addon on or off.\nCurrent setting: ",
	    [2] = "The ignore feature filters chat requests.\nCurrent setting: ",
	    [3] = "The confirmation feature filters chat requests.\nCurrent setting: ",
	    [4] = "The spam message is sent to /say, /party, or /raid.\nCurrent setting: ",
	    [5] = "If AFK Status is on, requests are sent straight to the queue.\nCurrent setting: ",
	    [6] = "The header is \"HST:\" on outgoing whispers.\nCurrent setting: ",
	    [7] = "The UI Scale determines how big the UI is.\nCurrent setting: ",
	    [8] = "If your number of soul shards is below the threshold, \nyou have to confirm healthstone requests.\nCurrent setting: ",
	    [9] = "When on, no outgoing whispers will be sent.\nCurrent Setting: ",
	    [10] = "Restores all settings to defaults.",
	    [11] = "Click to hide this window.",
	}
else
	hstquotes = {
		addclass = "HST: Adding Class: ",
	    added = " added to ",
		addplayer = "HST: Adding Player: ",
		afkoff = "HST: AFK Status disabled.",
		afkon = "HST: AFK Status enabled!",
		afkstatus = "HST: AFK Status: ",
		alreadyin = " already in ",
		badplayer = "This player is on your BanList!  Press your keybinding to terminate trade.",
		badclass = "This class is on your BanList!  Press your keybinding to terminate trade.",
		badscale = "HST: Please pick a value between 0.5 and 1.5",
		badthreshold = "HST: Please pick an integer greater than or equal to 0",
		ban = "HST: Currently banned players and classes:",
		banall = "HST: Healthstone Trader will ignore all requests.",
		banclear = "HST: BanList cleared!",
		banlist = "HST: BanList.",
		banmsg = "HST: Healthstone whisper ignorer: ",
		banned = " has been banned, sorry!",
		bannongroup = "HST: Healthstone Trader will ignore requests from non-group members.",
		banoff = "HST: Healthstone Trader will not ignore any requests.",
	    blocknoshards = "Your trade has been cancelled due to lack of shards.",
		busy = "HST: I'm busy!  ",
		cancelled = "Trade cancelled; transfer aborted.",
		cantclear = "Unable to clear table!",
		canttarget = "Please move into targetting range!  ",
		canttrade = "HST: Please move into trading range of your target.",
		class = "class ",
		combat = "I'm in combat!  ",
		confirmall = "HST: Healthstone Trader will ask for confirmation for everyone.",
		confirmmsg = "HST: Healthstone Trader whisper confirmer: ",
		confirmnongroup = "HST: Healthstone Trader will ask for confirmation for non-group members.",
		confirmoff = "HST: Healthstone Trader will ask for confirmation for no one.",
		defaultspam = "Healthstone Trader enabled! Whisper me the word *healthstone* to receive one!",
		disabled = "HST: Healthstone Trader disabled.",
		enabled = "HST: Healthstone Trader enabled!",
		enabledmsg = "HST: Healthstone Trader is ",
		healthstone = "healthstone",
		help = "HST: Type /hst help for the help menu.",
		hsattempt = "HST: Attempting to give you a healthstone...",
		hst = "HST: ",
		inqueue = "Your name is already in the queue.",
		keyconfirm = "HST: Press your key binding to confirm this trade!.",
		movingcloser = "You are out of trading range, please wait for me to move closer.",
		noban = "HST: There are no banned players or classes.",
		noblock = "Press your key binding to intiate as normal.",
		nocban = "HST: There are no banned classes.",
		noconfirm = "HST: Confirm timed out.",
	    noheader = "HST: The header will not be shown on outgoing messages.",
		nohealthstone = " not found, press your key binding to make one!",
		noqueue = "HST: There is no one in the queue.",
	    noshards = "HST: You have too few soul shards, press your key binding to initiate trade.",
		notin = " not found in ",
		player = "player ",
		queue = "queue.",
		queueadd = "Your name has been added to the queue.",
		queuecleared = "HST: Healthstone Trader's queue has been cleared.",
		queuelist = "HST: Currently queued players:",
		queueremove = "You have been removed from the queue.",
		removed = " removed from ",
		resetsettings = "HST: Settings returned to default state.",
		resetvars = "HST: Variables reset.",
	    scalechanged = "HST: Scale changed to ",
		scalemsg = "HST: UI Scale is: ",
		secondhs = "HST: Press your key binding within the next second to conjure and add a second healthstone!",
	    showheader = "HST: The header will be shown on outgoing messages.",
		silenceoff = "HST: Outgoing whispers will be sent.",
		silenceon = "HST: No outgoing whispers will be sent.",
	    solo = "HST: You are not in a group!",
		spamsetto = "HST: Spam msg set to: ",
	    statusmsg = "HST: Status:",
	    thresholdchanged = "HST: Soul shards threshold changed to ",
	    thresholdmsg = "HST: Threshold for soul shards is: ",
		timedout = "Timed out!  ",
		turnon = "HST: Please turn this addon on before making any changes!",
		warlock = "warlock",
	    whisperlist = "HST: Whisper Triggers:",
		whispers = "Whisper Checking List.",
		whisperself = "HST: Do not try to whisper yourself!",
		zonein = "Healthstone Trader v2.1 by Asheyla loaded!  Type /hst help for options.",
	}
	hsths = {
		[1] = "minor",
		[2] = "lesser",
		[3] = "whatever lolz",
		[4] = "greater",
		[5] = "major"
	}
	hstlocalizedwhispers = {
        [1] = "healthstone",
        [2] = "healstone",
        [3] = "health stone",
        [4] = "heathstone",
        [5] = "helathstone",
        [6] = "healthsone",
		[7] = "healtstone"
	}
	hstwords = {
	    minorhs = "Minor Healthstone",
	    lesserhs = "Lesser Healthstone",
	    reghs = "Healthstone",
	    greaterhs = "Greater Healthstone",
	    majorhs = "Major Healthstone",
	}
	HSTMenuTooltip = {
	    [1] = "Turn the addon on or off.\nCurrent setting: ",
	    [2] = "The ignore feature filters chat requests.\nCurrent setting: ",
	    [3] = "The confirmation feature filters chat requests.\nCurrent setting: ",
	    [4] = "The spam message is sent to /say, /party, or /raid.\nCurrent setting: ",
	    [5] = "If AFK Status is on, requests are sent straight to the queue.\nCurrent setting: ",
	    [6] = "The header is \"HST:\" on outgoing whispers.\nCurrent setting: ",
	    [7] = "The UI Scale determines how big the UI is.\nCurrent setting: ",
	    [8] = "If your number of soul shards is below the threshold, \nyou have to confirm healthstone requests.\nCurrent setting: ",
	    [9] = "When on, no outgoing whispers will be sent.\nCurrent Setting: ",
	    [10] = "Restores all settings to defaults.",
	    [11] = "Click to hide this window."
	}
end

function hst_helpmenu()
	if GetLocale() == "deDE" then
		hst_addtext("Healthstone Trader Hilfemen\195\188:")
		hst_addtext("/hst on: aktiviert Healthstone Trader")
		hst_addtext("/hst off: deaktiviert Healthstone Trader")
		hst_addtext("/hst status: zeigt den Status des Addons")
		hst_addtext("/hst reset: benutzen falls Fehler auftreten; setzt alle Variablen auf die Defaultwerte")
		hst_addtext("/hst ignore [off,nongroup,all]: ignoriert Anfragen von den entsprechenden Gruppen")
		hst_addtext("/hst confirm [off,nongroup,all]: fordert eine Best\195\164tigung von den entsprechenden Gruppen an")
		hst_addtext("/hst clear queue: l\195\182scht die Warteschlange")
		hst_addtext("/hst show queue: zeigt die Warteschlange an")
		hst_addtext("/hst help advanced: zeigt das erweiterte Hilfemen\195\188 an")
		hst_addtext("/hst menu: aktiviere das Men\195\188")
	elseif GetLocale() == "frFR" then
		hst_addtext("Healthstone Trader Help Menu:")
		hst_addtext("/hst on: enables Healthstone Trader")
		hst_addtext("/hst off: disables Healthstone Trader")
		hst_addtext("/hst status: shows the status of this addon")
		hst_addtext("/hst reset: use if you get an error; resets variables")
		hst_addtext("/hst ignore [off,nongroup,all]: ignores requests from specified")
		hst_addtext("/hst confirm [off,nongroup,all]: seeks confirmation from specified")
		hst_addtext("/hst clear queue: clears the queue")
		hst_addtext("/hst show queue: shows the queue")
		hst_addtext("/hst help advanced: shows the advanced help menu")
		hst_addtext("/hst menu: show the menu")
	else
		hst_addtext("Healthstone Trader Help Menu:")
		hst_addtext("/hst on: enables Healthstone Trader")
		hst_addtext("/hst off: disables Healthstone Trader")
		hst_addtext("/hst status: shows the status of this addon")
		hst_addtext("/hst reset: use if you get an error; resets variables")
		hst_addtext("/hst ignore [off,nongroup,all]: ignores requests from specified")
		hst_addtext("/hst confirm [off,nongroup,all]: seeks confirmation from specified")
		hst_addtext("/hst clear queue: clears the queue")
		hst_addtext("/hst show queue: shows the queue")
		hst_addtext("/hst help advanced: shows the advanced help menu")
		hst_addtext("/hst menu: show the menu")
	end
end

function hst_advhelpmenu()
	if GetLocale() == "deDE" then
	    hst_addtext("Healthstone Trader erweitertes Hilfemen\195\188:")
		hst_addtext("/hst ban [player,class]: bannt Anfragen von diesem Spieler / dieser Klasse")
		hst_addtext("/hst unban [player,class]: l\195\182scht den Spieler / die Klasse von der Ausschlussliste")
		hst_addtext("/hst clear banned: l\195\182scht die Ausschlussliste")
		hst_addtext("/hst show banned: zeigt die Ausschlussliste an")
		hst_addtext("/hst remove [player]: entfernt den Spieler aus der Warteschlange")
		hst_addtext("/hst spam: [msg]: \195\164ndert die Spamnachricht (\"default\" f\195\188r Standard)")
		hst_addtext("/hst trigger [msg]: startet einen Handel wenn die Nachricht an den Spieler gefl\195\188stert wird")
		hst_addtext("/hst untrigger [msg]: stoppt die \195\156berpr\195\188fung auf Ausl\195\182ser in den Fl\195\188sternachrichten")
		hst_addtext("/hst show triggers: zeigt alle Fl\195\188sterausl\195\182ser an")
		hst_addtext("/hst toggle ui: ein-/ausschalten des UI")
		hst_addtext("/hst afk [on,off]: falls on, gehen alle Anfragen direkt in die Warteschlange")
		hst_addtext("/hst toggle header: ein-/ausschalten der Anzeige \"HST: \" in verschickten Nachrichten")
		hst_addtext("/hst scale [value]: setzt die Skalierung der UI auf die value*normale Gr\195\182sse")
		hst_addtext("/hst threshold [#]: unterbindet Fl\195\188sternachrichten wenn weniger als # Seelensplitter vorhanden sind")
		hst_addtext("/hst add player [player]: f\195\188gt den Spieler in die Warteschlange ein")
		hst_addtext("/hst add class [class]: f\195\188gt alle Spieler in Deiner Gruppe von dieser Klasse in die Warteschlange ein")
	elseif GetLocale() == "frFR" then
	    hst_addtext("Healthstone Trader Advanced Help Menu:")
		hst_addtext("/hst ban [player,class]: bans requests from this player/class")
		hst_addtext("/hst unban [player,class]: unbans requests from this player/class")
		hst_addtext("/hst clear banned: clears the BanList")
		hst_addtext("/hst show banned: shows the BanList")
		hst_addtext("/hst remove [player]: removes that player from the queue")
		hst_addtext("/hst spam: [msg]: changes the spam message (\"default\" for default)")
		hst_addtext("/hst trigger [msg]: will initiate trade if msg is whispered to player")
		hst_addtext("/hst untrigger [msg]: stops checking for msg in whispers")
		hst_addtext("/hst show triggers: shows all the whisper trigger words")
		hst_addtext("/hst toggle ui: toggles the ui")
		hst_addtext("/hst afk [on,off]: if on, requests will go straight to queue")
		hst_addtext("/hst toggle header: toggles displaying \"HST: \" on outgoing msgs")
		hst_addtext("/hst scale [value]: sets the UI scale to value*normal size")
		hst_addtext("/hst threshold [#]: will block whispers if fewer than # soul shards")
		hst_addtext("/hst add player [player]: adds that player to the queue")
		hst_addtext("/hst add class [class]: queues all people in your group of that class")
	else
	    hst_addtext("Healthstone Trader Advanced Help Menu:")
		hst_addtext("/hst ban [player,class]: bans requests from this player/class")
		hst_addtext("/hst unban [player,class]: unbans requests from this player/class")
		hst_addtext("/hst clear banned: clears the BanList")
		hst_addtext("/hst show banned: shows the BanList")
		hst_addtext("/hst remove [player]: removes that player from the queue")
		hst_addtext("/hst spam: [msg]: changes the spam message (\"default\" for default)")
		hst_addtext("/hst trigger [msg]: will initiate trade if msg is whispered to player")
		hst_addtext("/hst untrigger [msg]: stops checking for msg in whispers")
		hst_addtext("/hst show triggers: shows all the whisper trigger words")
		hst_addtext("/hst toggle ui: toggles the ui")
		hst_addtext("/hst afk [on,off]: if on, requests will go straight to queue")
		hst_addtext("/hst toggle header: toggles displaying \"HST: \" on outgoing msgs")
		hst_addtext("/hst scale [value]: sets the UI scale to value*normal size")
		hst_addtext("/hst threshold [#]: will block whispers if fewer than # soul shards")
		hst_addtext("/hst add player [player]: adds that player to the queue")
		hst_addtext("/hst add class [class]: queues all people in your group of that class")
	end
end