--Healthstone Trader, written by Asheyla of Warcraft Gaming Faction, Shattered Hand Horde.
--Access this addon ingame by typing /hst help

HSTOptions = {}                        
local hst = {}
local Player = UnitName("player")
local Realm = GetRealmName()
local hstqueue = {}                                
local loaded,temptarget,temptarget2
local language = GetDefaultLanguage("player")
BINDING_HEADER_HST = "Healthstone Trader"
BINDING_NAME_HST = "Perform the proper action"

function hst_OnLoad()
	SLASH_HST1 = "/hst"
	SlashCmdList["HST"] = hst_commands
	this:RegisterEvent("TRADE_PLAYER_ITEM_CHANGED")
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("TRADE_REQUEST_CANCEL")
	this:RegisterEvent("TRADE_SHOW")
	this:RegisterEvent("CHAT_MSG_WHISPER")
	this:RegisterEvent("TRADE_CLOSED")
	this:RegisterEvent("BAG_UPDATE")
	this:RegisterEvent("PLAYER_REGEN_ENABLED")
	this:RegisterEvent("PLAYER_REGEN_DISABLED")
	this:RegisterEvent("ZONE_CHANGED")
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	this:RegisterEvent("PLAYER_TARGET_CHANGED")
	hst_addtext(hstquotes.zonein)
end

function hst_OnEvent(event)
	if not loaded then
		if event == "PLAYER_ENTERING_WORLD" then hst_startup() end
	else
	    if HSTOptions[Realm][Player]["Status"] == "on" then
			if event == "CHAT_MSG_WHISPER" and HSTOptions[Realm][Player]["Ignore"] ~= "all" then
				hst.text = arg1
				temptarget = string.lower(arg2)
				if hst_teststring() then
				    hst_hstalent()
					if temptarget ~= string.lower(Player) then
						hst.player = temptarget
						table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
						if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
							hst_sendchatmsg(hstquotes.hst..hstquotes.player..hst_capitalize(hst.player)..hstquotes.banned,"WHISPER",language,temptarget)
						else
							if hst_testforrange(temptarget) then
								hst.player = string.lower(UnitClass("target"))
								table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
								if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
									hst_sendchatmsg(hstquotes.hst..hstquotes.class..hst_capitalize(hst.player)..hstquotes.banned,"WHISPER",language,temptarget)
         							if hst.combat then TargetLastEnemy() else ClearTarget() end
								elseif not hst_ignore() then
								    if not hst_confirm() then
										hst_underthreshold()
									else
									    hst.sayonce = nil
										hst.confirm = 1
										hst.confirmstart = GetTime()
									end
								else
 									if hst.combat then TargetLastEnemy() else ClearTarget() end
								end
							else
								hst_sendchatmsg(hstquotes.hst..hstquotes.canttarget,"WHISPER",language,temptarget)
							end
						end
					end
				end
			elseif event == "TRADE_SHOW" then
				temptarget2 = string.lower(UnitName("npc"))
				hst.window = 1
				if hst.trading then
				    if temptarget2 == hst.target then
					    for i = 1,4 do CloseBag(i) end --new
						--hst_determinehs()
						PickupContainerItem(hst.bag,hst.slot) --new
						ClickTradeButton(hst.button) --new
					else
					    CancelTrade()
					    hst_sendchatmsg(hstquotes.hst..hstquotes.busy,"WHISPER",language,temptarget2)
					end
				else
					hst.player = temptarget2
					table.foreachi(hstqueue,hst_playerplace)
					if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
						hst_sendchatmsg(hstquotes.hst..hstquotes.inqueue,"WHISPER",language,temptarget2)
						CancelTrade()
					else
						table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
						if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
							hst_addtext(hstquotes.hst..hstquotes.badplayer)
							hst.trigger = 1
							hst.triggerstart = GetTime()
      					else
							hst.player = string.lower(UnitClass("npc"))
							table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
							if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
								hst_addtext(hstquotes.hst..hstquotes.badclass)
								hst.trigger = 1
								hst.triggerstart = GetTime()
							end
						end
					end
				end
			elseif event == "TRADE_REQUEST_CANCEL" and hst.trading then 
				hst_sendchatmsg(hstquotes.hst..hstquotes.cancelled,"WHISPER",language,hst.target)
				hst_reset()
			elseif event == "TRADE_CLOSED" then
				hst.window = nil
				hst_reset()
   	 			if hst.combat then TargetLastEnemy() else ClearTarget() end
			elseif event == "BAG_UPDATE" then
				hst.update = 1
				if hst.trading and hst.casting then hst_tradinghs() end
			elseif event == "PLAYER_REGEN_ENABLED" then hst.combat = nil
			elseif event == "PLAYER_REGEN_DISABLED" then hst.combat = 1
			elseif event == "TRADE_PLAYER_ITEM_CHANGED" and hst.trading then
				if hst.numhs == 1 then
				    hst_addtext(hstquotes.secondhs)
				end
				hst.hsadded = 1
				hst.addedstart = GetTime()
			elseif event == "ZONE_CHANGED" or event == "ZONE_CHANGED_NEW_AREA" then
				if UnitAffectingCombat("player") then
					hst.combat = 1
				else
					hst.combat = nil
				end
			elseif event == "PLAYER_TARGET_CHANGED" and hst.targetting then
				table.insert(hstqueue,hst.target)
				hstqueue.update = 1
				hst_sendchatmsg(hstquotes.queueadd,"WHISPER",language,hst.target)
				hst_reset()
			end
		end
	end
end

function hst_OnUpdate()
	if loaded and HSTOptions[Realm][Player]["Status"] == "on" then
		if not hst.uhslevel then hst_reset() end
		if HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
			if hstqueue.update then
			    table.foreachi(hstqueue,hst_sendtolist)
			    hstqueue.update = nil
			    if table.getn(hstqueue)<10 then
			        for entry = table.getn(hstqueue) + 1,10 do
			            getglobal("HST_Queue"..entry):Hide()
					end
				end
			end
		elseif HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
			if HSTOptions[Realm][Player]["BanList"].update then
				table.foreachi(HSTOptions[Realm][Player]["BanList"], hst_sendtolist)
				HSTOptions[Realm][Player]["BanList"].update = nil
				if table.getn(HSTOptions[Realm][Player]["BanList"])<10 then
					for entry = table.getn(HSTOptions[Realm][Player]["BanList"]) + 1,10 do
						getglobal("HST_Queue"..entry):Hide()
					end
				end
			end
		elseif HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
			if HSTOptions[Realm][Player]["Whispers"].update then
				table.foreachi(HSTOptions[Realm][Player]["Whispers"], hst_sendtolist)
				HSTOptions[Realm][Player]["Whispers"].update = nil
				if table.getn(HSTOptions[Realm][Player]["Whispers"])<10 then
					for entry = table.getn(HSTOptions[Realm][Player]["Whispers"]) + 1,10 do
						getglobal("HST_Queue"..entry):Hide()
					end
				end
			end
		elseif HSTOptions[Realm][Player]["ShowUI"] == "None" then
			if hst.update then
				hst.update = nil
				getglobal("HST_Queue"):SetText(hst_filler())
			end
		end
		if hstqueue.announce == nil then hstqueue.announce = GetTime() end
		local time = GetTime()
		if hst.trigger then
			if time >= hst.triggerstart + 5 then
				hst.triggerstart = nil
				hst.trigger = nil
				hst_addtext(hstquotes.hst..hstquotes.noblock)
			end	
		elseif hst.confirm then
			if time >= hst.confirmstart + .5 and not hst.sayonce then
			    hst_addtext(hstquotes.keyconfirm,1.00,0.00,0.00)
			    hst.sayonce = 1
			elseif time >= hst.confirmstart + 5 then
	 			hst_addtext(hstquotes.noconfirm)
				hst.confirm = nil
				hst.sayonce = nil
    			if hst.combat then TargetLastEnemy() else ClearTarget() end
			end
		elseif hst.threshold then
			if time >= hst.thresholdstart + .5 and not hst.sayonce then
			    hst_addtext(hstquotes.noshards,1.00,0.00,0.00)
			    
			    hst.sayonce = 1
			elseif time >= hst.confirmstart + 5 then
	 			hst_sendchatmsg(hstquotes.hst..hstquotes.blocknoshards,"WHISPER",language,temptarget)
				hst.threshold = nil
				hst.sayonce = nil
    			if hst.combat then TargetLastEnemy() else ClearTarget() end
			end
		elseif hst.hsadded and time >= hst.addedstart + 2 then
			AcceptTrade()
			hst.numhs = hst.numhs + 1
			hst.hsadded = nil
		end
	end
end

function hst_startup()
	if HSTOptions["General"] then for key in HSTOptions do HSTOptions[key] = nil end end
	loaded = 1
	if not HSTOptions[Realm] then HSTOptions[Realm] = {} end
	if not HSTOptions[Realm][Player] then HSTOptions[Realm][Player] = {} end
	if not HSTOptions[Realm][Player]["ShowUI"] then HSTOptions[Realm][Player]["ShowUI"] = "Queue" end
	if not HSTOptions[Realm][Player]["Status"] then
		local _,Class = UnitClass("player")
		local level = UnitLevel("player")
		if Class == "WARLOCK" and level >= 10 then
			HSTOptions[Realm][Player]["Status"] = "on"
		else
			HSTOptions[Realm][Player]["Status"] = "off"
			getglobal("HST_MainFrame"):Hide()
			HSTOptions[Realm][Player]["ShowUI"] = 0
		end
	end
	if not HSTOptions[Realm][Player]["Confirm"] then HSTOptions[Realm][Player]["Confirm"] = "nongroup" end
	if not HSTOptions[Realm][Player]["Ignore"] then HSTOptions[Realm][Player]["Ignore"] = "off" end
	if not HSTOptions[Realm][Player]["Spam"] then HSTOptions[Realm][Player]["Spam"] = hstquotes.hst..hstquotes.defaultspam end
	if not HSTOptions[Realm][Player]["BanList"] then HSTOptions[Realm][Player]["BanList"] = {[1] = hstquotes.warlock} end
	if not HSTOptions[Realm][Player]["Threshold"] then HSTOptions[Realm][Player]["Threshold"] = 0 end
	if not HSTOptions[Realm][Player]["Scale"] then HSTOptions[Realm][Player]["Scale"] = 1 end
	if not HSTOptions[Realm][Player]["Header"] then HSTOptions[Realm][Player]["Header"] = "HST: " end
	if not HSTOptions[Realm][Player]["Whispers"] then HSTOptions[Realm][Player]["Whispers"] = hstlocalizedwhispers end
	if not HSTOptions[Realm][Player]["Silence"] then HSTOptions[Realm][Player]["Silence"] = "off" end
	hstquotes.hst = HSTOptions[Realm][Player]["Header"]
    for entry = 1,10 do getglobal("HST_Queue"..entry):Hide() end
	hst_reset()
 	hstqueue.update = 1
 	getglobal("HST_Close"):SetScale(HSTOptions[Realm][Player]["Scale"])
 	if HSTOptions[Realm][Player]["ShowUI"] ~= 0 then getglobal("HST_MainFrame"):Show() else getglobal("HST_MainFrame"):Hide() end
 	if HSTOptions[Realm][Player]["ShowUI"] == "banned" then HSTOptions[Realm][Player]["ShowUI"] = "BanList" end
end

function hst_reset()
	local savewindow = hst.window
	local saveafk = hst.afk
	for key in hst do hst[key] = nil end
	hst.numhs = 0
	hst.button = 1
	hst_hstalent()
	hst.timespam = GetTime()
	hst.ulevel = UnitLevel("player")
   		if 10 <= hst.ulevel and hst.ulevel<22 then
			hst.uhealthstone = hstwords.minorhs
			hst.uhslevel = 1
			hst.uhsamount = 100 + 10 * hst.hstalent
		elseif 22 <= hst.ulevel and hst.ulevel<34 then
			hst.uhealthstone = hstwords.lesserhs
			hst.uhslevel = 2
			hst.uhsamount =  250 + 25 * hst.hstalent
		elseif 34 <= hst.ulevel and hst.ulevel<46 then
			hst.uhealthstone = hstwords.reghs
			hst.uhslevel = 3
			hst.uhsamount = 500 + 50 * hst.hstalent
		elseif 46 <= hst.ulevel and hst.ulevel<58 then
			hst.uhealthstone = hstwords.greaterhs
			hst.uhslevel = 4
			hst.uhsamount = 800 + 80 * hst.hstalent
		elseif 58 <= hst.ulevel then
			hst.uhealthstone = hstwords.majorhs
			hst.uhslevel = 5
			hst.uhsamount = 1200 + 120 * hst.hstalent
		end
	hst.uhstype = hsths[hst.uhslevel]
	hst.combat = UnitAffectingCombat("player")
	hst.window = savewindow
	hst.afk = saveafk
	if hst.afk == nil then hst.afk = "off" end
 	if HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
     	getglobal("HST_Queue"):SetText("Ban List:")
     	HSTOptions[Realm][Player]["BanList"].update = 1
	end
	if HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
		getglobal("HST_Queue"):SetText("Current Queue:")
		hstqueue.update = 1
	end
	if HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
		getglobal("HST_Queue"):SetText("Triggers:")
		HSTOptions[Realm][Player]["Whispers"].update = 1
	end
	if HSTOptions[Realm][Player]["ShowUI"] == "None" then
		getglobal("HST_Queue"):SetText(hst_filler())
		for entry = 1,10 do getglobal("HST_Queue"..entry):Hide() end
	end
end

function hst_hstalent()
	_,_,_,_,hst.hstalent = GetTalentInfo(2,1)
	if hst.hstalent == 0 then
		hstitems = {
		    [1] = 5512,
		    [2] = 5511,
		    [3] = 5509,
		    [4] = 5510,
		    [5] = 9421
		}
	elseif hst.hstalent == 1 then
		hstitems = {
		    [1] = 19004,
		    [2] = 19006,
		    [3] = 19008,
		    [4] = 19010,
		    [5] = 19012
		}
	elseif hst.hstalent == 2 then
		hstitems = {
		    [1] = 19005,
		    [2] = 19007,
		    [3] = 19009,
		    [4] = 19011,
		    [5] = 19013
		}
	end
end

function hst_underthreshold()
	local soulshard = 0
	for bag = 0,4 do
  	 	for slot = 1,GetContainerNumSlots(bag) do
  			if (GetContainerItemLink(bag,slot)) then
    			if string.find(GetContainerItemLink(bag,slot),"6265") then soulshard = soulshard + 1 end
			end
		end
	end
	if soulshard >= HSTOptions[Realm][Player]["Threshold"] then
  		hst_checkafk()
	else
		hst.sayonce = nil
		hst.threshold = 1
		hst.thresholdstart = GetTime()
	end
end

function hst_confirm()
	if HSTOptions[Realm][Player]["Confirm"] == "nongroup" then
		if UnitInParty("target") or UnitInRaid("target") then
			return false
		else
			return true
		end
	elseif HSTOptions[Realm][Player]["Confirm"] == "off" then
		return false
	else
		return true
	end
end

function hst_ignore()
	if HSTOptions[Realm][Player]["Ignore"] == "nongroup" then
		if UnitInParty("target") or UnitInRaid("target") then
			return false
		else
			return true
		end
	elseif HSTOptions[Realm][Player]["Ignore"] == "off" then
		return false
	else
		return true
	end
end

function hst_commands(msg)
	if HSTOptions[Realm][Player]["Status"] == "off" then
		if msg == "on" then
			HSTOptions[Realm][Player]["Status"] = "on"
			getglobal("HST_MainFrame"):Show()
			HSTOptions[Realm][Player]["ShowUI"] = "Queue"
			getglobal("HST_Queue"):SetText("Current Queue:")
			hstqueue.update = 1
			hst_addtext(hstquotes.enabled)
		elseif msg == "menu" then
			getglobal("HST_MenuButtons"):Show()
		elseif msg == "status" then
		    hst_addtext(hstquotes.statusmsg)
			hst_addtext(hstquotes.enabledmsg..HSTOptions[Realm][Player]["Status"]..".")
			hst_addtext(hstquotes.banmsg..HSTOptions[Realm][Player]["Ignore"])
			hst_addtext(hstquotes.confirmmsg..HSTOptions[Realm][Player]["Confirm"])
			hst_addtext(hstquotes.afkstatus..hst.afk)
			hst_addtext(hstquotes.thresholdmsg..HSTOptions[Realm][Player]["Threshold"])
			hst_addtext(hstquotes.scalemsg..HSTOptions[Realm][Player]["Scale"])
		else
			hst_addtext(hstquotes.turnon)
		end
	else 
		if msg == "reset" then
			hst_reset()
			hst_addtext(hstquotes.resetvars)
		elseif msg == "on" then
			HSTOptions[Realm][Player]["Status"] = "on"
			getglobal("HST_MainFrame"):Show()
			HSTOptions[Realm][Player]["ShowUI"] = "Queue"
			getglobal("HST_Queue"):SetText("Current Queue:")
			hstqueue.update = 1
			hst_addtext(hstquotes.enabled)
		elseif msg == "off" then
			HSTOptions[Realm][Player]["Status"] = "off"
			getglobal("HST_MainFrame"):Hide()
			HSTOptions[Realm][Player]["ShowUI"] = 0
			hst_addtext(hstquotes.disabled)
		elseif msg == "menu" then
			getglobal("HST_MenuButtons"):Show()
		elseif msg == "ignore nongroup" then
			HSTOptions[Realm][Player]["Ignore"] = "nongroup"
			hst_addtext(hstquotes.bannongroup)
		elseif msg == "ignore all" then
			HSTOptions[Realm][Player]["Ignore"] = "all"
			hst_addtext(hstquotes.banall)
		elseif msg == "ignore off" then
			HSTOptions[Realm][Player]["Ignore"] = "off"
			hst_addtext(hstquotes.banoff)
		elseif msg == "confirm off" then
			HSTOptions[Realm][Player]["Confirm"] = "off"
			hst_addtext(hstquotes.confirmoff)
		elseif msg == "confirm nongroup" then
			HSTOptions[Realm][Player]["Confirm"] = "nongroup"
			hst_addtext(hstquotes.confirmnongroup)
		elseif msg == "confirm all" then
			HSTOptions[Realm][Player]["Confirm"] = "all"
			hst_addtext(hstquotes.confirmall)
		elseif msg == "clear queue" then
			hst_addtext(hstquotes.queuecleared)
		  	table.foreachi(hstqueue,hst_sendmsg)
			for id = 1,table.getn(hstqueue) do table.remove(hstqueue,id) end
			hstqueue.update = 1
		elseif string.sub(msg,1,5) == "spam:" then
			local spam = string.sub(msg,7)
			if spam == "default" then
				HSTOptions[Realm][Player]["Spam"] = hstquotes.hst..hstquotes.defaultspam
			else
				if spam ~= "" then
					HSTOptions[Realm][Player]["Spam"] = spam
					hst_addtext(hstquotes.spamsetto..HSTOptions[Realm][Player]["Spam"])
				end
			end
		elseif string.sub(msg,1,3) == "add" then
		    if string.sub(msg,5,9) == "class" then
		    	local msg = string.lower(string.sub(msg,11))
		    	if GetNumRaidMembers()>0 then
					hst_addtext(hstquotes.addclass..msg)
		    		for i = 1,40 do
		    			if UnitExists("raid"..i) and msg ~= "" then
							if msg == string.lower(UnitClass("raid"..i)) and not UnitIsUnit("raid"..i,"player") then
							    hst.player = string.lower(UnitName("raid"..i))
							    table.foreachi(hstqueue,hst_playerplace)
							    if hst.playerplace == nil or table.getn(hstqueue) == 0 then
									table.insert(hstqueue,hst.player)
									hstqueue.update = 1
									hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,hst.player)
								end
							end
						end
					end
				elseif GetNumPartyMembers()>0 then 
					hst_addtext(hstquotes.addplayer..msg)
					for i = 1,4 do
						if UnitExists("party"..i) and msg ~= "" then
							if msg == string.lower(UnitClass("party"..i)) then
							    hst.player = string.lower(UnitName("party"..i))
							    table.foreachi(hstqueue,hst_playerplace)
							    if hst.playerplace == nil or table.getn(hstqueue) == 0 then
									table.insert(hstqueue,hst.player)
									hstqueue.update = 1
									hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,hst.player)
								end
							end
						end
					end
				else
					hst_addtext(hstquotes.solo)
				end
		    elseif string.sub(msg,5,10) == "player" then
			    hst.player = string.lower(string.sub(msg,12))
			    if hst.player ~= "" then
				    table.foreachi(hstqueue,hst_playerplace)
				    if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
						hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.alreadyin..hstquotes.queue)
					else
						table.insert(hstqueue,hst.player)
						hstqueue.update = 1
						hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,hst.player)
						hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.added..hstquotes.queue)
					end
				end
		    end
		elseif string.sub(msg,1,9) == "threshold" then
			if type(tonumber(string.sub(msg,11))) == "number" then
			    HSTOptions[Realm][Player]["Threshold"] = tonumber(string.sub(msg,11))
			    hst_addtext(hstquotes.thresholdchanged..HSTOptions[Realm][Player]["Threshold"]..".")
			else
				hst_addtext(hstquotes.badthreshold)
			end
		elseif string.sub(msg,1,5) == "scale" then
		    local scaler = tonumber(string.sub(msg,7))
		    if type(scaler) == "number" then
			    if scaler > 1.5 or scaler < .5 then
			    	hst_addtext(hstquotes.badscale)
			    else
				    getglobal("HST_Close"):SetScale(scaler)
				    HSTOptions[Realm][Player]["Scale"] = scaler
				    hst_addtext(hstquotes.scalechanged..scaler)
				end
			else
				hst_addtext(hstquotes.badscale)
			end
		elseif msg == "toggle header" then
		    if HSTOptions[Realm][Player]["Header"] == "HST: " then
		        HSTOptions[Realm][Player]["Header"] = ""
		        hstquotes.hst = ""
		        hst_addtext(hstquotes.noheader)
			else
			    HSTOptions[Realm][Player]["Header"] = "HST: "
			    hst_addtext(hstquotes.showheader)
			    hstquotes.hst = "HST: "
			end
		elseif msg == "status" then
		    hst_addtext(hstquotes.statusmsg)
			hst_addtext(hstquotes.enabledmsg..HSTOptions[Realm][Player]["Status"]..".")
			hst_addtext(hstquotes.banmsg..HSTOptions[Realm][Player]["Ignore"])
			hst_addtext(hstquotes.confirmmsg..HSTOptions[Realm][Player]["Confirm"])
			hst_addtext(hstquotes.afkstatus..hst.afk)
			hst_addtext(hstquotes.thresholdmsg..HSTOptions[Realm][Player]["Threshold"])
			hst_addtext(hstquotes.scalemsg..HSTOptions[Realm][Player]["Scale"])
		elseif string.sub(msg,1,6) == "remove" then
		    hst.player = string.lower(string.sub(msg,8))
		    table.foreachi(hstqueue,hst_playerplace)
		    if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
				table.remove(hstqueue,hst.playerplace)
				hstqueue.update = 1
				hst_sendchatmsg(hstquotes.hst..hstquotes.queueremove,"WHISPER",language,hst.player)
				hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.removed..hstquotes.queue)
			else
				hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.notin..hstquotes.queue)
			end
		elseif string.sub(msg,1,5) == "unban" then
			hst.player = string.lower(string.sub(msg,7))
			table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
			if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
				table.remove(HSTOptions[Realm][Player]["BanList"],hst.playerplace)
				hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.removed..hstquotes.banlist)
				HSTOptions[Realm][Player]["BanList"].update = 1
			else
				hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.notin..hstquotes.banlist)
			end
		elseif msg == "clear banned" then
			for id = 1,table.getn(HSTOptions[Realm][Player]["BanList"]) do table.remove(HSTOptions[Realm][Player]["BanList"],id) end
			hst_addtext(hstquotes.banclear)
			HSTOptions[Realm][Player]["BanList"].update = 1
		elseif msg == "show banned" then
			if table.getn(HSTOptions[Realm][Player]["BanList"]) == 0 then
				hst_addtext(hstquotes.noban)
			else	
				hst_addtext(hstquotes.ban)
				table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_printlist)
			end
		elseif string.sub(msg,1,3) == "ban" then 
			hst.player = string.lower(string.sub(msg,5))
			table.foreachi(HSTOptions[Realm][Player]["BanList"],hst_playerplace)
				if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["BanList"]) ~= 0 then
					hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.alreadyin..hstquotes.banlist)
				else
	                table.insert(HSTOptions[Realm][Player]["BanList"],hst.player)
					hst_addtext(hstquotes.hst..hst_capitalize(hst.player)..hstquotes.added..hstquotes.banlist)
					HSTOptions[Realm][Player]["BanList"].update = 1
				end
		elseif msg == "show queue" then
			if table.getn(hstqueue) == 0 then
				hst_addtext(hstquotes.noqueue)
			else	
				hst_addtext(hstquotes.queuelist)
				table.foreachi(hstqueue,hst_printlist)
			end
		elseif string.sub(msg,1,9) == "untrigger" then
		    hst.player = string.lower(string.sub(msg,11))
		    table.foreachi(HSTOptions[Realm][Player]["Whispers"],hst_playerplace)
		        if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["Whispers"]) ~= 0 then
		            table.remove(HSTOptions[Realm][Player]["Whispers"],hst.playerplace)
					hst_addtext(hstquotes.hst..hst.player..hstquotes.removed..hstquotes.whispers)
					HSTOptions[Realm][Player]["Whispers"].update = 1
				else
					hst_addtext(hstquotes.hst..hst.player..hstquotes.notin..hstquotes.whispers)
				end
		elseif msg == "show triggers" then
		    hst_addtext(hstquotes.whisperlist)
		    table.foreachi(HSTOptions[Realm][Player]["Whispers"],hst_printlist)
		elseif string.sub(msg,1,7) == "trigger" then
			hst.player = string.lower(string.sub(msg,9))
			if hst.player ~= "" then
				table.foreachi(HSTOptions[Realm][Player]["Whispers"],hst_playerplace)
				if hst.playerplace ~= nil and table.getn(HSTOptions[Realm][Player]["Whispers"]) ~= 0 then
					hst_addtext(hstquotes.hst..hst.player..hstquotes.alreadyin..hstquotes.whispers)
				else
	                table.insert(HSTOptions[Realm][Player]["Whispers"],hst.player)
					hst_addtext(hstquotes.hst..hst.player..hstquotes.added..hstquotes.whispers)
					HSTOptions[Realm][Player]["Whispers"].update = 1
				end
			end
		elseif msg == "toggle ui" then
		    if getglobal("HST_MainFrame"):IsVisible() then
				getglobal("HST_MainFrame"):Hide()
				HSTOptions[Realm][Player]["ShowUI"] = 0
			else
				getglobal("HST_MainFrame"):Show()
				HSTOptions[Realm][Player]["ShowUI"] = "Queue"
				getglobal("HST_Queue"):SetText("Current Queue:")
				hstqueue.update = 1
			end
		elseif msg == "afk on" then
		    hst.afk = "on"
		    hst_addtext(hstquotes.afkon)
		elseif msg == "afk off" then
		    hst.afk = "off"
		    hst_addtext(hstquotes.afkoff)
		elseif msg == "help" then hst_helpmenu()
		elseif msg == "help advanced" then hst_advhelpmenu()
		elseif msg == "restore settings" then
			hst_addtext(hstquotes.resetsettings) 
			for key in HSTOptions[Realm][Player] do HSTOptions[Realm][Player] = nil end
			hst_startup()
		elseif msg == "silence on" then
			HSTOptions[Realm][Player]["Silence"] = "on"
			hst_addtext(hstquotes.silenceon)
		elseif msg == "silence off" then
			HSTOptions[Realm][Player]["Silence"] = "off"
			hst_addtext(hstquotes.silenceoff)
		elseif msg == "doit" then
			hst_createhs()
		else
			hst_addtext(hstquotes.help)
		end
	end
end

function hst_createhs()
	if HSTOptions[Realm][Player]["Status"] == "on" and string.lower(UnitClass("player")) == hstquotes.warlock then
		hst_hstalent()
		if hst.confirm then
			hst.confirm = nil
			hst.sayonce = nil
			hst_underthreshold()
		elseif hst.threshold then
		    hst.threshold = nil
		    hst.sayonce = nil
		    hst_checkafk()
		elseif hst.trading then
			if hst.casting and hst.numhs<2 then
				hst_casths()
			elseif hst.hsadded and hst.numhs<2 then
				hst.hsadded = nil
				hst.button = hst.button + 1
				hst.hslevel = hst.hslevel-1
				hst_hslevel()
				hst_tradinghs()
			elseif hst.targetting then
			    if not CheckInteractDistance("target",2) then
					hst_addtext(hstquotes.canttrade)
					hst_sendchatmsg(hstquotes.hst..hstquotes.movingcloser,"WHISPER",language,temptarget)
				else
				    hst.targetting = nil
					hst_determinehs()
				end
			end
		elseif hst.trigger then
			CancelTrade()
			hst_sendchatmsg(hstquotes.hst..hstquotes.cancelled,"WHISPER",language,temptarget2)
			hst.trigger = nil
			hst.triggerstart = nil
		elseif hst.window then
			hst.trading = 1
			hst.target = temptarget2
			--hst_sendchatmsg(hstquotes.hsattempt,"WHISPER",language,hst.target)
			TargetByName(hst.target)
			hst_determinehs()
		elseif hst.combat then
			hst.hstype = hst.uhstype
			hst.hslevel = hst.uhslevel
			hst.healthstone = hst.uhealthstone
			if not hst_havehs() then
				if UnitHealthMax("player")-UnitHealth("player") >= hst.uhsamount then UseContainerItem(hst.bag,hst.slot) end
			else 
				hst.hslevel = hst.hslevel-1
				hst_hslevel()
				if not hst_havehs() then
					if UnitHealthMax("player")-UnitHealth("player") >= hst.uhsamount then UseContainerItem(hst.bag,hst.slot) end
				else
					hst.hslevel = hst.hslevel + 1
					hst_hslevel()
					hst_casths()
				end 
			end
		else
			hst.hstype = hst.uhstype
			hst.hslevel = hst.uhslevel
			hst.healthstone = hst.uhealthstone
			if hst_havehs() then
				hst_casths()
			else
				if UnitName("target") ~= nil and UnitIsFriend("player","target") and UnitIsPlayer("target") and UnitName("target") ~= UnitName("player") then
					temptarget = string.lower(UnitName("target"))
					hst.player = temptarget
					table.foreachi(hstqueue,hst_playerplace)
					if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then table.remove(hstqueue,hst.playerplace) end
					hst.bypassqueuecheck = 1
					hst_prelim()
				else
					temptarget = hstqueue[1]
					if temptarget then
						table.remove(hstqueue,1)
						hstqueue.update = 1
                   			 	if hst_testforrange(temptarget) then
                    					hst.bypassqueuecheck = 1
				 			hst_prelim()
						else
							hst_sendchatmsg(hstquotes.hst..hstquotes.canttarget..hstquotes.queueadd,"WHISPER",language,temptarget)
							table.insert(hstqueue,temptarget)
							hstqueue.update = 1
						end
					else
						if GetNumPartyMembers()>0 then hst.audience = "PARTY" end
						if GetNumRaidMembers()>0 then hst.audience = "RAID" end
						if hst.audience == nil then hst.audience = "SAY" end
						local time = GetTime()
						if time >= hst.timespam + 10 and not UnitIsDeadOrGhost("player") then
							hst_sendchatmsg(HSTOptions[Realm][Player]["Spam"],hst.audience)
							hst.timespam = GetTime()
						end
					end
				end
			end
		end
	end
end

function hst_testforrange(target)
	TargetByName(target)
	if UnitName("target") == nil or string.lower(UnitName("target")) ~= target then
   		if hst.combat then TargetLastEnemy() else ClearTarget() end
		return false
	else
	    return true
	end
end

function hst_checkafk()
	if hst.afk == "on" then
		hst.player = temptarget
     	if hst.combat then TargetLastEnemy() else ClearTarget() end
		table.foreachi(hstqueue,hst_playerplace)
		if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
			hst_sendchatmsg(hstquotes.hst..hstquotes.inqueue,"WHISPER",language,temptarget)
		else
			hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,temptarget)
			table.insert(hstqueue,temptarget)
			hstqueue.update = 1
		end
	else
	    hst_prelim()
	end
end

function hst_prelim()
	local distIndex = UnitPopupButtons["TRADE"].dist
	if UnitIsDeadOrGhost("player") then
		hst.player = temptarget
		table.foreachi(hstqueue,hst_playerplace)
		if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
			hst_sendchatmsg(hstquotes.hst..hstquotes.inqueue,"WHISPER",language,temptarget)
		else
			hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,temptarget)
			table.insert(hstqueue,temptarget)
			hstqueue.update = 1
		end
	elseif hst.trading or hst.window then
		hst.player = temptarget
  		if hst.combat then TargetLastEnemy() else ClearTarget() end
		table.foreachi(hstqueue,hst_playerplace)
		if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
			hst_sendchatmsg(hstquotes.busy..hstquotes.inqueue,"WHISPER",language,temptarget)
		else
			hst_sendchatmsg(hstquotes.busy..hstquotes.queueadd,"WHISPER",language,temptarget)
			table.insert(hstqueue,temptarget)
			hstqueue.update = 1
		end
	elseif hst.combat then
		hst.player = temptarget
  		TargetLastEnemy()
		table.foreachi(hstqueue,hst_playerplace)
		if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
			hst_sendchatmsg(hstquotes.hst..hstquotes.combat..hstquotes.inqueue,"WHISPER",language,temptarget)
		else
			hst_sendchatmsg(hstquotes.hst..hstquotes.combat..hstquotes.queueadd,"WHISPER",language,temptarget)
			table.insert(hstqueue,temptarget)
			hstqueue.update = 1
		end
	elseif table.getn(hstqueue) ~= 0 and not hst.bypassqueuecheck then
		hst.player = temptarget
     	if hst.combat then TargetLastEnemy() else ClearTarget() end
		table.foreachi(hstqueue,hst_playerplace)
		if hst.playerplace ~= nil and table.getn(hstqueue) ~= 0 then
			hst_sendchatmsg(hstquotes.hst..hstquotes.inqueue,"WHISPER",language,temptarget)
		else
			hst_sendchatmsg(hstquotes.hst..hstquotes.queueadd,"WHISPER",language,temptarget)
			table.insert(hstqueue,temptarget)
			hstqueue.update = 1
		end
	elseif not CheckInteractDistance("target",distIndex) then
		hst_addtext(hstquotes.canttrade)
		hst_sendchatmsg(hstquotes.hst..hstquotes.movingcloser,"WHISPER",language,temptarget)
  		hst.targetting = 1
  		hst.trading = 1
  		hst.bypassqueuecheck = nil
  		hst.target = temptarget
	else
		hst.trading = 1
		hst.bypassqueuecheck = nil
		hst.target = temptarget
		hst_determinehs() --new
		--hst_sendchatmsg(hstquotes.hsattempt,"WHISPER",language,hst.target)
		--InitiateTrade("target")
	end
end

function hst_teststring()
	for index,value in HSTOptions[Realm][Player]["Whispers"] do
		if string.lower(string.sub(hst.text,1,string.len(value))) == string.lower(value) and not string.find(string.sub(hst.text,string.len(value) + 1,string.len(value) + 2),"%a") then return true end
	end
	return false
end

function hst_determinehs()
	--ToggleBackpack()
	hst.level = UnitLevel("target")
	if hst.level<12 then
		hst.hslevel = 1
	elseif 12 <= hst.level and hst.level<24 then
		hst.hslevel = 2
	elseif 24 <= hst.level and hst.level<36 then
		hst.hslevel = 3
	elseif 36 <= hst.level and hst.level<48 then
		hst.hslevel = 4
	elseif 48 <= hst.level then
		hst.hslevel = 5
	end
	hst_hslevel()
	hst_tradinghs()
end

function hst_tradinghs()
    if hst_havehs() then
		if not hst.casting then
			hst.casting = 1
			hst_addtext(hstquotes.hst..hst.healthstone..hstquotes.nohealthstone,1.00,0.00,0.00)
		end
	else
	    hst.casting = nil
	    hst.numhs = hst.numhs + 1
		hst_sendchatmsg(hstquotes.hsattempt,"WHISPER",language,hst.target) --new
		if not hst.window then
			InitiateTrade("target")
		else
		    for i = 1,4 do CloseBag(i) end --new
			PickupContainerItem(hst.bag,hst.slot) --new
			ClickTradeButton(hst.button) --new
		end
		--PickupContainerItem(hst.bag,hst.slot)
		--ClickTradeButton(hst.button)
	end
end

function hst_hslevel()
	if hst.hslevel == 1 or hst.hslevel == 0 then
		hst.healthstone = hstwords.minorhs
	elseif hst.hslevel == 2 then
		hst.healthstone = hstwords.lesserhs
	elseif hst.hslevel == 3 then
		hst.healthstone = hstwords.reghs
	elseif hst.hslevel == 4 then
		hst.healthstone = hstwords.greaterhs
	elseif hst.hslevel == 5 then
	    hst.healthstone = hstwords.majorhs
	end
	hst.hstype = hsths[hst.hslevel]
end

function hst_havehs()
	local bag
	local slot
	if hst.hslevel>hst.uhslevel then
	    hst.healthstone = hst.uhealthstone
	    hst.hstype = hst.uhstype
	    hst.hslevel = hst.uhslevel
	end
	for bag = 0,4 do
  	 	for slot = 1,GetContainerNumSlots(bag) do
      			if (GetContainerItemLink(bag,slot)) then
        			if string.find(GetContainerItemLink(bag,slot),hstitems[hst.hslevel]) then
          				hst.bag = bag
					hst.slot = slot
					return false
				end
			end
		end
	end
	return true
end

function hst_casths()
	hst.id = nil
	local i = 1
	while GetSpellName(i,"spell") do
   		hst.spellname = string.lower(GetSpellName(i,"spell"))
 		if hst.hslevel ~= 3 then
		 	if string.find(hst.spellname,hstquotes.healthstone) and string.find(hst.spellname,hst.hstype) then
				hst.id = i
			end
		else
			if string.find(hst.spellname,hstquotes.healthstone) then
				hst.notright = nil
				for value in hsths do
					if string.find(hst.spellname,value) then hst.notright = 1 end
				end
				if not hst.notright then
					hst.id = i
					break
				end
			end
		end
		i = i + 1
	end
	CastSpell(hst.id,"spell")
end

function hst_sendmsg(index,value)
    hst_sendchatmsg(hstquotes.hst..hstquotes.queueremove,"WHISPER",language,value)
end

function hst_sendchatmsg(msg,type,lang,target)
	if type == "WHISPER" then
		if HSTOptions[Realm][Player]["Silence"] == "off" then
			SendChatMessage(msg,type,lang,target)
		end
	else
		SendChatMessage(msg,type,lang,target)
	end
end

function hst_playerplace(index,value)
	if index == 1 then hst.playerplace = nil end
	if value == hst.player then hst.playerplace = index end
end

function hst_printlist(index,value)
	hst_addtext(hst_capitalize(value))
end

function hst_sendtolist(index,value)
	if index <= 10 then
		getglobal("HST_Queue"..index):Show()
		if HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
			getglobal("HST_Queue"..index.."Target"):SetText(index..": "..value)
		else
			getglobal("HST_Queue"..index.."Target"):SetText(index..": "..hst_capitalize(value))
		end
	end
end

function hst_capitalize(name)
	 return string.upper(string.sub(name,1,1))..string.sub(name,2)
end

function hst_addtext(text,color1,color2,color3)
	if DEFAULT_CHAT_FRAME then DEFAULT_CHAT_FRAME:AddMessage(text,color1,color2,color3) end
end

function hst_OnEditClick()
	if not getglobal("HST_EditBox"):IsVisible() then
		getglobal("HST_EditBox"):Show()
		getglobal("HST_EditBox"):ClearAllPoints()
		getglobal("HST_EditBox"):SetPoint("TOPRIGHT",this,"BOTTOMLEFT",-20,0)
	else
		getglobal("HST_EditBox"):Hide()
	end
end

function hst_enterpressed()
	local text = string.lower(getglobal("HST_EditBox"):GetText())
	if HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
		hst_commands("add "..string.lower(text))
	elseif HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
	    hst_commands("ban "..string.lower(text))
	elseif HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
	    hst_commands("trigger "..string.lower(text))
	end
	getglobal("HST_EditBox"):SetText("")
	getglobal("HST_EditBox"):Hide()
end

function hst_OnEntryClick()
	local index = this:GetID()
	local _,_,target = string.find(getglobal("HST_Queue"..index.."Target"):GetText(),"(%a+)")
	if HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
		hst_commands("remove "..string.lower(target))
	elseif HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
	    hst_commands("unban "..string.lower(target))
	elseif HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
	    hst_commands("untrigger "..string.lower(target))
	end
end

function hst_editmouseover(state)
	if HSTOptions[Realm][Player]["ShowUI"] ~= "None" then
		if state == 1 then
			getglobal("HST_TooltipTemplate"):Show()
			getglobal("HST_TooltipTemplateTooltip"):SetText("Left-Click to add an entry, prefix with [class,player] if for queue")
			getglobal("HST_TooltipTemplate"):ClearAllPoints()
			getglobal("HST_TooltipTemplate"):SetPoint("TOPRIGHT", this, "TOPLEFT",-10,0)
		elseif state == 0 then
			getglobal("HST_TooltipTemplate"):Hide()
		end
	end
end

function hst_entrymouseover(state)
	if state == 1 then
		getglobal("HST_TooltipTemplate"):Show()
		getglobal("HST_TooltipTemplateTooltip"):SetText("Left-Click to remove this entry.")
		getglobal("HST_TooltipTemplate"):ClearAllPoints()
		getglobal("HST_TooltipTemplate"):SetPoint("TOPRIGHT", this, "TOPLEFT",-10,0)
	elseif state == 0 then
		getglobal("HST_TooltipTemplate"):Hide()
	end
end

function hst_togglebuttons()
	if getglobal("HST_Menu"):IsVisible() then getglobal("HST_Menu"):Hide() else getglobal("HST_Menu"):Show() end
end

function hst_toggleview()
    if HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
     	HSTOptions[Realm][Player]["ShowUI"] = "BanList"
     	getglobal("HST_Queue"):SetText("Ban List:")
     	HSTOptions[Realm][Player]["BanList"].update = 1
	elseif HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
		HSTOptions[Realm][Player]["ShowUI"] = "Triggers"
		getglobal("HST_Queue"):SetText("Triggers")
		HSTOptions[Realm][Player]["Whispers"].update = 1
	elseif HSTOptions[Realm][Player]["ShowUI"] == "Triggers" then
	    HSTOptions[Realm][Player]["ShowUI"] = "None"
	    getglobal("HST_Queue"):SetText(hst_filler())
		for entry = 1,10 do getglobal("HST_Queue"..entry):Hide() end
	elseif HSTOptions[Realm][Player]["ShowUI"] == "None" then
		HSTOptions[Realm][Player]["ShowUI"] = "Queue"
		getglobal("HST_Queue"):SetText("Current Queue:")
		hstqueue.update = 1
	end
end

function hst_clearshown()
	if HSTOptions[Realm][Player]["ShowUI"] == "BanList" then
		hst_commands("clear banned")
	elseif HSTOptions[Realm][Player]["ShowUI"] == "Queue" then
		hst_commands("clear queue")
	else
		hst_addtext(hstquotes.hst..hstquotes.cantclear)
	end
end

function hst_filler()
	local bag
	local slot
	local healthstone = 0
	local soulshard = 0
	for bag = 0,4 do
  	 	for slot = 1,GetContainerNumSlots(bag) do
  			if (GetContainerItemLink(bag,slot)) then
    			if string.find(string.lower(GetContainerItemLink(bag,slot)),hstquotes.healthstone) then healthstone = healthstone + 1 end
			end
  			if (GetContainerItemLink(bag,slot)) then
    			if string.find(GetContainerItemLink(bag,slot),"6265") then soulshard = soulshard + 1 end
			end
		end
	end
	return "SS: "..soulshard..", HS: "..healthstone
end

function hst_tooltip(id,state)
	if state == 1 then
		getglobal("HST_TooltipTemplate"):Show()
		local text = HSTMenuTooltip[id]
		local setting
		if id == 1 then setting = HSTOptions[Realm][Player]["Status"]
		elseif id == 2 then setting = HSTOptions[Realm][Player]["Ignore"]
		elseif id == 3 then setting = HSTOptions[Realm][Player]["Confirm"]
		elseif id == 4 then 
			if HSTOptions[Realm][Player]["Spam"] == hstquotes.hst..hstquotes.defaultspam then setting = "default" else setting = "custom" end 
		elseif id == 5 then 
			if hst.afk then setting = "on" else setting = "off" end
		elseif id == 6 then
			if HSTOptions[Realm][Player]["Header"] == "HST: " then setting = "on" else setting = "off" end
		elseif id == 7 then setting = HSTOptions[Realm][Player]["Scale"]
		elseif id == 8 then setting = HSTOptions[Realm][Player]["Threshold"]
		elseif id == 9 then setting = HSTOptions[Realm][Player]["Silence"]
		elseif id == 10 then setting = ""
		elseif id == 11 then setting = ""
		end
		getglobal("HST_TooltipTemplateTooltip"):SetText(text..setting)
		getglobal("HST_TooltipTemplate"):ClearAllPoints()
		getglobal("HST_TooltipTemplate"):SetPoint("TOPRIGHT", this, "TOPLEFT",-50,0)
	elseif state == 0 then
		getglobal("HST_TooltipTemplate"):Hide()
	end
end

function hst_menuclick(id)
	for id = 1,3 do getglobal("HST_MenuButton2_"..id):Hide() end
	getglobal("HST_MenuEditBox"):Hide()
	if hst.menuid ~= id then
	    hst.menuid = id
		if id == 1 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("On")
			getglobal("HST_MenuButton2_2"):Show()
			getglobal("HST_MenuButton2_2"):ClearAllPoints()
			getglobal("HST_MenuButton2_2"):SetPoint("TOP",getglobal("HST_MenuButton2_1"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_2"):SetText("Off")
		elseif id == 2 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("All")
			getglobal("HST_MenuButton2_2"):Show()
			getglobal("HST_MenuButton2_2"):ClearAllPoints()
			getglobal("HST_MenuButton2_2"):SetPoint("TOP",getglobal("HST_MenuButton2_1"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_2"):SetText("Nongroup")
	 		getglobal("HST_MenuButton2_3"):Show()
			getglobal("HST_MenuButton2_3"):ClearAllPoints()
			getglobal("HST_MenuButton2_3"):SetPoint("TOP",getglobal("HST_MenuButton2_2"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_3"):SetText("Off")
		elseif id == 3 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("All")
			getglobal("HST_MenuButton2_2"):Show()
			getglobal("HST_MenuButton2_2"):ClearAllPoints()
			getglobal("HST_MenuButton2_2"):SetPoint("TOP",getglobal("HST_MenuButton2_1"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_2"):SetText("Nongroup")
	 		getglobal("HST_MenuButton2_3"):Show()
			getglobal("HST_MenuButton2_3"):ClearAllPoints()
			getglobal("HST_MenuButton2_3"):SetPoint("TOP",getglobal("HST_MenuButton2_2"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_3"):SetText("Off")
		elseif id == 4 then
			getglobal("HST_MenuEditBox"):Show()
			getglobal("HST_MenuEditBox"):ClearAllPoints()
			getglobal("HST_MenuEditBox"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("TOP",getglobal("HST_MenuEditBox"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_1"):SetText("Default")
		elseif id == 5 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("On")
			getglobal("HST_MenuButton2_2"):Show()
			getglobal("HST_MenuButton2_2"):ClearAllPoints()
			getglobal("HST_MenuButton2_2"):SetPoint("TOP",getglobal("HST_MenuButton2_1"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_2"):SetText("Off")
		elseif id == 6 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("Toggle")
		elseif id == 7 then
			getglobal("HST_MenuEditBox"):Show()
			getglobal("HST_MenuEditBox"):ClearAllPoints()
			getglobal("HST_MenuEditBox"):SetPoint("LEFT",this,"RIGHT",35,0)
		elseif id == 8 then
			getglobal("HST_MenuEditBox"):Show()
			getglobal("HST_MenuEditBox"):ClearAllPoints()
			getglobal("HST_MenuEditBox"):SetPoint("LEFT",this,"RIGHT",35,0)
		elseif id == 9 then
			getglobal("HST_MenuButton2_1"):Show()
			getglobal("HST_MenuButton2_1"):ClearAllPoints()
			getglobal("HST_MenuButton2_1"):SetPoint("LEFT",this,"RIGHT",35,0)
			getglobal("HST_MenuButton2_1"):SetText("On")
			getglobal("HST_MenuButton2_2"):Show()
			getglobal("HST_MenuButton2_2"):ClearAllPoints()
			getglobal("HST_MenuButton2_2"):SetPoint("TOP",getglobal("HST_MenuButton2_1"),"BOTTOM",0,-1)
			getglobal("HST_MenuButton2_2"):SetText("Off")
		elseif id == 10 then
			hst_commands("restore settings")
			hst.menuid = nil
		elseif id == 11 then
			getglobal("HST_MenuButtons"):Hide()
			hst.menuid = nil
		end
	end
end

function hst_menuenterpressed()
	local text = this:GetText()
	this:SetText("")
	if hst.menuid == 4 then
		hst_commands("spam: "..text)
	elseif hst.menuid == 7 then
		hst_commands("scale "..text)
	elseif hst.menuid == 8 then
		hst_commands("threshold "..text)
	end
	for id = 1,3 do getglobal("HST_MenuButton2_"..id):Hide() end
	getglobal("HST_MenuEditBox"):Hide()
	hst.menuid = nil
end

function hst_menubuttonclick(id)
	if hst.menuid == 1 then
		if id == 1 then
			hst_commands("on")
		elseif id == 2 then
			hst_commands("off")
		end
	elseif hst.menuid == 2 then
		if id == 1 then
			hst_commands("ignore all")
		elseif id == 2 then
			hst_commands("ignore nongroup")
		elseif id == 3 then
			hst_commands("ignore off")
		end
	elseif hst.menuid == 3 then
		if id == 1 then
			hst_commands("confirm all")
		elseif id == 2 then
			hst_commands("confirm nongroup")
		elseif id == 3 then
			hst_commands("confirm off")
		end
	elseif hst.menuid == 4 then 
		hst_commands("spam: default")
	elseif hst.menuid == 5 then
		if id == 1 then
		    hst_commands("afk on")
		elseif id == 2 then
		    hst_commands("afk off")
		end
	elseif hst.menuid == 6 then
		hst_commands("toggle header")
	elseif hst.menuid == 9 then
		if id == 1 then
			hst_commands("silence on")
		elseif id == 2 then
			hst_commands("silence off")
		end
	end
	for id = 1,3 do getglobal("HST_MenuButton2_"..id):Hide() end
	getglobal("HST_MenuEditBox"):Hide()
	hst.menuid = nil
end

function hst_showmenu()
    if not getglobal("HST_MenuButtons"):IsVisible() then
		getglobal("HST_MenuButtons"):Show()
		for id = 1,3 do getglobal("HST_MenuButton2_"..id):Hide() end
		getglobal("HST_MenuEditBox"):Hide()
	else
		getglobal("HST_MenuButtons"):Hide()
	end
end