#!/usr/bin/perl -w

# This program takes data from my |-delimited file and creates an HTML
# schedule

# require HTML::TokeParser;

use CGI qw/:standard/;
use strict;

my $route = param('route');
my $daytype = param('daytype');
my $direction = param('direction');
#my $route = "54C";
#my $daytype = "WEEK";
#my $direction = "Inbound";
my $daytype_pretty;
if($daytype eq "WEEK") { $daytype_pretty = "Weekdays"; }
elsif($daytype eq "SATU") { $daytype_pretty = "Saturday"; }
elsif($daytype eq "SUND") { $daytype_pretty = "Sunday"; }
else { $daytype_pretty = "Holidays"; }

print header,
    start_html("Custom Schedule -- ${route} $daytype_pretty $direction"),
    h1('Custom Schedule'), "\n";

my $i = 0;

my @stops = param('stop');

#  print "stops = ";
#  print @stops;
#  print "\n";

open(STOPS, "/home/brian/www/buses/data/${route}-${daytype}-${direction}-stops")or
    (print("<p>Unable to open data file\n"), exit(1));

my $stops_string = <STOPS>;

my @file_stops = split (/\|/, $stops_string);

print ("size of file_stops is", (0+@file_stops), "\n");

#my @interested = map { 0 != grep(/${_}/, @stops)  } @file_stops;
#my @interested = map { my @ta = @stops; my $u = 0; while (0 != @ta && !($v = ($_ eq pop(@ta)))){}; 0 != $v } @file_stops;
#my @interested = map { 0; 0!=1 } @file_stops;

my $j;
my $k;
my @interested;
for ($j =0; $j < @file_stops; $j++)
{
    $interested[$j] = 0;
    for ($k = 0; $k < @stops; $k++)
    {
	if ($file_stops[$j] eq $stops[$k])
	{
	    $interested[$j] = 1;
	}
    }
}

my $v;

#  for ($v = 0; $v < @interested; $v++)
#  {
#      print "interested[${v}] is $interested[$v]\n";
#  }

my %times = (); #The times for the stops we are interested in


my $temp = "";

my $outrow = 0;

my $stop;


my $tripstring;

my $tripstring1;

my @trip;

open (INFILE, "/home/brian/www/buses/data/${route}-${daytype}-${direction}.dat")or
    (print("<p>Unable to open second data file\n"), exit(1));
print ("<p> opening /home/brian/www/buses/data/${route}-${daytype}-${direction}.dat\n");
print "<TABLE BORDER=\"1\">\n" ;

while (<INFILE>)
{
    $tripstring = $_;
    chomp( $tripstring );
#    print "<p>tripstring is ${tripstring}\n";
    
    @trip = split(/\|/, $tripstring);

    for ($i=0; $i < @file_stops; $i++)
    {
	if (($trip[$i] ne "") && $interested[$i])
	{
	    $times{ $file_stops[$i] } = $trip[$i];
	}
    }

    if ((keys(%times) == @stops) || (keys(%times) > 1))
    {
#	print 'keys(%times) is ';
#	print keys(%times);
#	print "\n";
	if ($outrow % 20 == 0)             #If we've printed 20x lines
	{
	    print ("<TR>");
	    for($i=0; $i < @stops; $i++)
	    {
		print ("<TH>$stops[$i]</TH>");
	    }
	    print ("</TR>\n");
	}

	print ("<TR>");
	foreach $i (@stops)
	{
	    print ("<TD>");
	    print (exists($times{$i}) ? $times{$i} : "");
	    print ("</TD>");
	}
	%times = ();
	print ("</TR>\n");
	$outrow ++;
    }
}
print "</TABLE>" ;

print "<p>Data gathered on",
    scalar localtime((stat("/home/brian/www/buses/data/${route}-${daytype}-${direction}.dat"))[9]);

print "<p><a href=\"../${route}-${daytype}-${direction}.html\">Click here</a>\n";

