#!/usr/bin/perl -w

# This program takes data from my |-delimited file and creates an HTML
# schedule

use strict;

use lib "/home/brian/perl/lib/site_perl/i386-linux";
use lib "/home/brian/perl/lib/site_perl";

require HTML::TokeParser;

use CGI qw/:standard/;
#use File::stat;
#use Time::localtime;

my $route = param('route');
my $daytype = param('daytype');
my $direction = param('direction');
#my $route = "54C";
#my $daytype = "WEEK";
#my $direction = "Inbound";
my $daytype_pretty;
if($daytype eq "WEEK") { $daytype_pretty = "Weekdays"; }
elsif($daytype eq "SATU") { $daytype_pretty = "Saturday"; }
elsif($daytype eq "SUND") { $daytype_pretty = "Sunday"; }
else { $daytype_pretty = "Holidays"; }

print header, h1('Step 4'), "\n";

open (STOPS, "/home/brian/www/buses/data/${route}-${daytype}-${direction}-stops");

my $stops_string = <STOPS>;

my @stops = split (/\|/, $stops_string);

#my @in_stops = ("South Hills Junction", "McKinley / Brownsville", "Drycove / Conniston", "Amanda / Charles", "Arlington / 18th", "Carson / 18th");

#my @in_stops = ("Pittsburgh Airport Departures", "Pittsburgh Airport Arrivals", "Robinson Town Center", "Bell Station", "Liberty / Stanwix", "Carnegie Mellon University");

#my @stops = @in_stops;

open (OUT, ">/home/brian/www/buses/${route}-${daytype}-${direction}.html");
#select (OUT);

my %times = ();

my $i = 0;

my $temp = "";

my $outrow = 0;

my $stop;


my $tripstring;

my $tripstring1;

my @trip;

#    ctime((stat("${route}-${daytype}-${direction}.dat"))->mtime), "\n";

print OUT "<TITLE>${route} ${daytype_pretty} ${direction}</TITLE>\n";

print OUT "<TABLE BORDER=\"1\">\n" ;
open (INFILE, "/home/brian/www/buses/data/${route}-${daytype}-${direction}.dat");
#print ("<p> opening /home/brian/www/buses/data/${route}-${daytype}-${direction}.dat\n");

while (<INFILE>)
{
    $tripstring = $_;
    chomp( $tripstring );
#    print "<p>tripstring is ${tripstring}\n";
    
    @trip = split(/\|/, $tripstring);

    if ($outrow % 20 == 0)             #If we've printed 20x lines
    {
	print OUT ("<TR>");
	for($i=0; $i < @stops; $i++)
	{
	    print OUT ("<TH>$stops[$i]</TH>");
	}
	print OUT ("</TR>\n");
    }

    print OUT ("<TR>");
    for ($i=0; $i < @stops; $i++)
    {
	print OUT ("<TD>");
	print OUT ($trip[$i]);
	print OUT ("</TD>");
	delete ($times{$stop});
    }
    print OUT ("</TR>\n");
    $outrow ++;
}
print OUT "</TABLE>" ;

print OUT "<p>Data gathered on",
    scalar localtime((stat("/home/brian/www/buses/data/${route}-${daytype}-${direction}.dat"))[9]);

print "<p><a href=\"../${route}-${daytype}-${direction}.html\">Click here</a>\n";
