#!/usr/bin/perl -w

# This program takes data from copies of the PortAuthority webpage on the hard
# drive and creates | delimited output.

# use strict;

use lib "/home/brian/perl/lib/site_perl/i386-linux";
use lib "/home/brian/perl/lib/site_perl";

require HTML::TokeParser;

use CGI qw/:standard/;

my $route = param('route');
my $daytype = param('daytype');
my $direction = param('direction');
#my $route = "54C";
#my $daytype = "WEEK";
#my $direction = "Inbound";
my $daytype_pretty;
if($daytype eq "WEEK") { $daytype_pretty = "Weekdays"; }
elsif($daytype eq "SATU") { $daytype_pretty = "Saturday"; }
elsif($daytype eq "SUND") { $daytype_pretty = "Sunday"; }
else { $daytype_pretty = "Holidays"; }

open (STOPS, "/home/brian/www/buses/data/${route}-${daytype}-${direction}-stops");

my $stops_string = <STOPS>;

my @stops = split (/\|/, $stops_string);

#my @in_stops = ("South Hills Junction", "McKinley / Brownsville", "Drycove / Conniston", "Amanda / Charles", "Arlington / 18th", "Carson / 18th");

#my @in_stops = ("Pittsburgh Airport Departures", "Pittsburgh Airport Arrivals", "Robinson Town Center", "Bell Station", "Liberty / Stanwix", "Carnegie Mellon University");

#my @stops = @in_stops;

print header, h1('Step 3'), "\n";

open (OUT, ">/home/brian/www/buses/data/${route}-${daytype}-${direction}.dat");
#select (OUT);

my %times = ();

my $i = 0;

my $temp = "";

my $token = "";
my $outrow = 0;

my $stop;

open (INPUT, "</home/brian/www/buses/data/${route}-${daytype}-${direction}.1");

while (<INPUT>)
{
    ($time, $stop, $code) = split(/\|/, $_, 3) ;

    $times{ $stop }  = $time;

    if ($code =~ /^E/ )
    {
#	    print STDERR ("    found E\n");
	
	# We have a trip

	my $anystops = 0;    #are we interested in any of the stops?

	foreach $stop (@stops)
	{
	    if (exists($times{$stop})) 
	    {
		$anystops = 1;
		last;
	    }
	}

	if ($anystops)
	{
	    foreach $stop (@stops)
	    {
		print OUT (exists($times{$stop}) ? $times{$stop} : "");
		print OUT ("|");
		delete ($times{$stop});
	    }
	    print OUT ("\n");
	    $outrow ++;
	}
    }
}
print "<p><a href=\"request4.pl?route=${route}&direction=${direction}&" ,
    "daytype=${daytype}\">Click here to continue</a>\n";

#     defined ( $ttext = $parsein->get_trimmed_text("/font")) or
# 	$ttext = "error--can't get text 1223c9\n";

# if ($ttext eq "Time")
# {
#     print "Found Time\n";
# }



