#!/usr/bin/perl -w

# This program takes data from copies of the PortAuthority webpage on the hard
# drive and creates the HTML output.

require HTML::TokeParser;

use CGI qw/:standard/;
use strict;

my $route = param('route');
my $daytype = param('daytype');
my $direction = param('direction');
#my $route = "54C";
#my $daytype = "WEEK";
#my $direction = "Inbound";
my $daytype_pretty;
if($daytype eq "WEEK") { $daytype_pretty = "Weekdays"; }
elsif($daytype eq "SATU") { $daytype_pretty = "Saturday"; }
elsif($daytype eq "SUND") { $daytype_pretty = "Sunday"; }
else { $daytype_pretty = "Holidays"; }

open (STOPS, "/home/brian/www/buses/data/${route}-${daytype}-${direction}-stops");

my $stops_string = <STOPS>;

my @stops = split (/\|/, $stops_string);

#my @in_stops = ("South Hills Junction", "McKinley / Brownsville", "Drycove / Conniston", "Amanda / Charles", "Arlington / 18th", "Carson / 18th");

#my @in_stops = ("Pittsburgh Airport Departures", "Pittsburgh Airport Arrivals", "Robinson Town Center", "Bell Station", "Liberty / Stanwix", "Carnegie Mellon University");

#my @stops = @in_stops;

print header, h1('Step 3'), "\n";

open (OUT, ">/home/brian/www/buses/htdocs/${route}-${daytype}-${direction}.html");
#select (OUT);
print OUT ("<TITLE>${route} Schedule $daytype_pretty ${direction}</TITLE>\n");
print OUT ("<H1>${route} Schedule $daytype_pretty ${direction}</H1>\n");

print OUT "<TABLE BORDER=\"1\">\n<TR>" ;
my %times = ();

print OUT "</TR>\n";

my $i = 0;

my $temp = "";

my $token = "";
my $outrow = 0;

my $stop;

while (my $parsein =
     HTML::TokeParser->new("/home/brian/www/buses/data/${route}-${daytype}-${direction}-${i}.html"))
{
    print STDERR "  starting to process file ${route}-${daytype}-${direction}-${i}.html\n";
#     my $token = $parsein->get_tag() or print STDERR ("error -- out of tokens");
#     print STDERR "  test token is $token->[0] \n";

    defined ($token = $parsein->get_tag("th")) or
	print STDERR ("error--out of tokens\n");

    defined ($parsein->get_tag("/tr")) or 
	print STDERR ("error -- unable to find end of header row\n");

#    print STDERR ("found end of header row\n");

    while (defined ($token = $parsein->get_tag) &&
	   lc($token->[0]) eq "tr")                     #Do I need lc() func?
    {
#	print STDERR ("    Inside inner loop\n");
	#Get column 1
	my $time = $parsein->get_trimmed_text("/td");
#	print STDERR ("    time was ${time}\n");

	$parsein->get_tag("/td");

	#Get column 2
	$temp = $parsein->get_trimmed_text("/td");
	$times{ $temp }  = $time;
	$parsein->get_tag("/td");

#	print STDERR ("    stop was ${temp}\n");

	#Check for anything in Column 3
	if (($parsein->get_trimmed_text("/td")) eq "E")
	{
#	    print STDERR ("    found E\n");
	    
	    # We have a trip

	    my $anystops = 0;    #are we interested in any of the stops?

	    foreach $stop (@stops)
	    {
		if (exists($times{$stop})) 
		{
		    $anystops = 1;
		    last;
		}
	    }

	    if ($anystops)
	    {
		if ($outrow % 20 == 0)             #If we've printed 20x lines
		{                              # Reprint the stop list row
		    print OUT ("<TR>");
		    foreach $stop (@stops)
		    {
			print OUT ("<TH>${stop}</TH>");
		    }
		    print OUT ("</TR>\n");
		}

		#Output a row
		print OUT ("<TR>");
		foreach $stop (@stops)
		{
		    print OUT ("<TD>");
		    print OUT (exists($times{$stop}) ? $times{$stop} : "");
		    print OUT ("</TD>");
		    delete ($times{$stop});
		}
		print OUT ("</TR>\n");
		$outrow ++;
	    }
	}
	#We can ignore any other columns

	#Pop everything up to next "</tr>" off of input
	$parsein->get_tag("/tr");
    }
    $i += 100;
}
#     defined ( $ttext = $parsein->get_trimmed_text("/font")) or
# 	$ttext = "error--can't get text 1223c9\n";

# if ($ttext eq "Time")
# {
#     print "Found Time\n";
# }

print OUT "</TABLE>";


