#!/usr/bin/perl -w

# Produces a list of stops in the data directory

use strict;

use lib "/home/brian/perl/lib/site_perl/i386-linux";
use lib "/home/brian/perl/lib/site_perl";

require HTML::TokeParser;

use CGI qw/:standard/;

my $route = param('route');
my $daytype = param('daytype');
my $direction = param('direction');

my $return;
my $line;

#my $route = "54C";
#my $daytype = "WEEK";
my $daytype_pretty;
if($daytype eq "WEEK") { $daytype_pretty = "Weekdays"; }
elsif($daytype eq "SATU") { $daytype_pretty = "Saturday"; }
elsif($daytype eq "SUND") { $daytype_pretty = "Sunday"; }
else { $daytype_pretty = "Holidays"; }
#my $direction = "Inbound";


open (STOPS, ">/home/brian/www/buses/data/${route}-${daytype}-${direction}-stops");
#select (OUT);

my $i = 0;

my $j;

my $temp = "";

my $token = "";
my $outrow = 0;

my $prevstop = "";
my $stop = "";

#my local %stops;
my %stops = ();

#print header(-Refresh=>'5; URL=request3.pl'), start_html('Step 2');
print header, start_html('Step 2');
print h1('Step 2');

chdir ("/home/brian/www/buses/data/") or
    print STDERR "unable to cd to /home/brian/www/buses/data/";
open (OUTFILE, "> ${route}-${daytype}-${direction}.1") or
    print STDERR "unable to open ${route}-${daytype}-${direction}.1 : $! \n";

#print STDERR "trying to open ${route}-${daytype}-${direction}-${i}.html\n";
while ($return = open (INFILE, "< ${route}-${daytype}-${direction}-${i}.html")
       && 0 != (stat("${route}-${daytype}-${direction}-${i}.html"))[7] )
{
#    print STDERR "  inside loop\n";
    do{
	$line = <INFILE>;
    }
    while (defined($line) && index($line, "VARIATION") < 0);
#      if (defined ($line))
#      {
#  	print STDERR ("found VARIATION\n");
#      }
    
    print STDERR "  checkpoint 10\n";
    my $parsein = HTML::TokeParser->new( \*INFILE );

    if (! defined $parsein)
    {
	print STDERR "error generating parsein\n";
    }

#    print "  starting to process file ${route}-${daytype}-${direction}-${i}.html\n";
#   my $token = $parsein->get_tag() or print STDERR ("error -- out of tokens");
#     print STDERR "  test token is $token->[0] \n";

    defined ($parsein->get_tag("/tr")) or 
	print ("error -- unable to find end of title row\n");

#    print ("found end of header row\n");

    while (defined ($token = $parsein->get_tag) &&
	   lc($token->[0]) eq "tr")                     #Do I need lc() func?
    {
#	print ("    Inside inner loop\n");

	#Get column 1
	$temp = $parsein->get_trimmed_text("/td");
	if (!defined ($temp) || index($temp, ":") < 0)
	{  next;  }
#	print STDERR ("    temp is $temp \n");
	print OUTFILE $temp, "|";

	$parsein->get_tag("/td");
	#Get column 2
	$temp = $parsein->get_trimmed_text("/td");
#	print STDERR ("    temp2 is $temp \n");
	$prevstop = $stop;
	$stop = $temp;

	if (!($prevstop eq "") && exists ($stops{$stop}))
	{
	    foreach $j (@{$stops{$stop}})
	    {
		if ($j eq $prevstop)
		{
		    goto FOUND;
		}
	    }
	    push (@{$stops{$stop}}, $prevstop);
	  FOUND:
	}
	else
	{
	    $stops{$stop} = (($prevstop eq "") ? [0] : [ 0, $prevstop ]);
	}

	print OUTFILE $stop, "|";

	$parsein->get_tag("/td");
#	print STDERR ("    stop was ${temp}\n");

	#Check for anything in Column 3
	$temp = $parsein->get_trimmed_text("/td");
#	print STDERR ("temp 3 is $temp\n"); 
	print OUTFILE $temp, "\n";
	if ($temp eq "E")
	{
#	    print STDERR ("    found E\n");
	    
	    $prevstop = $stop = "";

	    # We have a trip

	}
	#We can ignore any other columns
    }
    continue
    {
	#Pop everything up to next "</tr>" off of input
	$parsein->get_tag("/tr");
    }
    $i++;
}

#print STDERR "error opening ${route}-${daytype}-${direction}-${i}.html\n";
#print STDERR $! ;

#     defined ( $ttext = $parsein->get_trimmed_text("/font")) or
# 	$ttext = "error--can't get text 1223c9\n";

#sub print_stop($instop);
sub print_stop
{
    my $stop = $_[0];
    if (!(exists ($stops{ $stop })))
    {
	return;
    }
    if ($stops{ $stop }[0] ne 0)     #If there's a 0 this is our first time
    {
	return;
    }
    shift ( @{$stops{ $stop }});
    
    foreach $i ( @{$stops{ $stop }} )
    {
	print_stop($i);
    }
    print STOPS $stop, '|';
    delete ($stops{ $stop });
}

foreach $i (keys(%stops))
{
    print_stop($i);
}

print "<p><a href=\"request3.pl?route=${route}&direction=${direction}&" ,
    "daytype=${daytype}\">Click here to continue</a>\n";

