#include <sysdep.h>
#include <zephyr/zephyr.h>
#include <com_err.h>

int
main(argc,argv)
	int argc;
	char *argv[];
{
	int retval, nsubs, one;
	short wgport;
	ZSubscription_t subs;

	if ((retval = ZInitialize()) != ZERR_NONE) {
	  com_err(argv[0],retval,"while initializing");
	  exit (1);
	}

 	if ((wgport = ZGetWGPort()) == -1) {
	  com_err(argv[0],errno,"while finding WindowGram port");
	  exit (1);
	} 
	
	retval = ZRetrieveSubscriptions((u_short)wgport,&nsubs);

	if (retval && retval != ZERR_TOOMANYSUBS) {
	  com_err(argv[0],errno,"while finding subscriptions");
	  exit (1);
	}

	if (nsubs < 1)
	  exit (0);

	one = 1;

	if ((retval = ZGetSubscriptions(&subs,&one)) != ZERR_NONE) {
	  com_err(argv[0],retval,"while getting subscription");
	  exit (1);
	}

	retval = ZSubscribeTo(&subs,1,(u_short)wgport);
	
	if (retval != ZERR_NONE) {
	  com_err(argv[0],retval,"while subscribing");
	  exit (1);
	}

	exit (0);
} 
