/* This file is part of the Project Athena Zephyr Notification System.
 * It contains source for the ZFormatSmallRawNotice function.
 *
 *	Created by:	Robert French
 *
 *	$Source: /afs/andrew.cmu.edu/system/cvs/src/zephyr/lib/ZFmtSmRaw.c,v $
 *	$Author: shadow $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */
/* $Header: /afs/andrew.cmu.edu/system/cvs/src/zephyr/lib/ZFmtSmRaw.c,v 1.1.1.1 1998/10/16 13:52:25 shadow Exp $ */

#ifndef lint
static char rcsid_ZFormatRawNotice_c[] = "$Header: /afs/andrew.cmu.edu/system/cvs/src/zephyr/lib/ZFmtSmRaw.c,v 1.1.1.1 1998/10/16 13:52:25 shadow Exp $";
#endif

#include <internal.h>

Code_t ZFormatSmallRawNotice(notice, buffer, ret_len)
    ZNotice_t *notice;
    ZPacket_t buffer;
    int *ret_len;
{
    Code_t retval;
    int hdrlen;
    
    if ((retval = Z_FormatRawHeader(notice, buffer, Z_MAXHEADERLEN,
				    &hdrlen, NULL, NULL)) != ZERR_NONE)
	return (retval);

    *ret_len = hdrlen+notice->z_message_len;

    if (*ret_len > Z_MAXPKTLEN)
	return (ZERR_PKTLEN);

    (void) memcpy(buffer+hdrlen, notice->z_message, notice->z_message_len);

    return (ZERR_NONE);
}

Code_t ZNewFormatSmallRawNotice(notice, buffer, ret_len)
    ZNotice_t *notice;
    ZPacket_t buffer;
    int *ret_len;
{
    Code_t retval;
    int hdrlen;
    
    if ((retval = Z_AsciiFormatRawHeader(notice, buffer, Z_MAXHEADERLEN,
					 &hdrlen, NULL, NULL, NULL, NULL)) 
	!= ZERR_NONE)
	return (retval);
    
    *ret_len = hdrlen+notice->z_message_len;
    
    if (*ret_len > Z_MAXPKTLEN)
	return (ZERR_PKTLEN);
    
    (void) memcpy(buffer+hdrlen, notice->z_message, notice->z_message_len);
    
    return (ZERR_NONE);
}
