

/*

    Copyright 1999-2001, University of Washington.  All rights reserved.

     ____        _                     _    _
    |  _ \ _   _| |__   ___ ___   ___ | | _(_) ___
    | |_) | | | | '_ \ / __/ _ \ / _ \| |/ / |/ _ \
    |  __/| |_| | |_) | (_| (_) | (_) |   <| |  __/
    |_|    \__,_|_.__/ \___\___/ \___/|_|\_\_|\___|


    Created by the Pubcookie Team

    Comments and suggestions:
	Internal to U. of Washington: pubcookie@cac.washington.edu
	External to U. of Washington: pubcookie-ext@cac.washington.edu
    Pubcookie on the Web: http://www.washington.edu/computing/pubcookie/

    this is installation documentation for the login sever

 */

/*
    $Id: INSTALL.login,v 1.4 2001/05/29 20:54:33 willey Exp $
 */


Introduction

The Pubcookie login server has two primary functions; to authenticate user
sessions and to issue authentication tokens that may be used by other
Pubcookie components.  The login server authenticates users either by
checking user provided credentials via an authentication service
(Kerberos, SecurID, ...) or by verifying a token that was created on a
previous visit to the login server.  Example code to interface to an
authentication system is provided.

Implementation

The login server uses a binary CGI, compiled from C, to process requests.  
This CGI is the Pubcookie only active component on the login server.  The
login server runs Apache webserver, however other webserver software that
supports SSL and CGI would probably work.  Due to the nature of the login
server only other apps that receive a high level of security scrutiny
should be run on the login server.

The login cgi displays the web page where users are asked to enter
credentials as well as web pages displaying any errors.

Authentication services

Pubcookie has a very simple interface for talking to authentication
services There is a sample authentication module provied.  Additionally
there is a module for Kerberos 5.

Internal to the login.cgi support for multiple and various authentication
services is not very flexable and will be revised in the futue.

Until the authentication module build structure and the credential choice
mechanism is redone the U of WA securid autheniticaion module is included.  
This securid interface is a only designed to talk to non-standard securid
server.  We realize that it's confusing, and perhaps misleading.  having
this code there shouldn't cause a problem, even if there are requests to
the login server for securid credentials the the failure is polite.

Localization

pbc_config.h has macros for the url of the login server, the domain of the
organization, and other site specific stuff.  They will need to be changed
to suit your organization.

The login cgi will need to be customized to your local environment.  The
design of index.cgi didn't take this into consideration so there will be
much work to be done there.

Compiling

Of the many Makefiles, Makefile.index.cgi is for making the login CGI and 
Makefile is for misc tools and general distration.

The login cgi uses the CGIC library for some functions.  This library is
included with the Pubcookie distribution.  Pubcookie uses a modified CGIC
library.  Currently cgic comes in a seperate tar file and is compiled
seperately.  The pubcookie modifications should not affect other expected
uses of cgic, the modifications simply make some cgic-internal functions
available to external apps.
 
To compile cgic, untar the pubcookie_cgic.tar.gz into a seperate
directory. Check the Makefile for installation specific stuff and type
'make'.  libcgic.a and cgic.h can be put in the pubcookie install
directory or other locations you please.

Once cigc is compiled you can build the index.cgi with Makefile.index.cgi

Server Setup

Apache configuration

On my test server I hav the following pubcookie directives in addition to 
the Add/LoadModule lines.

"
PubCookieLogin https://weblogintest.cac.washington.edu/
PubCookieCryptKeyfile /usr/local/pubcookie/c_key.pcookiel1
PubCookieSessionCertfile /usr/local/pubcookie/pubcookie_session.cert
PubCookieSessionKeyfile /usr/local/pubcookie/pubcookie_session.key
"

In most cases this should be all that's required unless you want to scope
a whole webserver to the same pubcookie authentication domain (appid).  
One popular addition is turning off the inactivity expiration with,
"PubcookieInactiveExpire -1"  this eliminated the annoying cookie per web
object and will reduce some unecessary trips back to the login server.

All of the Apache directives for pubcookie are described in:
https://www.washington.edu/computing/pubcookie/apache/directives.html

User Agent Blocking via ok_browsers file

The idea behind ok_browsers is to block browsers that either hav a known
security flaw (i.e. don't forget cookies when they shoud) or don't work
with pubcookie (i.e. Opera which doesn't do domain level cookie scoping
correctly).  IE and Netscape are the only two browser families that are
known to work with pubcookie.

So far we've been too chicken to really use the 'ok_browsers'
functionality to block browses that we know don't work.  For now our
ok_broswers has a single line: "Mozilla" since both Netscape and IE claim
to be Mozilla that covers the only two browsers known to work with
pubcookie.

Key Pairs for Signing and Verifying Cookies

The key pairs (PBC_L_CERTFILE / PBC_L_KEYFILE, ...) can be generated with
the openssl command line tool, below is the openssl command.  The Login
and Granting key pairs only need to generate once.  The Granting key and
lives on the login server(s) and the Granting cert.  The Session key pair
is specific to the web application server and you'll want one set per web
server or web server cluster.

" mod_pubcookie needs a key/certificate pair (session key and session
certificate) which can be generated using:

% openssl req -new -x509 -nodes -out file-for-cert -newkey rsa:1024
-keyout file-for-key "

Encryption Key / Key Management (as it is)

Current key management in pubcookie is a simple shared key hashed to the
host's ip.  There is no current mechanism for revoking a key or forcing a
new generation of keys.
	
For the initial install use mkc_make_generic to make a master key.  this 
master key is then hashed to the host ip's via the mkc_make_local tool.  

Anciliary Tools

Tools that you need for key management:
mkc_make_local - 'localizes' master crypt key for a specific host (ip).
new client hosts will need a localized key.
mkc_make_generic - Makes a blob of bits that can be used for a master c_key.

Tool rarely used for debugging:
test_local_c_key

Obsolete tools that might be handy for debugging:
pbc_create - creates a pubcookie cookie, see src for usage.
pbc_verify - decrypts/verifys/displays pubcookie cookies.



