/*
 * Decompiled with CFR 0.152.
 */
package org.akrieger.Nethrar;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.akrieger.Nethrar.Portal;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

public class PortalUtil {
    private static Plugin plugin;
    private static Map<Location, Portal> portals;
    private static Map<World, World> worldLinks;
    private static Map<World, World> respawnRedirects;
    private static Map<World, Integer> worldScales;
    private static Map<Material, World> blocksToWorlds;
    private static Map<World, Material> worldsToBlocks;
    private static Map<Entity, Long> entityLastTeleportedTime;
    private static Map<Location, List<Portal>> forceLoadedChunks;
    private static int keepAliveRadius;
    private static final Logger log;
    private static final long TELEPORT_TIMEOUT_NANOS = 500000000L;

    public static boolean initialize(Plugin plugin, Configuration configuration, int n) {
        PortalUtil.plugin = plugin;
        keepAliveRadius = n;
        portals = new HashMap<Location, Portal>();
        worldLinks = new HashMap<World, World>();
        worldScales = new HashMap<World, Integer>();
        respawnRedirects = new HashMap<World, World>();
        blocksToWorlds = new HashMap<Material, World>();
        worldsToBlocks = new HashMap<World, Material>();
        entityLastTeleportedTime = new HashMap<Entity, Long>();
        forceLoadedChunks = new HashMap<Location, List<Portal>>();
        PortalUtil.initializeWorlds(configuration);
        Configuration configuration2 = new Configuration(new File(PortalUtil.plugin.getDataFolder(), "portals.yml"));
        configuration2.load();
        PortalUtil.initializePortals(configuration2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void initializeWorlds(Configuration configuration) {
        Object object;
        World world;
        String string;
        ConfigurationNode configurationNode;
        HashMap<World, String> hashMap = new HashMap<World, String>();
        List list = configuration.getKeys(null);
        if (list == null || list.size() == 0) {
            void var4_9;
            Object object22;
            void var4_7;
            Object object32;
            List list2 = plugin.getServer().getWorlds();
            Object world2 = null;
            for (Object object32 : list2) {
                if (!object32.getEnvironment().equals((Object)World.Environment.NORMAL)) continue;
                World object4 = object32;
                break;
            }
            if (var4_7 == null) {
                World world3 = plugin.getServer().createWorld("world", World.Environment.NORMAL);
            }
            list2 = plugin.getServer().getWorlds();
            World world4 = null;
            for (Object object22 : list2) {
                if (!object22.getEnvironment().equals((Object)World.Environment.NETHER)) continue;
                world4 = object22;
                break;
            }
            if (world4 == null) {
                world4 = plugin.getServer().createWorld(var4_9.getName() + "_nether", World.Environment.NETHER);
            }
            worldLinks.put((World)var4_9, world4);
            worldLinks.put(world4, (World)var4_9);
            respawnRedirects.put(world4, (World)var4_9);
            worldScales.put((World)var4_9, 8);
            worldScales.put(world4, 1);
            object32 = var4_9.getName();
            object22 = world4.getName();
            configuration.setProperty((String)object32 + ".environment", (Object)"normal");
            configuration.setProperty((String)object32 + ".destination", object22);
            configuration.setProperty((String)object32 + ".scale", (Object)8);
            configuration.setProperty((String)object22 + ".environment", (Object)"nether");
            configuration.setProperty((String)object22 + ".destination", object32);
            configuration.setProperty((String)object22 + ".scale", (Object)1);
            configuration.setProperty((String)object22 + ".peaceful", (Object)false);
            configuration.setProperty((String)object22 + ".respawnTo", object32);
            configuration.save();
            return;
        }
        for (String string2 : list) {
            configurationNode = configuration.getNode(string2);
            string = configurationNode.getString("environment", "");
            if (string.equals("")) {
                world = plugin.getServer().getWorld(string2);
                if (world == null) {
                    log.severe("[NETHRAR] World \"" + string2 + "\" " + "does not exist, and does not have an environment " + "set. Please set \"" + string2 + ".environment\" " + "in worlds.yml.");
                }
                throw new IllegalArgumentException("Need to set an environment for world " + string2 + ", or create the " + "world through some means.");
            }
            try {
                object = World.Environment.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.severe("[NETHRAR] Illegal environment " + string + " specified for world " + string2 + ".");
                throw new IllegalArgumentException("Need to set a valid environment for world " + string2);
            }
            world = plugin.getServer().getWorld(string2);
            if (world == null) {
                world = plugin.getServer().createWorld(string2, (World.Environment)object);
            } else if (!world.getEnvironment().equals(object)) {
                log.warning("[NETHRAR] World \"" + string2 + "\" " + "already exists, but is the wrong enviroment. Either " + "remove the world's directory, or change the " + "environment in the configuration file.");
            }
            boolean bl = configurationNode.getBoolean("peaceful", false);
            world.setSpawnFlags(!bl, true);
            int n = configurationNode.getInt("scale", 1);
            worldScales.put(world, n);
            String string3 = configurationNode.getString("destination", "");
            hashMap.put(world, string3);
            int n2 = configurationNode.getInt("worldBlock", -1);
            if (n2 != -1) {
                blocksToWorlds.put(Material.getMaterial((int)n2), world);
                worldsToBlocks.put(world, Material.getMaterial((int)n2));
                log.info("[NETHRAR] World \"" + string2 + "\", environment " + string + ", scale " + n + ", world block ID " + n2 + ".");
                continue;
            }
            log.info("[NETHRAR] World \"" + string2 + "\", environment " + string + ", scale " + n + ".");
        }
        log.info("[NETHRAR] World graph:");
        for (String string4 : list) {
            configurationNode = plugin.getServer().getWorld(string4);
            string = plugin.getServer().getWorld((String)hashMap.get(configurationNode));
            worldLinks.put((World)configurationNode, (World)string);
            log.info(configurationNode.getName() + " --> " + string.getName());
            object = configuration.getString(string4 + ".respawnTo", "");
            if (((String)object).equals("") || (world = plugin.getServer().getWorld((String)object)) == null) continue;
            respawnRedirects.put((World)configurationNode, world);
        }
        log.info("[NETHRAR] World respawn redirects:");
        for (Map.Entry entry : respawnRedirects.entrySet()) {
            log.info(((World)entry.getKey()).getName() + " respawns redirect to " + ((World)entry.getValue()).getName());
        }
    }

    private static void initializePortals(Configuration configuration) {
        Object object;
        Object object2;
        String string;
        HashMap<String, Portal> hashMap = new HashMap<String, Portal>();
        List list = configuration.getKeys(null);
        if (portals == null) {
            return;
        }
        for (String string2 : list) {
            Block block;
            Portal portal;
            World world;
            string = string2.substring(0, string2.lastIndexOf(";"));
            object2 = configuration.getNode(string2);
            object = object2.getIntList("keyblock", null);
            if (object == null || (world = plugin.getServer().getWorld(string)) == null || (portal = PortalUtil.getPortalAt(block = world.getBlockAt(((Integer)object.get(0)).intValue(), ((Integer)object.get(1)).intValue(), ((Integer)object.get(2)).intValue()))) == null) continue;
            PortalUtil.addPortal(portal);
            hashMap.put(string2, portal);
        }
        for (String string2 : list) {
            string = configuration.getNode(string2);
            object2 = string.getString("destination");
            object = (Portal)hashMap.get(string2);
            if (object == null) continue;
            ((Portal)object).setCounterpart((Portal)hashMap.get(object2));
        }
    }

    public static boolean savePortals() {
        Configuration configuration = new Configuration(new File(plugin.getDataFolder(), "portals.yml"));
        return PortalUtil.savePortals(configuration);
    }

    private static boolean savePortals(Configuration configuration) {
        World world;
        Portal portal;
        int n = 0;
        HashMap<Portal, String> hashMap = new HashMap<Portal, String>();
        for (Map.Entry<Location, Portal> entry : portals.entrySet()) {
            portal = entry.getValue();
            world = portal.getKeyBlock().getWorld();
            hashMap.put(portal, world.getName() + ";" + n++);
        }
        for (Map.Entry<Location, Portal> entry : portals.entrySet()) {
            portal = entry.getValue();
            world = portal.getKeyBlock().getLocation();
            String string = (String)hashMap.get(portal);
            String string2 = (String)hashMap.get(portal.getCounterpart());
            int n2 = world.getBlockX();
            int n3 = world.getBlockY();
            int n4 = world.getBlockZ();
            List<Integer> list = Arrays.asList(n2, n3, n4);
            configuration.setProperty(string + ".keyblock", list);
            configuration.setProperty(string + ".destination", (Object)string2);
        }
        return configuration.save();
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static boolean addPortal(Portal portal) {
        Object object;
        if (keepAliveRadius > 0) {
            object = portal.getKeyBlock().getWorld();
            int n = portal.getKeyBlock().getChunk().getX();
            int n2 = portal.getKeyBlock().getChunk().getZ();
            int n3 = n + keepAliveRadius - 1;
            for (int i = n - keepAliveRadius + 1; i <= n3; ++i) {
                int n4 = n2 + keepAliveRadius - 1;
                for (int j = n2 - keepAliveRadius + 1; j <= n4; ++j) {
                    Location location = new Location(object, (double)i, 0.0, (double)j);
                    List<Portal> list = forceLoadedChunks.get(location);
                    if (list == null) {
                        list = new LinkedList<Portal>();
                        list.add(portal);
                        forceLoadedChunks.put(location, list);
                        object.loadChunk(i, j);
                        continue;
                    }
                    list.add(portal);
                }
            }
        }
        if ((object = portals.get(portal.getKeyBlock().getLocation())) != null) {
            PortalUtil.removePortal((Portal)object);
        }
        return portals.put(portal.getKeyBlock().getLocation(), portal) != null;
    }

    public static boolean removePortal(Portal portal) {
        Block block = portal.getKeyBlock();
        if (keepAliveRadius > 0) {
            int n = block.getChunk().getX();
            int n2 = block.getChunk().getZ();
            World world = block.getWorld();
            int n3 = n + keepAliveRadius - 1;
            for (int i = n - keepAliveRadius + 1; i <= n3; ++i) {
                int n4 = n2 + keepAliveRadius - 1;
                for (int j = n2 - keepAliveRadius + 1; j <= n4; ++j) {
                    Location location = new Location(world, (double)i, 0.0, (double)j);
                    List<Portal> list = forceLoadedChunks.get(location);
                    if (list != null) {
                        if (!list.remove(portal)) {
                            log.warning("Chunk location " + location + " did " + "not have the portal at " + block + " linked to " + "it.");
                        }
                        if (!list.isEmpty()) continue;
                        forceLoadedChunks.remove(location);
                        world.unloadChunkRequest(i, j);
                        continue;
                    }
                    log.warning("Chunk location " + location + " was not " + "kept loaded when it should have been.");
                }
            }
        }
        if (portal.getCounterpart() != null) {
            portal.getCounterpart().setCounterpart(null);
        }
        return portals.remove(block.getLocation()) != null;
    }

    public static boolean removePortalAt(Block block) {
        Portal portal = PortalUtil.getPortalAt(block);
        return PortalUtil.removePortal(portal);
    }

    public static int getScaleFor(World world) {
        Integer n = worldScales.get(world);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static World getRespawnWorldFor(World world) {
        return respawnRedirects.get(world);
    }

    public static World getDestWorldFor(Portal portal) {
        if (blocksToWorlds.get(portal.getWorldBlock().getType()) != null) {
            return blocksToWorlds.get(portal.getWorldBlock().getType());
        }
        return PortalUtil.getDestWorldFor(portal.getKeyBlock().getWorld());
    }

    public static World getDestWorldFor(World world) {
        return worldLinks.get(world);
    }

    public static Portal getPortalAt(Location location) {
        return PortalUtil.getPortalAt(location.getBlock());
    }

    public static Portal getPortalAt(Block block) {
        int n = block.getX();
        int n2 = block.getY();
        int n3 = block.getZ();
        World world = block.getWorld();
        if (!block.getType().equals((Object)Material.PORTAL)) {
            return null;
        }
        while (world.getBlockAt(--n, n2, n3).getType().equals((Object)Material.PORTAL)) {
        }
        ++n;
        while (world.getBlockAt(n, n2, --n3).getType().equals((Object)Material.PORTAL)) {
        }
        ++n3;
        while (world.getBlockAt(n, --n2, n3).getType().equals((Object)Material.PORTAL)) {
        }
        Location location = new Location(block.getWorld(), (double)n, (double)(++n2), (double)n3);
        Portal portal = portals.get(location);
        if (portal == null) {
            portal = new Portal(block.getWorld().getBlockAt(n, n2, n3));
            if (portal.isValid()) {
                PortalUtil.addPortal(portal);
            } else {
                portal = null;
            }
        }
        return portal;
    }

    public static Portal getOrCreatePortalAt(Portal portal, Block block) {
        int n;
        int n2;
        World world = block.getWorld();
        int n3 = block.getX();
        int n4 = block.getY();
        int n5 = block.getZ();
        HashSet<Block> hashSet = new HashSet<Block>();
        HashSet<Block> hashSet2 = new HashSet<Block>();
        if (portal.isFacingNorth()) {
            for (n2 = n5; n2 <= n5 + 1; ++n2) {
                hashSet2.add(world.getBlockAt(n3, n4 + 0, n2));
                hashSet2.add(world.getBlockAt(n3, n4 + 1, n2));
                hashSet2.add(world.getBlockAt(n3, n4 + 2, n2));
                hashSet.add(world.getBlockAt(n3 - 1, n4 + 0, n2));
                hashSet.add(world.getBlockAt(n3 - 1, n4 + 1, n2));
                hashSet.add(world.getBlockAt(n3 - 1, n4 + 2, n2));
                hashSet.add(world.getBlockAt(n3 + 1, n4 + 0, n2));
                hashSet.add(world.getBlockAt(n3 + 1, n4 + 1, n2));
                hashSet.add(world.getBlockAt(n3 + 1, n4 + 2, n2));
            }
        } else {
            for (n2 = n3; n2 <= n3 + 1; ++n2) {
                hashSet2.add(world.getBlockAt(n2, n4 + 0, n5));
                hashSet2.add(world.getBlockAt(n2, n4 + 1, n5));
                hashSet2.add(world.getBlockAt(n2, n4 + 2, n5));
                hashSet.add(world.getBlockAt(n2, n4 + 0, n5 - 1));
                hashSet.add(world.getBlockAt(n2, n4 + 1, n5 - 1));
                hashSet.add(world.getBlockAt(n2, n4 + 2, n5 - 1));
                hashSet.add(world.getBlockAt(n2, n4 + 0, n5 + 1));
                hashSet.add(world.getBlockAt(n2, n4 + 1, n5 + 1));
                hashSet.add(world.getBlockAt(n2, n4 + 2, n5 + 1));
            }
        }
        HashSet<Block> hashSet3 = new HashSet<Block>();
        if (portal.isFacingNorth()) {
            for (n = n5 - 1; n <= n5 + 2; ++n) {
                hashSet3.add(world.getBlockAt(n3, n4 - 1, n));
                hashSet3.add(world.getBlockAt(n3, n4 + 3, n));
            }
            for (n = 0; n <= 2; ++n) {
                hashSet3.add(world.getBlockAt(n3, n4 + n, n5 - 1));
                hashSet3.add(world.getBlockAt(n3, n4 + n, n5 + 2));
            }
        } else {
            for (n = n3 - 1; n <= n3 + 2; ++n) {
                hashSet3.add(world.getBlockAt(n, n4 - 1, n5));
                hashSet3.add(world.getBlockAt(n, n4 + 3, n5));
            }
            for (n = 0; n <= 2; ++n) {
                hashSet3.add(world.getBlockAt(n3 - 1, n4 + n, n5));
                hashSet3.add(world.getBlockAt(n3 + 2, n4 + n, n5));
            }
        }
        HashSet<Block> hashSet4 = new HashSet<Block>();
        if (portal.isFacingNorth()) {
            hashSet4.add(world.getBlockAt(n3 + 1, n4 - 1, n5));
            hashSet4.add(world.getBlockAt(n3 + 1, n4 - 1, n5 + 1));
            hashSet4.add(world.getBlockAt(n3 - 1, n4 - 1, n5));
            hashSet4.add(world.getBlockAt(n3 - 1, n4 - 1, n5 + 1));
        } else {
            hashSet4.add(world.getBlockAt(n3, n4 - 1, n5 - 1));
            hashSet4.add(world.getBlockAt(n3 + 1, n4 - 1, n5 - 1));
            hashSet4.add(world.getBlockAt(n3, n4 - 1, n5 + 1));
            hashSet4.add(world.getBlockAt(n3 + 1, n4 - 1, n5 + 1));
        }
        for (Block block2 : hashSet) {
            if (!block2.getType().equals((Object)Material.PORTAL)) continue;
            return PortalUtil.getPortalAt(block2);
        }
        for (Block block2 : hashSet2) {
            if (!block2.getType().equals((Object)Material.PORTAL)) continue;
            return PortalUtil.getPortalAt(block2);
        }
        for (Block block2 : hashSet3) {
            if (!block2.getType().equals((Object)Material.PORTAL)) continue;
            return PortalUtil.getPortalAt(block2);
        }
        for (Block block2 : hashSet3) {
            block2.setType(Material.OBSIDIAN);
        }
        for (Block block2 : hashSet2) {
            block2.setType(Material.AIR);
        }
        for (Block block2 : hashSet) {
            if (block2.getType().equals((Object)Material.OBSIDIAN)) continue;
            block2.setType(Material.AIR);
        }
        for (Block block2 : hashSet4) {
            if (block2.getType().equals((Object)Material.OBSIDIAN) || block2.getType().equals((Object)Material.PORTAL)) continue;
            block2.setType(Material.STONE);
        }
        block.setType(Material.FIRE);
        if (block.getType().equals((Object)Material.PORTAL)) {
            return PortalUtil.getPortalAt(block);
        }
        return null;
    }

    public static Portal getCounterpartPortalFor(Portal portal) {
        return PortalUtil.getCounterpartPortalFor(portal, PortalUtil.getDestWorldFor(portal));
    }

    public static Portal getCounterpartPortalFor(Portal portal, World world) {
        Object object;
        if (world == null) {
            return null;
        }
        Block block = portal.getKeyBlock();
        double d = (double)PortalUtil.getScaleFor(world) / (double)PortalUtil.getScaleFor(block.getWorld());
        double d2 = Math.floor((double)block.getX() * d);
        double d3 = block.getY();
        double d4 = Math.floor((double)block.getZ() * d);
        if (d > 1.0) {
            object = new int[]{-1, 0, -1, 2, 0, 1, -1, 3, 1, 2, -1, 2};
            int[] nArray = new int[]{0, 1, -2, -1};
            int[] nArray2 = new int[]{-2, -1, 0, 2, -1, 0, 2, 3};
            int[] nArray3 = new int[]{-1, 2, 1, 2, -1, 3, 0, 1, -1, 2, -1, 0};
            int[] nArray4 = new int[]{-2, -1, 0, 1};
            int[] nArray5 = new int[]{2, 3, -1, 0, 0, 2, -2, -1};
            int n = block.getX();
            int n2 = block.getY();
            int n3 = block.getZ();
            int n4 = n2 - 1;
            int n5 = n2 + 3;
            HashSet<Portal> hashSet = new HashSet<Portal>();
            if (portal.isFacingNorth()) {
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions((int[])object, d, block, world));
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions(nArray, d, block, world));
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions(nArray2, d, block, world));
            } else {
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions(nArray3, d, block, world));
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions(nArray4, d, block, world));
                hashSet.addAll(PortalUtil.findPortalsInDeltaRegions(nArray5, d, block, world));
            }
            Vector vector = new Vector(d2, d3, d4);
            double d5 = Double.MAX_VALUE;
            Portal portal2 = null;
            for (Portal portal3 : hashSet) {
                Vector vector2 = new Vector(portal3.getKeyBlock().getX(), portal3.getKeyBlock().getY(), portal3.getKeyBlock().getZ());
                double d6 = vector2.distanceSquared(vector);
                if (!(d6 < d5)) continue;
                d5 = d6;
                portal2 = portal3;
            }
            if (portal2 != null) {
                PortalUtil.linkPortals(portal, portal2);
                return portal2;
            }
        }
        if (d3 < 6.0) {
            d3 = 6.0;
        }
        if (world.getEnvironment().equals((Object)World.Environment.NETHER) && d3 > 119.0) {
            d3 = 119.0;
        }
        Block block2 = world.getBlockAt((int)d2, (int)d3, (int)d4);
        object = PortalUtil.getOrCreatePortalAt(portal, block2);
        PortalUtil.linkPortals(portal, (Portal)object);
        return object;
    }

    private static Set<Portal> findPortalsInDeltaRegions(int[] nArray, double d, Block block, World world) {
        int n = block.getX();
        int n2 = block.getY();
        int n3 = block.getZ();
        int n4 = n2 - 1;
        int n5 = n2 + 3;
        HashSet<Portal> hashSet = new HashSet<Portal>();
        for (int i = 0; i < nArray.length; i += 4) {
            int n6 = (int)Math.ceil((double)(n + nArray[i + 0]) * d);
            int n7 = (int)Math.ceil((double)(n + nArray[i + 1]) * d - 1.0);
            int n8 = (int)Math.ceil((double)(n3 + nArray[i + 2]) * d);
            int n9 = (int)Math.ceil((double)(n3 + nArray[i + 3]) * d - 1.0);
            hashSet.addAll(PortalUtil.findPortalsInRegion(n6, n4, n8, n7, n5, n9, world));
        }
        return hashSet;
    }

    private static Set<Portal> findPortalsInRegion(int n, int n2, int n3, int n4, int n5, int n6, World world) {
        n2 = n2 < 0 ? 0 : n2;
        n5 = n5 > 127 ? 127 : n5;
        HashSet<Portal> hashSet = new HashSet<Portal>();
        for (int i = n; i <= n4; ++i) {
            for (int j = n2; j <= n5; ++j) {
                for (int k = n3; k <= n6; ++k) {
                    Portal portal;
                    Block block;
                    if (!world.getBlockAt(i, j, k).getType().equals((Object)Material.PORTAL) || (block = (portal = PortalUtil.getPortalAt(world.getBlockAt(i, j, k))).getKeyBlock()).getX() > n4 || block.getX() < n || block.getZ() > n6 || block.getZ() < n3) continue;
                    hashSet.add(portal);
                }
            }
        }
        return hashSet;
    }

    public static void linkPortals(Portal portal, Portal portal2) {
        Material material;
        if (portal == null || portal2 == null) {
            return;
        }
        if (portal.getCounterpart() == null) {
            portal.setCounterpart(portal2);
            material = worldsToBlocks.get(portal2.getKeyBlock().getWorld());
            if (material != null) {
                portal.getWorldBlock().setType(material);
            }
        }
        if (portal2.getCounterpart() == null) {
            portal2.setCounterpart(portal);
            material = worldsToBlocks.get(portal.getKeyBlock().getWorld());
            if (material != null) {
                portal2.getWorldBlock().setType(material);
            }
        }
    }

    public static boolean isChunkForcedLoaded(Chunk chunk) {
        Location location = new Location(chunk.getWorld(), (double)chunk.getX(), 0.0, (double)chunk.getZ());
        return forceLoadedChunks.keySet().contains(location);
    }

    public static void markTeleported(Entity entity) {
        entityLastTeleportedTime.put(entity, System.nanoTime());
    }

    public static boolean canTeleport(Entity entity) {
        Long l = entityLastTeleportedTime.get(entity);
        if (l == null) {
            return true;
        }
        long l2 = System.nanoTime() - l;
        return l2 > 500000000L;
    }

    static {
        log = Logger.getLogger("Minecraft.Nethrar");
    }
}

