/*
 * Decompiled with CFR 0.152.
 */
package org.akrieger.Nethrar;

import java.util.HashSet;
import java.util.logging.Logger;
import org.akrieger.Nethrar.NethrarVehicleTeleportEvent;
import org.akrieger.Nethrar.PortalUtil;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class Portal {
    private Portal counterpart;
    private boolean facingNorth;
    private Block keyBlock;
    private static final Logger log = Logger.getLogger("Minecraft.Nethrar");
    private static final double OFFSET = 1.3;

    public Portal(Block block) {
        this.keyBlock = block;
        this.facingNorth = block.getWorld().getBlockAt(block.getX(), block.getY(), block.getZ() - 1).getType().equals((Object)Material.PORTAL) || block.getWorld().getBlockAt(block.getX(), block.getY(), block.getZ() + 1).getType().equals((Object)Material.PORTAL);
        this.counterpart = null;
    }

    public Block getKeyBlock() {
        return this.keyBlock;
    }

    public void setBlock(Block block) {
        this.keyBlock = block;
    }

    public Block getWorldBlock() {
        if (this.facingNorth) {
            return this.keyBlock.getRelative(BlockFace.UP, 3).getRelative(BlockFace.EAST);
        }
        return this.keyBlock.getRelative(BlockFace.UP, 3).getRelative(BlockFace.NORTH);
    }

    public boolean isFacingNorth() {
        return this.facingNorth;
    }

    public Portal getCounterpart() {
        return this.counterpart;
    }

    public void setCounterpart(Portal portal) {
        this.counterpart = portal;
    }

    public Location getLocation() {
        return this.keyBlock.getLocation();
    }

    public boolean equals(Portal portal) {
        return this.keyBlock.equals(portal.getKeyBlock()) && this.keyBlock.getWorld().equals(portal.getKeyBlock().getWorld()) && this.facingNorth == portal.isFacingNorth();
    }

    public Location teleport(Entity entity, Location location) {
        Vector vector;
        float f;
        if (this.counterpart != null) {
            if (!this.counterpart.isValid()) {
                PortalUtil.removePortal(this.counterpart);
                this.counterpart = null;
                PortalUtil.getCounterpartPortalFor(this);
            } else if (!this.counterpart.getKeyBlock().getWorld().equals(PortalUtil.getDestWorldFor(this))) {
                this.counterpart = null;
                PortalUtil.getCounterpartPortalFor(this);
            }
        } else {
            PortalUtil.getCounterpartPortalFor(this);
        }
        if (this.counterpart == null) {
            return null;
        }
        int n = 0;
        Vector vector2 = location.toVector().subtract(this.keyBlock.getLocation().toVector());
        if (this.facingNorth) {
            if (vector2.getX() < 0.5) {
                vector2.setX(vector2.getX() + 1.3);
            } else {
                vector2.setX(vector2.getX() - 1.3);
            }
            if (this.counterpart.isFacingNorth()) {
                f = entity.getLocation().getYaw();
                vector = vector2;
            } else {
                f = entity.getLocation().getYaw() - 90.0f;
                vector = new Vector(vector2.getZ(), vector2.getY(), -vector2.getX() + 1.3);
                n = 1;
            }
        } else {
            if (vector2.getZ() < 0.5) {
                vector2.setZ(vector2.getZ() + 1.3);
            } else {
                vector2.setZ(vector2.getZ() - 1.3);
            }
            if (this.counterpart.isFacingNorth()) {
                f = entity.getLocation().getYaw() + 90.0f;
                vector = new Vector(-vector2.getZ() + 1.3, vector2.getY(), vector2.getX());
                n = 2;
            } else {
                f = entity.getLocation().getYaw();
                vector = vector2;
            }
        }
        World world = this.counterpart.getKeyBlock().getWorld();
        double d = (double)this.counterpart.getKeyBlock().getX() + vector.getX();
        double d2 = (double)this.counterpart.getKeyBlock().getY() + vector.getY();
        double d3 = (double)this.counterpart.getKeyBlock().getZ() + vector.getZ();
        float f2 = entity.getLocation().getPitch();
        if (entity instanceof Player && ((Player)entity).isInsideVehicle() || entity instanceof Vehicle) {
            d2 += 1.0;
        }
        Location location2 = new Location(world, d, d2, d3, f, f2);
        Chunk chunk = location2.getBlock().getChunk();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                world.loadChunk(chunk.getX() + i, chunk.getZ() + j);
            }
        }
        Vehicle vehicle = null;
        Vehicle vehicle2 = null;
        if (entity instanceof Player) {
            if (((Player)entity).isInsideVehicle()) {
                vehicle = ((Player)entity).getVehicle();
                ((Player)entity).leaveVehicle();
            }
        } else if (entity instanceof StorageMinecart || entity instanceof Minecart || entity instanceof Boat) {
            vehicle = (Vehicle)entity;
        }
        if (vehicle != null) {
            Vector vector3;
            if (vehicle instanceof StorageMinecart) {
                vehicle2 = (Vehicle)world.spawn(location2, StorageMinecart.class);
                ((StorageMinecart)vehicle2).getInventory().setContents(((StorageMinecart)vehicle).getInventory().getContents());
            } else if (vehicle instanceof Minecart) {
                vehicle2 = (Vehicle)world.spawn(location2, Minecart.class);
            } else if (vehicle instanceof Boat) {
                vehicle2 = (Vehicle)world.spawn(location2, Boat.class);
            } else {
                log.warning("[NETHRAR] Unsupported vehicle hit a portal.");
            }
            Vector vector4 = vehicle.getVelocity();
            switch (n) {
                case 1: {
                    vector3 = new Vector(vector4.getZ(), vector4.getY(), vector4.getX() * -1.0);
                    break;
                }
                case 2: {
                    vector3 = new Vector(vector4.getZ() * -1.0, vector4.getY(), vector4.getX());
                    break;
                }
                default: {
                    vector3 = vector4;
                }
            }
            PortalUtil.markTeleported(entity);
            final Location location3 = location2;
            final Entity entity2 = entity;
            final Vehicle vehicle3 = vehicle;
            final Vehicle vehicle4 = vehicle2;
            final Vector vector5 = vector3;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(PortalUtil.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (entity2 instanceof Player) {
                        if (((Player)entity2).teleport(location3)) {
                            World world = entity2.getLocation().getWorld();
                            Chunk chunk = entity2.getLocation().getBlock().getChunk();
                            int n = chunk.getX();
                            int n2 = chunk.getZ();
                            for (int i = -1; i <= 1; ++i) {
                                for (int j = -1; j <= 1; ++j) {
                                    world.refreshChunk(n + i, n2 + j);
                                }
                            }
                        } else {
                            return;
                        }
                    }
                    if (vehicle4 != null) {
                        if (entity2 instanceof Player) {
                            vehicle4.setPassenger(entity2);
                        }
                        vehicle4.setVelocity(vector5);
                    }
                    Bukkit.getServer().getPluginManager().callEvent((Event)new NethrarVehicleTeleportEvent(vehicle3, vehicle4));
                    vehicle3.remove();
                }
            });
        } else {
            PortalUtil.markTeleported(entity);
            final Location location4 = location2;
            final Entity entity3 = entity;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(PortalUtil.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (((Player)entity3).teleport(location4)) {
                        World world = entity3.getLocation().getWorld();
                        Chunk chunk = entity3.getLocation().getBlock().getChunk();
                        int n = chunk.getX();
                        int n2 = chunk.getZ();
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                world.refreshChunk(n + i, n2 + j);
                            }
                        }
                    }
                }
            });
        }
        return null;
    }

    public boolean isValid() {
        int n;
        HashSet<Block> hashSet = new HashSet<Block>();
        HashSet<Block> hashSet2 = new HashSet<Block>();
        Block block = this.keyBlock;
        World world = block.getWorld();
        int n2 = block.getX();
        int n3 = block.getY();
        int n4 = block.getZ();
        if (this.facingNorth) {
            for (n = 0; n <= 1; ++n) {
                hashSet2.add(world.getBlockAt(n2, n3 - 1, n4 + n));
                hashSet2.add(world.getBlockAt(n2, n3 + 3, n4 + n));
            }
        } else {
            for (n = 0; n <= 1; ++n) {
                hashSet2.add(world.getBlockAt(n2 + n, n3 - 1, n4));
                hashSet2.add(world.getBlockAt(n2 + n, n3 + 3, n4));
            }
        }
        for (n = 0; n <= 2; ++n) {
            hashSet.add(block.getWorld().getBlockAt(n2, n3 + n, n4));
            if (this.facingNorth) {
                hashSet.add(world.getBlockAt(n2, n3 + n, n4 + 1));
                hashSet2.add(world.getBlockAt(n2, n3 + n, n4 + 2));
                hashSet2.add(world.getBlockAt(n2, n3 + n, n4 - 1));
                continue;
            }
            hashSet.add(world.getBlockAt(n2 + 1, n3 + n, n4));
            hashSet2.add(world.getBlockAt(n2 + 2, n3 + n, n4));
            hashSet2.add(world.getBlockAt(n2 - 1, n3 + n, n4));
        }
        n = 1;
        for (Block block2 : hashSet) {
            if (block2.getType().equals((Object)Material.PORTAL)) continue;
            n = 0;
            break;
        }
        for (Block block2 : hashSet2) {
            if (n != 0 && block2.getType().equals((Object)Material.OBSIDIAN)) continue;
            n = 0;
            break;
        }
        return n != 0;
    }
}

