/*
 * Decompiled with CFR 0.152.
 */
package org.akrieger.Nethrar;

import java.util.logging.Logger;
import org.akrieger.Nethrar.Nethrar;
import org.akrieger.Nethrar.Portal;
import org.akrieger.Nethrar.PortalUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class NethrarPlayerListener
extends PlayerListener {
    private final Logger log = Logger.getLogger("Minecraft.Nethrar");

    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Location location;
        Player player = playerMoveEvent.getPlayer();
        if (Nethrar.permissions != null && !Nethrar.permissions.has(player, "nethrar.use")) {
            return;
        }
        Block block = !playerMoveEvent.getPlayer().isInsideVehicle() ? playerMoveEvent.getTo().getBlock() : playerMoveEvent.getTo().getBlock().getRelative(BlockFace.UP);
        if (!block.getType().equals((Object)Material.PORTAL)) {
            return;
        }
        if (!PortalUtil.canTeleport((Entity)player)) {
            return;
        }
        Portal portal = PortalUtil.getPortalAt(block);
        if (portal != null && (location = portal.teleport((Entity)player, playerMoveEvent.getTo())) != null) {
            playerMoveEvent.setTo(location);
        }
    }

    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        Location location = playerRespawnEvent.getPlayer().getLocation();
        if (location == null) {
            this.log.warning("[NETHRAR] Player died, but respawn event has no respawn location.");
            return;
        }
        World world = location.getWorld();
        if (world == null) {
            this.log.warning("[NETHRAR] Player died, respawn event has a location, but the location has no world.");
            return;
        }
        World world2 = PortalUtil.getRespawnWorldFor(world);
        if (world2 != null) {
            playerRespawnEvent.setRespawnLocation(world2.getSpawnLocation());
        }
    }
}

