/*
 * Decompiled with CFR 0.152.
 */
package org.akrieger.Nethrar;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akrieger.Nethrar.NethrarCommandExecutor;
import org.akrieger.Nethrar.NethrarPlayerListener;
import org.akrieger.Nethrar.NethrarVehicleListener;
import org.akrieger.Nethrar.NethrarWorldListener;
import org.akrieger.Nethrar.PortalUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class Nethrar
extends JavaPlugin {
    public static PermissionHandler permissions;
    private final NethrarPlayerListener playerListener = new NethrarPlayerListener();
    private final NethrarVehicleListener vehicleListener = new NethrarVehicleListener();
    private final NethrarWorldListener worldListener = new NethrarWorldListener();
    private final NethrarCommandExecutor commandExecutor = new NethrarCommandExecutor((Plugin)this);
    private final Logger log = Logger.getLogger("Minecraft.Nethrar");

    public void onEnable() {
        this.log.setLevel(Level.INFO);
        Configuration configuration = this.getConfiguration();
        Configuration configuration2 = new Configuration(new File(this.getDataFolder(), "worlds.yml"));
        configuration2.load();
        PluginManager pluginManager = this.getServer().getPluginManager();
        int n = configuration.getInt("debugLevel", 0);
        boolean bl = configuration.getBoolean("usePermissions", false);
        if (bl) {
            this.log.info("[NETHRAR] Using Permissions. Set permissions nodes as appropriate.");
            this.setupPermissions();
        } else {
            permissions = null;
        }
        pluginManager.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        this.getCommand("nethrar").setExecutor((CommandExecutor)this.commandExecutor);
        boolean bl2 = configuration.getBoolean("riderlessVehicles", true);
        if (bl2) {
            pluginManager.registerEvent(Event.Type.VEHICLE_MOVE, (Listener)this.vehicleListener, Event.Priority.Normal, (Plugin)this);
        } else {
            this.log.info("[NETHRAR] Not allowing riderless vehicles to teleport.");
        }
        boolean bl3 = configuration.getBoolean("listen.respawn", true);
        if (bl3) {
            pluginManager.registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        } else {
            this.log.info("[NETHRAR] Not listening for player respawns.");
        }
        int n2 = this.getConfiguration().getInt("forceLoadRadius", 0);
        if (n2 > 0) {
            pluginManager.registerEvent(Event.Type.CHUNK_UNLOAD, (Listener)this.worldListener, Event.Priority.Normal, (Plugin)this);
            this.log.info("[NETHRAR] Forcing chunks to stay loaded in a radius of " + n2 + " around portals.");
        } else if (bl2) {
            this.log.warning("[NETHRAR] Riderless vehicles are enabled, but no forceLoadRadius was defined.");
            this.log.warning("[NETHRAR] For best results, you should set at least a radius of 2.");
        }
        PortalUtil.initialize((Plugin)this, configuration2, n2);
        configuration.setProperty("usePermissions", (Object)bl);
        configuration.setProperty("riderlessVehicles", (Object)bl2);
        configuration.setProperty("listen.respawn", (Object)bl3);
        configuration.setProperty("forceLoadRadius", (Object)n2);
        configuration.setProperty("debugLevel", (Object)n);
        configuration.save();
        PluginDescriptionFile pluginDescriptionFile = this.getDescription();
        this.log.info("[NETHRAR] " + pluginDescriptionFile.getName() + " v" + pluginDescriptionFile.getVersion() + " enabled.");
        switch (n) {
            case 2: {
                this.log.setLevel(Level.INFO);
                break;
            }
            case 1: {
                this.log.setLevel(Level.WARNING);
                break;
            }
            default: {
                this.log.setLevel(Level.SEVERE);
            }
        }
    }

    private void setupPermissions() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Permissions");
        if (permissions == null) {
            if (plugin != null) {
                permissions = ((Permissions)plugin).getHandler();
                this.log.info("[NETHRAR] Permissions enabled.");
            } else {
                this.log.warning("[NETHRAR] Permissions not detected.");
            }
        }
    }

    public void onDisable() {
        if (PortalUtil.savePortals()) {
            this.log.info("[NETHRAR] Portal saving successful.");
        } else {
            this.log.severe("[NETHRAR] Unable to save portals. All links will be broken on reload.");
        }
    }

    public void onLoad() {
    }
}

