// visbefView.h : interface of the CVisBefView class
//
/////////////////////////////////////////////////////////////////////////////

class CVisBefView : public CScrollView
{
protected: // create from serialization only
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	CVisBefView();
	DECLARE_DYNCREATE(CVisBefView)

	void GetFontDimensions();
	void ClientToBef(CPoint &point);
   void BefToClient(CPoint &point);

// Attributes
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CVisBefDoc* GetDocument();

   CFont  m_thisFont;
	LONG	 m_charwidth;
   LONG   m_charheight;

#ifdef ALLOW_EDIT
	CPoint m_cursor;
#endif /* ALLOW_EDIT */
	CPoint m_lastPopupMenuPos;  //in befunge coords

	void DrawRect(CDC *pDC, int x, int y, char thischar, COLORREF fgCol, COLORREF bkCol);
   void DrawDirect(int x, int y, char thischar, BOOL bIsPC );

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVisBefView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CVisBefView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CVisBefView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDoBefRun();
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBefrun();
	afx_msg void OnUpdateBefrun(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChangefont();
	afx_msg void OnTogglebreakpoint();
	afx_msg void OnTogglebreakcursor();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in visbefView.cpp
inline CVisBefDoc* CVisBefView::GetDocument()
   { return (CVisBefDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
