// visbefView.cpp : implementation of the CVisBefView class
//
///////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "visbef.h"
#include "visbefDoc.h"
#include "visbefView.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//Colors used for drawing text.
const COLORREF rgbWhite = RGB(255,255,255);
const COLORREF rgbBlack = RGB(0,0,0);
const COLORREF rgbRed   = RGB(255,0,0);
const COLORREF rgbBlue  = RGB(0,0,255);

/////////////////////////////////////////////////////////////////////////////
// CVisBefView

IMPLEMENT_DYNCREATE(CVisBefView, CScrollView)

BEGIN_MESSAGE_MAP(CVisBefView, CScrollView)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CVisBefView)
	ON_WM_CREATE()
	ON_COMMAND(ID_DOBEFRUN, OnDoBefRun)
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(IDM_BEFRUN, OnBefrun)
	ON_UPDATE_COMMAND_UI(IDM_BEFRUN, OnUpdateBefrun)
	ON_WM_KEYDOWN()
	ON_WM_CHAR()
	ON_COMMAND(IDM_CHANGEFONT, OnChangefont)
	ON_COMMAND(IDM_TOGGLEBREAKPOINT, OnTogglebreakpoint)
	ON_COMMAND(IDM_TOGGLEBREAKCURSOR, OnTogglebreakcursor)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVisBefView construction/destruction

CVisBefView::CVisBefView()
:
m_charwidth(0),
m_charheight(0)
#ifdef ALLOW_EDIT
,m_cursor(0,0)
#endif /* ALLOW_EDIT */
{
	// TODO: add construction code here
}


CVisBefView::~CVisBefView()
{
}

BOOL CVisBefView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CVisBefView drawing
/////////////////////////////////////////////////////////////////////////////

void CVisBefView::DrawRect(CDC *pDC, int x, int y, char thischar, COLORREF fgCol, COLORREF bkCol)
{
	char tempbuf[2];

	tempbuf[0] = thischar;
	tempbuf[1] = '\0';

	COLORREF prevbkcolor;
	COLORREF prevfgcolor;

	prevbkcolor = pDC->SetBkColor(bkCol );
	prevfgcolor = pDC->SetTextColor(fgCol );
//	pDC->TextOut(x*m_charwidth,y*m_charheight,tempbuf,1);
	pDC->TextOut(x,y,tempbuf,1);
	pDC->SetBkColor(prevbkcolor );
	pDC->SetTextColor(prevfgcolor );
}

///////////////////////////////////////////////////////
// Following routine skips OnDraw() entirely and draws
// straight to the client area
//
// WR9-7-97: adapted for use with getline()
//
void CVisBefView::DrawDirect(int x, int y, char thischar, BOOL bIsPC )
{
	CDC *pDC = GetDC();
	COLORREF fgCol;
	COLORREF bkCol;

	CFont *pPrevFont =  pDC->SelectObject(&m_thisFont);

	CPoint thispt(x,y) ;
	if ( !bIsPC && CBefunge::HitBreakPoint(thispt) )
	{
	   fgCol = rgbWhite;
	   bkCol = rgbRed;
	}
	else
	{
	   fgCol = bIsPC?rgbWhite:rgbBlack;
	   bkCol = bIsPC?rgbBlue: rgbWhite;
	}

	BefToClient(thispt);
	CRect updRect = CRect(0,0,m_charwidth,m_charheight) + thispt;
	InvalidateRect(updRect);

   DrawRect(pDC,thispt.x,thispt.y,thischar,fgCol,bkCol);

	ValidateRect(updRect);
	pDC->SelectObject(pPrevFont);
	ReleaseDC(pDC);
}


void CVisBefView::OnDraw(CDC* pDC)
{
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	int x; 
	int y;
	CFont *pPrevFont =  pDC->SelectObject(&m_thisFont);

	CRect updRect;
	const int kTempbufSize = 80;
	GridType tempbuf[kTempbufSize];
	char charbuf[kTempbufSize];

	for ( y = 0 ; y < CBefWorld::GetHeight(); ++y)
	{
		//Determine rect size to update
		updRect = CRect(0,0,CBefWorld::GetWidth()*m_charwidth,m_charheight) +
			       CPoint(0,y*m_charheight);

		if ( pDC->RectVisible( updRect ) )
		{
			//Create line in local buffer
			int len = kTempbufSize;
			x = 0;
         while ( x < CBefWorld::GetWidth())
			{
				if ( len + x > CBefWorld::GetWidth())
					len = CBefWorld::GetWidth() - x;

				pDoc->m_state.getline( tempbuf, x, y, len);

				for ( int i = 0; i < len; ++ i)
					charbuf[i] = (tempbuf[i] > 255)? 255:tempbuf[i];

				pDC->TextOut(x*m_charwidth,y*m_charheight,charbuf ,len);
			
				x += len;
			}
		}

      updRect += CPoint(0,m_charheight);
	}

#ifdef ALLOW_EDIT
	//Draw black rect for cursor
	x = m_cursor.x;
	y = m_cursor.y;

	updRect = CRect(0,0,m_charwidth,m_charheight) +
			    CPoint(x*m_charwidth,y*m_charheight);

	if ( pDC->RectVisible( updRect ) )
		DrawRect(pDC,x*m_charwidth,y*m_charheight, pDoc->m_state.GetCur(x,y), rgbWhite, rgbBlack);
#endif /* ALLOW_EDIT */	

	//Draw red rect for breakpoints
	for ( int breakcnt = 0; breakcnt < CBefunge::NumBreaks(); ++breakcnt)
	{
		CPoint thisBreak = CBefunge::GetBreak(breakcnt);
		x = thisBreak.x;
		y = thisBreak.y;


		updRect = CRect(0,0,m_charwidth,m_charheight) +
					 CPoint(x*m_charwidth,y*m_charheight);

		if ( pDC->RectVisible( updRect ) && x != -1 && y != -1 )
		{
		   DrawRect(pDC,x*m_charwidth,y*m_charheight, pDoc->m_state.GetCur(x,y), rgbWhite, rgbRed);
		}
	}

	//Draw the blue rects for the PC's
	for ( int j =0 ; j < pDoc->m_state.GetNumTasks(); ++j )
	{
	   int numpc = pDoc->m_state.GetTask(j).GetNumThreads();
		for ( int i =0 ; i < numpc; ++i )
		{
			CPoint pos = pDoc->m_state.GetTask(j).GetThread(i).GetPos();

			updRect = CRect(0,0,m_charwidth,m_charheight) +
					 CPoint(pos.x*m_charwidth,pos.y*m_charheight);

			if ( pDC->RectVisible( updRect ))
				DrawRect(pDC,pos.x*m_charwidth,pos.y*m_charheight, pDoc->m_state.GetCur(pos.x,pos.y), rgbWhite, rgbBlue);
		}
	}
	
	pDC->SelectObject(pPrevFont);
}

/////////////////////////////////////////////////////////////////////////////
// CVisBefView printing

BOOL CVisBefView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CVisBefView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CVisBefView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CVisBefView diagnostics

#ifdef _DEBUG
void CVisBefView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CVisBefView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CVisBefDoc* CVisBefView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVisBefDoc)));
	return (CVisBefDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVisBefView message handlers

int CVisBefView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CString fontName = "Courier New";
   VERIFY(m_thisFont.CreateFont( -11, 0, 0, 0, 0, FALSE, FALSE, 0,
		      ANSI_CHARSET, OUT_DEVICE_PRECIS, CLIP_DEFAULT_PRECIS, 
				DEFAULT_QUALITY, FIXED_PITCH, fontName ) );


	GetFontDimensions();

	return 0;
}

void CVisBefView::OnChangefont() 
{
	LOGFONT myFont;
	VERIFY(m_thisFont.GetLogFont( &myFont ) );

	CFontDialog Dlg( &myFont, CF_NOSCRIPTSEL |CF_INITTOLOGFONTSTRUCT|CF_SCREENFONTS|CF_FIXEDPITCHONLY, NULL); //, this );

	if ( Dlg.DoModal() == IDOK )
	{
		Dlg.GetCurrentFont(&myFont );
		m_thisFont.DeleteObject();
		VERIFY( m_thisFont.CreateFontIndirect( &myFont ));
		GetFontDimensions();
		SetScrollSizes( MM_TEXT, CSize(m_charwidth*CBefWorld::GetWidth(), m_charheight*CBefWorld::GetHeight()) );
		Invalidate();
  	}
	else
	{
		TRACE("Font change cancelled.\n");
	}
}

void CVisBefView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
   m_thisFont.DeleteObject();
}

void CVisBefView::GetFontDimensions()
{
	//Remember width and height of font
	CDC *pDC = GetDC();
	CFont *pPrevFont =  pDC->SelectObject(&m_thisFont);
	TEXTMETRIC Metrics;
	pDC->GetTextMetrics( &Metrics );
	m_charwidth = Metrics.tmAveCharWidth;
   m_charheight = Metrics.tmHeight;
	pDC->SelectObject(pPrevFont);
	ReleaseDC(pDC);
}

void CVisBefView::OnLButtonDown(UINT nFlags, CPoint point) 
{
#ifdef ALLOW_EDIT
	//Set the edit cursor to this position
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	ASSERT( m_charwidth );
	ASSERT( m_charheight );

	CPoint prevpos = m_cursor;

	//Adjust for scrolling
	point += GetDeviceScrollPosition( );

	//Convert to char value
	int xpos = point.x / m_charwidth;
	int ypos = point.y / m_charheight;

	//Reset the cursor position
	m_cursor = CPoint(xpos,ypos);

	//Update screen as well
	DrawDirect(prevpos.x, prevpos.y,pDoc->m_state.GetCur(prevpos.x,prevpos.y), FALSE);
	DrawDirect(m_cursor.x, m_cursor.y,pDoc->m_state.GetCur(m_cursor.x,m_cursor.y), FALSE);
#endif /* ALLOW_EDIT */

	CScrollView::OnLButtonDown(nFlags, point);
}

/* Original right button handling - toggle breakpoint directly

void CVisBefView::OnRButtonDown(UINT nFlags, CPoint point) 
{  //Set cursor to this position
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	ASSERT( m_charwidth );
	ASSERT( m_charheight );

	//Adjust for scrolling
	point += GetDeviceScrollPosition( );

	//Convert to char value
	int xpos = point.x / m_charwidth;
	int ypos = point.y / m_charheight;
	
	pDoc->ToggleBreak(xpos, ypos);

	CScrollView::OnRButtonDown(nFlags, point);
}
*/

void CVisBefView::OnBefrun() 
{
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	pDoc->ToggleRun();

	if ( pDoc->IsRunning() )
		PostMessage(WM_COMMAND, MAKELONG(ID_DOBEFRUN,0) );

}

void CVisBefView::OnDoBefRun()
{
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	MSG msg;
   HACCEL  hAccelTable = ((CFrameWnd *)AfxGetMainWnd())->m_hAccelTable;  
   HWND    hwnd =  AfxGetMainWnd()->m_hWnd;
	if ( pDoc->IsRunning() )
	{
      while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
      {
         if (msg.message == WM_QUIT)
            return; // TRUE;
 
         if ( TranslateAccelerator(hwnd,hAccelTable,&msg) == FALSE)
		    TranslateMessage(&msg);
         DispatchMessage(&msg);
      }
 
		pDoc->DoStep();
		PostMessage(WM_COMMAND, MAKELONG(ID_DOBEFRUN,0) );
	}
}


void CVisBefView::OnUpdateBefrun(CCmdUI* pCmdUI) 
{
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if ( pDoc->IsRunning() )
	{
		pCmdUI->SetText( "Stop &Run\tF5" );
	}
	else
	{
		pCmdUI->SetText( "&Run\tF5" );
	}
	
}

void CVisBefView::OnInitialUpdate() 
{
	CScrollView::OnInitialUpdate();
	
	SetScrollSizes( MM_TEXT, CSize(m_charwidth*CBefWorld::GetWidth(), m_charheight*CBefWorld::GetHeight()) );
}

void CVisBefView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
#ifdef ALLOW_EDIT
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	//ASCII Printables get inserted into current cursor pos
	if ( char(nChar) >= ' ' && nChar < 128)
	{
		pDoc->m_state.SetCur(m_cursor.x,m_cursor.y,nChar);
		pDoc->SetModifiedFlag();

		DrawDirect(m_cursor.x,m_cursor.y,nChar,FALSE);
	}
#endif /* ALLOW_EDIT */
	CScrollView::OnChar(nChar, nRepCnt, nFlags);
}

void CVisBefView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
#ifdef ALLOW_EDIT
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	BOOL bChanged = TRUE;

	CPoint prevpos = m_cursor;

	switch ( nChar )
	{
	case VK_RIGHT:m_cursor.x = (m_cursor.x +1)%CBefWorld::GetWidth();
		break;
	case VK_LEFT: m_cursor.x = (m_cursor.x +CBefWorld::GetWidth()-1)%CBefWorld::GetWidth();
		break;
	case VK_DOWN: m_cursor.y  = (m_cursor.y+1)%CBefWorld::GetHeight();
		break;
	case VK_UP:   m_cursor.y  = (m_cursor.y+CBefWorld::GetHeight()-1)%CBefWorld::GetHeight();
		break;
	case VK_HOME: m_cursor.x = 0;
		break;
	case VK_END:  m_cursor.x = CBefWorld::GetWidth()-1;
		break;
	case VK_PRIOR:m_cursor.y = 0;
		break;
	case VK_NEXT: m_cursor.y = CBefWorld::GetHeight()-1;
		break;
	case VK_DELETE: 
		{ //Set item under cursor to space
		  pDoc->m_state.SetCur(m_cursor.x,m_cursor.y,' ');
		  pDoc->SetModifiedFlag();
  		}
		break;
	default: bChanged = FALSE;
		break;
	}

	if ( bChanged )
	{
		DrawDirect(prevpos.x,prevpos.y,pDoc->GetCur(prevpos.x,prevpos.y,FALSE);
		DrawDirect(m_cursor.x,m_cursor.y,pDoc->GetCur(m_cursor.x,m_cursor.y,FALSE);
	}
#endif /* ALLOW_EDIT */

	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CVisBefView::OnContextMenu(CWnd*, CPoint point)
{
	// CG: This function was added by the Pop-up Menu component

	m_lastPopupMenuPos = point;
	ScreenToClient(&m_lastPopupMenuPos);
	ClientToBef(m_lastPopupMenuPos);

	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_VIS_BEF_VIEW));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	pPopup->AppendMenu(MF_SEPARATOR);

	//All the following does is determine if char under cursor
	//is ASCII
	CString strout;
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	GridType value = pDoc->m_state.GetCur(m_lastPopupMenuPos.x,m_lastPopupMenuPos.y);

	//ASCII Printables get inserted into current cursor pos
	if ( char(value) >= ' ' && value < 128)
	{
		strout.Format("Pos: (%d,%d); Value: %d \'%c\'",
			           m_lastPopupMenuPos.x,m_lastPopupMenuPos.y,
						  value,value);
	}
	else
	{
		strout.Format("Pos: (%d,%d); Value: %d",
						  m_lastPopupMenuPos.x,m_lastPopupMenuPos.y,
						  value);
	}
	
	pPopup->AppendMenu(MF_STRING,0,strout);


	CWnd* pWndPopupOwner = this;
	while (pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,
		pWndPopupOwner);
}

BOOL CVisBefView::PreTranslateMessage(MSG* pMsg)
{
	// CG: This block was added by the Pop-up Menu component
	{
		// Shift+F10: show pop-up menu.
		if ((((pMsg->message == WM_KEYDOWN || pMsg->message == WM_SYSKEYDOWN) && // If we hit a key and
			(pMsg->wParam == VK_F10) && (GetKeyState(VK_SHIFT) & ~1)) != 0) ||	// it's Shift+F10 OR
			(pMsg->message == WM_CONTEXTMENU))									// Natural keyboard key
		{
			//
			// My God what a crummy default implementation.
			// You would expect that the folks at Redmont would
			// have thought this thru.
			//

			//CRect rect;
			//GetClientRect(rect);
			//ClientToScreen(rect);
         //
			//CPoint point = rect.TopLeft();
			//point.Offset(5, 5);

			CPoint point;
			GetCursorPos(&point);

			OnContextMenu(NULL, point);

			return TRUE;
		}
	}

	return CScrollView::PreTranslateMessage(pMsg);
}

void CVisBefView::OnTogglebreakpoint() 
{  //Set cursor to last popup menu position
	CVisBefDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

  pDoc->ToggleBreak(m_lastPopupMenuPos.x, m_lastPopupMenuPos.y);

}

void CVisBefView::ClientToBef(CPoint &point)
{
	ASSERT( m_charwidth );
	ASSERT( m_charheight );

	//Adjust for scrolling
	point += GetDeviceScrollPosition( );

	//Convert to char value
	point.x = point.x / m_charwidth;
	point.y = point.y / m_charheight;
}

void CVisBefView::BefToClient(CPoint &point)
{
	ASSERT( m_charwidth );
	ASSERT( m_charheight );

	//Convert to int char value
	point.x = point.x * m_charwidth;
	point.y = point.y * m_charheight;

	//Adjust for scrolling
	point -= GetDeviceScrollPosition( );

}

void CVisBefView::OnTogglebreakcursor() 
{
	//
	//	Same as OnTogglebreakpoint, but uses current mouse
	// cursor pos immediately
	//
	GetCursorPos(&m_lastPopupMenuPos);
	ScreenToClient(&m_lastPopupMenuPos);
	ClientToBef(m_lastPopupMenuPos);

	//You aren't supposed to call callbacks directly, but
	//what the hell...
	OnTogglebreakpoint();
}
