// visbefDoc.h : interface of the CVisbefDoc class
//
/////////////////////////////////////////////////////////////////////////////
#include "befclass.h"

class CVisBefView;
class CVisBefDoc : public CDocument
{
protected: // create from serialization only
	CVisBefDoc();
	DECLARE_DYNCREATE(CVisBefDoc)

// Attributes
public:
	CBefunge     m_state;
	BOOL         m_bAnimating;
	BOOL			 m_bRunning;

	CArray<CPoint, CPoint &> m_watchpoint;

protected:
	CVisBefView *GetView();
	void UpdateWatch(int index, CPoint &pt);

public:
	BOOL IsAnimating()  { return m_bAnimating; }
	BOOL IsRunning()    { return m_bRunning; }
	void StartRunning();
   void StopRunning(BOOL bForceIt = FALSE);
	void StopAnimating();
	void StartAnimating();
	void ToggleRun();
	void DoStep();
	void Reset(BOOL bDoBreaksAndWatches = TRUE);
	void ToggleBreak(int x, int y);
	
	void CheckWatch(CPoint &pt);
	void ClearAllWatches();
	void UpdateAllWatches();



// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVisBefDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CVisBefDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CVisBefDoc)
	afx_msg void OnBefstep();
	afx_msg void OnBefreset();
	afx_msg void OnBefanimate();
	afx_msg void OnUpdateBefanimate(CCmdUI* pCmdUI);
	afx_msg void OnWarpspace();
	afx_msg void OnUpdateWarpspace(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnAddtowatch();
	afx_msg void OnUpdateAddtowatch(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
