// visbefDoc.cpp : implementation of the CVisbefDoc class
//

#include "stdafx.h"
#include "visbef.h"
#include "befmfc.h"
#include "mainfrm.h"
#include "visbefdoc.h"
#include "visbefview.h" //for member m_lastPopupMenuPos

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVisBefDoc

IMPLEMENT_DYNCREATE(CVisBefDoc, CDocument)

BEGIN_MESSAGE_MAP(CVisBefDoc, CDocument)
	//{{AFX_MSG_MAP(CVisBefDoc)
	ON_COMMAND(IDM_BEFSTEP, OnBefstep)
	ON_COMMAND(IDM_BEFRESET, OnBefreset)
	ON_COMMAND(IDM_BEFANIMATE, OnBefanimate)
	ON_UPDATE_COMMAND_UI(IDM_BEFANIMATE, OnUpdateBefanimate)
	ON_COMMAND(IDM_WARPSPACE, OnWarpspace)
	ON_UPDATE_COMMAND_UI(IDM_WARPSPACE, OnUpdateWarpspace)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(ID_POPUP_ADDTOWATCH, OnAddtowatch)
	ON_UPDATE_COMMAND_UI(ID_POPUP_ADDTOWATCH, OnUpdateAddtowatch)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVisBefDoc construction/destruction


CVisBefDoc::CVisBefDoc()
:
m_bAnimating(FALSE),
m_bRunning(FALSE)
{
	m_state.Init();
}


CVisBefDoc::~CVisBefDoc()
{
}


BOOL CVisBefDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	Reset();
	SetModifiedFlag(FALSE);
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CVisBefDoc serialization


void CVisBefDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


/////////////////////////////////////////////////////////////////////////////
// CVisBefDoc diagnostics


#ifdef _DEBUG
void CVisBefDoc::AssertValid() const
{
	CDocument::AssertValid();
}


void CVisBefDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CVisBefDoc commands


BOOL CVisBefDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
   Reset();
	FILE *f = fopen(lpszPathName, "r");
	m_state.loadfile(f);
   fclose(f);
	SetModifiedFlag(FALSE);
	return TRUE;
}


BOOL CVisBefDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	FILE *f = fopen(lpszPathName, "w");
	m_state.savefile(f);
   fclose(f);
	
	SetModifiedFlag(FALSE);
	return TRUE; //CDocument::OnSaveDocument(lpszPathName);
}


void CVisBefDoc::OnBefstep() 
{
	DoStep(); 
}


void CVisBefDoc::OnBefreset() 
{
	// Maybe TODO: add following to run/animate/step
	if ( IsModified() )
	if ( !SaveModified( ) )
	{
			OutputString("[Can't reset if you don't save your creation]\r\n");
			return;
	}
	//Just reload the given file
	const CString& szFilename = GetPathName( );

   if ( szFilename.GetLength() )
	{
      Reset(FALSE);
		FILE *f = fopen(szFilename, "r");
		m_state.loadfile(f);
		fclose(f);

		UpdateAllWatches();
		//Update entire view
      UpdateAllViews(NULL);
	}
}


void CVisBefDoc::OnBefanimate() 
{
	m_bAnimating = ! m_bAnimating;
	StopRunning();
	if ( m_bAnimating)
	{
		//Start the animation timer
		AfxGetMainWnd()->SetTimer(1,250,NULL);
	}
}


void CVisBefDoc::OnUpdateBefanimate(CCmdUI* pCmdUI) 
{
	if ( IsAnimating() )
	{
		pCmdUI->SetText( "Stop &Animating\tF11" );
	}
	else
	{
		pCmdUI->SetText( "&Animate\tF11" );
	}
}


void CVisBefDoc::DoStep()
{
	StepResult result;
	result = m_state.Step();

   if (result == TERMINATED)
	{
		//Program terminated
		m_bAnimating = FALSE;
		StopRunning();
		OutputString("\r\n[Program terminated]\r\n");
	}
  	else
	if ( result == BREAKPOINT )
 	{
		//breakpoint
		m_bAnimating = FALSE;
		StopRunning();
		OutputString("\r\n[Breakpoint encountered]\r\n");
	}
}


void CVisBefDoc::StopAnimating()  
{ 
	m_bAnimating = FALSE; 
}


void CVisBefDoc::StartAnimating() 
{ 
	m_bAnimating = TRUE; 
	StopRunning();
	//Start the animation timer
	AfxGetMainWnd()->SetTimer(1,250,NULL);
}


void CVisBefDoc::StopRunning(BOOL bForceIt)
{
	if (m_bRunning || bForceIt)
	{
		m_bRunning   = FALSE;

		//Turn on drawing of the stack listbox
		::DrawListBox(TRUE);
	}
}


void CVisBefDoc::StartRunning()
{
	m_bRunning   = TRUE;

	//Turn off drawing of the stack listbox
	::DrawListBox(FALSE);
}


void CVisBefDoc::OnWarpspace() 
{
	m_state.ToggleWarpSpace();
}


void CVisBefDoc::OnUpdateWarpspace(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( m_state.IsWarping() ) ; //m_warpspace );
}


void CVisBefDoc::ToggleBreak(int x, int y) 
{
	CPoint newpoint(x,y);

	CBefunge::ToggleBreakPoint(newpoint);

	//Update view
   GetView()->DrawDirect(x,y,m_state.GetCur(x,y),FALSE);
}


void CVisBefDoc::Reset(BOOL bDoBreaksAndWatches)
{
   m_bAnimating = FALSE;
	StopRunning();
	if ( bDoBreaksAndWatches)
	{
		m_state.ClearBreakPoints();
		ClearAllWatches();
	}
	m_state.Init();
	::ClearInput();
   ClearOutput();
}


void CVisBefDoc::ToggleRun() 
{
	m_bRunning = ! m_bRunning;
	m_bAnimating = FALSE;

	if ( !m_bRunning )
		StopRunning(TRUE);
	else
		StartRunning();
}


void CVisBefDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(IsModified());
}


///////////////////////////////////////////////////////////////
//Check if given point is displayed in the watch
//window; if so, update watch value
//
void CVisBefDoc::CheckWatch(CPoint &pt)
{
	//scan list
	for (int i = 0; i < m_watchpoint.GetSize() ; ++ i)
	{
		if (m_watchpoint[i] == pt)
		{
			UpdateWatch(i, pt);
			return;
		}
	}
}


///////////////////////////////////////////////////////////////
// Update watch value with given index to value at given 
// coords
//
void CVisBefDoc::UpdateWatch(int index, CPoint &pt)
{
	ASSERT( index >= 0 && index < m_watchpoint.GetSize() );

	CListBox *pList = ( ( CMainFrame * ) AfxGetMainWnd() )->GetWatchList();
	ASSERT(pList);

	GridType value = m_state.GetCur(pt.x,pt.y);
			
	CString strout;
	if ( char(value) >= ' ' && value < 128)
		strout.Format("(%d,%d) : %d \'%c\'",pt.x,pt.y,value,value);
	else
		strout.Format("(%d,%d) : %d",pt.x,pt.y,value);

	pList->InsertString( index, strout );
	pList->DeleteString( index+1 );
 	return;
}


///////////////////////////////////////////////////////////////
// Update all watch values
//
void CVisBefDoc::UpdateAllWatches()
{
	//scan entire list
	for (int i = 0; i < m_watchpoint.GetSize() ; ++ i)
		UpdateWatch(i,m_watchpoint[i]);
}


void CVisBefDoc::OnAddtowatch() 
{
	CVisBefView *pView = GetView();

	CPoint pt = pView->m_lastPopupMenuPos;
   CListBox *pList = ( ( CMainFrame * ) AfxGetMainWnd() )->GetWatchList();

	for (int i = 0; i < m_watchpoint.GetSize() ; ++ i)
	{
		if (m_watchpoint[i] == pt)
		{
			//Found it - remove from watch
			m_watchpoint.RemoveAt(i);
			pList->DeleteString( i );
		   return;
		}
	}

	//Didn't find it; add to watch
	GridType value = m_state.GetCur(pt.x,pt.y);
	CString strout;
	if ( char(value) >= ' ' && value < 128)
	{
		strout.Format("(%d,%d) : %d \'%c\'",
						  pt.x,pt.y,
						  value,value);
	}
	else
	{
		strout.Format("(%d,%d) : %d",
						  pt.x,pt.y,
						  value);
	}

	m_watchpoint.Add(pt);
	pList->AddString(strout );
}


void CVisBefDoc::OnUpdateAddtowatch(CCmdUI* pCmdUI) 
{
	//If Watch already present, change the text
	CVisBefView *pView = GetView();

	CPoint pt = pView->m_lastPopupMenuPos;

	//scan list
	for (int i = 0; i < m_watchpoint.GetSize() ; ++ i)
	{
		if (m_watchpoint[i] == pt)
		{
			//Found it;
			pCmdUI->SetText("Remove Watch");
		   return;
		}
	}
}


void CVisBefDoc::ClearAllWatches() 
{
   CMainFrame *pWnd = ( CMainFrame * ) AfxGetMainWnd();
	if ( pWnd && ::IsWindow(pWnd->m_hWnd))
	{
		CListBox *pList = pWnd->GetWatchList();
		if ( pList && ::IsWindow(pList->m_hWnd))
			pList->ResetContent();
	}
	m_watchpoint.RemoveAll();
}

CVisBefView *CVisBefDoc::GetView()
{
	POSITION pos = GetFirstViewPosition();
	CVisBefView *pView = (CVisBefView *) GetNextView( pos );
	ASSERT(pView);
	return pView;
}