#ifndef BEF_HASHWORLD_H
#define BEF_HASHWORLD_H

#include "beftempl.h"


///////////////////////////////////////////////////////////////
// Class CBlock
//
//A Block is a BLOCKSIZE*BLOCKSIZE array of grid values
//
///////////////////////////////////////////////////////////////


//The alternative fo the following is long
typedef char GridType;


class CBlock
{
public:
	enum { BLOCKSIZE = 32};

private:
	long m_top;
	GridType m_grid[BLOCKSIZE][BLOCKSIZE];

	static GridType defchar;						     //Default grid value (space for bef '97)

public:
	CBlock();
	void Clear();
	GridType get(long x, long y);
	GridType *getline(long y) { return m_grid[y]; }
	void put(long x, long y, GridType val);

	static GridType defaultvalue() { return defchar; }

};


///////////////////////////////////////////////////////////////
// Class CHashPoint
///////////////////////////////////////////////////////////////


class CHashPoint : public CPoint
{
public:
	CHashPoint(int thisx = 0, int thisy = 0) : CPoint(thisx,thisy) {}
	operator long() const { return ( ( long(y) << 8)  + x); }
};


///////////////////////////////////////////////////////////////
// Class CBefWorld
//
//I tried using template CTypedMapPtrToPtr here,
//but I got bogged down with Microsoft peculiarities.
//I won't bother any further
//
///////////////////////////////////////////////////////////////


//Following only for reading convenience
#define CHashHorizontal THashList< CHashPoint, CBlock >


class CBefWorld : public CHashHorizontal
{
private:
	enum { LINEWIDTH = 80, PAGEHEIGHT = 25 };

	//Cached versions of last lookup
	static CHashPoint lastKey;
	static CBlock *pBlock;

public:
	GridType get(long x, long y);
	void put(long x, long y, GridType val);

   void ClearGrid();
   static int GetWidth()  { return LINEWIDTH; }
   static int GetHeight() { return PAGEHEIGHT; }

	void getline(GridType *pBuf, long x, long y, long width);

};


///////////////////////////////////////////////////////////////
// The original 80x25 befunge space, when life was sweet
//   and innocent (sigh).
///////////////////////////////////////////////////////////////


/*
class CBefWorld
{
private:
	enum { LINEWIDTH = 80, PAGEHEIGHT = 25 };

	GridType m_grid[PAGEHEIGHT][LINEWIDTH];

public:
	CBefWorld();

   void ClearGrid();
   static int GetWidth()  { return LINEWIDTH; }
   static int GetHeight() { return PAGEHEIGHT; }
	GridType &GetCur(int x, int y) { return m_grid[y][x]; } 
};
*/

#endif /* BEF_HASHWORLD_H */
