///////////////////////////////////////////////////////////////
// DATE       : 15-5-97
// AUTHOR     : Wim Rijnders
// LAST_UPDATE: 9-7-97
// TITLE      : Befunge space implementation.
// PROJECT    : VISBEF
// VERSION    : 2
// PLATFORM   : WIN32, MFC.
//-------------------------------------------------------------
// DESCRIPTION
// ===========
//
// Implementation of a potentially pretty huge befunge executable
// space using a pretty basic hashing approach.
//-------------------------------------------------------------
// NOTES
// =====
//-------------------------------------------------------------
// HISTORY
// =======
//
//  9- 7-97 Wim Rijnders v2: Added caching previous values to 
//          CBefWorld::get().
//        - Added getline() functions.
// 15- 5-97 Wim Rijnders v1: Created it.
///////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "hashworld.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


///////////////////////////////////////////////////////////////
// Class CBlock 
///////////////////////////////////////////////////////////////


//static member declaration(s)
GridType CBlock::defchar = ' ';


CBlock::CBlock()
{
	Clear();
}


///////////////////////////////////////////////////////////////
//Init grid to spaces
//
void CBlock::Clear()
{
	GridType *pcell = (GridType *) m_grid;

	for ( int i = 0; i < BLOCKSIZE*BLOCKSIZE; ++ i)
		*pcell++ = ' ';
}


GridType CBlock::get(long x, long y)
{
	ASSERT(x>=0 && x < BLOCKSIZE);
	ASSERT(y>=0 && y < BLOCKSIZE);

	return m_grid[y][x];
}


void CBlock::put(long x, long y, GridType val)
{
	ASSERT(x>=0 && x < BLOCKSIZE);
	ASSERT(y>=0 && y < BLOCKSIZE);

	m_grid[y][x] = val;
}


///////////////////////////////////////////////////////////////
// Class CBefWorld
///////////////////////////////////////////////////////////////

//static declarations
CHashPoint CBefWorld::lastKey(-1,-1);
CBlock *CBefWorld::pBlock = NULL;

GridType CBefWorld::get(long x, long y)
{
	long xrel = x % CBlock::BLOCKSIZE;
	long yrel = y % CBlock::BLOCKSIZE;

	CHashPoint thisKey(x/CBlock::BLOCKSIZE,y/CBlock::BLOCKSIZE);

	if ( thisKey != lastKey )
	{
		lastKey = thisKey;
		pBlock = CHashHorizontal::get(thisKey);
	}

	if ( pBlock )
		return pBlock->get(xrel,yrel);
	else
		return CBlock::defaultvalue();
}


void CBefWorld::put(long x, long y, GridType val)
{
	//
	//Note: this function is not using the
	//static members intended for caching
	//
	CBlock *pBlock;

	long xrel = x % CBlock::BLOCKSIZE;
	long yrel = y % CBlock::BLOCKSIZE;

	CHashPoint thisKey(x/CBlock::BLOCKSIZE,y/CBlock::BLOCKSIZE);

	pBlock = CHashHorizontal::set(thisKey);
	if ( pBlock )
		pBlock->put(xrel,yrel,val);
	else
	{
		//SHOULD NEVER HAPPEN
		ASSERT(FALSE);
	}
}

void CBefWorld::ClearGrid() 
{ 
	lastKey = CHashPoint(-1,-1); 
	pBlock = NULL; 
	Destroy(); 
}


///////////////////////////////////////////////////////////////
// Dirty hack: Retrieve entire lines from the befunge space so
// we can speed up the screen update. The performance increase
// as compared to straightforward get()'s is quite dramatic.
//
//
void CBefWorld::getline(GridType *pBuf, long x, long y, long width)
{
	long curpos =0;
	long lastx = x + width;
	while (x < lastx)
	{
		long xrel = x % CBlock::BLOCKSIZE;
		long yrel = y % CBlock::BLOCKSIZE;

		//Force cached pointer to correct block
		get(x,y);

		long len = CBlock::BLOCKSIZE - xrel;
		if ( len + x > lastx)
			len = lastx - x;

		if ( pBlock )
		{
			//Retrieve line for current block
			GridType *pLine = pBlock->getline(yrel);

			memcpy(pBuf + curpos,pLine + xrel, len*sizeof(GridType));
		}
		else
		{
			//Fill with empty char
			for ( int i = 0; i < len; ++i)
				*(pBuf + curpos + i) = CBlock::defaultvalue();
		}
		curpos += len;
		x += len;
	}
}

///////////////////////////////////////////////////////////////
// The original 80x25 befunge space, used in the very early
// original version.
///////////////////////////////////////////////////////////////

/*
CBefWorld::CBefWorld()
{
	ClearGrid();
}

void CBefWorld::ClearGrid()
{
	//Fill the grid with spaces
	int x;
	char *phelp = (char*) m_grid;
	for ( x = 0; x < LINEWIDTH * PAGEHEIGHT; x++ )
		*phelp++ = ' ';
}
*/
