///////////////////////////////////////////////////////////////
// DATE       : 15-5-97
// AUTHOR     : Wim Rijnders
// LAST_UPDATE: 1-7-97
// TITLE      : Console version of Visual Befunge interpreter.
// PROJECT    : VISBEF
// VERSION    : 1
// PLATFORM   : WIN32,CONSOLE
//-------------------------------------------------------------
// DESCRIPTION
// ===========
//
// Console version of Visual Befunge, using the exact same 
// interpreter core as the full-blown Visual Befunge Windows
// version. The primary goal here is to show that it can be 
// done.
//-------------------------------------------------------------
// NOTES
// =====
//-------------------------------------------------------------
// HISTORY
// =======
//
// 15- 5-97 Wim Rijnders v1: Created it.
///////////////////////////////////////////////////////////////
#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#include "..\befclass.h"

CBefunge State;
	

///////////////////////////////////////////////////////////////
// Main program.
///////////////////////////////////////////////////////////////


int main(int argc, char *argv[])
{		
	FILE *f;
	srand(time(0));

	State.Init();

	printf("Wim Rijnders Befunge'93 Interpreter v1.00 Console Version.\n");

	if (argc < 2)
	{
		printf("USAGE : befcons <befunge-source>\n");
		return 0;
	}

	if ((f = fopen(argv[1], "r")) != NULL)
	{
		State.loadfile(f);
		fclose(f);
	}
	else
	{
		printf("Error : couldn't open '%s' for input.\n", argv[1]);
		return 0;
	}

	while ( State.Step() != TERMINATED );
	return 0;
}


///////////////////////////////////////////////////////////////
// Hook Functions
///////////////////////////////////////////////////////////////


void OutputInt(long v)
{
	printf("%ld ", v);
	fflush(stdout);
}


void OutputChar(char c)
{
	printf("%c", c);
	fflush(stdout);
}


void OutputString(const char *s)
{
	//Used for error output
	printf(s);
	fflush(stdout);
}


void PushStack(long v)
{
	//For visual output only - not used in console mode
}


void PopStack()
{
	// For visual output only - not used in console mode
}


void ClearStack()
{
	//For visual output only - not used in console mode
}


char GetInputChar()
{
   return fgetc(stdin);
}


long GetInputNum()
{
   signed long b;
	fscanf(stdin, "%ld", &b);
	return b;
}


void CellChanged(long x, long y, char thischar, BOOL bIsPC )
{
	//For visual output only - not used in console mode
}
