///////////////////////////////////////////////////////////////
// DATE       : 15-5-97
// AUTHOR     : Wim Rijnders
// LAST_UPDATE: 1-7-97
// TITLE      : Templates for Visual Befunge.
// PROJECT    : VISBEF
// VERSION    : 1
// PLATFORM   : WIN32, MFC.
//-------------------------------------------------------------
// DESCRIPTION
// ===========
//
// Recycled template definitions for Visual Befunge.
//-------------------------------------------------------------
// NOTES
// =====
//
// * Given half a chance and some intimate quality time,
//   I'll attempt to get to grips with STL and replace the
//   following stuff with a decent STL implementation.
//-------------------------------------------------------------
// HISTORY
// =======
//
// 15-5-97 Wim Rijnders v1: Created it.
///////////////////////////////////////////////////////////////
#ifndef BEF_TEMPLATE_H
#define BEF_TEMPLATE_H
//
//Templates for use with bef'97
//

#include <afxtempl.h>


///////////////////////////////////////////////////////////////
//Following template adds essential cleanup 
//functions to the MFC-based CTypedPtrList template
///////////////////////////////////////////////////////////////


template< class TYPE >
class THashPtrList : public CTypedPtrList<CPtrList, TYPE *>
{
public:
  ~THashPtrList() { Destroy(); }
	void Clear();
	void Destroy();
};


template< class TYPE >
void THashPtrList<TYPE>::Clear()
{
	//Iterate over all elements
	POSITION pos = GetHeadPosition();
	TYPE *pItem;
	while ( pos )
	{
		pItem = GetNext(pos);
			pItem->Clear();
	}
}


template< class TYPE >
void THashPtrList<TYPE>::Destroy()
{
	//Iterate over all elements
	POSITION pos = GetHeadPosition();
	TYPE *pItem;
	while ( pos )
	{
		pItem = GetNext(pos);
		delete pItem;
	}

	RemoveAll();
}


///////////////////////////////////////////////////////////////
// Template THashList
//
// Hashed element needs one member function in
// current implementation:
//
// Destroy() - Clean up given instance to an
//             initial state, without destroying
//             it (no destructor call).
//
// CHashKey needs one member function:
//
// * cast to long integer: operator long()
//
///////////////////////////////////////////////////////////////


template< class CHashKey, class CHashType, const int HASHTABLESIZE = 31 >
class THashList
{
private: 

	//Internal class definition for nodes
	class CHashNode : public CHashType
	{
	private:
		const CHashKey m_key;

	public:
		CHashNode(CHashKey key) : m_key(key) {}
		const CHashKey &HashKey() { return m_key; }

	};


	int hash(long x) { return x%HASHTABLESIZE; } // hash function 

	THashPtrList<CHashNode> *m_hashlist[HASHTABLESIZE];

protected:
	void Destroy();
	CHashType *get(const CHashKey &key);
	CHashType *set(const CHashKey &key);

public:
	THashList();
  ~THashList() { Destroy(); }

	void Clear();
};


template< class CHashKey, class CHashType, const int HASHTABLESIZE >
THashList<CHashKey, CHashType, HASHTABLESIZE>::
THashList()
{

	for ( int i = 0; i < HASHTABLESIZE; ++ i)
		m_hashlist[i] = NULL;
}


template< class CHashKey, class CHashType, const int HASHTABLESIZE >
void 
THashList<CHashKey, CHashType, HASHTABLESIZE>::
Clear()
{
	for ( int i = 0; i < HASHTABLESIZE; ++ i)
	{
		if ( m_hashlist[i] )
		{
			//Clear the current list
			m_hashlist[i]->Clear();
		}
	}
}


template< class CHashKey, class CHashType, const int HASHTABLESIZE >
void 
THashList<CHashKey, CHashType, HASHTABLESIZE>::
Destroy()
{
	for ( int i = 0; i < HASHTABLESIZE; ++ i)
	{
		if ( m_hashlist[i] )
		{
			delete m_hashlist[i];
			m_hashlist[i] = NULL;
		}
	}
}


///////////////////////////////////////////////////////////////
// Returns the element with given key index.
// If not found, return NULL.
//
template< class CHashKey, class CHashType, const int HASHTABLESIZE >
CHashType *
THashList<CHashKey, CHashType, HASHTABLESIZE>::
get(const CHashKey &key)
{
	THashPtrList<CHashNode> *pList;
	CHashNode *pHashItem;

	pList = m_hashlist[hash( key)];

	if ( !pList ) 
		return NULL;

	//Search the list for given key
	POSITION pos = pList->GetHeadPosition();
	while ( pos )
	{
		pHashItem = pList->GetNext(pos);
		if ( pHashItem->HashKey() == key)
		{	//Found it!
			return pHashItem;
		}
	}

   //Didn't find it
	return NULL;
}


///////////////////////////////////////////////////////////////
// Returns the element with given key index.
// If not found, create it.
//
template< class CHashKey, class CHashType, const int HASHTABLESIZE >
CHashType *
THashList<CHashKey, CHashType, HASHTABLESIZE>::
set(const CHashKey &key)
{
	CHashType *pHashItem = get(key);

	if ( pHashItem )
		return pHashItem;

	//Item does not exist; we need to create it
	pHashItem = new CHashNode(key);

	//If list not present, create it
	long hashindex = hash(key);

	if ( !m_hashlist[hashindex] ) 
		m_hashlist[hashindex] = new THashPtrList<CHashNode>;

	//Add item to the list
	POSITION pos = m_hashlist[hashindex]->AddTail( pHashItem);

	ASSERT(pos);
	return m_hashlist[hashindex]->GetAt( pos);
}


/////////////////////////////////////////////
// Template for simple stack 
/////////////////////////////////////////////


/////////////////////////////////////////////
//Class definition for node - Can't get VC to compile 
//this as private class def within TStack. Shame.
//
// CStackType needs copy ctor or operator=().
//
template< class CStackType>
class CStackNode
{
public:
	CStackType val;
	CStackNode *next;

	CStackNode(CStackType &v,CStackNode *p) { val = v;  next = p;}
};


template< class CStackType>
class TStack
{
private: 

	CStackNode<CStackType> *head;

public:
	TStack() : head(NULL) {}
  ~TStack() { Destroy(); }

	void push (CStackType val);
	int  pop (CStackType &val );
	void Destroy();
};


template< class CStackType>
void
TStack<CStackType>::
push(CStackType val)
{ 
  head = new CStackNode<CStackType>(val,head);
}


template< class CStackType>
int
TStack<CStackType>::
pop (CStackType &val )
{
   if (!head)
		return 0;

	CStackNode<CStackType> *pNode = head;
	val = head->val;
	head = head->next;
	delete pNode;
	return 1;
}


template< class CStackType>
void
TStack<CStackType>::
Destroy()
{
	CStackType dummy;
   while ( pop(dummy) );
}


#endif BEF_TEMPLATE_H
