#ifndef BEFUNGE_CLASS
#define BEFUNGE_CLASS
#include <afxtempl.h>
#include "hashworld.h"

///////////////////////////////////////////////////////////////
// Hook functions for external communication.
//
// Define these elsewhere to communicate with the befunge core.
///////////////////////////////////////////////////////////////
extern void OutputInt( long v);
extern void OutputChar( char c);
extern void OutputString(const char *s);
extern void PushStack(long v);
extern void PopStack();
extern void ClearStack();
extern char GetInputChar();
extern long GetInputNum();
extern void CellChanged(long x, long y, char thischar, BOOL bIsPC );

typedef enum
{
	BEFOK,
	BREAKPOINT,
	TERMINATED
} StepResult;


//Forward declaration(s)
class CBefunge;


///////////////////////////////////////////////////////////////
// Class CBefThread
///////////////////////////////////////////////////////////////


class CBefThread : private TStack<long>
{
private:
   int x, y;                           /* x and y of the PC */
   int dx, dy;                         /* direction of the PC */
   int stringmode;                     /* flag : are we in string mode? */

	//Stack interface functions
	void ClearStack() { TStack<long>::Destroy(); ::ClearStack(); }
	void push (long val) {  TStack<long>::push(val); ::PushStack(val); }
	long pop () { long val = 0; TStack<long>::pop(val); ::PopStack(); return val; }

public:
	CBefThread() { Init(); }

	void Init();
	StepResult Step();
	CPoint &GetPos() { static CPoint pt; pt = CPoint(x,y); return pt; }

   const GridType getcur();
	void setcur(GridType val);
};


///////////////////////////////////////////////////////////////
// Class CBefTask
///////////////////////////////////////////////////////////////


class CBefTask
{
private:
	CArray<CBefThread,CBefThread &> m_thread;
	int m_curthread;

   void AddThread() { CBefThread newthread;  m_thread.Add(newthread); }
public:
	CBefTask() : m_curthread(0) { AddThread(); } 

	//needed for template
	CBefTask &operator=(CBefTask &task);

	StepResult Step();
   CBefThread & GetThread(int n ) { return m_thread[n]; }
	int GetNumThreads() { return m_thread.GetSize(); }
};


///////////////////////////////////////////////////////////////
// Class CBefThread
///////////////////////////////////////////////////////////////


class CBefunge
{
private:
	static CBefWorld m_world;
	CArray<CBefTask, CBefTask &> m_task;

   void AddTask() { CBefTask newtask;  m_task.Add(newtask); }

	//option flag(s)
	static BOOL m_warpspace;

	//Debugging stuff
	static CArray<CPoint, CPoint &> m_breakpoint;
	static int FindBreakPoint( CPoint &pos);

	//helpers
	int ScanLastNonSpace(int x);

public:
	void savefile(FILE *f);
	static void loadfile(FILE *f);

	//Befunge Calls
	void Init() { m_world.ClearGrid(); m_task.RemoveAll(); AddTask(); }
	StepResult Step();
	int GetNumTasks() { return m_task.GetSize(); }
   CBefTask & GetTask(int n ) { return m_task[n]; }
	static const GridType GetCur(int x, int y) { return m_world.get(x,y); }
	static void SetCur(int x, int y, GridType val) { m_world.put(x,y,val); }
	static void getline(GridType *pBuf, long x, long y, long width) { m_world.getline(pBuf, x, y, width); }


	//Options
	static void ToggleWarpSpace() { m_warpspace = !m_warpspace; }
	static BOOL IsWarping() { return m_warpspace; }

	//Breakpoints
	static BOOL HitBreakPoint( CPoint &pos);
	static void ToggleBreakPoint( CPoint &pos);
	static void ClearBreakPoints() { m_breakpoint.RemoveAll(); } 
	static int NumBreaks() { return m_breakpoint.GetSize(); }
	static const CPoint &GetBreak(int n ) { return m_breakpoint[n]; }
};

#endif /* BEFUNGE_CLASS */
