// StackBar.cpp : implementation file
//

#include "stdafx.h"
#include "visbef.h"
#include "StackBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStackBar dialog


IMPLEMENT_DYNAMIC(CStackBar, CMRCSizeControlBar);

CStackBar::CStackBar() 
: 
CMRCSizeControlBar( SZBARF_STDMOUSECLICKS ),
m_pFont(NULL)
{
}

CStackBar::~CStackBar()
{
	delete m_pFont;
}



BEGIN_MESSAGE_MAP(CStackBar, CMRCSizeControlBar)
	//{{AFX_MSG_MAP(CStackBar)
	ON_WM_CREATE()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyListBoxBar message handlers

void CStackBar::OnSizedOrDocked(int cx, int cy, BOOL bFloating, int flags)
{
	CRect rect(0, 0, cx, cy);		// rectangle for client area
	
	BOOL bHorz = (m_dwStyle & CBRS_ORIENT_HORZ) != 0;
	
	// shrink rectangle if we're docked
	if (IsProbablyFloating())
		rect.InflateRect(-9, -7);		// shrink for border when floating
	else
		rect.InflateRect(-9, -7);

	// fill the rest of the window with the list box..
	m_ListBox.MoveWindow(&rect);

}


int CStackBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMRCSizeControlBar::OnCreate(lpCreateStruct) == -1)
		return -1;

	CRect rect;
	GetClientRect(&rect);
	
	
	// Register a class for the list box without CS_VREDRAW, CS_HREDRAW
	WNDCLASS wc;
	VERIFY(GetClassInfo(AfxGetInstanceHandle(), _T("LISTBOX"), &wc)); 	
	wc.style &= ~(CS_VREDRAW | CS_HREDRAW);
	wc.lpszClassName = "_MF_LISTBOX";
	VERIFY(AfxRegisterClass(&wc));
	
	// create a list box to fill the client area with. Use CreateEx to add the
	// WS_EX_CLIENTEDGE style. 
	if (!m_ListBox.CreateEx(WS_EX_CLIENTEDGE,
                 			_T("_MF_LISTBOX"),
                 			NULL,
     						WS_CHILD | WS_VISIBLE | WS_VSCROLL
	 								| LBS_HASSTRINGS | LBS_NOTIFY | LBS_NOINTEGRALHEIGHT, 
	             			rect.left,
                 			rect.top,
      						rect.Width(),
							rect.Height(),
                 			GetSafeHwnd(),
                 			(HMENU) IDC_LIST1,
                 			NULL))
	{
		TRACE("Failed to create list box\n");
		return -1;
	}
	
	m_pFont = new CFont;
	VERIFY(m_pFont->CreatePointFont(90, "Courier New"));
	m_ListBox.SetFont( m_pFont);
//  	m_ListBox.SetHorizontalExtent(50);
	
	return 0;					
}



void CStackBar::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	// disable docking.
	CMRCSizeControlBar::OnRButtonUp(nFlags, point);

	/*if (m_bAllowDocking)
	{
		EnableDocking(NULL);	// disable docking.
		CMRCMDIFrameWndSizeDock * pMain = (CMRCMDIFrameWndSizeDock *) AfxGetMainWnd();
		pMain->FloatControlBar(this, CPoint(0,0));
		m_bAllowDocking = FALSE;
	}
	else
	{
		EnableDocking(CBRS_ALIGN_ANY);
		m_bAllowDocking = TRUE;
	} */
}


BOOL CStackBar::PreCreateWindow(CREATESTRUCT& cs) 
{
	return CMRCSizeControlBar::PreCreateWindow(cs);
}


BOOL CStackBar::Create(CWnd * pParentWnd)
{
	// register a window class for the control bar
	static CString strWndClass;
	if (strWndClass.IsEmpty())
	{
		strWndClass = AfxRegisterWndClass(CS_DBLCLKS);
	}
	
	return CMRCSizeControlBar::Create(strWndClass,
									   "Stack Window",
									   WS_VISIBLE | WS_CHILD | CBRS_BOTTOM | WS_CLIPCHILDREN,
									   CFrameWnd::rectDefault,
									   pParentWnd, ID_STACKBAR);
}



