// OutputWindow.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "visbef.h"
#include "OutputWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COutputWindow dialog

IMPLEMENT_DYNAMIC(COutputWindow, CMRCSizeControlBar);

COutputWindow::COutputWindow() 
: 
CMRCSizeControlBar( SZBARF_STDMOUSECLICKS),
m_pFont(NULL)
{
}

COutputWindow::~COutputWindow()
{
	delete m_pFont;
}



BEGIN_MESSAGE_MAP(COutputWindow, CMRCSizeControlBar)
	//{{AFX_MSG_MAP(COutputWindow)
	ON_WM_CREATE()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// COutputWindow message handlers

void COutputWindow::OnSizedOrDocked(int cx, int cy, BOOL bFloating, int flags)
{
	CRect rect(0, 0, cx, cy);		// rectangle for client area
	
	BOOL bHorz = (m_dwStyle & CBRS_ORIENT_HORZ) != 0;
	
	// shrink rectangle if we're docked
	if (IsProbablyFloating())
		rect.InflateRect(-7, -9);		// shrink for border when floating
	else
		rect.InflateRect(-7, -9);

	// fill the rest of the window with the list box..
	m_EditBox.MoveWindow(&rect);
}


int COutputWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMRCSizeControlBar::OnCreate(lpCreateStruct) == -1)
		return -1;

	CRect rect;
	GetClientRect(&rect);
	
	
	// Register a class for the Edit Control without CS_VREDRAW, CS_HREDRAW
	WNDCLASS wc;
	VERIFY(GetClassInfo(AfxGetInstanceHandle(), _T("EDIT"), &wc)); 	
	wc.style &= ~(CS_VREDRAW | CS_HREDRAW);
	wc.lpszClassName = "_MF_EDIT";
	VERIFY(AfxRegisterClass(&wc));
	
	// create a list box to fill the client area with. Use CreateEx to add the
	// WS_EX_CLIENTEDGE style. 
	if (!m_EditBox.CreateEx(WS_EX_CLIENTEDGE,
                 			_T("_MF_EDIT"),
                 			NULL,
     						WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_BORDER |
	 							ES_AUTOHSCROLL| ES_AUTOVSCROLL|ES_MULTILINE|
								ES_WANTRETURN,
	             			rect.left,
                 			rect.top,
      						rect.Width(),
							rect.Height(),
                 			GetSafeHwnd(),
                 			(HMENU) IDC_EDIT1,
                 			NULL))
	{
		TRACE("Failed to create list box\n");
		return -1;
	}
	
	m_pFont = new CFont;
	VERIFY(m_pFont->CreatePointFont(90, "Courier New"));
	m_EditBox.SetFont( m_pFont);
	
	return 0;					
}



void COutputWindow::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	// disable docking.
	CMRCSizeControlBar::OnRButtonUp(nFlags, point);

	/*if (m_bAllowDocking)
	{
		EnableDocking(NULL);	// disable docking.
		CMRCMDIFrameWndSizeDock * pMain = (CMRCMDIFrameWndSizeDock *) AfxGetMainWnd();
		pMain->FloatControlBar(this, CPoint(0,0));
		m_bAllowDocking = FALSE;
	}
	else
	{
		EnableDocking(CBRS_ALIGN_ANY);
		m_bAllowDocking = TRUE;
	} */
}


BOOL COutputWindow::PreCreateWindow(CREATESTRUCT& cs) 
{
	return CMRCSizeControlBar::PreCreateWindow(cs);
}


BOOL COutputWindow::Create(CWnd * pParentWnd)
{
	// register a window class for the control bar
	static CString strWndClass;
	if (strWndClass.IsEmpty())
	{
		strWndClass = AfxRegisterWndClass(CS_DBLCLKS);
	}
	
	return CMRCSizeControlBar::Create(strWndClass,
									   "Output Window",
									   WS_VISIBLE | WS_CHILD | CBRS_BOTTOM | WS_CLIPCHILDREN,
									   CFrameWnd::rectDefault,
									   pParentWnd, ID_OUTPUTBAR);
}



