// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
#include "outputwindow.h"
#include "stackbar.h"
#include "watchbar.h"


#define MainFrameParent CMRCFrameWndSizeDock

class CMainFrame : public MainFrameParent
{
friend CEdit *GetOutputWindow();
friend  CListBox *GetStackWindow();
friend void ClearOutput();
friend void DrawListBox( BOOL bDraw);

protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
public:

// Operations
public:
					    
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  	m_wndStatusBar;

	int 				m_BarCount;

	CToolBar       m_wndToolBar;
	COutputWindow  m_wndOutput;
	CStackBar      m_wndStackBar;
	CWatchBar		m_wndWatchBar;

public:
	CListBox *GetWatchList() { return &m_wndWatchBar.m_ListBox; }
	
// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnViewTiledockbars();
	afx_msg void OnArrangeBottomLeft();
	afx_msg void OnArrangeBottomRight();
	afx_msg void OnArrangeTopLeft();
	afx_msg void OnArrangeTopRight();
	afx_msg void OnClose();
	
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
