// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "visbef.h"
#include "visbefdoc.h"
#include "befmfc.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, MainFrameParent)

BEGIN_MESSAGE_MAP(CMainFrame, MainFrameParent)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_COMMAND(ID_VIEW_TILEDOCKBARS, OnViewTiledockbars)
	ON_COMMAND(ID_ArrangeBottomLeft, OnArrangeBottomLeft)
	ON_COMMAND(ID_ArrangeBottomRight, OnArrangeBottomRight)
	ON_COMMAND(ID_ArrangeTopLeft, OnArrangeTopLeft)
	ON_COMMAND(ID_ArrangeTopRight, OnArrangeTopRight)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP

	// standard on/off control bar handlers for View menu. 
	ON_UPDATE_COMMAND_UI(ID_STACKBAR, OnUpdateControlBarMenu)
	ON_COMMAND_EX(ID_STACKBAR, OnBarCheck)
	
	ON_UPDATE_COMMAND_UI(ID_OUTPUTBAR, OnUpdateControlBarMenu)
	ON_COMMAND_EX(ID_OUTPUTBAR, OnBarCheck)

	ON_UPDATE_COMMAND_UI(ID_WATCHBAR, OnUpdateControlBarMenu)
	ON_COMMAND_EX(ID_WATCHBAR, OnBarCheck)
END_MESSAGE_MAP()


static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() 
{
	m_BarCount = 0;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (MainFrameParent::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// This is a list box that is added dynamically. You can have almost any number of these...
	if (!m_wndOutput.Create(this))
	{
		TRACE0("Failed to create stack window\n");
		return -1;      
	} 

	m_wndOutput.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndOutput, AFX_IDW_DOCKBAR_BOTTOM);

	   //Watch window inialization
	if (!m_wndWatchBar.Create(this))
	{
		TRACE0("Failed to create watch window\n");
		return -1;      
	} 

	m_wndWatchBar.EnableDocking(CBRS_ALIGN_ANY);

//Please read NOTES.TXT about following conditional compile
#ifdef _DEBUG
#pragma message("Second param DockControlBar() set to zero for debugging")
	DockControlBar(&m_wndWatchBar, (unsigned int ) 0);
#else
	DockControlBar(&m_wndWatchBar, AFX_IDW_DOCKBAR_LEFT);
#endif

   //Stack window inialization
	if (!m_wndStackBar.Create(this))
	{
		TRACE0("Failed to create stack window\n");
		return -1;      
	} 

	m_wndStackBar.EnableDocking(CBRS_ALIGN_ANY);

//Please read NOTES.TXT about following conditional compile
#ifdef _DEBUG
#pragma message("Second param DockControlBar() set to zero for debugging")
   DockControlBar(&m_wndStackBar, (unsigned int ) 0);
#else
   DockControlBar(&m_wndStackBar, AFX_IDW_DOCKBAR_RIGHT);
#endif


	RecalcLayout();
//	TileDockedBars(CBRS_ALIGN_BOTTOM);		// this makes the bars the same size

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	MainFrameParent::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	MainFrameParent::Dump(dc);
}

#endif //_DEBUG


void ClearOutput()
{
	//
	// This function is called once in the initial
	// OnNewDocument(), when the Main window has 
	// not been created yet. Following test avoids 
	// embarrassing Access Violations.
	//
	CMainFrame *pMainWnd = ( CMainFrame * ) AfxGetMainWnd();
	if (!pMainWnd || !IsWindow(pMainWnd->m_hWnd) ) 
		return;
	
	CEdit *pWnd = &pMainWnd->m_wndOutput.m_EditBox;
	ASSERT(pWnd && IsWindow(pWnd->m_hWnd));

	//Clear entire contents of edit control
	pWnd->SetSel( 0, -1) ; 
	pWnd->Clear();
}


void CMainFrame::OnTimer(UINT nIDEvent) 
{
	CVisBefDoc *pDoc = (CVisBefDoc *) GetActiveDocument( );
	if ( pDoc && pDoc->IsAnimating() )
	{
		pDoc->DoStep();
		if ( !pDoc->IsAnimating() )
			KillTimer(1);	//Program terminated
	}
	else
		KillTimer(1);

	CFrameWnd::OnTimer(nIDEvent);
}


void DrawListBox( BOOL bDraw)
{
	CListBox *pWnd = (CListBox *) ( ( CMainFrame * ) AfxGetMainWnd() ) ->m_wndStackBar.GetDlgItem(IDC_LIST1);

	pWnd->SendMessage(WM_SETREDRAW, bDraw,0);
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnViewTiledockbars() 
{
  	TileDockedBars();
	RecalcLayout();
}


void CMainFrame::OnArrangeBottomLeft() 
{
	ArrangeFloatingBars(CBRS_ARRANGE_BOTTOMLEFT);
}


void CMainFrame::OnArrangeBottomRight() 
{
	ArrangeFloatingBars(CBRS_ARRANGE_BOTTOMRIGHT);
}


void CMainFrame::OnArrangeTopLeft() 
{
	ArrangeFloatingBars(CBRS_ARRANGE_TOPLEFT);
}


void CMainFrame::OnArrangeTopRight() 
{
	ArrangeFloatingBars(CBRS_ARRANGE_TOPRIGHT);
}


void CMainFrame::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	// DestroyDynamicBars();
	SaveSizeBarState("VisBefBars");
	MainFrameParent::OnClose();
}
